<?php

namespace Opsuite\BatchExport;

class GLExportByLocationIdAndBatchId
{

    /**
     * @var ExportType $exportType
     */
    protected $exportType = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var int $batchId
     */
    protected $batchId = null;

    /**
     * @param ExportType $exportType
     * @param int $locationId
     * @param int $batchId
     */
    public function __construct($exportType, $locationId, $batchId)
    {
      $this->exportType = $exportType;
      $this->locationId = $locationId;
      $this->batchId = $batchId;
    }

    /**
     * @return ExportType
     */
    public function getExportType()
    {
      return $this->exportType;
    }

    /**
     * @param ExportType $exportType
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchId
     */
    public function setExportType($exportType)
    {
      $this->exportType = $exportType;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchId
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getBatchId()
    {
      return $this->batchId;
    }

    /**
     * @param int $batchId
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchId
     */
    public function setBatchId($batchId)
    {
      $this->batchId = $batchId;
      return $this;
    }

}
