<?php

namespace Opsuite\BatchExport;

class GLExportByLocationId
{

    /**
     * @var ExportType $exportType
     */
    protected $exportType = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var boolean $forceExport
     */
    protected $forceExport = null;

    /**
     * @param ExportType $exportType
     * @param int $locationId
     * @param boolean $forceExport
     */
    public function __construct($exportType, $locationId, $forceExport)
    {
      $this->exportType = $exportType;
      $this->locationId = $locationId;
      $this->forceExport = $forceExport;
    }

    /**
     * @return ExportType
     */
    public function getExportType()
    {
      return $this->exportType;
    }

    /**
     * @param ExportType $exportType
     * @return \Opsuite\BatchExport\GLExportByLocationId
     */
    public function setExportType($exportType)
    {
      $this->exportType = $exportType;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\BatchExport\GLExportByLocationId
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getForceExport()
    {
      return $this->forceExport;
    }

    /**
     * @param boolean $forceExport
     * @return \Opsuite\BatchExport\GLExportByLocationId
     */
    public function setForceExport($forceExport)
    {
      $this->forceExport = $forceExport;
      return $this;
    }

}
