<?php

namespace Opsuite\BatchExport;

class GLExport
{

    /**
     * @var ExportType $exportType
     */
    protected $exportType = null;

    /**
     * @var boolean $forceExport
     */
    protected $forceExport = null;

    /**
     * @param ExportType $exportType
     * @param boolean $forceExport
     */
    public function __construct($exportType, $forceExport)
    {
      $this->exportType = $exportType;
      $this->forceExport = $forceExport;
    }

    /**
     * @return ExportType
     */
    public function getExportType()
    {
      return $this->exportType;
    }

    /**
     * @param ExportType $exportType
     * @return \Opsuite\BatchExport\GLExport
     */
    public function setExportType($exportType)
    {
      $this->exportType = $exportType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getForceExport()
    {
      return $this->forceExport;
    }

    /**
     * @param boolean $forceExport
     * @return \Opsuite\BatchExport\GLExport
     */
    public function setForceExport($forceExport)
    {
      $this->forceExport = $forceExport;
      return $this;
    }

}
