<?php

namespace Opsuite\BatchExport;

class ExportTender
{

    /**
     * @var guid $Id
     */
    protected $Id = null;

    /**
     * @var float $OverUnder
     */
    protected $OverUnder = null;

    /**
     * @var guid $ParentId
     */
    protected $ParentId = null;

    /**
     * @var \DateTime $ReceiptDate
     */
    protected $ReceiptDate = null;

    /**
     * @var int $RegisterId
     */
    protected $RegisterId = null;

    /**
     * @var string $TenderCode
     */
    protected $TenderCode = null;

    /**
     * @var int $TenderId
     */
    protected $TenderId = null;

    /**
     * @var string $TenderTypeName
     */
    protected $TenderTypeName = null;

    /**
     * @var TransactionTypeCodes $TransactionTypeCode
     */
    protected $TransactionTypeCode = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return guid
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param guid $Id
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return float
     */
    public function getOverUnder()
    {
      return $this->OverUnder;
    }

    /**
     * @param float $OverUnder
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setOverUnder($OverUnder)
    {
      $this->OverUnder = $OverUnder;
      return $this;
    }

    /**
     * @return guid
     */
    public function getParentId()
    {
      return $this->ParentId;
    }

    /**
     * @param guid $ParentId
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setParentId($ParentId)
    {
      $this->ParentId = $ParentId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getReceiptDate()
    {
      if ($this->ReceiptDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ReceiptDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ReceiptDate
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setReceiptDate(\DateTime $ReceiptDate = null)
    {
      if ($ReceiptDate == null) {
       $this->ReceiptDate = null;
      } else {
        $this->ReceiptDate = $ReceiptDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterId()
    {
      return $this->RegisterId;
    }

    /**
     * @param int $RegisterId
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setRegisterId($RegisterId)
    {
      $this->RegisterId = $RegisterId;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderCode()
    {
      return $this->TenderCode;
    }

    /**
     * @param string $TenderCode
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setTenderCode($TenderCode)
    {
      $this->TenderCode = $TenderCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getTenderId()
    {
      return $this->TenderId;
    }

    /**
     * @param int $TenderId
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setTenderId($TenderId)
    {
      $this->TenderId = $TenderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderTypeName()
    {
      return $this->TenderTypeName;
    }

    /**
     * @param string $TenderTypeName
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setTenderTypeName($TenderTypeName)
    {
      $this->TenderTypeName = $TenderTypeName;
      return $this;
    }

    /**
     * @return TransactionTypeCodes
     */
    public function getTransactionTypeCode()
    {
      return $this->TransactionTypeCode;
    }

    /**
     * @param TransactionTypeCodes $TransactionTypeCode
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setTransactionTypeCode($TransactionTypeCode)
    {
      $this->TransactionTypeCode = $TransactionTypeCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Opsuite\BatchExport\ExportTender
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

}
