<?php

namespace Opsuite\BatchExport;

class ExportPayment
{

    /**
     * @var float $Amount
     */
    protected $Amount = null;

    /**
     * @var string $Comment
     */
    protected $Comment = null;

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var int $CustomerId
     */
    protected $CustomerId = null;

    /**
     * @var int $ExternalTransactionNumber
     */
    protected $ExternalTransactionNumber = null;

    /**
     * @var guid $Id
     */
    protected $Id = null;

    /**
     * @var guid $ParentId
     */
    protected $ParentId = null;

    /**
     * @var \DateTime $PaymentDate
     */
    protected $PaymentDate = null;

    /**
     * @var string $TenderDescription
     */
    protected $TenderDescription = null;

    /**
     * @var int $TenderId
     */
    protected $TenderId = null;

    /**
     * @var string $TenderType
     */
    protected $TenderType = null;

    /**
     * @var ArrayOfExportTender $Tenders
     */
    protected $Tenders = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return float
     */
    public function getAmount()
    {
      return $this->Amount;
    }

    /**
     * @param float $Amount
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setAmount($Amount)
    {
      $this->Amount = $Amount;
      return $this;
    }

    /**
     * @return string
     */
    public function getComment()
    {
      return $this->Comment;
    }

    /**
     * @param string $Comment
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setComment($Comment)
    {
      $this->Comment = $Comment;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->CustomerId;
    }

    /**
     * @param int $CustomerId
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setCustomerId($CustomerId)
    {
      $this->CustomerId = $CustomerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalTransactionNumber()
    {
      return $this->ExternalTransactionNumber;
    }

    /**
     * @param int $ExternalTransactionNumber
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setExternalTransactionNumber($ExternalTransactionNumber)
    {
      $this->ExternalTransactionNumber = $ExternalTransactionNumber;
      return $this;
    }

    /**
     * @return guid
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param guid $Id
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return guid
     */
    public function getParentId()
    {
      return $this->ParentId;
    }

    /**
     * @param guid $ParentId
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setParentId($ParentId)
    {
      $this->ParentId = $ParentId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPaymentDate()
    {
      if ($this->PaymentDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->PaymentDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $PaymentDate
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setPaymentDate(\DateTime $PaymentDate = null)
    {
      if ($PaymentDate == null) {
       $this->PaymentDate = null;
      } else {
        $this->PaymentDate = $PaymentDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderDescription()
    {
      return $this->TenderDescription;
    }

    /**
     * @param string $TenderDescription
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setTenderDescription($TenderDescription)
    {
      $this->TenderDescription = $TenderDescription;
      return $this;
    }

    /**
     * @return int
     */
    public function getTenderId()
    {
      return $this->TenderId;
    }

    /**
     * @param int $TenderId
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setTenderId($TenderId)
    {
      $this->TenderId = $TenderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderType()
    {
      return $this->TenderType;
    }

    /**
     * @param string $TenderType
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setTenderType($TenderType)
    {
      $this->TenderType = $TenderType;
      return $this;
    }

    /**
     * @return ArrayOfExportTender
     */
    public function getTenders()
    {
      return $this->Tenders;
    }

    /**
     * @param ArrayOfExportTender $Tenders
     * @return \Opsuite\BatchExport\ExportPayment
     */
    public function setTenders($Tenders)
    {
      $this->Tenders = $Tenders;
      return $this;
    }

}
