<?php

namespace Opsuite\BatchExport;

class ExportItem
{

    /**
     * @var ArrayOfExportItemBenefit $Benefits
     */
    protected $Benefits = null;

    /**
     * @var string $CashierName
     */
    protected $CashierName = null;

    /**
     * @var string $CashierNumber
     */
    protected $CashierNumber = null;

    /**
     * @var string $CatCode
     */
    protected $CatCode = null;

    /**
     * @var int $CategoryId
     */
    protected $CategoryId = null;

    /**
     * @var string $Comment
     */
    protected $Comment = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var string $CurrentPrimaryVendorCode
     */
    protected $CurrentPrimaryVendorCode = null;

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var int $CustomerId
     */
    protected $CustomerId = null;

    /**
     * @var int $DepartmentId
     */
    protected $DepartmentId = null;

    /**
     * @var string $DeptCode
     */
    protected $DeptCode = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $DiscountReasonCode
     */
    protected $DiscountReasonCode = null;

    /**
     * @var int $DiscountReasonCodeId
     */
    protected $DiscountReasonCodeId = null;

    /**
     * @var int $ExternalTransactionNumber
     */
    protected $ExternalTransactionNumber = null;

    /**
     * @var string $ExternalTransactionReference
     */
    protected $ExternalTransactionReference = null;

    /**
     * @var guid $Id
     */
    protected $Id = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var float $NetLineSales
     */
    protected $NetLineSales = null;

    /**
     * @var guid $ParentId
     */
    protected $ParentId = null;

    /**
     * @var string $PromotionCode
     */
    protected $PromotionCode = null;

    /**
     * @var string $PromotionDescription
     */
    protected $PromotionDescription = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var \DateTime $ReceiptDate
     */
    protected $ReceiptDate = null;

    /**
     * @var float $RegularUnitPrice
     */
    protected $RegularUnitPrice = null;

    /**
     * @var int $RetailTransactionLineItemId
     */
    protected $RetailTransactionLineItemId = null;

    /**
     * @var float $Sales
     */
    protected $Sales = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var float $Tax
     */
    protected $Tax = null;

    /**
     * @var string $TaxCode
     */
    protected $TaxCode = null;

    /**
     * @var ArrayOfstring $TaxCodes
     */
    protected $TaxCodes = null;

    /**
     * @var ArrayOfdecimal $Taxes
     */
    protected $Taxes = null;

    /**
     * @var string $TenderDescription
     */
    protected $TenderDescription = null;

    /**
     * @var int $TenderId
     */
    protected $TenderId = null;

    /**
     * @var string $TenderType
     */
    protected $TenderType = null;

    /**
     * @var ArrayOfExportTender $Tenders
     */
    protected $Tenders = null;

    /**
     * @var int $TransactionId
     */
    protected $TransactionId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ArrayOfExportItemBenefit
     */
    public function getBenefits()
    {
      return $this->Benefits;
    }

    /**
     * @param ArrayOfExportItemBenefit $Benefits
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setBenefits($Benefits)
    {
      $this->Benefits = $Benefits;
      return $this;
    }

    /**
     * @return string
     */
    public function getCashierName()
    {
      return $this->CashierName;
    }

    /**
     * @param string $CashierName
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCashierName($CashierName)
    {
      $this->CashierName = $CashierName;
      return $this;
    }

    /**
     * @return string
     */
    public function getCashierNumber()
    {
      return $this->CashierNumber;
    }

    /**
     * @param string $CashierNumber
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCashierNumber($CashierNumber)
    {
      $this->CashierNumber = $CashierNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getCatCode()
    {
      return $this->CatCode;
    }

    /**
     * @param string $CatCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCatCode($CatCode)
    {
      $this->CatCode = $CatCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {
      return $this->CategoryId;
    }

    /**
     * @param int $CategoryId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCategoryId($CategoryId)
    {
      $this->CategoryId = $CategoryId;
      return $this;
    }

    /**
     * @return string
     */
    public function getComment()
    {
      return $this->Comment;
    }

    /**
     * @param string $Comment
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setComment($Comment)
    {
      $this->Comment = $Comment;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return string
     */
    public function getCurrentPrimaryVendorCode()
    {
      return $this->CurrentPrimaryVendorCode;
    }

    /**
     * @param string $CurrentPrimaryVendorCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCurrentPrimaryVendorCode($CurrentPrimaryVendorCode)
    {
      $this->CurrentPrimaryVendorCode = $CurrentPrimaryVendorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->CustomerId;
    }

    /**
     * @param int $CustomerId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setCustomerId($CustomerId)
    {
      $this->CustomerId = $CustomerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getDepartmentId()
    {
      return $this->DepartmentId;
    }

    /**
     * @param int $DepartmentId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setDepartmentId($DepartmentId)
    {
      $this->DepartmentId = $DepartmentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeptCode()
    {
      return $this->DeptCode;
    }

    /**
     * @param string $DeptCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setDeptCode($DeptCode)
    {
      $this->DeptCode = $DeptCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getDiscountReasonCode()
    {
      return $this->DiscountReasonCode;
    }

    /**
     * @param string $DiscountReasonCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setDiscountReasonCode($DiscountReasonCode)
    {
      $this->DiscountReasonCode = $DiscountReasonCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getDiscountReasonCodeId()
    {
      return $this->DiscountReasonCodeId;
    }

    /**
     * @param int $DiscountReasonCodeId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setDiscountReasonCodeId($DiscountReasonCodeId)
    {
      $this->DiscountReasonCodeId = $DiscountReasonCodeId;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalTransactionNumber()
    {
      return $this->ExternalTransactionNumber;
    }

    /**
     * @param int $ExternalTransactionNumber
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setExternalTransactionNumber($ExternalTransactionNumber)
    {
      $this->ExternalTransactionNumber = $ExternalTransactionNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getExternalTransactionReference()
    {
      return $this->ExternalTransactionReference;
    }

    /**
     * @param string $ExternalTransactionReference
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setExternalTransactionReference($ExternalTransactionReference)
    {
      $this->ExternalTransactionReference = $ExternalTransactionReference;
      return $this;
    }

    /**
     * @return guid
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param guid $Id
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return float
     */
    public function getNetLineSales()
    {
      return $this->NetLineSales;
    }

    /**
     * @param float $NetLineSales
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setNetLineSales($NetLineSales)
    {
      $this->NetLineSales = $NetLineSales;
      return $this;
    }

    /**
     * @return guid
     */
    public function getParentId()
    {
      return $this->ParentId;
    }

    /**
     * @param guid $ParentId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setParentId($ParentId)
    {
      $this->ParentId = $ParentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionCode()
    {
      return $this->PromotionCode;
    }

    /**
     * @param string $PromotionCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setPromotionCode($PromotionCode)
    {
      $this->PromotionCode = $PromotionCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionDescription()
    {
      return $this->PromotionDescription;
    }

    /**
     * @param string $PromotionDescription
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setPromotionDescription($PromotionDescription)
    {
      $this->PromotionDescription = $PromotionDescription;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getReceiptDate()
    {
      if ($this->ReceiptDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ReceiptDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ReceiptDate
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setReceiptDate(\DateTime $ReceiptDate = null)
    {
      if ($ReceiptDate == null) {
       $this->ReceiptDate = null;
      } else {
        $this->ReceiptDate = $ReceiptDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getRegularUnitPrice()
    {
      return $this->RegularUnitPrice;
    }

    /**
     * @param float $RegularUnitPrice
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setRegularUnitPrice($RegularUnitPrice)
    {
      $this->RegularUnitPrice = $RegularUnitPrice;
      return $this;
    }

    /**
     * @return int
     */
    public function getRetailTransactionLineItemId()
    {
      return $this->RetailTransactionLineItemId;
    }

    /**
     * @param int $RetailTransactionLineItemId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setRetailTransactionLineItemId($RetailTransactionLineItemId)
    {
      $this->RetailTransactionLineItemId = $RetailTransactionLineItemId;
      return $this;
    }

    /**
     * @return float
     */
    public function getSales()
    {
      return $this->Sales;
    }

    /**
     * @param float $Sales
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setSales($Sales)
    {
      $this->Sales = $Sales;
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return float
     */
    public function getTax()
    {
      return $this->Tax;
    }

    /**
     * @param float $Tax
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTax($Tax)
    {
      $this->Tax = $Tax;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxCode()
    {
      return $this->TaxCode;
    }

    /**
     * @param string $TaxCode
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTaxCode($TaxCode)
    {
      $this->TaxCode = $TaxCode;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getTaxCodes()
    {
      return $this->TaxCodes;
    }

    /**
     * @param ArrayOfstring $TaxCodes
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTaxCodes($TaxCodes)
    {
      $this->TaxCodes = $TaxCodes;
      return $this;
    }

    /**
     * @return ArrayOfdecimal
     */
    public function getTaxes()
    {
      return $this->Taxes;
    }

    /**
     * @param ArrayOfdecimal $Taxes
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTaxes($Taxes)
    {
      $this->Taxes = $Taxes;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderDescription()
    {
      return $this->TenderDescription;
    }

    /**
     * @param string $TenderDescription
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTenderDescription($TenderDescription)
    {
      $this->TenderDescription = $TenderDescription;
      return $this;
    }

    /**
     * @return int
     */
    public function getTenderId()
    {
      return $this->TenderId;
    }

    /**
     * @param int $TenderId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTenderId($TenderId)
    {
      $this->TenderId = $TenderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getTenderType()
    {
      return $this->TenderType;
    }

    /**
     * @param string $TenderType
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTenderType($TenderType)
    {
      $this->TenderType = $TenderType;
      return $this;
    }

    /**
     * @return ArrayOfExportTender
     */
    public function getTenders()
    {
      return $this->Tenders;
    }

    /**
     * @param ArrayOfExportTender $Tenders
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTenders($Tenders)
    {
      $this->Tenders = $Tenders;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionId()
    {
      return $this->TransactionId;
    }

    /**
     * @param int $TransactionId
     * @return \Opsuite\BatchExport\ExportItem
     */
    public function setTransactionId($TransactionId)
    {
      $this->TransactionId = $TransactionId;
      return $this;
    }

}
