<?php

namespace Opsuite\BatchExport;

class ExportCategory
{

    /**
     * @var string $CatCode
     */
    protected $CatCode = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var string $DeptCode
     */
    protected $DeptCode = null;

    /**
     * @var guid $Id
     */
    protected $Id = null;

    /**
     * @var guid $ParentId
     */
    protected $ParentId = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var float $Sales
     */
    protected $Sales = null;

    /**
     * @var float $Tax
     */
    protected $Tax = null;

    /**
     * @var ArrayOfstring $TaxCodes
     */
    protected $TaxCodes = null;

    /**
     * @var ArrayOfdecimal $Taxes
     */
    protected $Taxes = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getCatCode()
    {
      return $this->CatCode;
    }

    /**
     * @param string $CatCode
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setCatCode($CatCode)
    {
      $this->CatCode = $CatCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeptCode()
    {
      return $this->DeptCode;
    }

    /**
     * @param string $DeptCode
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setDeptCode($DeptCode)
    {
      $this->DeptCode = $DeptCode;
      return $this;
    }

    /**
     * @return guid
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param guid $Id
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return guid
     */
    public function getParentId()
    {
      return $this->ParentId;
    }

    /**
     * @param guid $ParentId
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setParentId($ParentId)
    {
      $this->ParentId = $ParentId;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getSales()
    {
      return $this->Sales;
    }

    /**
     * @param float $Sales
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setSales($Sales)
    {
      $this->Sales = $Sales;
      return $this;
    }

    /**
     * @return float
     */
    public function getTax()
    {
      return $this->Tax;
    }

    /**
     * @param float $Tax
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setTax($Tax)
    {
      $this->Tax = $Tax;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getTaxCodes()
    {
      return $this->TaxCodes;
    }

    /**
     * @param ArrayOfstring $TaxCodes
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setTaxCodes($TaxCodes)
    {
      $this->TaxCodes = $TaxCodes;
      return $this;
    }

    /**
     * @return ArrayOfdecimal
     */
    public function getTaxes()
    {
      return $this->Taxes;
    }

    /**
     * @param ArrayOfdecimal $Taxes
     * @return \Opsuite\BatchExport\ExportCategory
     */
    public function setTaxes($Taxes)
    {
      $this->Taxes = $Taxes;
      return $this;
    }

}
