<?php

namespace Opsuite\BatchExport;

class ExportBatch
{

    /**
     * @var ArrayOfExportPayment $AccountOrderPayments
     */
    protected $AccountOrderPayments = null;

    /**
     * @var ArrayOfExportPayment $AccountPayments
     */
    protected $AccountPayments = null;

    /**
     * @var ArrayOfExportCategory $BatchCategories
     */
    protected $BatchCategories = null;

    /**
     * @var ArrayOfExportDepartment $BatchDepartments
     */
    protected $BatchDepartments = null;

    /**
     * @var guid $BatchId
     */
    protected $BatchId = null;

    /**
     * @var ArrayOfExportItem $BatchItems
     */
    protected $BatchItems = null;

    /**
     * @var int $BatchNumber
     */
    protected $BatchNumber = null;

    /**
     * @var float $CustomerDepositMade
     */
    protected $CustomerDepositMade = null;

    /**
     * @var float $CustomerDepositRedeemed
     */
    protected $CustomerDepositRedeemed = null;

    /**
     * @var \DateTime $Date
     */
    protected $Date = null;

    /**
     * @var ArrayOfExportDrop $Drops
     */
    protected $Drops = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var ArrayOfExportPayment $OrderPayments
     */
    protected $OrderPayments = null;

    /**
     * @var ArrayOfExportPayout $Payouts
     */
    protected $Payouts = null;

    /**
     * @var int $RegisterId
     */
    protected $RegisterId = null;

    /**
     * @var int $RegisterNumber
     */
    protected $RegisterNumber = null;

    /**
     * @var int $Status
     */
    protected $Status = null;

    /**
     * @var ArrayOfExportTax $Taxes
     */
    protected $Taxes = null;

    /**
     * @var ArrayOfExportTender $Tenders
     */
    protected $Tenders = null;

    /**
     * @var float $TotalDropped
     */
    protected $TotalDropped = null;

    /**
     * @var float $TotalPaidOut
     */
    protected $TotalPaidOut = null;

    /**
     * @var float $TotalShipping
     */
    protected $TotalShipping = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ArrayOfExportPayment
     */
    public function getAccountOrderPayments()
    {
      return $this->AccountOrderPayments;
    }

    /**
     * @param ArrayOfExportPayment $AccountOrderPayments
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setAccountOrderPayments($AccountOrderPayments)
    {
      $this->AccountOrderPayments = $AccountOrderPayments;
      return $this;
    }

    /**
     * @return ArrayOfExportPayment
     */
    public function getAccountPayments()
    {
      return $this->AccountPayments;
    }

    /**
     * @param ArrayOfExportPayment $AccountPayments
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setAccountPayments($AccountPayments)
    {
      $this->AccountPayments = $AccountPayments;
      return $this;
    }

    /**
     * @return ArrayOfExportCategory
     */
    public function getBatchCategories()
    {
      return $this->BatchCategories;
    }

    /**
     * @param ArrayOfExportCategory $BatchCategories
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setBatchCategories($BatchCategories)
    {
      $this->BatchCategories = $BatchCategories;
      return $this;
    }

    /**
     * @return ArrayOfExportDepartment
     */
    public function getBatchDepartments()
    {
      return $this->BatchDepartments;
    }

    /**
     * @param ArrayOfExportDepartment $BatchDepartments
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setBatchDepartments($BatchDepartments)
    {
      $this->BatchDepartments = $BatchDepartments;
      return $this;
    }

    /**
     * @return guid
     */
    public function getBatchId()
    {
      return $this->BatchId;
    }

    /**
     * @param guid $BatchId
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setBatchId($BatchId)
    {
      $this->BatchId = $BatchId;
      return $this;
    }

    /**
     * @return ArrayOfExportItem
     */
    public function getBatchItems()
    {
      return $this->BatchItems;
    }

    /**
     * @param ArrayOfExportItem $BatchItems
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setBatchItems($BatchItems)
    {
      $this->BatchItems = $BatchItems;
      return $this;
    }

    /**
     * @return int
     */
    public function getBatchNumber()
    {
      return $this->BatchNumber;
    }

    /**
     * @param int $BatchNumber
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setBatchNumber($BatchNumber)
    {
      $this->BatchNumber = $BatchNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomerDepositMade()
    {
      return $this->CustomerDepositMade;
    }

    /**
     * @param float $CustomerDepositMade
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setCustomerDepositMade($CustomerDepositMade)
    {
      $this->CustomerDepositMade = $CustomerDepositMade;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomerDepositRedeemed()
    {
      return $this->CustomerDepositRedeemed;
    }

    /**
     * @param float $CustomerDepositRedeemed
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setCustomerDepositRedeemed($CustomerDepositRedeemed)
    {
      $this->CustomerDepositRedeemed = $CustomerDepositRedeemed;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
      if ($this->Date == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->Date);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $Date
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setDate(\DateTime $Date = null)
    {
      if ($Date == null) {
       $this->Date = null;
      } else {
        $this->Date = $Date->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfExportDrop
     */
    public function getDrops()
    {
      return $this->Drops;
    }

    /**
     * @param ArrayOfExportDrop $Drops
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setDrops($Drops)
    {
      $this->Drops = $Drops;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return ArrayOfExportPayment
     */
    public function getOrderPayments()
    {
      return $this->OrderPayments;
    }

    /**
     * @param ArrayOfExportPayment $OrderPayments
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setOrderPayments($OrderPayments)
    {
      $this->OrderPayments = $OrderPayments;
      return $this;
    }

    /**
     * @return ArrayOfExportPayout
     */
    public function getPayouts()
    {
      return $this->Payouts;
    }

    /**
     * @param ArrayOfExportPayout $Payouts
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setPayouts($Payouts)
    {
      $this->Payouts = $Payouts;
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterId()
    {
      return $this->RegisterId;
    }

    /**
     * @param int $RegisterId
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setRegisterId($RegisterId)
    {
      $this->RegisterId = $RegisterId;
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterNumber()
    {
      return $this->RegisterNumber;
    }

    /**
     * @param int $RegisterNumber
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setRegisterNumber($RegisterNumber)
    {
      $this->RegisterNumber = $RegisterNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param int $Status
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return ArrayOfExportTax
     */
    public function getTaxes()
    {
      return $this->Taxes;
    }

    /**
     * @param ArrayOfExportTax $Taxes
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setTaxes($Taxes)
    {
      $this->Taxes = $Taxes;
      return $this;
    }

    /**
     * @return ArrayOfExportTender
     */
    public function getTenders()
    {
      return $this->Tenders;
    }

    /**
     * @param ArrayOfExportTender $Tenders
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setTenders($Tenders)
    {
      $this->Tenders = $Tenders;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalDropped()
    {
      return $this->TotalDropped;
    }

    /**
     * @param float $TotalDropped
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setTotalDropped($TotalDropped)
    {
      $this->TotalDropped = $TotalDropped;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalPaidOut()
    {
      return $this->TotalPaidOut;
    }

    /**
     * @param float $TotalPaidOut
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setTotalPaidOut($TotalPaidOut)
    {
      $this->TotalPaidOut = $TotalPaidOut;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalShipping()
    {
      return $this->TotalShipping;
    }

    /**
     * @param float $TotalShipping
     * @return \Opsuite\BatchExport\ExportBatch
     */
    public function setTotalShipping($TotalShipping)
    {
      $this->TotalShipping = $TotalShipping;
      return $this;
    }

}
