<?php

namespace Opsuite\BatchExport;

use Opsuite\WSSSoapClient;

class BatchExportService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfstring' => 'Opsuite\\BatchExport\\ArrayOfstring',
      'ArrayOfdecimal' => 'Opsuite\\BatchExport\\ArrayOfdecimal',
      'ArrayOfint' => 'Opsuite\\BatchExport\\ArrayOfint',
      'ArrayOfExportBatch' => 'Opsuite\\BatchExport\\ArrayOfExportBatch',
      'ExportBatch' => 'Opsuite\\BatchExport\\ExportBatch',
      'ArrayOfExportPayment' => 'Opsuite\\BatchExport\\ArrayOfExportPayment',
      'ExportPayment' => 'Opsuite\\BatchExport\\ExportPayment',
      'ArrayOfExportTender' => 'Opsuite\\BatchExport\\ArrayOfExportTender',
      'ExportTender' => 'Opsuite\\BatchExport\\ExportTender',
      'ArrayOfExportCategory' => 'Opsuite\\BatchExport\\ArrayOfExportCategory',
      'ExportCategory' => 'Opsuite\\BatchExport\\ExportCategory',
      'ArrayOfExportDepartment' => 'Opsuite\\BatchExport\\ArrayOfExportDepartment',
      'ExportDepartment' => 'Opsuite\\BatchExport\\ExportDepartment',
      'ArrayOfExportItem' => 'Opsuite\\BatchExport\\ArrayOfExportItem',
      'ExportItem' => 'Opsuite\\BatchExport\\ExportItem',
      'ArrayOfExportItemBenefit' => 'Opsuite\\BatchExport\\ArrayOfExportItemBenefit',
      'ExportItemBenefit' => 'Opsuite\\BatchExport\\ExportItemBenefit',
      'ArrayOfExportDrop' => 'Opsuite\\BatchExport\\ArrayOfExportDrop',
      'ExportDrop' => 'Opsuite\\BatchExport\\ExportDrop',
      'ArrayOfExportPayout' => 'Opsuite\\BatchExport\\ArrayOfExportPayout',
      'ExportPayout' => 'Opsuite\\BatchExport\\ExportPayout',
      'ArrayOfExportTax' => 'Opsuite\\BatchExport\\ArrayOfExportTax',
      'ExportTax' => 'Opsuite\\BatchExport\\ExportTax',
      'GLExport' => 'Opsuite\\BatchExport\\GLExport',
      'GLExportResponse' => 'Opsuite\\BatchExport\\GLExportResponse',
      'GLExportByLocationId' => 'Opsuite\\BatchExport\\GLExportByLocationId',
      'GLExportByLocationIdResponse' => 'Opsuite\\BatchExport\\GLExportByLocationIdResponse',
      'GLExportByLocationIdAndBatchId' => 'Opsuite\\BatchExport\\GLExportByLocationIdAndBatchId',
      'GLExportByLocationIdAndBatchIdResponse' => 'Opsuite\\BatchExport\\GLExportByLocationIdAndBatchIdResponse',
      'GLExportByLocationIdAndBatchStatus' => 'Opsuite\\BatchExport\\GLExportByLocationIdAndBatchStatus',
      'GLExportByLocationIdAndBatchStatusResponse' => 'Opsuite\\BatchExport\\GLExportByLocationIdAndBatchStatusResponse',
      'GetBatchNumbersByLocationIdAndBatchStatus' => 'Opsuite\\BatchExport\\GetBatchNumbersByLocationIdAndBatchStatus',
      'GetBatchNumbersByLocationIdAndBatchStatusResponse' => 'Opsuite\\BatchExport\\GetBatchNumbersByLocationIdAndBatchStatusResponse',
      'GetBatchNumbersByLocationIdBatchStatusAndDateTime' => 'Opsuite\\BatchExport\\GetBatchNumbersByLocationIdBatchStatusAndDateTime',
      'GetBatchNumbersByLocationIdBatchStatusAndDateTimeResponse' => 'Opsuite\\BatchExport\\GetBatchNumbersByLocationIdBatchStatusAndDateTimeResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/BatchExportService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GLExport $parameters
     * @return GLExportResponse
     */
    public function GLExport(GLExport $parameters)
    {
      return $this->__soapCall('GLExport', array($parameters));
    }

    /**
     * @param GLExportByLocationId $parameters
     * @return GLExportByLocationIdResponse
     */
    public function GLExportByLocationId(GLExportByLocationId $parameters)
    {
      return $this->__soapCall('GLExportByLocationId', array($parameters));
    }

    /**
     * @param GLExportByLocationIdAndBatchId $parameters
     * @return GLExportByLocationIdAndBatchIdResponse
     */
    public function GLExportByLocationIdAndBatchId(GLExportByLocationIdAndBatchId $parameters)
    {
      return $this->__soapCall('GLExportByLocationIdAndBatchId', array($parameters));
    }

    /**
     * @param GLExportByLocationIdAndBatchStatus $parameters
     * @return GLExportByLocationIdAndBatchStatusResponse
     */
    public function GLExportByLocationIdAndBatchStatus(GLExportByLocationIdAndBatchStatus $parameters)
    {
      return $this->__soapCall('GLExportByLocationIdAndBatchStatus', array($parameters));
    }

    /**
     * @param GetBatchNumbersByLocationIdAndBatchStatus $parameters
     * @return GetBatchNumbersByLocationIdAndBatchStatusResponse
     */
    public function GetBatchNumbersByLocationIdAndBatchStatus(GetBatchNumbersByLocationIdAndBatchStatus $parameters)
    {
      return $this->__soapCall('GetBatchNumbersByLocationIdAndBatchStatus', array($parameters));
    }

    /**
     * @param GetBatchNumbersByLocationIdBatchStatusAndDateTime $parameters
     * @return GetBatchNumbersByLocationIdBatchStatusAndDateTimeResponse
     */
    public function GetBatchNumbersByLocationIdBatchStatusAndDateTime(GetBatchNumbersByLocationIdBatchStatusAndDateTime $parameters)
    {
      return $this->__soapCall('GetBatchNumbersByLocationIdBatchStatusAndDateTime', array($parameters));
    }

}
