<?php

namespace Opsuite\BatchExport;

class ArrayOfExportTender implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportTender[] $ExportTender
     */
    protected $ExportTender = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportTender[]
     */
    public function getExportTender()
    {
      return $this->ExportTender;
    }

    /**
     * @param ExportTender[] $ExportTender
     * @return \Opsuite\BatchExport\ArrayOfExportTender
     */
    public function setExportTender(array $ExportTender = null)
    {
      $this->ExportTender = $ExportTender;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportTender[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportTender
     */
    public function offsetGet($offset)
    {
      return $this->ExportTender[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportTender $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportTender[] = $value;
      } else {
        $this->ExportTender[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportTender[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportTender Return the current element
     */
    public function current()
    {
      return current($this->ExportTender);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportTender);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportTender);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportTender);
    }

    /**
     * Countable implementation
     *
     * @return ExportTender Return count of elements
     */
    public function count()
    {
      return count($this->ExportTender);
    }

}
