<?php

namespace Opsuite\BatchExport;

class ArrayOfExportTax implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportTax[] $ExportTax
     */
    protected $ExportTax = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportTax[]
     */
    public function getExportTax()
    {
      return $this->ExportTax;
    }

    /**
     * @param ExportTax[] $ExportTax
     * @return \Opsuite\BatchExport\ArrayOfExportTax
     */
    public function setExportTax(array $ExportTax = null)
    {
      $this->ExportTax = $ExportTax;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportTax[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportTax
     */
    public function offsetGet($offset)
    {
      return $this->ExportTax[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportTax $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportTax[] = $value;
      } else {
        $this->ExportTax[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportTax[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportTax Return the current element
     */
    public function current()
    {
      return current($this->ExportTax);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportTax);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportTax);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportTax);
    }

    /**
     * Countable implementation
     *
     * @return ExportTax Return count of elements
     */
    public function count()
    {
      return count($this->ExportTax);
    }

}
