<?php

namespace Opsuite\BatchExport;

class ArrayOfExportPayout implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportPayout[] $ExportPayout
     */
    protected $ExportPayout = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportPayout[]
     */
    public function getExportPayout()
    {
      return $this->ExportPayout;
    }

    /**
     * @param ExportPayout[] $ExportPayout
     * @return \Opsuite\BatchExport\ArrayOfExportPayout
     */
    public function setExportPayout(array $ExportPayout = null)
    {
      $this->ExportPayout = $ExportPayout;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportPayout[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportPayout
     */
    public function offsetGet($offset)
    {
      return $this->ExportPayout[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportPayout $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportPayout[] = $value;
      } else {
        $this->ExportPayout[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportPayout[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportPayout Return the current element
     */
    public function current()
    {
      return current($this->ExportPayout);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportPayout);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportPayout);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportPayout);
    }

    /**
     * Countable implementation
     *
     * @return ExportPayout Return count of elements
     */
    public function count()
    {
      return count($this->ExportPayout);
    }

}
