<?php

namespace Opsuite\BatchExport;

class ArrayOfExportPayment implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportPayment[] $ExportPayment
     */
    protected $ExportPayment = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportPayment[]
     */
    public function getExportPayment()
    {
      return $this->ExportPayment;
    }

    /**
     * @param ExportPayment[] $ExportPayment
     * @return \Opsuite\BatchExport\ArrayOfExportPayment
     */
    public function setExportPayment(array $ExportPayment = null)
    {
      $this->ExportPayment = $ExportPayment;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportPayment[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportPayment
     */
    public function offsetGet($offset)
    {
      return $this->ExportPayment[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportPayment $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportPayment[] = $value;
      } else {
        $this->ExportPayment[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportPayment[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportPayment Return the current element
     */
    public function current()
    {
      return current($this->ExportPayment);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportPayment);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportPayment);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportPayment);
    }

    /**
     * Countable implementation
     *
     * @return ExportPayment Return count of elements
     */
    public function count()
    {
      return count($this->ExportPayment);
    }

}
