<?php

namespace Opsuite\BatchExport;

class ArrayOfExportItemBenefit implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportItemBenefit[] $ExportItemBenefit
     */
    protected $ExportItemBenefit = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportItemBenefit[]
     */
    public function getExportItemBenefit()
    {
      return $this->ExportItemBenefit;
    }

    /**
     * @param ExportItemBenefit[] $ExportItemBenefit
     * @return \Opsuite\BatchExport\ArrayOfExportItemBenefit
     */
    public function setExportItemBenefit(array $ExportItemBenefit = null)
    {
      $this->ExportItemBenefit = $ExportItemBenefit;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportItemBenefit[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportItemBenefit
     */
    public function offsetGet($offset)
    {
      return $this->ExportItemBenefit[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportItemBenefit $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportItemBenefit[] = $value;
      } else {
        $this->ExportItemBenefit[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportItemBenefit[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportItemBenefit Return the current element
     */
    public function current()
    {
      return current($this->ExportItemBenefit);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportItemBenefit);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportItemBenefit);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportItemBenefit);
    }

    /**
     * Countable implementation
     *
     * @return ExportItemBenefit Return count of elements
     */
    public function count()
    {
      return count($this->ExportItemBenefit);
    }

}
