<?php

namespace Opsuite\BatchExport;

class ArrayOfExportItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportItem[] $ExportItem
     */
    protected $ExportItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportItem[]
     */
    public function getExportItem()
    {
      return $this->ExportItem;
    }

    /**
     * @param ExportItem[] $ExportItem
     * @return \Opsuite\BatchExport\ArrayOfExportItem
     */
    public function setExportItem(array $ExportItem = null)
    {
      $this->ExportItem = $ExportItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportItem
     */
    public function offsetGet($offset)
    {
      return $this->ExportItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportItem[] = $value;
      } else {
        $this->ExportItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportItem Return the current element
     */
    public function current()
    {
      return current($this->ExportItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportItem);
    }

    /**
     * Countable implementation
     *
     * @return ExportItem Return count of elements
     */
    public function count()
    {
      return count($this->ExportItem);
    }

}
