<?php

namespace Opsuite\BatchExport;

class ArrayOfExportCategory implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportCategory[] $ExportCategory
     */
    protected $ExportCategory = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportCategory[]
     */
    public function getExportCategory()
    {
      return $this->ExportCategory;
    }

    /**
     * @param ExportCategory[] $ExportCategory
     * @return \Opsuite\BatchExport\ArrayOfExportCategory
     */
    public function setExportCategory(array $ExportCategory = null)
    {
      $this->ExportCategory = $ExportCategory;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportCategory[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportCategory
     */
    public function offsetGet($offset)
    {
      return $this->ExportCategory[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportCategory $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportCategory[] = $value;
      } else {
        $this->ExportCategory[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportCategory[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportCategory Return the current element
     */
    public function current()
    {
      return current($this->ExportCategory);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportCategory);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportCategory);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportCategory);
    }

    /**
     * Countable implementation
     *
     * @return ExportCategory Return count of elements
     */
    public function count()
    {
      return count($this->ExportCategory);
    }

}
