<?php

namespace Opsuite\BatchExport;

class ArrayOfExportBatch implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportBatch[] $ExportBatch
     */
    protected $ExportBatch = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportBatch[]
     */
    public function getExportBatch()
    {
      return $this->ExportBatch;
    }

    /**
     * @param ExportBatch[] $ExportBatch
     * @return \Opsuite\BatchExport\ArrayOfExportBatch
     */
    public function setExportBatch(array $ExportBatch = null)
    {
      $this->ExportBatch = $ExportBatch;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportBatch[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportBatch
     */
    public function offsetGet($offset)
    {
      return $this->ExportBatch[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportBatch $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportBatch[] = $value;
      } else {
        $this->ExportBatch[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportBatch[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportBatch Return the current element
     */
    public function current()
    {
      return current($this->ExportBatch);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportBatch);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportBatch);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportBatch);
    }

    /**
     * Countable implementation
     *
     * @return ExportBatch Return count of elements
     */
    public function count()
    {
      return count($this->ExportBatch);
    }

}
