<?php

namespace Opsuite\Admin;

class ItemAuditEntry
{

    /**
     * @var string $AuditColumn
     */
    protected $AuditColumn = null;

    /**
     * @var string $Became
     */
    protected $Became = null;

    /**
     * @var \DateTime $DateChanged
     */
    protected $DateChanged = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var string $StoreName
     */
    protected $StoreName = null;

    /**
     * @var string $User
     */
    protected $User = null;

    /**
     * @var string $Was
     */
    protected $Was = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getAuditColumn()
    {
      return $this->AuditColumn;
    }

    /**
     * @param string $AuditColumn
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setAuditColumn($AuditColumn)
    {
      $this->AuditColumn = $AuditColumn;
      return $this;
    }

    /**
     * @return string
     */
    public function getBecame()
    {
      return $this->Became;
    }

    /**
     * @param string $Became
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setBecame($Became)
    {
      $this->Became = $Became;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateChanged()
    {
      if ($this->DateChanged == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateChanged);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateChanged
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setDateChanged(\DateTime $DateChanged = null)
    {
      if ($DateChanged == null) {
       $this->DateChanged = null;
      } else {
        $this->DateChanged = $DateChanged->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return string
     */
    public function getStoreName()
    {
      return $this->StoreName;
    }

    /**
     * @param string $StoreName
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setStoreName($StoreName)
    {
      $this->StoreName = $StoreName;
      return $this;
    }

    /**
     * @return string
     */
    public function getUser()
    {
      return $this->User;
    }

    /**
     * @param string $User
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setUser($User)
    {
      $this->User = $User;
      return $this;
    }

    /**
     * @return string
     */
    public function getWas()
    {
      return $this->Was;
    }

    /**
     * @param string $Was
     * @return \Opsuite\Admin\ItemAuditEntry
     */
    public function setWas($Was)
    {
      $this->Was = $Was;
      return $this;
    }

}
