<?php

namespace Opsuite\Admin;

class GetItemAuditHistory
{

    /**
     * @var ArrayOfstring $auditColumns
     */
    protected $auditColumns = null;

    /**
     * @var \DateTime $auditPeriodStartDate
     */
    protected $auditPeriodStartDate = null;

    /**
     * @var \DateTime $auditPeriodEndDate
     */
    protected $auditPeriodEndDate = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @param ArrayOfstring $auditColumns
     * @param \DateTime $auditPeriodStartDate
     * @param \DateTime $auditPeriodEndDate
     * @param int $locationId
     */
    public function __construct($auditColumns, \DateTime $auditPeriodStartDate, \DateTime $auditPeriodEndDate, $locationId)
    {
      $this->auditColumns = $auditColumns;
      $this->auditPeriodStartDate = $auditPeriodStartDate->format(\DateTime::ATOM);
      $this->auditPeriodEndDate = $auditPeriodEndDate->format(\DateTime::ATOM);
      $this->locationId = $locationId;
    }

    /**
     * @return ArrayOfstring
     */
    public function getAuditColumns()
    {
      return $this->auditColumns;
    }

    /**
     * @param ArrayOfstring $auditColumns
     * @return \Opsuite\Admin\GetItemAuditHistory
     */
    public function setAuditColumns($auditColumns)
    {
      $this->auditColumns = $auditColumns;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getAuditPeriodStartDate()
    {
      if ($this->auditPeriodStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->auditPeriodStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $auditPeriodStartDate
     * @return \Opsuite\Admin\GetItemAuditHistory
     */
    public function setAuditPeriodStartDate(\DateTime $auditPeriodStartDate)
    {
      $this->auditPeriodStartDate = $auditPeriodStartDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getAuditPeriodEndDate()
    {
      if ($this->auditPeriodEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->auditPeriodEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $auditPeriodEndDate
     * @return \Opsuite\Admin\GetItemAuditHistory
     */
    public function setAuditPeriodEndDate(\DateTime $auditPeriodEndDate)
    {
      $this->auditPeriodEndDate = $auditPeriodEndDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Admin\GetItemAuditHistory
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

}
