<?php

namespace Opsuite\Admin;

class AttributeGroup
{

    /**
     * @var TagTypeEnum $AttributeType
     */
    protected $AttributeType = null;

    /**
     * @var ArrayOfAttribute $Attributes
     */
    protected $Attributes = null;

    /**
     * @var string $Code
     */
    protected $Code = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var boolean $IsRequired
     */
    protected $IsRequired = null;

    /**
     * @var boolean $UseAsMatrixDimension
     */
    protected $UseAsMatrixDimension = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TagTypeEnum
     */
    public function getAttributeType()
    {
      return $this->AttributeType;
    }

    /**
     * @param TagTypeEnum $AttributeType
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setAttributeType($AttributeType)
    {
      $this->AttributeType = $AttributeType;
      return $this;
    }

    /**
     * @return ArrayOfAttribute
     */
    public function getAttributes()
    {
      return $this->Attributes;
    }

    /**
     * @param ArrayOfAttribute $Attributes
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setAttributes($Attributes)
    {
      $this->Attributes = $Attributes;
      return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
      return $this->Code;
    }

    /**
     * @param string $Code
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setCode($Code)
    {
      $this->Code = $Code;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsRequired()
    {
      return $this->IsRequired;
    }

    /**
     * @param boolean $IsRequired
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setIsRequired($IsRequired)
    {
      $this->IsRequired = $IsRequired;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getUseAsMatrixDimension()
    {
      return $this->UseAsMatrixDimension;
    }

    /**
     * @param boolean $UseAsMatrixDimension
     * @return \Opsuite\Admin\AttributeGroup
     */
    public function setUseAsMatrixDimension($UseAsMatrixDimension)
    {
      $this->UseAsMatrixDimension = $UseAsMatrixDimension;
      return $this;
    }

}
