<?php

namespace Opsuite\Admin;

class ArrayOfTaxGroup implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TaxGroup[] $TaxGroup
     */
    protected $TaxGroup = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TaxGroup[]
     */
    public function getTaxGroup()
    {
      return $this->TaxGroup;
    }

    /**
     * @param TaxGroup[] $TaxGroup
     * @return \Opsuite\Admin\ArrayOfTaxGroup
     */
    public function setTaxGroup(array $TaxGroup = null)
    {
      $this->TaxGroup = $TaxGroup;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TaxGroup[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TaxGroup
     */
    public function offsetGet($offset)
    {
      return $this->TaxGroup[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TaxGroup $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TaxGroup[] = $value;
      } else {
        $this->TaxGroup[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TaxGroup[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TaxGroup Return the current element
     */
    public function current()
    {
      return current($this->TaxGroup);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TaxGroup);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TaxGroup);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TaxGroup);
    }

    /**
     * Countable implementation
     *
     * @return TaxGroup Return count of elements
     */
    public function count()
    {
      return count($this->TaxGroup);
    }

}
