<?php

namespace Opsuite\Admin;

class ArrayOfShippingService implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ShippingService[] $ShippingService
     */
    protected $ShippingService = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ShippingService[]
     */
    public function getShippingService()
    {
      return $this->ShippingService;
    }

    /**
     * @param ShippingService[] $ShippingService
     * @return \Opsuite\Admin\ArrayOfShippingService
     */
    public function setShippingService(array $ShippingService = null)
    {
      $this->ShippingService = $ShippingService;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ShippingService[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ShippingService
     */
    public function offsetGet($offset)
    {
      return $this->ShippingService[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ShippingService $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ShippingService[] = $value;
      } else {
        $this->ShippingService[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ShippingService[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ShippingService Return the current element
     */
    public function current()
    {
      return current($this->ShippingService);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ShippingService);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ShippingService);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ShippingService);
    }

    /**
     * Countable implementation
     *
     * @return ShippingService Return count of elements
     */
    public function count()
    {
      return count($this->ShippingService);
    }

}
