<?php

namespace Opsuite\Admin;

class ArrayOfShippingCarrier implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ShippingCarrier[] $ShippingCarrier
     */
    protected $ShippingCarrier = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ShippingCarrier[]
     */
    public function getShippingCarrier()
    {
      return $this->ShippingCarrier;
    }

    /**
     * @param ShippingCarrier[] $ShippingCarrier
     * @return \Opsuite\Admin\ArrayOfShippingCarrier
     */
    public function setShippingCarrier(array $ShippingCarrier = null)
    {
      $this->ShippingCarrier = $ShippingCarrier;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ShippingCarrier[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ShippingCarrier
     */
    public function offsetGet($offset)
    {
      return $this->ShippingCarrier[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ShippingCarrier $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ShippingCarrier[] = $value;
      } else {
        $this->ShippingCarrier[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ShippingCarrier[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ShippingCarrier Return the current element
     */
    public function current()
    {
      return current($this->ShippingCarrier);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ShippingCarrier);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ShippingCarrier);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ShippingCarrier);
    }

    /**
     * Countable implementation
     *
     * @return ShippingCarrier Return count of elements
     */
    public function count()
    {
      return count($this->ShippingCarrier);
    }

}
