<?php

namespace Opsuite\Admin;

class ArrayOfReasonCode implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ReasonCode[] $ReasonCode
     */
    protected $ReasonCode = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ReasonCode[]
     */
    public function getReasonCode()
    {
      return $this->ReasonCode;
    }

    /**
     * @param ReasonCode[] $ReasonCode
     * @return \Opsuite\Admin\ArrayOfReasonCode
     */
    public function setReasonCode(array $ReasonCode = null)
    {
      $this->ReasonCode = $ReasonCode;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ReasonCode[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ReasonCode
     */
    public function offsetGet($offset)
    {
      return $this->ReasonCode[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ReasonCode $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ReasonCode[] = $value;
      } else {
        $this->ReasonCode[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ReasonCode[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ReasonCode Return the current element
     */
    public function current()
    {
      return current($this->ReasonCode);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ReasonCode);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ReasonCode);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ReasonCode);
    }

    /**
     * Countable implementation
     *
     * @return ReasonCode Return count of elements
     */
    public function count()
    {
      return count($this->ReasonCode);
    }

}
