<?php

namespace Opsuite\Admin;

class ArrayOfItemAuditEntry implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ItemAuditEntry[] $ItemAuditEntry
     */
    protected $ItemAuditEntry = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ItemAuditEntry[]
     */
    public function getItemAuditEntry()
    {
      return $this->ItemAuditEntry;
    }

    /**
     * @param ItemAuditEntry[] $ItemAuditEntry
     * @return \Opsuite\Admin\ArrayOfItemAuditEntry
     */
    public function setItemAuditEntry(array $ItemAuditEntry = null)
    {
      $this->ItemAuditEntry = $ItemAuditEntry;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ItemAuditEntry[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ItemAuditEntry
     */
    public function offsetGet($offset)
    {
      return $this->ItemAuditEntry[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ItemAuditEntry $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ItemAuditEntry[] = $value;
      } else {
        $this->ItemAuditEntry[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ItemAuditEntry[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ItemAuditEntry Return the current element
     */
    public function current()
    {
      return current($this->ItemAuditEntry);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ItemAuditEntry);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ItemAuditEntry);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ItemAuditEntry);
    }

    /**
     * Countable implementation
     *
     * @return ItemAuditEntry Return count of elements
     */
    public function count()
    {
      return count($this->ItemAuditEntry);
    }

}
