<?php

namespace Opsuite\Admin;

class ArrayOfAttributeGroup implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AttributeGroup[] $AttributeGroup
     */
    protected $AttributeGroup = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AttributeGroup[]
     */
    public function getAttributeGroup()
    {
      return $this->AttributeGroup;
    }

    /**
     * @param AttributeGroup[] $AttributeGroup
     * @return \Opsuite\Admin\ArrayOfAttributeGroup
     */
    public function setAttributeGroup(array $AttributeGroup = null)
    {
      $this->AttributeGroup = $AttributeGroup;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AttributeGroup[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AttributeGroup
     */
    public function offsetGet($offset)
    {
      return $this->AttributeGroup[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AttributeGroup $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AttributeGroup[] = $value;
      } else {
        $this->AttributeGroup[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AttributeGroup[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AttributeGroup Return the current element
     */
    public function current()
    {
      return current($this->AttributeGroup);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AttributeGroup);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AttributeGroup);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AttributeGroup);
    }

    /**
     * Countable implementation
     *
     * @return AttributeGroup Return count of elements
     */
    public function count()
    {
      return count($this->AttributeGroup);
    }

}
