<?php

namespace Opsuite\Admin;

class ArrayOfAttribute implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Attribute[] $Attribute
     */
    protected $Attribute = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Attribute[]
     */
    public function getAttribute()
    {
      return $this->Attribute;
    }

    /**
     * @param Attribute[] $Attribute
     * @return \Opsuite\Admin\ArrayOfAttribute
     */
    public function setAttribute(array $Attribute = null)
    {
      $this->Attribute = $Attribute;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Attribute[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Attribute
     */
    public function offsetGet($offset)
    {
      return $this->Attribute[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Attribute $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Attribute[] = $value;
      } else {
        $this->Attribute[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Attribute[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Attribute Return the current element
     */
    public function current()
    {
      return current($this->Attribute);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Attribute);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Attribute);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Attribute);
    }

    /**
     * Countable implementation
     *
     * @return Attribute Return count of elements
     */
    public function count()
    {
      return count($this->Attribute);
    }

}
