<?php

namespace Opsuite\Admin;

use Opsuite\WSSSoapClient;

class AdminService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfTenderType' => 'Opsuite\\Admin\\ArrayOfTenderType',
      'TenderType' => 'Opsuite\\Admin\\TenderType',
      'ArrayOfTenderDefinition' => 'Opsuite\\Admin\\ArrayOfTenderDefinition',
      'TenderDefinition' => 'Opsuite\\Admin\\TenderDefinition',
      'ArrayOfTaxRate' => 'Opsuite\\Admin\\ArrayOfTaxRate',
      'TaxRate' => 'Opsuite\\Admin\\TaxRate',
      'ArrayOfTaxGroup' => 'Opsuite\\Admin\\ArrayOfTaxGroup',
      'TaxGroup' => 'Opsuite\\Admin\\TaxGroup',
      'ArrayOfAttributeGroup' => 'Opsuite\\Admin\\ArrayOfAttributeGroup',
      'AttributeGroup' => 'Opsuite\\Admin\\AttributeGroup',
      'ArrayOfAttribute' => 'Opsuite\\Admin\\ArrayOfAttribute',
      'Attribute' => 'Opsuite\\Admin\\Attribute',
      'ArrayOfReasonCode' => 'Opsuite\\Admin\\ArrayOfReasonCode',
      'ReasonCode' => 'Opsuite\\Admin\\ReasonCode',
      'ArrayOfShippingCarrier' => 'Opsuite\\Admin\\ArrayOfShippingCarrier',
      'ShippingCarrier' => 'Opsuite\\Admin\\ShippingCarrier',
      'ArrayOfShippingService' => 'Opsuite\\Admin\\ArrayOfShippingService',
      'ShippingService' => 'Opsuite\\Admin\\ShippingService',
      'ArrayOfShippingServiceCharge' => 'Opsuite\\Admin\\ArrayOfShippingServiceCharge',
      'ShippingServiceCharge' => 'Opsuite\\Admin\\ShippingServiceCharge',
      'ArrayOfUser' => 'Opsuite\\Admin\\ArrayOfUser',
      'User' => 'Opsuite\\Admin\\User',
      'ArrayOfItemAuditColumn' => 'Opsuite\\Admin\\ArrayOfItemAuditColumn',
      'ItemAuditColumn' => 'Opsuite\\Admin\\ItemAuditColumn',
      'ArrayOfItemAuditEntry' => 'Opsuite\\Admin\\ArrayOfItemAuditEntry',
      'ItemAuditEntry' => 'Opsuite\\Admin\\ItemAuditEntry',
      'ArrayOfSubmitResultOfAttributeGroupmW6e9szI' => 'Opsuite\\Admin\\ArrayOfSubmitResultOfAttributeGroupmW6e9szI',
      'SubmitResultOfAttributeGroupmW6e9szI' => 'Opsuite\\Admin\\SubmitResultOfAttributeGroupmW6e9szI',
      'ArrayOfErrorInfoOfAttributeGroupmW6e9szI' => 'Opsuite\\Admin\\ArrayOfErrorInfoOfAttributeGroupmW6e9szI',
      'ErrorInfoOfAttributeGroupmW6e9szI' => 'Opsuite\\Admin\\ErrorInfoOfAttributeGroupmW6e9szI',
      'ArrayOfSubmitResultOfAttributemW6e9szI' => 'Opsuite\\Admin\\ArrayOfSubmitResultOfAttributemW6e9szI',
      'SubmitResultOfAttributemW6e9szI' => 'Opsuite\\Admin\\SubmitResultOfAttributemW6e9szI',
      'ArrayOfErrorInfoOfAttributemW6e9szI' => 'Opsuite\\Admin\\ArrayOfErrorInfoOfAttributemW6e9szI',
      'ErrorInfoOfAttributemW6e9szI' => 'Opsuite\\Admin\\ErrorInfoOfAttributemW6e9szI',
      'ArrayOfstring' => 'Opsuite\\Admin\\ArrayOfstring',
      'GetTenderTypes' => 'Opsuite\\Admin\\GetTenderTypes',
      'GetTenderTypesResponse' => 'Opsuite\\Admin\\GetTenderTypesResponse',
      'TenderDefinitions' => 'Opsuite\\Admin\\TenderDefinitions',
      'TenderDefinitionsResponse' => 'Opsuite\\Admin\\TenderDefinitionsResponse',
      'TenderDefinitionsForLocation' => 'Opsuite\\Admin\\TenderDefinitionsForLocation',
      'TenderDefinitionsForLocationResponse' => 'Opsuite\\Admin\\TenderDefinitionsForLocationResponse',
      'GetTaxRates' => 'Opsuite\\Admin\\GetTaxRates',
      'GetTaxRatesResponse' => 'Opsuite\\Admin\\GetTaxRatesResponse',
      'GetTaxGroups' => 'Opsuite\\Admin\\GetTaxGroups',
      'GetTaxGroupsResponse' => 'Opsuite\\Admin\\GetTaxGroupsResponse',
      'GetAttributeGroups' => 'Opsuite\\Admin\\GetAttributeGroups',
      'GetAttributeGroupsResponse' => 'Opsuite\\Admin\\GetAttributeGroupsResponse',
      'SubmitAttributesGroups' => 'Opsuite\\Admin\\SubmitAttributesGroups',
      'SubmitAttributesGroupsResponse' => 'Opsuite\\Admin\\SubmitAttributesGroupsResponse',
      'SubmitAttributeValues' => 'Opsuite\\Admin\\SubmitAttributeValues',
      'SubmitAttributeValuesResponse' => 'Opsuite\\Admin\\SubmitAttributeValuesResponse',
      'GetReasonCodes' => 'Opsuite\\Admin\\GetReasonCodes',
      'GetReasonCodesResponse' => 'Opsuite\\Admin\\GetReasonCodesResponse',
      'GetShippingCarriers' => 'Opsuite\\Admin\\GetShippingCarriers',
      'GetShippingCarriersResponse' => 'Opsuite\\Admin\\GetShippingCarriersResponse',
      'GetUsers' => 'Opsuite\\Admin\\GetUsers',
      'GetUsersResponse' => 'Opsuite\\Admin\\GetUsersResponse',
      'GetItemAuditColumns' => 'Opsuite\\Admin\\GetItemAuditColumns',
      'GetItemAuditColumnsResponse' => 'Opsuite\\Admin\\GetItemAuditColumnsResponse',
      'GetItemAuditHistory' => 'Opsuite\\Admin\\GetItemAuditHistory',
      'GetItemAuditHistoryResponse' => 'Opsuite\\Admin\\GetItemAuditHistoryResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/AdminService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetTenderTypes $parameters
     * @return GetTenderTypesResponse
     */
    public function GetTenderTypes(GetTenderTypes $parameters)
    {
      return $this->__soapCall('GetTenderTypes', array($parameters));
    }

    /**
     * @param TenderDefinitions $parameters
     * @return TenderDefinitionsResponse
     */
    public function TenderDefinitions(TenderDefinitions $parameters)
    {
      return $this->__soapCall('TenderDefinitions', array($parameters));
    }

    /**
     * @param TenderDefinitionsForLocation $parameters
     * @return TenderDefinitionsForLocationResponse
     */
    public function TenderDefinitionsForLocation(TenderDefinitionsForLocation $parameters)
    {
      return $this->__soapCall('TenderDefinitionsForLocation', array($parameters));
    }

    /**
     * @param GetTaxRates $parameters
     * @return GetTaxRatesResponse
     */
    public function GetTaxRates(GetTaxRates $parameters)
    {
      return $this->__soapCall('GetTaxRates', array($parameters));
    }

    /**
     * @param GetTaxGroups $parameters
     * @return GetTaxGroupsResponse
     */
    public function GetTaxGroups(GetTaxGroups $parameters)
    {
      return $this->__soapCall('GetTaxGroups', array($parameters));
    }

    /**
     * @param GetAttributeGroups $parameters
     * @return GetAttributeGroupsResponse
     */
    public function GetAttributeGroups(GetAttributeGroups $parameters)
    {
      return $this->__soapCall('GetAttributeGroups', array($parameters));
    }

    /**
     * @param SubmitAttributesGroups $parameters
     * @return SubmitAttributesGroupsResponse
     */
    public function SubmitAttributesGroups(SubmitAttributesGroups $parameters)
    {
      return $this->__soapCall('SubmitAttributesGroups', array($parameters));
    }

    /**
     * @param SubmitAttributeValues $parameters
     * @return SubmitAttributeValuesResponse
     */
    public function SubmitAttributeValues(SubmitAttributeValues $parameters)
    {
      return $this->__soapCall('SubmitAttributeValues', array($parameters));
    }

    /**
     * @param GetReasonCodes $parameters
     * @return GetReasonCodesResponse
     */
    public function GetReasonCodes(GetReasonCodes $parameters)
    {
      return $this->__soapCall('GetReasonCodes', array($parameters));
    }

    /**
     * @param GetShippingCarriers $parameters
     * @return GetShippingCarriersResponse
     */
    public function GetShippingCarriers(GetShippingCarriers $parameters)
    {
      return $this->__soapCall('GetShippingCarriers', array($parameters));
    }

    /**
     * @param GetUsers $parameters
     * @return GetUsersResponse
     */
    public function GetUsers(GetUsers $parameters)
    {
      return $this->__soapCall('GetUsers', array($parameters));
    }

    /**
     * @param GetItemAuditColumns $parameters
     * @return GetItemAuditColumnsResponse
     */
    public function GetItemAuditColumns(GetItemAuditColumns $parameters)
    {
      return $this->__soapCall('GetItemAuditColumns', array($parameters));
    }

    /**
     * @param GetItemAuditHistory $parameters
     * @return GetItemAuditHistoryResponse
     */
    public function GetItemAuditHistory(GetItemAuditHistory $parameters)
    {
      return $this->__soapCall('GetItemAuditHistory', array($parameters));
    }

}
