<?php
/**
 * ToolkitDataClassesStockProduct
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Model;

use \ArrayAccess;
use \Mintsoft\ObjectSerializer;

/**
 * ToolkitDataClassesStockProduct Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ToolkitDataClassesStockProduct implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Toolkit.DataClasses.Stock.Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'name' => 'string',
        'pallet_sizes' => 'string',
        'packing_instructions' => 'string',
        'description' => 'string',
        'customs_description' => 'string',
        'country_of_manufacture_id' => 'int',
        'country_of_manufacture' => '\Mintsoft\Model\ToolkitDataClassesCommonCountry',
        'ean' => 'string',
        'upc' => 'string',
        'low_stock_alert_level' => 'int',
        'weight' => 'float',
        'height' => 'float',
        'width' => 'float',
        'depth' => 'float',
        'volume' => 'float',
        'back_order' => 'bool',
        'bundle' => 'bool',
        'dis_cont' => 'bool',
        'price' => 'float',
        'cost_price' => 'float',
        'vat_exempt' => 'bool',
        'additional_parcels_required' => 'int',
        'units_per_parcel' => 'float',
        'has_batch_number' => 'bool',
        'log_batch_inbound' => 'bool',
        'log_batch_outbound' => 'bool',
        'has_serial_number' => 'bool',
        'has_expiry_date' => 'bool',
        'best_before_date_warning_period_days' => 'int',
        'commodity_code' => '\Mintsoft\Model\ToolkitDataClassesStockCommodityCode',
        'handling_time' => 'int',
        'un_number' => 'string',
        'image_url' => 'string',
        'product_hazardous_goods' => '\Mintsoft\Model\ToolkitDataClassesStockProductHazardousGoods',
        'subscription' => 'bool',
        'subscription_length' => 'int',
        'subscription_frequency' => 'string',
        'product_in_categories' => '\Mintsoft\Model\ToolkitDataClassesStockProductInCategory[]',
        'product_prices' => '\Mintsoft\Model\ToolkitDataClassesStockProductPrice[]',
        'product_suppliers' => '\Mintsoft\Model\ToolkitDataClassesStockProductInSupplier[]',
        'client_id' => 'int',
        'id' => 'int',
        'last_updated' => '\DateTime',
        'last_updated_by_user' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'name' => null,
        'pallet_sizes' => null,
        'packing_instructions' => null,
        'description' => null,
        'customs_description' => null,
        'country_of_manufacture_id' => 'int32',
        'country_of_manufacture' => null,
        'ean' => null,
        'upc' => null,
        'low_stock_alert_level' => 'int32',
        'weight' => 'double',
        'height' => 'double',
        'width' => 'double',
        'depth' => 'double',
        'volume' => 'double',
        'back_order' => null,
        'bundle' => null,
        'dis_cont' => null,
        'price' => 'double',
        'cost_price' => 'double',
        'vat_exempt' => null,
        'additional_parcels_required' => 'int32',
        'units_per_parcel' => 'double',
        'has_batch_number' => null,
        'log_batch_inbound' => null,
        'log_batch_outbound' => null,
        'has_serial_number' => null,
        'has_expiry_date' => null,
        'best_before_date_warning_period_days' => 'int32',
        'commodity_code' => null,
        'handling_time' => 'int32',
        'un_number' => null,
        'image_url' => null,
        'product_hazardous_goods' => null,
        'subscription' => null,
        'subscription_length' => 'int32',
        'subscription_frequency' => null,
        'product_in_categories' => null,
        'product_prices' => null,
        'product_suppliers' => null,
        'client_id' => 'int32',
        'id' => 'int32',
        'last_updated' => 'date-time',
        'last_updated_by_user' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'name' => false,
        'pallet_sizes' => false,
        'packing_instructions' => false,
        'description' => false,
        'customs_description' => false,
        'country_of_manufacture_id' => false,
        'country_of_manufacture' => false,
        'ean' => false,
        'upc' => false,
        'low_stock_alert_level' => false,
        'weight' => false,
        'height' => false,
        'width' => false,
        'depth' => false,
        'volume' => false,
        'back_order' => false,
        'bundle' => false,
        'dis_cont' => false,
        'price' => false,
        'cost_price' => false,
        'vat_exempt' => false,
        'additional_parcels_required' => false,
        'units_per_parcel' => false,
        'has_batch_number' => false,
        'log_batch_inbound' => false,
        'log_batch_outbound' => false,
        'has_serial_number' => false,
        'has_expiry_date' => false,
        'best_before_date_warning_period_days' => false,
        'commodity_code' => false,
        'handling_time' => false,
        'un_number' => false,
        'image_url' => false,
        'product_hazardous_goods' => false,
        'subscription' => false,
        'subscription_length' => false,
        'subscription_frequency' => false,
        'product_in_categories' => false,
        'product_prices' => false,
        'product_suppliers' => false,
        'client_id' => false,
        'id' => false,
        'last_updated' => false,
        'last_updated_by_user' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'name' => 'Name',
        'pallet_sizes' => 'PalletSizes',
        'packing_instructions' => 'PackingInstructions',
        'description' => 'Description',
        'customs_description' => 'CustomsDescription',
        'country_of_manufacture_id' => 'CountryOfManufactureId',
        'country_of_manufacture' => 'CountryOfManufacture',
        'ean' => 'EAN',
        'upc' => 'UPC',
        'low_stock_alert_level' => 'LowStockAlertLevel',
        'weight' => 'Weight',
        'height' => 'Height',
        'width' => 'Width',
        'depth' => 'Depth',
        'volume' => 'Volume',
        'back_order' => 'BackOrder',
        'bundle' => 'Bundle',
        'dis_cont' => 'DisCont',
        'price' => 'Price',
        'cost_price' => 'CostPrice',
        'vat_exempt' => 'VatExempt',
        'additional_parcels_required' => 'AdditionalParcelsRequired',
        'units_per_parcel' => 'UnitsPerParcel',
        'has_batch_number' => 'HasBatchNumber',
        'log_batch_inbound' => 'LogBatchInbound',
        'log_batch_outbound' => 'LogBatchOutbound',
        'has_serial_number' => 'HasSerialNumber',
        'has_expiry_date' => 'HasExpiryDate',
        'best_before_date_warning_period_days' => 'BestBeforeDateWarningPeriodDays',
        'commodity_code' => 'CommodityCode',
        'handling_time' => 'HandlingTime',
        'un_number' => 'UnNumber',
        'image_url' => 'ImageURL',
        'product_hazardous_goods' => 'ProductHazardousGoods',
        'subscription' => 'Subscription',
        'subscription_length' => 'SubscriptionLength',
        'subscription_frequency' => 'SubscriptionFrequency',
        'product_in_categories' => 'ProductInCategories',
        'product_prices' => 'ProductPrices',
        'product_suppliers' => 'ProductSuppliers',
        'client_id' => 'ClientId',
        'id' => 'ID',
        'last_updated' => 'LastUpdated',
        'last_updated_by_user' => 'LastUpdatedByUser'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'name' => 'setName',
        'pallet_sizes' => 'setPalletSizes',
        'packing_instructions' => 'setPackingInstructions',
        'description' => 'setDescription',
        'customs_description' => 'setCustomsDescription',
        'country_of_manufacture_id' => 'setCountryOfManufactureId',
        'country_of_manufacture' => 'setCountryOfManufacture',
        'ean' => 'setEan',
        'upc' => 'setUpc',
        'low_stock_alert_level' => 'setLowStockAlertLevel',
        'weight' => 'setWeight',
        'height' => 'setHeight',
        'width' => 'setWidth',
        'depth' => 'setDepth',
        'volume' => 'setVolume',
        'back_order' => 'setBackOrder',
        'bundle' => 'setBundle',
        'dis_cont' => 'setDisCont',
        'price' => 'setPrice',
        'cost_price' => 'setCostPrice',
        'vat_exempt' => 'setVatExempt',
        'additional_parcels_required' => 'setAdditionalParcelsRequired',
        'units_per_parcel' => 'setUnitsPerParcel',
        'has_batch_number' => 'setHasBatchNumber',
        'log_batch_inbound' => 'setLogBatchInbound',
        'log_batch_outbound' => 'setLogBatchOutbound',
        'has_serial_number' => 'setHasSerialNumber',
        'has_expiry_date' => 'setHasExpiryDate',
        'best_before_date_warning_period_days' => 'setBestBeforeDateWarningPeriodDays',
        'commodity_code' => 'setCommodityCode',
        'handling_time' => 'setHandlingTime',
        'un_number' => 'setUnNumber',
        'image_url' => 'setImageUrl',
        'product_hazardous_goods' => 'setProductHazardousGoods',
        'subscription' => 'setSubscription',
        'subscription_length' => 'setSubscriptionLength',
        'subscription_frequency' => 'setSubscriptionFrequency',
        'product_in_categories' => 'setProductInCategories',
        'product_prices' => 'setProductPrices',
        'product_suppliers' => 'setProductSuppliers',
        'client_id' => 'setClientId',
        'id' => 'setId',
        'last_updated' => 'setLastUpdated',
        'last_updated_by_user' => 'setLastUpdatedByUser'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'name' => 'getName',
        'pallet_sizes' => 'getPalletSizes',
        'packing_instructions' => 'getPackingInstructions',
        'description' => 'getDescription',
        'customs_description' => 'getCustomsDescription',
        'country_of_manufacture_id' => 'getCountryOfManufactureId',
        'country_of_manufacture' => 'getCountryOfManufacture',
        'ean' => 'getEan',
        'upc' => 'getUpc',
        'low_stock_alert_level' => 'getLowStockAlertLevel',
        'weight' => 'getWeight',
        'height' => 'getHeight',
        'width' => 'getWidth',
        'depth' => 'getDepth',
        'volume' => 'getVolume',
        'back_order' => 'getBackOrder',
        'bundle' => 'getBundle',
        'dis_cont' => 'getDisCont',
        'price' => 'getPrice',
        'cost_price' => 'getCostPrice',
        'vat_exempt' => 'getVatExempt',
        'additional_parcels_required' => 'getAdditionalParcelsRequired',
        'units_per_parcel' => 'getUnitsPerParcel',
        'has_batch_number' => 'getHasBatchNumber',
        'log_batch_inbound' => 'getLogBatchInbound',
        'log_batch_outbound' => 'getLogBatchOutbound',
        'has_serial_number' => 'getHasSerialNumber',
        'has_expiry_date' => 'getHasExpiryDate',
        'best_before_date_warning_period_days' => 'getBestBeforeDateWarningPeriodDays',
        'commodity_code' => 'getCommodityCode',
        'handling_time' => 'getHandlingTime',
        'un_number' => 'getUnNumber',
        'image_url' => 'getImageUrl',
        'product_hazardous_goods' => 'getProductHazardousGoods',
        'subscription' => 'getSubscription',
        'subscription_length' => 'getSubscriptionLength',
        'subscription_frequency' => 'getSubscriptionFrequency',
        'product_in_categories' => 'getProductInCategories',
        'product_prices' => 'getProductPrices',
        'product_suppliers' => 'getProductSuppliers',
        'client_id' => 'getClientId',
        'id' => 'getId',
        'last_updated' => 'getLastUpdated',
        'last_updated_by_user' => 'getLastUpdatedByUser'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('pallet_sizes', $data ?? [], null);
        $this->setIfExists('packing_instructions', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('customs_description', $data ?? [], null);
        $this->setIfExists('country_of_manufacture_id', $data ?? [], null);
        $this->setIfExists('country_of_manufacture', $data ?? [], null);
        $this->setIfExists('ean', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('low_stock_alert_level', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('volume', $data ?? [], null);
        $this->setIfExists('back_order', $data ?? [], null);
        $this->setIfExists('bundle', $data ?? [], null);
        $this->setIfExists('dis_cont', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('cost_price', $data ?? [], null);
        $this->setIfExists('vat_exempt', $data ?? [], null);
        $this->setIfExists('additional_parcels_required', $data ?? [], null);
        $this->setIfExists('units_per_parcel', $data ?? [], null);
        $this->setIfExists('has_batch_number', $data ?? [], null);
        $this->setIfExists('log_batch_inbound', $data ?? [], null);
        $this->setIfExists('log_batch_outbound', $data ?? [], null);
        $this->setIfExists('has_serial_number', $data ?? [], null);
        $this->setIfExists('has_expiry_date', $data ?? [], null);
        $this->setIfExists('best_before_date_warning_period_days', $data ?? [], null);
        $this->setIfExists('commodity_code', $data ?? [], null);
        $this->setIfExists('handling_time', $data ?? [], null);
        $this->setIfExists('un_number', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
        $this->setIfExists('product_hazardous_goods', $data ?? [], null);
        $this->setIfExists('subscription', $data ?? [], null);
        $this->setIfExists('subscription_length', $data ?? [], null);
        $this->setIfExists('subscription_frequency', $data ?? [], null);
        $this->setIfExists('product_in_categories', $data ?? [], null);
        $this->setIfExists('product_prices', $data ?? [], null);
        $this->setIfExists('product_suppliers', $data ?? [], null);
        $this->setIfExists('client_id', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('last_updated_by_user', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        if ((mb_strlen($this->container['sku']) > 75)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be smaller than or equal to 75.";
        }

        if ((mb_strlen($this->container['sku']) < 0)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['name']) && (mb_strlen($this->container['name']) > 99)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be smaller than or equal to 99.";
        }

        if (!is_null($this->container['name']) && (mb_strlen($this->container['name']) < 0)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['packing_instructions']) && (mb_strlen($this->container['packing_instructions']) > 250)) {
            $invalidProperties[] = "invalid value for 'packing_instructions', the character length must be smaller than or equal to 250.";
        }

        if (!is_null($this->container['packing_instructions']) && (mb_strlen($this->container['packing_instructions']) < 0)) {
            $invalidProperties[] = "invalid value for 'packing_instructions', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['customs_description']) && (mb_strlen($this->container['customs_description']) > 50)) {
            $invalidProperties[] = "invalid value for 'customs_description', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['customs_description']) && (mb_strlen($this->container['customs_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'customs_description', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['weight'] === null) {
            $invalidProperties[] = "'weight' can't be null";
        }
        if (($this->container['weight'] > 1E+3)) {
            $invalidProperties[] = "invalid value for 'weight', must be smaller than or equal to 1E+3.";
        }

        if (($this->container['weight'] < 0)) {
            $invalidProperties[] = "invalid value for 'weight', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['additional_parcels_required']) && ($this->container['additional_parcels_required'] > 1000)) {
            $invalidProperties[] = "invalid value for 'additional_parcels_required', must be smaller than or equal to 1000.";
        }

        if (!is_null($this->container['additional_parcels_required']) && ($this->container['additional_parcels_required'] < 0)) {
            $invalidProperties[] = "invalid value for 'additional_parcels_required', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['units_per_parcel']) && ($this->container['units_per_parcel'] > 1E+6)) {
            $invalidProperties[] = "invalid value for 'units_per_parcel', must be smaller than or equal to 1E+6.";
        }

        if (!is_null($this->container['units_per_parcel']) && ($this->container['units_per_parcel'] < 0)) {
            $invalidProperties[] = "invalid value for 'units_per_parcel', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['handling_time']) && ($this->container['handling_time'] > 365)) {
            $invalidProperties[] = "invalid value for 'handling_time', must be smaller than or equal to 365.";
        }

        if (!is_null($this->container['handling_time']) && ($this->container['handling_time'] < 1)) {
            $invalidProperties[] = "invalid value for 'handling_time', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['un_number']) && (mb_strlen($this->container['un_number']) > 4)) {
            $invalidProperties[] = "invalid value for 'un_number', the character length must be smaller than or equal to 4.";
        }

        if (!is_null($this->container['un_number']) && (mb_strlen($this->container['un_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'un_number', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        if ((mb_strlen($sku) > 75)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 75.');
        }
        if ((mb_strlen($sku) < 0)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        if ((mb_strlen($name) > 99)) {
            throw new \InvalidArgumentException('invalid length for $name when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 99.');
        }
        if ((mb_strlen($name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $name when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets pallet_sizes
     *
     * @return string|null
     */
    public function getPalletSizes()
    {
        return $this->container['pallet_sizes'];
    }

    /**
     * Sets pallet_sizes
     *
     * @param string|null $pallet_sizes pallet_sizes
     *
     * @return self
     */
    public function setPalletSizes($pallet_sizes)
    {
        if (is_null($pallet_sizes)) {
            throw new \InvalidArgumentException('non-nullable pallet_sizes cannot be null');
        }
        $this->container['pallet_sizes'] = $pallet_sizes;

        return $this;
    }

    /**
     * Gets packing_instructions
     *
     * @return string|null
     */
    public function getPackingInstructions()
    {
        return $this->container['packing_instructions'];
    }

    /**
     * Sets packing_instructions
     *
     * @param string|null $packing_instructions packing_instructions
     *
     * @return self
     */
    public function setPackingInstructions($packing_instructions)
    {
        if (is_null($packing_instructions)) {
            throw new \InvalidArgumentException('non-nullable packing_instructions cannot be null');
        }
        if ((mb_strlen($packing_instructions) > 250)) {
            throw new \InvalidArgumentException('invalid length for $packing_instructions when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 250.');
        }
        if ((mb_strlen($packing_instructions) < 0)) {
            throw new \InvalidArgumentException('invalid length for $packing_instructions when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['packing_instructions'] = $packing_instructions;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets customs_description
     *
     * @return string|null
     */
    public function getCustomsDescription()
    {
        return $this->container['customs_description'];
    }

    /**
     * Sets customs_description
     *
     * @param string|null $customs_description customs_description
     *
     * @return self
     */
    public function setCustomsDescription($customs_description)
    {
        if (is_null($customs_description)) {
            throw new \InvalidArgumentException('non-nullable customs_description cannot be null');
        }
        if ((mb_strlen($customs_description) > 50)) {
            throw new \InvalidArgumentException('invalid length for $customs_description when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($customs_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $customs_description when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['customs_description'] = $customs_description;

        return $this;
    }

    /**
     * Gets country_of_manufacture_id
     *
     * @return int|null
     */
    public function getCountryOfManufactureId()
    {
        return $this->container['country_of_manufacture_id'];
    }

    /**
     * Sets country_of_manufacture_id
     *
     * @param int|null $country_of_manufacture_id country_of_manufacture_id
     *
     * @return self
     */
    public function setCountryOfManufactureId($country_of_manufacture_id)
    {
        if (is_null($country_of_manufacture_id)) {
            throw new \InvalidArgumentException('non-nullable country_of_manufacture_id cannot be null');
        }
        $this->container['country_of_manufacture_id'] = $country_of_manufacture_id;

        return $this;
    }

    /**
     * Gets country_of_manufacture
     *
     * @return \Mintsoft\Model\ToolkitDataClassesCommonCountry|null
     */
    public function getCountryOfManufacture()
    {
        return $this->container['country_of_manufacture'];
    }

    /**
     * Sets country_of_manufacture
     *
     * @param \Mintsoft\Model\ToolkitDataClassesCommonCountry|null $country_of_manufacture country_of_manufacture
     *
     * @return self
     */
    public function setCountryOfManufacture($country_of_manufacture)
    {
        if (is_null($country_of_manufacture)) {
            throw new \InvalidArgumentException('non-nullable country_of_manufacture cannot be null');
        }
        $this->container['country_of_manufacture'] = $country_of_manufacture;

        return $this;
    }

    /**
     * Gets ean
     *
     * @return string|null
     */
    public function getEan()
    {
        return $this->container['ean'];
    }

    /**
     * Sets ean
     *
     * @param string|null $ean ean
     *
     * @return self
     */
    public function setEan($ean)
    {
        if (is_null($ean)) {
            throw new \InvalidArgumentException('non-nullable ean cannot be null');
        }
        $this->container['ean'] = $ean;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc upc
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets low_stock_alert_level
     *
     * @return int|null
     */
    public function getLowStockAlertLevel()
    {
        return $this->container['low_stock_alert_level'];
    }

    /**
     * Sets low_stock_alert_level
     *
     * @param int|null $low_stock_alert_level low_stock_alert_level
     *
     * @return self
     */
    public function setLowStockAlertLevel($low_stock_alert_level)
    {
        if (is_null($low_stock_alert_level)) {
            throw new \InvalidArgumentException('non-nullable low_stock_alert_level cannot be null');
        }
        $this->container['low_stock_alert_level'] = $low_stock_alert_level;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }

        if (($weight > 1E+3)) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 1E+3.');
        }
        if (($weight < 0)) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets volume
     *
     * @return float|null
     */
    public function getVolume()
    {
        return $this->container['volume'];
    }

    /**
     * Sets volume
     *
     * @param float|null $volume volume
     *
     * @return self
     */
    public function setVolume($volume)
    {
        if (is_null($volume)) {
            throw new \InvalidArgumentException('non-nullable volume cannot be null');
        }
        $this->container['volume'] = $volume;

        return $this;
    }

    /**
     * Gets back_order
     *
     * @return bool|null
     */
    public function getBackOrder()
    {
        return $this->container['back_order'];
    }

    /**
     * Sets back_order
     *
     * @param bool|null $back_order back_order
     *
     * @return self
     */
    public function setBackOrder($back_order)
    {
        if (is_null($back_order)) {
            throw new \InvalidArgumentException('non-nullable back_order cannot be null');
        }
        $this->container['back_order'] = $back_order;

        return $this;
    }

    /**
     * Gets bundle
     *
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->container['bundle'];
    }

    /**
     * Sets bundle
     *
     * @param bool|null $bundle bundle
     *
     * @return self
     */
    public function setBundle($bundle)
    {
        if (is_null($bundle)) {
            throw new \InvalidArgumentException('non-nullable bundle cannot be null');
        }
        $this->container['bundle'] = $bundle;

        return $this;
    }

    /**
     * Gets dis_cont
     *
     * @return bool|null
     */
    public function getDisCont()
    {
        return $this->container['dis_cont'];
    }

    /**
     * Sets dis_cont
     *
     * @param bool|null $dis_cont dis_cont
     *
     * @return self
     */
    public function setDisCont($dis_cont)
    {
        if (is_null($dis_cont)) {
            throw new \InvalidArgumentException('non-nullable dis_cont cannot be null');
        }
        $this->container['dis_cont'] = $dis_cont;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets cost_price
     *
     * @return float|null
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     *
     * @param float|null $cost_price cost_price
     *
     * @return self
     */
    public function setCostPrice($cost_price)
    {
        if (is_null($cost_price)) {
            throw new \InvalidArgumentException('non-nullable cost_price cannot be null');
        }
        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets vat_exempt
     *
     * @return bool|null
     */
    public function getVatExempt()
    {
        return $this->container['vat_exempt'];
    }

    /**
     * Sets vat_exempt
     *
     * @param bool|null $vat_exempt vat_exempt
     *
     * @return self
     */
    public function setVatExempt($vat_exempt)
    {
        if (is_null($vat_exempt)) {
            throw new \InvalidArgumentException('non-nullable vat_exempt cannot be null');
        }
        $this->container['vat_exempt'] = $vat_exempt;

        return $this;
    }

    /**
     * Gets additional_parcels_required
     *
     * @return int|null
     */
    public function getAdditionalParcelsRequired()
    {
        return $this->container['additional_parcels_required'];
    }

    /**
     * Sets additional_parcels_required
     *
     * @param int|null $additional_parcels_required additional_parcels_required
     *
     * @return self
     */
    public function setAdditionalParcelsRequired($additional_parcels_required)
    {
        if (is_null($additional_parcels_required)) {
            throw new \InvalidArgumentException('non-nullable additional_parcels_required cannot be null');
        }

        if (($additional_parcels_required > 1000)) {
            throw new \InvalidArgumentException('invalid value for $additional_parcels_required when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 1000.');
        }
        if (($additional_parcels_required < 0)) {
            throw new \InvalidArgumentException('invalid value for $additional_parcels_required when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['additional_parcels_required'] = $additional_parcels_required;

        return $this;
    }

    /**
     * Gets units_per_parcel
     *
     * @return float|null
     */
    public function getUnitsPerParcel()
    {
        return $this->container['units_per_parcel'];
    }

    /**
     * Sets units_per_parcel
     *
     * @param float|null $units_per_parcel units_per_parcel
     *
     * @return self
     */
    public function setUnitsPerParcel($units_per_parcel)
    {
        if (is_null($units_per_parcel)) {
            throw new \InvalidArgumentException('non-nullable units_per_parcel cannot be null');
        }

        if (($units_per_parcel > 1E+6)) {
            throw new \InvalidArgumentException('invalid value for $units_per_parcel when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 1E+6.');
        }
        if (($units_per_parcel < 0)) {
            throw new \InvalidArgumentException('invalid value for $units_per_parcel when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['units_per_parcel'] = $units_per_parcel;

        return $this;
    }

    /**
     * Gets has_batch_number
     *
     * @return bool|null
     */
    public function getHasBatchNumber()
    {
        return $this->container['has_batch_number'];
    }

    /**
     * Sets has_batch_number
     *
     * @param bool|null $has_batch_number has_batch_number
     *
     * @return self
     */
    public function setHasBatchNumber($has_batch_number)
    {
        if (is_null($has_batch_number)) {
            throw new \InvalidArgumentException('non-nullable has_batch_number cannot be null');
        }
        $this->container['has_batch_number'] = $has_batch_number;

        return $this;
    }

    /**
     * Gets log_batch_inbound
     *
     * @return bool|null
     */
    public function getLogBatchInbound()
    {
        return $this->container['log_batch_inbound'];
    }

    /**
     * Sets log_batch_inbound
     *
     * @param bool|null $log_batch_inbound log_batch_inbound
     *
     * @return self
     */
    public function setLogBatchInbound($log_batch_inbound)
    {
        if (is_null($log_batch_inbound)) {
            throw new \InvalidArgumentException('non-nullable log_batch_inbound cannot be null');
        }
        $this->container['log_batch_inbound'] = $log_batch_inbound;

        return $this;
    }

    /**
     * Gets log_batch_outbound
     *
     * @return bool|null
     */
    public function getLogBatchOutbound()
    {
        return $this->container['log_batch_outbound'];
    }

    /**
     * Sets log_batch_outbound
     *
     * @param bool|null $log_batch_outbound log_batch_outbound
     *
     * @return self
     */
    public function setLogBatchOutbound($log_batch_outbound)
    {
        if (is_null($log_batch_outbound)) {
            throw new \InvalidArgumentException('non-nullable log_batch_outbound cannot be null');
        }
        $this->container['log_batch_outbound'] = $log_batch_outbound;

        return $this;
    }

    /**
     * Gets has_serial_number
     *
     * @return bool|null
     */
    public function getHasSerialNumber()
    {
        return $this->container['has_serial_number'];
    }

    /**
     * Sets has_serial_number
     *
     * @param bool|null $has_serial_number has_serial_number
     *
     * @return self
     */
    public function setHasSerialNumber($has_serial_number)
    {
        if (is_null($has_serial_number)) {
            throw new \InvalidArgumentException('non-nullable has_serial_number cannot be null');
        }
        $this->container['has_serial_number'] = $has_serial_number;

        return $this;
    }

    /**
     * Gets has_expiry_date
     *
     * @return bool|null
     */
    public function getHasExpiryDate()
    {
        return $this->container['has_expiry_date'];
    }

    /**
     * Sets has_expiry_date
     *
     * @param bool|null $has_expiry_date has_expiry_date
     *
     * @return self
     */
    public function setHasExpiryDate($has_expiry_date)
    {
        if (is_null($has_expiry_date)) {
            throw new \InvalidArgumentException('non-nullable has_expiry_date cannot be null');
        }
        $this->container['has_expiry_date'] = $has_expiry_date;

        return $this;
    }

    /**
     * Gets best_before_date_warning_period_days
     *
     * @return int|null
     */
    public function getBestBeforeDateWarningPeriodDays()
    {
        return $this->container['best_before_date_warning_period_days'];
    }

    /**
     * Sets best_before_date_warning_period_days
     *
     * @param int|null $best_before_date_warning_period_days best_before_date_warning_period_days
     *
     * @return self
     */
    public function setBestBeforeDateWarningPeriodDays($best_before_date_warning_period_days)
    {
        if (is_null($best_before_date_warning_period_days)) {
            throw new \InvalidArgumentException('non-nullable best_before_date_warning_period_days cannot be null');
        }
        $this->container['best_before_date_warning_period_days'] = $best_before_date_warning_period_days;

        return $this;
    }

    /**
     * Gets commodity_code
     *
     * @return \Mintsoft\Model\ToolkitDataClassesStockCommodityCode|null
     */
    public function getCommodityCode()
    {
        return $this->container['commodity_code'];
    }

    /**
     * Sets commodity_code
     *
     * @param \Mintsoft\Model\ToolkitDataClassesStockCommodityCode|null $commodity_code commodity_code
     *
     * @return self
     */
    public function setCommodityCode($commodity_code)
    {
        if (is_null($commodity_code)) {
            throw new \InvalidArgumentException('non-nullable commodity_code cannot be null');
        }
        $this->container['commodity_code'] = $commodity_code;

        return $this;
    }

    /**
     * Gets handling_time
     *
     * @return int|null
     */
    public function getHandlingTime()
    {
        return $this->container['handling_time'];
    }

    /**
     * Sets handling_time
     *
     * @param int|null $handling_time handling_time
     *
     * @return self
     */
    public function setHandlingTime($handling_time)
    {
        if (is_null($handling_time)) {
            throw new \InvalidArgumentException('non-nullable handling_time cannot be null');
        }

        if (($handling_time > 365)) {
            throw new \InvalidArgumentException('invalid value for $handling_time when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 365.');
        }
        if (($handling_time < 1)) {
            throw new \InvalidArgumentException('invalid value for $handling_time when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 1.');
        }

        $this->container['handling_time'] = $handling_time;

        return $this;
    }

    /**
     * Gets un_number
     *
     * @return string|null
     */
    public function getUnNumber()
    {
        return $this->container['un_number'];
    }

    /**
     * Sets un_number
     *
     * @param string|null $un_number un_number
     *
     * @return self
     */
    public function setUnNumber($un_number)
    {
        if (is_null($un_number)) {
            throw new \InvalidArgumentException('non-nullable un_number cannot be null');
        }
        if ((mb_strlen($un_number) > 4)) {
            throw new \InvalidArgumentException('invalid length for $un_number when calling ToolkitDataClassesStockProduct., must be smaller than or equal to 4.');
        }
        if ((mb_strlen($un_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $un_number when calling ToolkitDataClassesStockProduct., must be bigger than or equal to 0.');
        }

        $this->container['un_number'] = $un_number;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            throw new \InvalidArgumentException('non-nullable image_url cannot be null');
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets product_hazardous_goods
     *
     * @return \Mintsoft\Model\ToolkitDataClassesStockProductHazardousGoods|null
     */
    public function getProductHazardousGoods()
    {
        return $this->container['product_hazardous_goods'];
    }

    /**
     * Sets product_hazardous_goods
     *
     * @param \Mintsoft\Model\ToolkitDataClassesStockProductHazardousGoods|null $product_hazardous_goods product_hazardous_goods
     *
     * @return self
     */
    public function setProductHazardousGoods($product_hazardous_goods)
    {
        if (is_null($product_hazardous_goods)) {
            throw new \InvalidArgumentException('non-nullable product_hazardous_goods cannot be null');
        }
        $this->container['product_hazardous_goods'] = $product_hazardous_goods;

        return $this;
    }

    /**
     * Gets subscription
     *
     * @return bool|null
     */
    public function getSubscription()
    {
        return $this->container['subscription'];
    }

    /**
     * Sets subscription
     *
     * @param bool|null $subscription subscription
     *
     * @return self
     */
    public function setSubscription($subscription)
    {
        if (is_null($subscription)) {
            throw new \InvalidArgumentException('non-nullable subscription cannot be null');
        }
        $this->container['subscription'] = $subscription;

        return $this;
    }

    /**
     * Gets subscription_length
     *
     * @return int|null
     */
    public function getSubscriptionLength()
    {
        return $this->container['subscription_length'];
    }

    /**
     * Sets subscription_length
     *
     * @param int|null $subscription_length subscription_length
     *
     * @return self
     */
    public function setSubscriptionLength($subscription_length)
    {
        if (is_null($subscription_length)) {
            throw new \InvalidArgumentException('non-nullable subscription_length cannot be null');
        }
        $this->container['subscription_length'] = $subscription_length;

        return $this;
    }

    /**
     * Gets subscription_frequency
     *
     * @return string|null
     */
    public function getSubscriptionFrequency()
    {
        return $this->container['subscription_frequency'];
    }

    /**
     * Sets subscription_frequency
     *
     * @param string|null $subscription_frequency subscription_frequency
     *
     * @return self
     */
    public function setSubscriptionFrequency($subscription_frequency)
    {
        if (is_null($subscription_frequency)) {
            throw new \InvalidArgumentException('non-nullable subscription_frequency cannot be null');
        }
        $this->container['subscription_frequency'] = $subscription_frequency;

        return $this;
    }

    /**
     * Gets product_in_categories
     *
     * @return \Mintsoft\Model\ToolkitDataClassesStockProductInCategory[]|null
     */
    public function getProductInCategories()
    {
        return $this->container['product_in_categories'];
    }

    /**
     * Sets product_in_categories
     *
     * @param \Mintsoft\Model\ToolkitDataClassesStockProductInCategory[]|null $product_in_categories product_in_categories
     *
     * @return self
     */
    public function setProductInCategories($product_in_categories)
    {
        if (is_null($product_in_categories)) {
            throw new \InvalidArgumentException('non-nullable product_in_categories cannot be null');
        }
        $this->container['product_in_categories'] = $product_in_categories;

        return $this;
    }

    /**
     * Gets product_prices
     *
     * @return \Mintsoft\Model\ToolkitDataClassesStockProductPrice[]|null
     */
    public function getProductPrices()
    {
        return $this->container['product_prices'];
    }

    /**
     * Sets product_prices
     *
     * @param \Mintsoft\Model\ToolkitDataClassesStockProductPrice[]|null $product_prices product_prices
     *
     * @return self
     */
    public function setProductPrices($product_prices)
    {
        if (is_null($product_prices)) {
            throw new \InvalidArgumentException('non-nullable product_prices cannot be null');
        }
        $this->container['product_prices'] = $product_prices;

        return $this;
    }

    /**
     * Gets product_suppliers
     *
     * @return \Mintsoft\Model\ToolkitDataClassesStockProductInSupplier[]|null
     */
    public function getProductSuppliers()
    {
        return $this->container['product_suppliers'];
    }

    /**
     * Sets product_suppliers
     *
     * @param \Mintsoft\Model\ToolkitDataClassesStockProductInSupplier[]|null $product_suppliers product_suppliers
     *
     * @return self
     */
    public function setProductSuppliers($product_suppliers)
    {
        if (is_null($product_suppliers)) {
            throw new \InvalidArgumentException('non-nullable product_suppliers cannot be null');
        }
        $this->container['product_suppliers'] = $product_suppliers;

        return $this;
    }

    /**
     * Gets client_id
     *
     * @return int|null
     */
    public function getClientId()
    {
        return $this->container['client_id'];
    }

    /**
     * Sets client_id
     *
     * @param int|null $client_id client_id
     *
     * @return self
     */
    public function setClientId($client_id)
    {
        if (is_null($client_id)) {
            throw new \InvalidArgumentException('non-nullable client_id cannot be null');
        }
        $this->container['client_id'] = $client_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated last_updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets last_updated_by_user
     *
     * @return string|null
     */
    public function getLastUpdatedByUser()
    {
        return $this->container['last_updated_by_user'];
    }

    /**
     * Sets last_updated_by_user
     *
     * @param string|null $last_updated_by_user last_updated_by_user
     *
     * @return self
     */
    public function setLastUpdatedByUser($last_updated_by_user)
    {
        if (is_null($last_updated_by_user)) {
            throw new \InvalidArgumentException('non-nullable last_updated_by_user cannot be null');
        }
        $this->container['last_updated_by_user'] = $last_updated_by_user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


