<?php
/**
 * ToolkitDataClassesOrdersOrder
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Model;

use \ArrayAccess;
use \Mintsoft\ObjectSerializer;

/**
 * ToolkitDataClassesOrdersOrder Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ToolkitDataClassesOrdersOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Toolkit.DataClasses.Orders.Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'client_id' => 'int',
        'client_code' => 'string',
        'order_number' => 'string',
        'external_order_reference' => 'string',
        'order_date' => '\DateTime',
        'despatch_date' => '\DateTime',
        'required_despatch_date' => '\DateTime',
        'required_delivery_date' => '\DateTime',
        'title' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'company_name' => 'string',
        'address1' => 'string',
        'address2' => 'string',
        'address3' => 'string',
        'town' => 'string',
        'county' => 'string',
        'post_code' => 'string',
        'phone' => 'string',
        'mobile' => 'string',
        'email' => 'string',
        'country_id' => 'int',
        'country' => '\Mintsoft\Model\ToolkitDataClassesCommonCountry',
        'source' => 'string',
        'comments' => 'string',
        'gift_messages' => 'string',
        'delivery_notes' => 'string',
        'vat_number' => 'string',
        'eori_number' => 'string',
        'pid_number' => 'string',
        'order_status_id' => 'int',
        'number_of_parcels' => 'int',
        'total_items' => 'int',
        'total_weight' => 'float',
        'order_value' => 'float',
        'part' => 'int',
        'number_of_parts' => 'int',
        'courier_service_type_id' => 'int',
        'courier_service_id' => 'int',
        'courier_service_name' => 'string',
        'tracking_number' => 'string',
        'tracking_url' => 'string',
        'shipping_total_ex_vat' => 'float',
        'shipping_total_vat' => 'float',
        'discount_total_ex_vat' => 'float',
        'discount_total_vat' => 'float',
        'total_vat' => 'float',
        'warehouse_id' => 'int',
        'warehouse_code' => 'string',
        'channel_id' => 'int',
        'channel' => '\Mintsoft\Model\ToolkitDataClassesChannelsChannel',
        'currency_id' => 'int',
        'currency' => '\Mintsoft\Model\ToolkitDataClassesCurrenciesCurrency',
        'despatched_by_user' => 'string',
        'order_items' => '\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]',
        'order_name_values' => '\Mintsoft\Model\ToolkitDataClassesOrdersOrderNameValue[]',
        'order_lock' => 'bool',
        'tags' => 'string',
        'id' => 'int',
        'last_updated' => '\DateTime',
        'last_updated_by_user' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'client_id' => 'int32',
        'client_code' => null,
        'order_number' => null,
        'external_order_reference' => null,
        'order_date' => 'date-time',
        'despatch_date' => 'date-time',
        'required_despatch_date' => 'date-time',
        'required_delivery_date' => 'date-time',
        'title' => null,
        'first_name' => null,
        'last_name' => null,
        'company_name' => null,
        'address1' => null,
        'address2' => null,
        'address3' => null,
        'town' => null,
        'county' => null,
        'post_code' => null,
        'phone' => null,
        'mobile' => null,
        'email' => null,
        'country_id' => 'int32',
        'country' => null,
        'source' => null,
        'comments' => null,
        'gift_messages' => null,
        'delivery_notes' => null,
        'vat_number' => null,
        'eori_number' => null,
        'pid_number' => null,
        'order_status_id' => 'int32',
        'number_of_parcels' => 'int32',
        'total_items' => 'int32',
        'total_weight' => 'double',
        'order_value' => 'double',
        'part' => 'int32',
        'number_of_parts' => 'int32',
        'courier_service_type_id' => 'int32',
        'courier_service_id' => 'int32',
        'courier_service_name' => null,
        'tracking_number' => null,
        'tracking_url' => null,
        'shipping_total_ex_vat' => 'double',
        'shipping_total_vat' => 'double',
        'discount_total_ex_vat' => 'double',
        'discount_total_vat' => 'double',
        'total_vat' => 'double',
        'warehouse_id' => 'int32',
        'warehouse_code' => null,
        'channel_id' => 'int32',
        'channel' => null,
        'currency_id' => 'int32',
        'currency' => null,
        'despatched_by_user' => null,
        'order_items' => null,
        'order_name_values' => null,
        'order_lock' => null,
        'tags' => null,
        'id' => 'int32',
        'last_updated' => 'date-time',
        'last_updated_by_user' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'client_id' => false,
        'client_code' => false,
        'order_number' => false,
        'external_order_reference' => false,
        'order_date' => false,
        'despatch_date' => false,
        'required_despatch_date' => false,
        'required_delivery_date' => false,
        'title' => false,
        'first_name' => false,
        'last_name' => false,
        'company_name' => false,
        'address1' => false,
        'address2' => false,
        'address3' => false,
        'town' => false,
        'county' => false,
        'post_code' => false,
        'phone' => false,
        'mobile' => false,
        'email' => false,
        'country_id' => false,
        'country' => false,
        'source' => false,
        'comments' => false,
        'gift_messages' => false,
        'delivery_notes' => false,
        'vat_number' => false,
        'eori_number' => false,
        'pid_number' => false,
        'order_status_id' => false,
        'number_of_parcels' => false,
        'total_items' => false,
        'total_weight' => false,
        'order_value' => false,
        'part' => false,
        'number_of_parts' => false,
        'courier_service_type_id' => false,
        'courier_service_id' => false,
        'courier_service_name' => false,
        'tracking_number' => false,
        'tracking_url' => false,
        'shipping_total_ex_vat' => false,
        'shipping_total_vat' => false,
        'discount_total_ex_vat' => false,
        'discount_total_vat' => false,
        'total_vat' => false,
        'warehouse_id' => false,
        'warehouse_code' => false,
        'channel_id' => false,
        'channel' => false,
        'currency_id' => false,
        'currency' => false,
        'despatched_by_user' => false,
        'order_items' => false,
        'order_name_values' => false,
        'order_lock' => false,
        'tags' => false,
        'id' => false,
        'last_updated' => false,
        'last_updated_by_user' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'client_id' => 'ClientId',
        'client_code' => 'CLIENT_CODE',
        'order_number' => 'OrderNumber',
        'external_order_reference' => 'ExternalOrderReference',
        'order_date' => 'OrderDate',
        'despatch_date' => 'DespatchDate',
        'required_despatch_date' => 'RequiredDespatchDate',
        'required_delivery_date' => 'RequiredDeliveryDate',
        'title' => 'Title',
        'first_name' => 'FirstName',
        'last_name' => 'LastName',
        'company_name' => 'CompanyName',
        'address1' => 'Address1',
        'address2' => 'Address2',
        'address3' => 'Address3',
        'town' => 'Town',
        'county' => 'County',
        'post_code' => 'PostCode',
        'phone' => 'Phone',
        'mobile' => 'Mobile',
        'email' => 'Email',
        'country_id' => 'CountryId',
        'country' => 'Country',
        'source' => 'Source',
        'comments' => 'Comments',
        'gift_messages' => 'GiftMessages',
        'delivery_notes' => 'DeliveryNotes',
        'vat_number' => 'VATNumber',
        'eori_number' => 'EORINumber',
        'pid_number' => 'PIDNumber',
        'order_status_id' => 'OrderStatusId',
        'number_of_parcels' => 'NumberOfParcels',
        'total_items' => 'TotalItems',
        'total_weight' => 'TotalWeight',
        'order_value' => 'OrderValue',
        'part' => 'Part',
        'number_of_parts' => 'NumberOfParts',
        'courier_service_type_id' => 'CourierServiceTypeId',
        'courier_service_id' => 'CourierServiceId',
        'courier_service_name' => 'CourierServiceName',
        'tracking_number' => 'TrackingNumber',
        'tracking_url' => 'TrackingURL',
        'shipping_total_ex_vat' => 'ShippingTotalExVat',
        'shipping_total_vat' => 'ShippingTotalVat',
        'discount_total_ex_vat' => 'DiscountTotalExVat',
        'discount_total_vat' => 'DiscountTotalVat',
        'total_vat' => 'TotalVat',
        'warehouse_id' => 'WarehouseId',
        'warehouse_code' => 'WAREHOUSE_CODE',
        'channel_id' => 'ChannelId',
        'channel' => 'Channel',
        'currency_id' => 'CurrencyId',
        'currency' => 'Currency',
        'despatched_by_user' => 'DespatchedByUser',
        'order_items' => 'OrderItems',
        'order_name_values' => 'OrderNameValues',
        'order_lock' => 'OrderLock',
        'tags' => 'Tags',
        'id' => 'ID',
        'last_updated' => 'LastUpdated',
        'last_updated_by_user' => 'LastUpdatedByUser'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'client_id' => 'setClientId',
        'client_code' => 'setClientCode',
        'order_number' => 'setOrderNumber',
        'external_order_reference' => 'setExternalOrderReference',
        'order_date' => 'setOrderDate',
        'despatch_date' => 'setDespatchDate',
        'required_despatch_date' => 'setRequiredDespatchDate',
        'required_delivery_date' => 'setRequiredDeliveryDate',
        'title' => 'setTitle',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'company_name' => 'setCompanyName',
        'address1' => 'setAddress1',
        'address2' => 'setAddress2',
        'address3' => 'setAddress3',
        'town' => 'setTown',
        'county' => 'setCounty',
        'post_code' => 'setPostCode',
        'phone' => 'setPhone',
        'mobile' => 'setMobile',
        'email' => 'setEmail',
        'country_id' => 'setCountryId',
        'country' => 'setCountry',
        'source' => 'setSource',
        'comments' => 'setComments',
        'gift_messages' => 'setGiftMessages',
        'delivery_notes' => 'setDeliveryNotes',
        'vat_number' => 'setVatNumber',
        'eori_number' => 'setEoriNumber',
        'pid_number' => 'setPidNumber',
        'order_status_id' => 'setOrderStatusId',
        'number_of_parcels' => 'setNumberOfParcels',
        'total_items' => 'setTotalItems',
        'total_weight' => 'setTotalWeight',
        'order_value' => 'setOrderValue',
        'part' => 'setPart',
        'number_of_parts' => 'setNumberOfParts',
        'courier_service_type_id' => 'setCourierServiceTypeId',
        'courier_service_id' => 'setCourierServiceId',
        'courier_service_name' => 'setCourierServiceName',
        'tracking_number' => 'setTrackingNumber',
        'tracking_url' => 'setTrackingUrl',
        'shipping_total_ex_vat' => 'setShippingTotalExVat',
        'shipping_total_vat' => 'setShippingTotalVat',
        'discount_total_ex_vat' => 'setDiscountTotalExVat',
        'discount_total_vat' => 'setDiscountTotalVat',
        'total_vat' => 'setTotalVat',
        'warehouse_id' => 'setWarehouseId',
        'warehouse_code' => 'setWarehouseCode',
        'channel_id' => 'setChannelId',
        'channel' => 'setChannel',
        'currency_id' => 'setCurrencyId',
        'currency' => 'setCurrency',
        'despatched_by_user' => 'setDespatchedByUser',
        'order_items' => 'setOrderItems',
        'order_name_values' => 'setOrderNameValues',
        'order_lock' => 'setOrderLock',
        'tags' => 'setTags',
        'id' => 'setId',
        'last_updated' => 'setLastUpdated',
        'last_updated_by_user' => 'setLastUpdatedByUser'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'client_id' => 'getClientId',
        'client_code' => 'getClientCode',
        'order_number' => 'getOrderNumber',
        'external_order_reference' => 'getExternalOrderReference',
        'order_date' => 'getOrderDate',
        'despatch_date' => 'getDespatchDate',
        'required_despatch_date' => 'getRequiredDespatchDate',
        'required_delivery_date' => 'getRequiredDeliveryDate',
        'title' => 'getTitle',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'company_name' => 'getCompanyName',
        'address1' => 'getAddress1',
        'address2' => 'getAddress2',
        'address3' => 'getAddress3',
        'town' => 'getTown',
        'county' => 'getCounty',
        'post_code' => 'getPostCode',
        'phone' => 'getPhone',
        'mobile' => 'getMobile',
        'email' => 'getEmail',
        'country_id' => 'getCountryId',
        'country' => 'getCountry',
        'source' => 'getSource',
        'comments' => 'getComments',
        'gift_messages' => 'getGiftMessages',
        'delivery_notes' => 'getDeliveryNotes',
        'vat_number' => 'getVatNumber',
        'eori_number' => 'getEoriNumber',
        'pid_number' => 'getPidNumber',
        'order_status_id' => 'getOrderStatusId',
        'number_of_parcels' => 'getNumberOfParcels',
        'total_items' => 'getTotalItems',
        'total_weight' => 'getTotalWeight',
        'order_value' => 'getOrderValue',
        'part' => 'getPart',
        'number_of_parts' => 'getNumberOfParts',
        'courier_service_type_id' => 'getCourierServiceTypeId',
        'courier_service_id' => 'getCourierServiceId',
        'courier_service_name' => 'getCourierServiceName',
        'tracking_number' => 'getTrackingNumber',
        'tracking_url' => 'getTrackingUrl',
        'shipping_total_ex_vat' => 'getShippingTotalExVat',
        'shipping_total_vat' => 'getShippingTotalVat',
        'discount_total_ex_vat' => 'getDiscountTotalExVat',
        'discount_total_vat' => 'getDiscountTotalVat',
        'total_vat' => 'getTotalVat',
        'warehouse_id' => 'getWarehouseId',
        'warehouse_code' => 'getWarehouseCode',
        'channel_id' => 'getChannelId',
        'channel' => 'getChannel',
        'currency_id' => 'getCurrencyId',
        'currency' => 'getCurrency',
        'despatched_by_user' => 'getDespatchedByUser',
        'order_items' => 'getOrderItems',
        'order_name_values' => 'getOrderNameValues',
        'order_lock' => 'getOrderLock',
        'tags' => 'getTags',
        'id' => 'getId',
        'last_updated' => 'getLastUpdated',
        'last_updated_by_user' => 'getLastUpdatedByUser'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('client_id', $data ?? [], null);
        $this->setIfExists('client_code', $data ?? [], null);
        $this->setIfExists('order_number', $data ?? [], null);
        $this->setIfExists('external_order_reference', $data ?? [], null);
        $this->setIfExists('order_date', $data ?? [], null);
        $this->setIfExists('despatch_date', $data ?? [], null);
        $this->setIfExists('required_despatch_date', $data ?? [], null);
        $this->setIfExists('required_delivery_date', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('company_name', $data ?? [], null);
        $this->setIfExists('address1', $data ?? [], null);
        $this->setIfExists('address2', $data ?? [], null);
        $this->setIfExists('address3', $data ?? [], null);
        $this->setIfExists('town', $data ?? [], null);
        $this->setIfExists('county', $data ?? [], null);
        $this->setIfExists('post_code', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('mobile', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('country_id', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('gift_messages', $data ?? [], null);
        $this->setIfExists('delivery_notes', $data ?? [], null);
        $this->setIfExists('vat_number', $data ?? [], null);
        $this->setIfExists('eori_number', $data ?? [], null);
        $this->setIfExists('pid_number', $data ?? [], null);
        $this->setIfExists('order_status_id', $data ?? [], null);
        $this->setIfExists('number_of_parcels', $data ?? [], null);
        $this->setIfExists('total_items', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('order_value', $data ?? [], null);
        $this->setIfExists('part', $data ?? [], null);
        $this->setIfExists('number_of_parts', $data ?? [], null);
        $this->setIfExists('courier_service_type_id', $data ?? [], null);
        $this->setIfExists('courier_service_id', $data ?? [], null);
        $this->setIfExists('courier_service_name', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('tracking_url', $data ?? [], null);
        $this->setIfExists('shipping_total_ex_vat', $data ?? [], null);
        $this->setIfExists('shipping_total_vat', $data ?? [], null);
        $this->setIfExists('discount_total_ex_vat', $data ?? [], null);
        $this->setIfExists('discount_total_vat', $data ?? [], null);
        $this->setIfExists('total_vat', $data ?? [], null);
        $this->setIfExists('warehouse_id', $data ?? [], null);
        $this->setIfExists('warehouse_code', $data ?? [], null);
        $this->setIfExists('channel_id', $data ?? [], null);
        $this->setIfExists('channel', $data ?? [], null);
        $this->setIfExists('currency_id', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('despatched_by_user', $data ?? [], null);
        $this->setIfExists('order_items', $data ?? [], null);
        $this->setIfExists('order_name_values', $data ?? [], null);
        $this->setIfExists('order_lock', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('last_updated_by_user', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['client_id'] === null) {
            $invalidProperties[] = "'client_id' can't be null";
        }
        if ($this->container['order_number'] === null) {
            $invalidProperties[] = "'order_number' can't be null";
        }
        if ((mb_strlen($this->container['order_number']) > 250)) {
            $invalidProperties[] = "invalid value for 'order_number', the character length must be smaller than or equal to 250.";
        }

        if ((mb_strlen($this->container['order_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'order_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['external_order_reference']) && (mb_strlen($this->container['external_order_reference']) > 250)) {
            $invalidProperties[] = "invalid value for 'external_order_reference', the character length must be smaller than or equal to 250.";
        }

        if (!is_null($this->container['external_order_reference']) && (mb_strlen($this->container['external_order_reference']) < 0)) {
            $invalidProperties[] = "invalid value for 'external_order_reference', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['first_name'] === null) {
            $invalidProperties[] = "'first_name' can't be null";
        }
        if ($this->container['address1'] === null) {
            $invalidProperties[] = "'address1' can't be null";
        }
        if ($this->container['post_code'] === null) {
            $invalidProperties[] = "'post_code' can't be null";
        }
        if ((mb_strlen($this->container['post_code']) > 20)) {
            $invalidProperties[] = "invalid value for 'post_code', the character length must be smaller than or equal to 20.";
        }

        if ((mb_strlen($this->container['post_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'post_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['phone']) && (mb_strlen($this->container['phone']) > 50)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['phone']) && (mb_strlen($this->container['phone']) < 0)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['mobile']) && (mb_strlen($this->container['mobile']) > 50)) {
            $invalidProperties[] = "invalid value for 'mobile', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['mobile']) && (mb_strlen($this->container['mobile']) < 0)) {
            $invalidProperties[] = "invalid value for 'mobile', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['country_id'] === null) {
            $invalidProperties[] = "'country_id' can't be null";
        }
        if (!is_null($this->container['gift_messages']) && (mb_strlen($this->container['gift_messages']) > 1000)) {
            $invalidProperties[] = "invalid value for 'gift_messages', the character length must be smaller than or equal to 1000.";
        }

        if (!is_null($this->container['gift_messages']) && (mb_strlen($this->container['gift_messages']) < 0)) {
            $invalidProperties[] = "invalid value for 'gift_messages', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['delivery_notes']) && (mb_strlen($this->container['delivery_notes']) > 1000)) {
            $invalidProperties[] = "invalid value for 'delivery_notes', the character length must be smaller than or equal to 1000.";
        }

        if (!is_null($this->container['delivery_notes']) && (mb_strlen($this->container['delivery_notes']) < 0)) {
            $invalidProperties[] = "invalid value for 'delivery_notes', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['vat_number']) && (mb_strlen($this->container['vat_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'vat_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['vat_number']) && (mb_strlen($this->container['vat_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'vat_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['eori_number']) && (mb_strlen($this->container['eori_number']) > 20)) {
            $invalidProperties[] = "invalid value for 'eori_number', the character length must be smaller than or equal to 20.";
        }

        if (!is_null($this->container['eori_number']) && (mb_strlen($this->container['eori_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'eori_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['number_of_parcels']) && ($this->container['number_of_parcels'] > 1000)) {
            $invalidProperties[] = "invalid value for 'number_of_parcels', must be smaller than or equal to 1000.";
        }

        if (!is_null($this->container['number_of_parcels']) && ($this->container['number_of_parcels'] < 1)) {
            $invalidProperties[] = "invalid value for 'number_of_parcels', must be bigger than or equal to 1.";
        }

        if ($this->container['courier_service_type_id'] === null) {
            $invalidProperties[] = "'courier_service_type_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets client_id
     *
     * @return int
     */
    public function getClientId()
    {
        return $this->container['client_id'];
    }

    /**
     * Sets client_id
     *
     * @param int $client_id client_id
     *
     * @return self
     */
    public function setClientId($client_id)
    {
        if (is_null($client_id)) {
            throw new \InvalidArgumentException('non-nullable client_id cannot be null');
        }
        $this->container['client_id'] = $client_id;

        return $this;
    }

    /**
     * Gets client_code
     *
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->container['client_code'];
    }

    /**
     * Sets client_code
     *
     * @param string|null $client_code client_code
     *
     * @return self
     */
    public function setClientCode($client_code)
    {
        if (is_null($client_code)) {
            throw new \InvalidArgumentException('non-nullable client_code cannot be null');
        }
        $this->container['client_code'] = $client_code;

        return $this;
    }

    /**
     * Gets order_number
     *
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string $order_number order_number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        if (is_null($order_number)) {
            throw new \InvalidArgumentException('non-nullable order_number cannot be null');
        }
        if ((mb_strlen($order_number) > 250)) {
            throw new \InvalidArgumentException('invalid length for $order_number when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 250.');
        }
        if ((mb_strlen($order_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $order_number when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets external_order_reference
     *
     * @return string|null
     */
    public function getExternalOrderReference()
    {
        return $this->container['external_order_reference'];
    }

    /**
     * Sets external_order_reference
     *
     * @param string|null $external_order_reference external_order_reference
     *
     * @return self
     */
    public function setExternalOrderReference($external_order_reference)
    {
        if (is_null($external_order_reference)) {
            throw new \InvalidArgumentException('non-nullable external_order_reference cannot be null');
        }
        if ((mb_strlen($external_order_reference) > 250)) {
            throw new \InvalidArgumentException('invalid length for $external_order_reference when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 250.');
        }
        if ((mb_strlen($external_order_reference) < 0)) {
            throw new \InvalidArgumentException('invalid length for $external_order_reference when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['external_order_reference'] = $external_order_reference;

        return $this;
    }

    /**
     * Gets order_date
     *
     * @return \DateTime|null
     */
    public function getOrderDate()
    {
        return $this->container['order_date'];
    }

    /**
     * Sets order_date
     *
     * @param \DateTime|null $order_date order_date
     *
     * @return self
     */
    public function setOrderDate($order_date)
    {
        if (is_null($order_date)) {
            throw new \InvalidArgumentException('non-nullable order_date cannot be null');
        }
        $this->container['order_date'] = $order_date;

        return $this;
    }

    /**
     * Gets despatch_date
     *
     * @return \DateTime|null
     */
    public function getDespatchDate()
    {
        return $this->container['despatch_date'];
    }

    /**
     * Sets despatch_date
     *
     * @param \DateTime|null $despatch_date despatch_date
     *
     * @return self
     */
    public function setDespatchDate($despatch_date)
    {
        if (is_null($despatch_date)) {
            throw new \InvalidArgumentException('non-nullable despatch_date cannot be null');
        }
        $this->container['despatch_date'] = $despatch_date;

        return $this;
    }

    /**
     * Gets required_despatch_date
     *
     * @return \DateTime|null
     */
    public function getRequiredDespatchDate()
    {
        return $this->container['required_despatch_date'];
    }

    /**
     * Sets required_despatch_date
     *
     * @param \DateTime|null $required_despatch_date required_despatch_date
     *
     * @return self
     */
    public function setRequiredDespatchDate($required_despatch_date)
    {
        if (is_null($required_despatch_date)) {
            throw new \InvalidArgumentException('non-nullable required_despatch_date cannot be null');
        }
        $this->container['required_despatch_date'] = $required_despatch_date;

        return $this;
    }

    /**
     * Gets required_delivery_date
     *
     * @return \DateTime|null
     */
    public function getRequiredDeliveryDate()
    {
        return $this->container['required_delivery_date'];
    }

    /**
     * Sets required_delivery_date
     *
     * @param \DateTime|null $required_delivery_date required_delivery_date
     *
     * @return self
     */
    public function setRequiredDeliveryDate($required_delivery_date)
    {
        if (is_null($required_delivery_date)) {
            throw new \InvalidArgumentException('non-nullable required_delivery_date cannot be null');
        }
        $this->container['required_delivery_date'] = $required_delivery_date;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string $first_name first_name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name last_name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets company_name
     *
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->container['company_name'];
    }

    /**
     * Sets company_name
     *
     * @param string|null $company_name company_name
     *
     * @return self
     */
    public function setCompanyName($company_name)
    {
        if (is_null($company_name)) {
            throw new \InvalidArgumentException('non-nullable company_name cannot be null');
        }
        $this->container['company_name'] = $company_name;

        return $this;
    }

    /**
     * Gets address1
     *
     * @return string
     */
    public function getAddress1()
    {
        return $this->container['address1'];
    }

    /**
     * Sets address1
     *
     * @param string $address1 address1
     *
     * @return self
     */
    public function setAddress1($address1)
    {
        if (is_null($address1)) {
            throw new \InvalidArgumentException('non-nullable address1 cannot be null');
        }
        $this->container['address1'] = $address1;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string|null $address2 address2
     *
     * @return self
     */
    public function setAddress2($address2)
    {
        if (is_null($address2)) {
            throw new \InvalidArgumentException('non-nullable address2 cannot be null');
        }
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets address3
     *
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->container['address3'];
    }

    /**
     * Sets address3
     *
     * @param string|null $address3 address3
     *
     * @return self
     */
    public function setAddress3($address3)
    {
        if (is_null($address3)) {
            throw new \InvalidArgumentException('non-nullable address3 cannot be null');
        }
        $this->container['address3'] = $address3;

        return $this;
    }

    /**
     * Gets town
     *
     * @return string|null
     */
    public function getTown()
    {
        return $this->container['town'];
    }

    /**
     * Sets town
     *
     * @param string|null $town town
     *
     * @return self
     */
    public function setTown($town)
    {
        if (is_null($town)) {
            throw new \InvalidArgumentException('non-nullable town cannot be null');
        }
        $this->container['town'] = $town;

        return $this;
    }

    /**
     * Gets county
     *
     * @return string|null
     */
    public function getCounty()
    {
        return $this->container['county'];
    }

    /**
     * Sets county
     *
     * @param string|null $county county
     *
     * @return self
     */
    public function setCounty($county)
    {
        if (is_null($county)) {
            throw new \InvalidArgumentException('non-nullable county cannot be null');
        }
        $this->container['county'] = $county;

        return $this;
    }

    /**
     * Gets post_code
     *
     * @return string
     */
    public function getPostCode()
    {
        return $this->container['post_code'];
    }

    /**
     * Sets post_code
     *
     * @param string $post_code post_code
     *
     * @return self
     */
    public function setPostCode($post_code)
    {
        if (is_null($post_code)) {
            throw new \InvalidArgumentException('non-nullable post_code cannot be null');
        }
        if ((mb_strlen($post_code) > 20)) {
            throw new \InvalidArgumentException('invalid length for $post_code when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 20.');
        }
        if ((mb_strlen($post_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $post_code when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['post_code'] = $post_code;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        if ((mb_strlen($phone) > 50)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($phone) < 0)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return string|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param string|null $mobile mobile
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        if (is_null($mobile)) {
            throw new \InvalidArgumentException('non-nullable mobile cannot be null');
        }
        if ((mb_strlen($mobile) > 50)) {
            throw new \InvalidArgumentException('invalid length for $mobile when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($mobile) < 0)) {
            throw new \InvalidArgumentException('invalid length for $mobile when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets country_id
     *
     * @return int
     */
    public function getCountryId()
    {
        return $this->container['country_id'];
    }

    /**
     * Sets country_id
     *
     * @param int $country_id country_id
     *
     * @return self
     */
    public function setCountryId($country_id)
    {
        if (is_null($country_id)) {
            throw new \InvalidArgumentException('non-nullable country_id cannot be null');
        }
        $this->container['country_id'] = $country_id;

        return $this;
    }

    /**
     * Gets country
     *
     * @return \Mintsoft\Model\ToolkitDataClassesCommonCountry|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param \Mintsoft\Model\ToolkitDataClassesCommonCountry|null $country country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source source
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets gift_messages
     *
     * @return string|null
     */
    public function getGiftMessages()
    {
        return $this->container['gift_messages'];
    }

    /**
     * Sets gift_messages
     *
     * @param string|null $gift_messages gift_messages
     *
     * @return self
     */
    public function setGiftMessages($gift_messages)
    {
        if (is_null($gift_messages)) {
            throw new \InvalidArgumentException('non-nullable gift_messages cannot be null');
        }
        if ((mb_strlen($gift_messages) > 1000)) {
            throw new \InvalidArgumentException('invalid length for $gift_messages when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 1000.');
        }
        if ((mb_strlen($gift_messages) < 0)) {
            throw new \InvalidArgumentException('invalid length for $gift_messages when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['gift_messages'] = $gift_messages;

        return $this;
    }

    /**
     * Gets delivery_notes
     *
     * @return string|null
     */
    public function getDeliveryNotes()
    {
        return $this->container['delivery_notes'];
    }

    /**
     * Sets delivery_notes
     *
     * @param string|null $delivery_notes delivery_notes
     *
     * @return self
     */
    public function setDeliveryNotes($delivery_notes)
    {
        if (is_null($delivery_notes)) {
            throw new \InvalidArgumentException('non-nullable delivery_notes cannot be null');
        }
        if ((mb_strlen($delivery_notes) > 1000)) {
            throw new \InvalidArgumentException('invalid length for $delivery_notes when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 1000.');
        }
        if ((mb_strlen($delivery_notes) < 0)) {
            throw new \InvalidArgumentException('invalid length for $delivery_notes when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['delivery_notes'] = $delivery_notes;

        return $this;
    }

    /**
     * Gets vat_number
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vat_number'];
    }

    /**
     * Sets vat_number
     *
     * @param string|null $vat_number vat_number
     *
     * @return self
     */
    public function setVatNumber($vat_number)
    {
        if (is_null($vat_number)) {
            throw new \InvalidArgumentException('non-nullable vat_number cannot be null');
        }
        if ((mb_strlen($vat_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $vat_number when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($vat_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $vat_number when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['vat_number'] = $vat_number;

        return $this;
    }

    /**
     * Gets eori_number
     *
     * @return string|null
     */
    public function getEoriNumber()
    {
        return $this->container['eori_number'];
    }

    /**
     * Sets eori_number
     *
     * @param string|null $eori_number eori_number
     *
     * @return self
     */
    public function setEoriNumber($eori_number)
    {
        if (is_null($eori_number)) {
            throw new \InvalidArgumentException('non-nullable eori_number cannot be null');
        }
        if ((mb_strlen($eori_number) > 20)) {
            throw new \InvalidArgumentException('invalid length for $eori_number when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 20.');
        }
        if ((mb_strlen($eori_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $eori_number when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 0.');
        }

        $this->container['eori_number'] = $eori_number;

        return $this;
    }

    /**
     * Gets pid_number
     *
     * @return string|null
     */
    public function getPidNumber()
    {
        return $this->container['pid_number'];
    }

    /**
     * Sets pid_number
     *
     * @param string|null $pid_number pid_number
     *
     * @return self
     */
    public function setPidNumber($pid_number)
    {
        if (is_null($pid_number)) {
            throw new \InvalidArgumentException('non-nullable pid_number cannot be null');
        }
        $this->container['pid_number'] = $pid_number;

        return $this;
    }

    /**
     * Gets order_status_id
     *
     * @return int|null
     */
    public function getOrderStatusId()
    {
        return $this->container['order_status_id'];
    }

    /**
     * Sets order_status_id
     *
     * @param int|null $order_status_id order_status_id
     *
     * @return self
     */
    public function setOrderStatusId($order_status_id)
    {
        if (is_null($order_status_id)) {
            throw new \InvalidArgumentException('non-nullable order_status_id cannot be null');
        }
        $this->container['order_status_id'] = $order_status_id;

        return $this;
    }

    /**
     * Gets number_of_parcels
     *
     * @return int|null
     */
    public function getNumberOfParcels()
    {
        return $this->container['number_of_parcels'];
    }

    /**
     * Sets number_of_parcels
     *
     * @param int|null $number_of_parcels number_of_parcels
     *
     * @return self
     */
    public function setNumberOfParcels($number_of_parcels)
    {
        if (is_null($number_of_parcels)) {
            throw new \InvalidArgumentException('non-nullable number_of_parcels cannot be null');
        }

        if (($number_of_parcels > 1000)) {
            throw new \InvalidArgumentException('invalid value for $number_of_parcels when calling ToolkitDataClassesOrdersOrder., must be smaller than or equal to 1000.');
        }
        if (($number_of_parcels < 1)) {
            throw new \InvalidArgumentException('invalid value for $number_of_parcels when calling ToolkitDataClassesOrdersOrder., must be bigger than or equal to 1.');
        }

        $this->container['number_of_parcels'] = $number_of_parcels;

        return $this;
    }

    /**
     * Gets total_items
     *
     * @return int|null
     */
    public function getTotalItems()
    {
        return $this->container['total_items'];
    }

    /**
     * Sets total_items
     *
     * @param int|null $total_items total_items
     *
     * @return self
     */
    public function setTotalItems($total_items)
    {
        if (is_null($total_items)) {
            throw new \InvalidArgumentException('non-nullable total_items cannot be null');
        }
        $this->container['total_items'] = $total_items;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight total_weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets order_value
     *
     * @return float|null
     */
    public function getOrderValue()
    {
        return $this->container['order_value'];
    }

    /**
     * Sets order_value
     *
     * @param float|null $order_value order_value
     *
     * @return self
     */
    public function setOrderValue($order_value)
    {
        if (is_null($order_value)) {
            throw new \InvalidArgumentException('non-nullable order_value cannot be null');
        }
        $this->container['order_value'] = $order_value;

        return $this;
    }

    /**
     * Gets part
     *
     * @return int|null
     */
    public function getPart()
    {
        return $this->container['part'];
    }

    /**
     * Sets part
     *
     * @param int|null $part part
     *
     * @return self
     */
    public function setPart($part)
    {
        if (is_null($part)) {
            throw new \InvalidArgumentException('non-nullable part cannot be null');
        }
        $this->container['part'] = $part;

        return $this;
    }

    /**
     * Gets number_of_parts
     *
     * @return int|null
     */
    public function getNumberOfParts()
    {
        return $this->container['number_of_parts'];
    }

    /**
     * Sets number_of_parts
     *
     * @param int|null $number_of_parts number_of_parts
     *
     * @return self
     */
    public function setNumberOfParts($number_of_parts)
    {
        if (is_null($number_of_parts)) {
            throw new \InvalidArgumentException('non-nullable number_of_parts cannot be null');
        }
        $this->container['number_of_parts'] = $number_of_parts;

        return $this;
    }

    /**
     * Gets courier_service_type_id
     *
     * @return int
     */
    public function getCourierServiceTypeId()
    {
        return $this->container['courier_service_type_id'];
    }

    /**
     * Sets courier_service_type_id
     *
     * @param int $courier_service_type_id courier_service_type_id
     *
     * @return self
     */
    public function setCourierServiceTypeId($courier_service_type_id)
    {
        if (is_null($courier_service_type_id)) {
            throw new \InvalidArgumentException('non-nullable courier_service_type_id cannot be null');
        }
        $this->container['courier_service_type_id'] = $courier_service_type_id;

        return $this;
    }

    /**
     * Gets courier_service_id
     *
     * @return int|null
     */
    public function getCourierServiceId()
    {
        return $this->container['courier_service_id'];
    }

    /**
     * Sets courier_service_id
     *
     * @param int|null $courier_service_id courier_service_id
     *
     * @return self
     */
    public function setCourierServiceId($courier_service_id)
    {
        if (is_null($courier_service_id)) {
            throw new \InvalidArgumentException('non-nullable courier_service_id cannot be null');
        }
        $this->container['courier_service_id'] = $courier_service_id;

        return $this;
    }

    /**
     * Gets courier_service_name
     *
     * @return string|null
     */
    public function getCourierServiceName()
    {
        return $this->container['courier_service_name'];
    }

    /**
     * Sets courier_service_name
     *
     * @param string|null $courier_service_name courier_service_name
     *
     * @return self
     */
    public function setCourierServiceName($courier_service_name)
    {
        if (is_null($courier_service_name)) {
            throw new \InvalidArgumentException('non-nullable courier_service_name cannot be null');
        }
        $this->container['courier_service_name'] = $courier_service_name;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets tracking_url
     *
     * @return string|null
     */
    public function getTrackingUrl()
    {
        return $this->container['tracking_url'];
    }

    /**
     * Sets tracking_url
     *
     * @param string|null $tracking_url tracking_url
     *
     * @return self
     */
    public function setTrackingUrl($tracking_url)
    {
        if (is_null($tracking_url)) {
            throw new \InvalidArgumentException('non-nullable tracking_url cannot be null');
        }
        $this->container['tracking_url'] = $tracking_url;

        return $this;
    }

    /**
     * Gets shipping_total_ex_vat
     *
     * @return float|null
     */
    public function getShippingTotalExVat()
    {
        return $this->container['shipping_total_ex_vat'];
    }

    /**
     * Sets shipping_total_ex_vat
     *
     * @param float|null $shipping_total_ex_vat shipping_total_ex_vat
     *
     * @return self
     */
    public function setShippingTotalExVat($shipping_total_ex_vat)
    {
        if (is_null($shipping_total_ex_vat)) {
            throw new \InvalidArgumentException('non-nullable shipping_total_ex_vat cannot be null');
        }
        $this->container['shipping_total_ex_vat'] = $shipping_total_ex_vat;

        return $this;
    }

    /**
     * Gets shipping_total_vat
     *
     * @return float|null
     */
    public function getShippingTotalVat()
    {
        return $this->container['shipping_total_vat'];
    }

    /**
     * Sets shipping_total_vat
     *
     * @param float|null $shipping_total_vat shipping_total_vat
     *
     * @return self
     */
    public function setShippingTotalVat($shipping_total_vat)
    {
        if (is_null($shipping_total_vat)) {
            throw new \InvalidArgumentException('non-nullable shipping_total_vat cannot be null');
        }
        $this->container['shipping_total_vat'] = $shipping_total_vat;

        return $this;
    }

    /**
     * Gets discount_total_ex_vat
     *
     * @return float|null
     */
    public function getDiscountTotalExVat()
    {
        return $this->container['discount_total_ex_vat'];
    }

    /**
     * Sets discount_total_ex_vat
     *
     * @param float|null $discount_total_ex_vat discount_total_ex_vat
     *
     * @return self
     */
    public function setDiscountTotalExVat($discount_total_ex_vat)
    {
        if (is_null($discount_total_ex_vat)) {
            throw new \InvalidArgumentException('non-nullable discount_total_ex_vat cannot be null');
        }
        $this->container['discount_total_ex_vat'] = $discount_total_ex_vat;

        return $this;
    }

    /**
     * Gets discount_total_vat
     *
     * @return float|null
     */
    public function getDiscountTotalVat()
    {
        return $this->container['discount_total_vat'];
    }

    /**
     * Sets discount_total_vat
     *
     * @param float|null $discount_total_vat discount_total_vat
     *
     * @return self
     */
    public function setDiscountTotalVat($discount_total_vat)
    {
        if (is_null($discount_total_vat)) {
            throw new \InvalidArgumentException('non-nullable discount_total_vat cannot be null');
        }
        $this->container['discount_total_vat'] = $discount_total_vat;

        return $this;
    }

    /**
     * Gets total_vat
     *
     * @return float|null
     */
    public function getTotalVat()
    {
        return $this->container['total_vat'];
    }

    /**
     * Sets total_vat
     *
     * @param float|null $total_vat total_vat
     *
     * @return self
     */
    public function setTotalVat($total_vat)
    {
        if (is_null($total_vat)) {
            throw new \InvalidArgumentException('non-nullable total_vat cannot be null');
        }
        $this->container['total_vat'] = $total_vat;

        return $this;
    }

    /**
     * Gets warehouse_id
     *
     * @return int|null
     */
    public function getWarehouseId()
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id
     *
     * @param int|null $warehouse_id warehouse_id
     *
     * @return self
     */
    public function setWarehouseId($warehouse_id)
    {
        if (is_null($warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_id cannot be null');
        }
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }

    /**
     * Gets warehouse_code
     *
     * @return string|null
     */
    public function getWarehouseCode()
    {
        return $this->container['warehouse_code'];
    }

    /**
     * Sets warehouse_code
     *
     * @param string|null $warehouse_code warehouse_code
     *
     * @return self
     */
    public function setWarehouseCode($warehouse_code)
    {
        if (is_null($warehouse_code)) {
            throw new \InvalidArgumentException('non-nullable warehouse_code cannot be null');
        }
        $this->container['warehouse_code'] = $warehouse_code;

        return $this;
    }

    /**
     * Gets channel_id
     *
     * @return int|null
     */
    public function getChannelId()
    {
        return $this->container['channel_id'];
    }

    /**
     * Sets channel_id
     *
     * @param int|null $channel_id channel_id
     *
     * @return self
     */
    public function setChannelId($channel_id)
    {
        if (is_null($channel_id)) {
            throw new \InvalidArgumentException('non-nullable channel_id cannot be null');
        }
        $this->container['channel_id'] = $channel_id;

        return $this;
    }

    /**
     * Gets channel
     *
     * @return \Mintsoft\Model\ToolkitDataClassesChannelsChannel|null
     */
    public function getChannel()
    {
        return $this->container['channel'];
    }

    /**
     * Sets channel
     *
     * @param \Mintsoft\Model\ToolkitDataClassesChannelsChannel|null $channel channel
     *
     * @return self
     */
    public function setChannel($channel)
    {
        if (is_null($channel)) {
            throw new \InvalidArgumentException('non-nullable channel cannot be null');
        }
        $this->container['channel'] = $channel;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return int|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param int|null $currency_id currency_id
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        if (is_null($currency_id)) {
            throw new \InvalidArgumentException('non-nullable currency_id cannot be null');
        }
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Mintsoft\Model\ToolkitDataClassesCurrenciesCurrency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Mintsoft\Model\ToolkitDataClassesCurrenciesCurrency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets despatched_by_user
     *
     * @return string|null
     */
    public function getDespatchedByUser()
    {
        return $this->container['despatched_by_user'];
    }

    /**
     * Sets despatched_by_user
     *
     * @param string|null $despatched_by_user despatched_by_user
     *
     * @return self
     */
    public function setDespatchedByUser($despatched_by_user)
    {
        if (is_null($despatched_by_user)) {
            throw new \InvalidArgumentException('non-nullable despatched_by_user cannot be null');
        }
        $this->container['despatched_by_user'] = $despatched_by_user;

        return $this;
    }

    /**
     * Gets order_items
     *
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]|null
     */
    public function getOrderItems()
    {
        return $this->container['order_items'];
    }

    /**
     * Sets order_items
     *
     * @param \Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]|null $order_items order_items
     *
     * @return self
     */
    public function setOrderItems($order_items)
    {
        if (is_null($order_items)) {
            throw new \InvalidArgumentException('non-nullable order_items cannot be null');
        }
        $this->container['order_items'] = $order_items;

        return $this;
    }

    /**
     * Gets order_name_values
     *
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderNameValue[]|null
     */
    public function getOrderNameValues()
    {
        return $this->container['order_name_values'];
    }

    /**
     * Sets order_name_values
     *
     * @param \Mintsoft\Model\ToolkitDataClassesOrdersOrderNameValue[]|null $order_name_values order_name_values
     *
     * @return self
     */
    public function setOrderNameValues($order_name_values)
    {
        if (is_null($order_name_values)) {
            throw new \InvalidArgumentException('non-nullable order_name_values cannot be null');
        }
        $this->container['order_name_values'] = $order_name_values;

        return $this;
    }

    /**
     * Gets order_lock
     *
     * @return bool|null
     */
    public function getOrderLock()
    {
        return $this->container['order_lock'];
    }

    /**
     * Sets order_lock
     *
     * @param bool|null $order_lock order_lock
     *
     * @return self
     */
    public function setOrderLock($order_lock)
    {
        if (is_null($order_lock)) {
            throw new \InvalidArgumentException('non-nullable order_lock cannot be null');
        }
        $this->container['order_lock'] = $order_lock;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string|null $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated last_updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets last_updated_by_user
     *
     * @return string|null
     */
    public function getLastUpdatedByUser()
    {
        return $this->container['last_updated_by_user'];
    }

    /**
     * Sets last_updated_by_user
     *
     * @param string|null $last_updated_by_user last_updated_by_user
     *
     * @return self
     */
    public function setLastUpdatedByUser($last_updated_by_user)
    {
        if (is_null($last_updated_by_user)) {
            throw new \InvalidArgumentException('non-nullable last_updated_by_user cannot be null');
        }
        $this->container['last_updated_by_user'] = $last_updated_by_user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


