<?php
/**
 * WarehouseApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * WarehouseApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WarehouseApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'warehouseBulkStockMovement' => [
            'application/json',
            'text/json',
        ],
        'warehouseCancelWarehouseTransfer' => [
            'application/json',
        ],
        'warehouseConfirmWarehouseTransfer' => [
            'application/json',
        ],
        'warehouseCreateWarehouseTransfer' => [
            'application/json',
            'text/json',
        ],
        'warehouseDeleteWarehouseTransfer' => [
            'application/json',
        ],
        'warehouseGetLocation' => [
            'application/json',
        ],
        'warehouseGetLocationTypes' => [
            'application/json',
        ],
        'warehouseGetLocations' => [
            'application/json',
        ],
        'warehouseGetStatuses' => [
            'application/json',
        ],
        'warehouseGetWarehouseTransfer' => [
            'application/json',
        ],
        'warehouseGetWarehouses' => [
            'application/json',
        ],
        'warehouseListWarehouseTransfers' => [
            'application/json',
        ],
        'warehouseLookupLocationId' => [
            'application/json',
        ],
        'warehouseStockMovement' => [
            'application/json',
            'text/json',
        ],
        'warehouseUpdateWarehouseTransfer' => [
            'application/json',
            'text/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation warehouseBulkStockMovement
     *
     * @param  string $api_key api_key (required)
     * @param  int $action action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[] $requests requests (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseBulkStockMovement'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]
     */
    public function warehouseBulkStockMovement($api_key, $action, $requests, string $contentType = self::contentTypes['warehouseBulkStockMovement'][0])
    {
        list($response) = $this->warehouseBulkStockMovementWithHttpInfo($api_key, $action, $requests, $contentType);
        return $response;
    }

    /**
     * Operation warehouseBulkStockMovementWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[] $requests (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseBulkStockMovement'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseBulkStockMovementWithHttpInfo($api_key, $action, $requests, string $contentType = self::contentTypes['warehouseBulkStockMovement'][0])
    {
        $request = $this->warehouseBulkStockMovementRequest($api_key, $action, $requests, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseBulkStockMovementAsync
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[] $requests (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseBulkStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseBulkStockMovementAsync($api_key, $action, $requests, string $contentType = self::contentTypes['warehouseBulkStockMovement'][0])
    {
        return $this->warehouseBulkStockMovementAsyncWithHttpInfo($api_key, $action, $requests, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseBulkStockMovementAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[] $requests (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseBulkStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseBulkStockMovementAsyncWithHttpInfo($api_key, $action, $requests, string $contentType = self::contentTypes['warehouseBulkStockMovement'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]';
        $request = $this->warehouseBulkStockMovementRequest($api_key, $action, $requests, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseBulkStockMovement'
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[] $requests (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseBulkStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseBulkStockMovementRequest($api_key, $action, $requests, string $contentType = self::contentTypes['warehouseBulkStockMovement'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseBulkStockMovement'
            );
        }

        // verify the required parameter 'action' is set
        if ($action === null || (is_array($action) && count($action) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $action when calling warehouseBulkStockMovement'
            );
        }

        // verify the required parameter 'requests' is set
        if ($requests === null || (is_array($requests) && count($requests) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $requests when calling warehouseBulkStockMovement'
            );
        }


        $resourcePath = '/api/Warehouse/BulkStockMovement';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $action,
            'Action', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($requests)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($requests));
            } else {
                $httpBody = $requests;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseCancelWarehouseTransfer
     *
     * Cancel WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCancelWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseCancelWarehouseTransfer($id, $api_key, string $contentType = self::contentTypes['warehouseCancelWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseCancelWarehouseTransferWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseCancelWarehouseTransferWithHttpInfo
     *
     * Cancel WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCancelWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseCancelWarehouseTransferWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseCancelWarehouseTransfer'][0])
    {
        $request = $this->warehouseCancelWarehouseTransferRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseCancelWarehouseTransferAsync
     *
     * Cancel WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCancelWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseCancelWarehouseTransferAsync($id, $api_key, string $contentType = self::contentTypes['warehouseCancelWarehouseTransfer'][0])
    {
        return $this->warehouseCancelWarehouseTransferAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseCancelWarehouseTransferAsyncWithHttpInfo
     *
     * Cancel WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCancelWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseCancelWarehouseTransferAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseCancelWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseCancelWarehouseTransferRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseCancelWarehouseTransfer'
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCancelWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseCancelWarehouseTransferRequest($id, $api_key, string $contentType = self::contentTypes['warehouseCancelWarehouseTransfer'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling warehouseCancelWarehouseTransfer'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseCancelWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/{id}/Cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseConfirmWarehouseTransfer
     *
     * Confirm WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseConfirmWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseConfirmWarehouseTransfer($id, $api_key, string $contentType = self::contentTypes['warehouseConfirmWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseConfirmWarehouseTransferWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseConfirmWarehouseTransferWithHttpInfo
     *
     * Confirm WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseConfirmWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseConfirmWarehouseTransferWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseConfirmWarehouseTransfer'][0])
    {
        $request = $this->warehouseConfirmWarehouseTransferRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseConfirmWarehouseTransferAsync
     *
     * Confirm WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseConfirmWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseConfirmWarehouseTransferAsync($id, $api_key, string $contentType = self::contentTypes['warehouseConfirmWarehouseTransfer'][0])
    {
        return $this->warehouseConfirmWarehouseTransferAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseConfirmWarehouseTransferAsyncWithHttpInfo
     *
     * Confirm WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseConfirmWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseConfirmWarehouseTransferAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseConfirmWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseConfirmWarehouseTransferRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseConfirmWarehouseTransfer'
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseConfirmWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseConfirmWarehouseTransferRequest($id, $api_key, string $contentType = self::contentTypes['warehouseConfirmWarehouseTransfer'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling warehouseConfirmWarehouseTransfer'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseConfirmWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/{id}/Confirm';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseCreateWarehouseTransfer
     *
     * Create new WarehouseTransfer
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer WarehouseTransfer Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCreateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseCreateWarehouseTransfer($api_key, $warehouse_transfer, string $contentType = self::contentTypes['warehouseCreateWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseCreateWarehouseTransferWithHttpInfo($api_key, $warehouse_transfer, $contentType);
        return $response;
    }

    /**
     * Operation warehouseCreateWarehouseTransferWithHttpInfo
     *
     * Create new WarehouseTransfer
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer WarehouseTransfer Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCreateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseCreateWarehouseTransferWithHttpInfo($api_key, $warehouse_transfer, string $contentType = self::contentTypes['warehouseCreateWarehouseTransfer'][0])
    {
        $request = $this->warehouseCreateWarehouseTransferRequest($api_key, $warehouse_transfer, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseCreateWarehouseTransferAsync
     *
     * Create new WarehouseTransfer
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer WarehouseTransfer Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCreateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseCreateWarehouseTransferAsync($api_key, $warehouse_transfer, string $contentType = self::contentTypes['warehouseCreateWarehouseTransfer'][0])
    {
        return $this->warehouseCreateWarehouseTransferAsyncWithHttpInfo($api_key, $warehouse_transfer, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseCreateWarehouseTransferAsyncWithHttpInfo
     *
     * Create new WarehouseTransfer
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer WarehouseTransfer Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCreateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseCreateWarehouseTransferAsyncWithHttpInfo($api_key, $warehouse_transfer, string $contentType = self::contentTypes['warehouseCreateWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseCreateWarehouseTransferRequest($api_key, $warehouse_transfer, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseCreateWarehouseTransfer'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer WarehouseTransfer Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseCreateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseCreateWarehouseTransferRequest($api_key, $warehouse_transfer, string $contentType = self::contentTypes['warehouseCreateWarehouseTransfer'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseCreateWarehouseTransfer'
            );
        }

        // verify the required parameter 'warehouse_transfer' is set
        if ($warehouse_transfer === null || (is_array($warehouse_transfer) && count($warehouse_transfer) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_transfer when calling warehouseCreateWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($warehouse_transfer)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($warehouse_transfer));
            } else {
                $httpBody = $warehouse_transfer;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseDeleteWarehouseTransfer
     *
     * Delete WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseDeleteWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseDeleteWarehouseTransfer($id, $api_key, string $contentType = self::contentTypes['warehouseDeleteWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseDeleteWarehouseTransferWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseDeleteWarehouseTransferWithHttpInfo
     *
     * Delete WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseDeleteWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseDeleteWarehouseTransferWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseDeleteWarehouseTransfer'][0])
    {
        $request = $this->warehouseDeleteWarehouseTransferRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseDeleteWarehouseTransferAsync
     *
     * Delete WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseDeleteWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseDeleteWarehouseTransferAsync($id, $api_key, string $contentType = self::contentTypes['warehouseDeleteWarehouseTransfer'][0])
    {
        return $this->warehouseDeleteWarehouseTransferAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseDeleteWarehouseTransferAsyncWithHttpInfo
     *
     * Delete WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseDeleteWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseDeleteWarehouseTransferAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseDeleteWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseDeleteWarehouseTransferRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseDeleteWarehouseTransfer'
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseDeleteWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseDeleteWarehouseTransferRequest($id, $api_key, string $contentType = self::contentTypes['warehouseDeleteWarehouseTransfer'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling warehouseDeleteWarehouseTransfer'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseDeleteWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetLocation
     *
     * @param  string $api_key api_key (required)
     * @param  int $warehouse_id warehouse_id (required)
     * @param  int $location_id location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseLocation
     */
    public function warehouseGetLocation($api_key, $warehouse_id, $location_id, string $contentType = self::contentTypes['warehouseGetLocation'][0])
    {
        list($response) = $this->warehouseGetLocationWithHttpInfo($api_key, $warehouse_id, $location_id, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetLocationWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseLocation, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetLocationWithHttpInfo($api_key, $warehouse_id, $location_id, string $contentType = self::contentTypes['warehouseGetLocation'][0])
    {
        $request = $this->warehouseGetLocationRequest($api_key, $warehouse_id, $location_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetLocationAsync
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationAsync($api_key, $warehouse_id, $location_id, string $contentType = self::contentTypes['warehouseGetLocation'][0])
    {
        return $this->warehouseGetLocationAsyncWithHttpInfo($api_key, $warehouse_id, $location_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetLocationAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationAsyncWithHttpInfo($api_key, $warehouse_id, $location_id, string $contentType = self::contentTypes['warehouseGetLocation'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation';
        $request = $this->warehouseGetLocationRequest($api_key, $warehouse_id, $location_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetLocation'
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetLocationRequest($api_key, $warehouse_id, $location_id, string $contentType = self::contentTypes['warehouseGetLocation'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetLocation'
            );
        }

        // verify the required parameter 'warehouse_id' is set
        if ($warehouse_id === null || (is_array($warehouse_id) && count($warehouse_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_id when calling warehouseGetLocation'
            );
        }

        // verify the required parameter 'location_id' is set
        if ($location_id === null || (is_array($location_id) && count($location_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $location_id when calling warehouseGetLocation'
            );
        }


        $resourcePath = '/api/Warehouse/{WarehouseId}/Location/{LocationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($warehouse_id !== null) {
            $resourcePath = str_replace(
                '{' . 'WarehouseId' . '}',
                ObjectSerializer::toPathValue($warehouse_id),
                $resourcePath
            );
        }
        // path params
        if ($location_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LocationId' . '}',
                ObjectSerializer::toPathValue($location_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetLocationTypes
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocationTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]
     */
    public function warehouseGetLocationTypes($api_key, string $contentType = self::contentTypes['warehouseGetLocationTypes'][0])
    {
        list($response) = $this->warehouseGetLocationTypesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetLocationTypesWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocationTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetLocationTypesWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetLocationTypes'][0])
    {
        $request = $this->warehouseGetLocationTypesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetLocationTypesAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocationTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationTypesAsync($api_key, string $contentType = self::contentTypes['warehouseGetLocationTypes'][0])
    {
        return $this->warehouseGetLocationTypesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetLocationTypesAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocationTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationTypesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetLocationTypes'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]';
        $request = $this->warehouseGetLocationTypesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetLocationTypes'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocationTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetLocationTypesRequest($api_key, string $contentType = self::contentTypes['warehouseGetLocationTypes'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetLocationTypes'
            );
        }


        $resourcePath = '/api/Warehouse/LocationTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetLocations
     *
     * @param  string $api_key api_key (required)
     * @param  int $warehouse_id warehouse_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocations'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]
     */
    public function warehouseGetLocations($api_key, $warehouse_id, string $contentType = self::contentTypes['warehouseGetLocations'][0])
    {
        list($response) = $this->warehouseGetLocationsWithHttpInfo($api_key, $warehouse_id, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetLocationsWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocations'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseLocation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetLocationsWithHttpInfo($api_key, $warehouse_id, string $contentType = self::contentTypes['warehouseGetLocations'][0])
    {
        $request = $this->warehouseGetLocationsRequest($api_key, $warehouse_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetLocationsAsync
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationsAsync($api_key, $warehouse_id, string $contentType = self::contentTypes['warehouseGetLocations'][0])
    {
        return $this->warehouseGetLocationsAsyncWithHttpInfo($api_key, $warehouse_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetLocationsAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetLocationsAsyncWithHttpInfo($api_key, $warehouse_id, string $contentType = self::contentTypes['warehouseGetLocations'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]';
        $request = $this->warehouseGetLocationsRequest($api_key, $warehouse_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetLocations'
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetLocationsRequest($api_key, $warehouse_id, string $contentType = self::contentTypes['warehouseGetLocations'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetLocations'
            );
        }

        // verify the required parameter 'warehouse_id' is set
        if ($warehouse_id === null || (is_array($warehouse_id) && count($warehouse_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_id when calling warehouseGetLocations'
            );
        }


        $resourcePath = '/api/Warehouse/{WarehouseId}/Location/All';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($warehouse_id !== null) {
            $resourcePath = str_replace(
                '{' . 'WarehouseId' . '}',
                ObjectSerializer::toPathValue($warehouse_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetStatuses
     *
     * Get WarehouseTransfer Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function warehouseGetStatuses($api_key, string $contentType = self::contentTypes['warehouseGetStatuses'][0])
    {
        list($response) = $this->warehouseGetStatusesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetStatusesWithHttpInfo
     *
     * Get WarehouseTransfer Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetStatusesWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetStatuses'][0])
    {
        $request = $this->warehouseGetStatusesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetStatusesAsync
     *
     * Get WarehouseTransfer Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetStatusesAsync($api_key, string $contentType = self::contentTypes['warehouseGetStatuses'][0])
    {
        return $this->warehouseGetStatusesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetStatusesAsyncWithHttpInfo
     *
     * Get WarehouseTransfer Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetStatusesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetStatuses'][0])
    {
        $returnType = 'string[]';
        $request = $this->warehouseGetStatusesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetStatuses'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetStatusesRequest($api_key, string $contentType = self::contentTypes['warehouseGetStatuses'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetStatuses'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/Statuses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetWarehouseTransfer
     *
     * Get WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer
     */
    public function warehouseGetWarehouseTransfer($id, $api_key, string $contentType = self::contentTypes['warehouseGetWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseGetWarehouseTransferWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetWarehouseTransferWithHttpInfo
     *
     * Get WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetWarehouseTransferWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseGetWarehouseTransfer'][0])
    {
        $request = $this->warehouseGetWarehouseTransferRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetWarehouseTransferAsync
     *
     * Get WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetWarehouseTransferAsync($id, $api_key, string $contentType = self::contentTypes['warehouseGetWarehouseTransfer'][0])
    {
        return $this->warehouseGetWarehouseTransferAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetWarehouseTransferAsyncWithHttpInfo
     *
     * Get WarehouseTransfer
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetWarehouseTransferAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['warehouseGetWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer';
        $request = $this->warehouseGetWarehouseTransferRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetWarehouseTransfer'
     *
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetWarehouseTransferRequest($id, $api_key, string $contentType = self::contentTypes['warehouseGetWarehouseTransfer'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling warehouseGetWarehouseTransfer'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseGetWarehouses
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockWarehouse[]
     */
    public function warehouseGetWarehouses($api_key, string $contentType = self::contentTypes['warehouseGetWarehouses'][0])
    {
        list($response) = $this->warehouseGetWarehousesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation warehouseGetWarehousesWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockWarehouse[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseGetWarehousesWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetWarehouses'][0])
    {
        $request = $this->warehouseGetWarehousesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockWarehouse[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockWarehouse[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockWarehouse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseGetWarehousesAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetWarehousesAsync($api_key, string $contentType = self::contentTypes['warehouseGetWarehouses'][0])
    {
        return $this->warehouseGetWarehousesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseGetWarehousesAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseGetWarehousesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['warehouseGetWarehouses'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockWarehouse[]';
        $request = $this->warehouseGetWarehousesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseGetWarehouses'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseGetWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseGetWarehousesRequest($api_key, string $contentType = self::contentTypes['warehouseGetWarehouses'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseGetWarehouses'
            );
        }


        $resourcePath = '/api/Warehouse';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseListWarehouseTransfers
     *
     * @param  string $api_key api_key (required)
     * @param  bool|null $include_warehouse_transfer_items include_warehouse_transfer_items (optional)
     * @param  string|null $warehouse_transfer_statuses warehouse_transfer_statuses (optional)
     * @param  int|null $page_no page_no (optional)
     * @param  int|null $limit limit (optional)
     * @param  int|null $client_id client_id (optional)
     * @param  int|null $source_warehouse_id source_warehouse_id (optional)
     * @param  int|null $destination_warehouse_id destination_warehouse_id (optional)
     * @param  \DateTime|null $since_last_updated since_last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseListWarehouseTransfers'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]
     */
    public function warehouseListWarehouseTransfers($api_key, $include_warehouse_transfer_items = null, $warehouse_transfer_statuses = null, $page_no = null, $limit = null, $client_id = null, $source_warehouse_id = null, $destination_warehouse_id = null, $since_last_updated = null, string $contentType = self::contentTypes['warehouseListWarehouseTransfers'][0])
    {
        list($response) = $this->warehouseListWarehouseTransfersWithHttpInfo($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated, $contentType);
        return $response;
    }

    /**
     * Operation warehouseListWarehouseTransfersWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  bool|null $include_warehouse_transfer_items (optional)
     * @param  string|null $warehouse_transfer_statuses (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $source_warehouse_id (optional)
     * @param  int|null $destination_warehouse_id (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseListWarehouseTransfers'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[], HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseListWarehouseTransfersWithHttpInfo($api_key, $include_warehouse_transfer_items = null, $warehouse_transfer_statuses = null, $page_no = null, $limit = null, $client_id = null, $source_warehouse_id = null, $destination_warehouse_id = null, $since_last_updated = null, string $contentType = self::contentTypes['warehouseListWarehouseTransfers'][0])
    {
        $request = $this->warehouseListWarehouseTransfersRequest($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseListWarehouseTransfersAsync
     *
     * @param  string $api_key (required)
     * @param  bool|null $include_warehouse_transfer_items (optional)
     * @param  string|null $warehouse_transfer_statuses (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $source_warehouse_id (optional)
     * @param  int|null $destination_warehouse_id (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseListWarehouseTransfers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseListWarehouseTransfersAsync($api_key, $include_warehouse_transfer_items = null, $warehouse_transfer_statuses = null, $page_no = null, $limit = null, $client_id = null, $source_warehouse_id = null, $destination_warehouse_id = null, $since_last_updated = null, string $contentType = self::contentTypes['warehouseListWarehouseTransfers'][0])
    {
        return $this->warehouseListWarehouseTransfersAsyncWithHttpInfo($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseListWarehouseTransfersAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  bool|null $include_warehouse_transfer_items (optional)
     * @param  string|null $warehouse_transfer_statuses (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $source_warehouse_id (optional)
     * @param  int|null $destination_warehouse_id (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseListWarehouseTransfers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseListWarehouseTransfersAsyncWithHttpInfo($api_key, $include_warehouse_transfer_items = null, $warehouse_transfer_statuses = null, $page_no = null, $limit = null, $client_id = null, $source_warehouse_id = null, $destination_warehouse_id = null, $since_last_updated = null, string $contentType = self::contentTypes['warehouseListWarehouseTransfers'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]';
        $request = $this->warehouseListWarehouseTransfersRequest($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseListWarehouseTransfers'
     *
     * @param  string $api_key (required)
     * @param  bool|null $include_warehouse_transfer_items (optional)
     * @param  string|null $warehouse_transfer_statuses (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $source_warehouse_id (optional)
     * @param  int|null $destination_warehouse_id (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseListWarehouseTransfers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseListWarehouseTransfersRequest($api_key, $include_warehouse_transfer_items = null, $warehouse_transfer_statuses = null, $page_no = null, $limit = null, $client_id = null, $source_warehouse_id = null, $destination_warehouse_id = null, $since_last_updated = null, string $contentType = self::contentTypes['warehouseListWarehouseTransfers'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseListWarehouseTransfers'
            );
        }










        $resourcePath = '/api/WarehouseTransfer/List';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_warehouse_transfer_items,
            'IncludeWarehouseTransferItems', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_transfer_statuses,
            'WarehouseTransferStatuses', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source_warehouse_id,
            'SourceWarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $destination_warehouse_id,
            'DestinationWarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_last_updated,
            'SinceLastUpdated', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseLookupLocationId
     *
     * @param  string $api_key api_key (required)
     * @param  int $warehouse_id warehouse_id (required)
     * @param  string $location location (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseLookupLocationId'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseLocation
     */
    public function warehouseLookupLocationId($api_key, $warehouse_id, $location, string $contentType = self::contentTypes['warehouseLookupLocationId'][0])
    {
        list($response) = $this->warehouseLookupLocationIdWithHttpInfo($api_key, $warehouse_id, $location, $contentType);
        return $response;
    }

    /**
     * Operation warehouseLookupLocationIdWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $location (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseLookupLocationId'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseLocation, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseLookupLocationIdWithHttpInfo($api_key, $warehouse_id, $location, string $contentType = self::contentTypes['warehouseLookupLocationId'][0])
    {
        $request = $this->warehouseLookupLocationIdRequest($api_key, $warehouse_id, $location, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseLookupLocationIdAsync
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $location (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseLookupLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseLookupLocationIdAsync($api_key, $warehouse_id, $location, string $contentType = self::contentTypes['warehouseLookupLocationId'][0])
    {
        return $this->warehouseLookupLocationIdAsyncWithHttpInfo($api_key, $warehouse_id, $location, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseLookupLocationIdAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $location (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseLookupLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseLookupLocationIdAsyncWithHttpInfo($api_key, $warehouse_id, $location, string $contentType = self::contentTypes['warehouseLookupLocationId'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseLocation';
        $request = $this->warehouseLookupLocationIdRequest($api_key, $warehouse_id, $location, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseLookupLocationId'
     *
     * @param  string $api_key (required)
     * @param  int $warehouse_id (required)
     * @param  string $location (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseLookupLocationId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseLookupLocationIdRequest($api_key, $warehouse_id, $location, string $contentType = self::contentTypes['warehouseLookupLocationId'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseLookupLocationId'
            );
        }

        // verify the required parameter 'warehouse_id' is set
        if ($warehouse_id === null || (is_array($warehouse_id) && count($warehouse_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_id when calling warehouseLookupLocationId'
            );
        }

        // verify the required parameter 'location' is set
        if ($location === null || (is_array($location) && count($location) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $location when calling warehouseLookupLocationId'
            );
        }


        $resourcePath = '/api/Warehouse/{WarehouseId}/Location/LookupLocationId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location,
            'Location', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($warehouse_id !== null) {
            $resourcePath = str_replace(
                '{' . 'WarehouseId' . '}',
                ObjectSerializer::toPathValue($warehouse_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseStockMovement
     *
     * @param  string $api_key api_key (required)
     * @param  int $action action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest $request request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseStockMovement'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseStockMovement($api_key, $action, $request, string $contentType = self::contentTypes['warehouseStockMovement'][0])
    {
        list($response) = $this->warehouseStockMovementWithHttpInfo($api_key, $action, $request, $contentType);
        return $response;
    }

    /**
     * Operation warehouseStockMovementWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest $request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseStockMovement'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseStockMovementWithHttpInfo($api_key, $action, $request, string $contentType = self::contentTypes['warehouseStockMovement'][0])
    {
        $request = $this->warehouseStockMovementRequest($api_key, $action, $request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseStockMovementAsync
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest $request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseStockMovementAsync($api_key, $action, $request, string $contentType = self::contentTypes['warehouseStockMovement'][0])
    {
        return $this->warehouseStockMovementAsyncWithHttpInfo($api_key, $action, $request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseStockMovementAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest $request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseStockMovementAsyncWithHttpInfo($api_key, $action, $request, string $contentType = self::contentTypes['warehouseStockMovement'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseStockMovementRequest($api_key, $action, $request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseStockMovement'
     *
     * @param  string $api_key (required)
     * @param  int $action (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest $request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseStockMovement'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseStockMovementRequest($api_key, $action, $request, string $contentType = self::contentTypes['warehouseStockMovement'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseStockMovement'
            );
        }

        // verify the required parameter 'action' is set
        if ($action === null || (is_array($action) && count($action) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $action when calling warehouseStockMovement'
            );
        }

        // verify the required parameter 'request' is set
        if ($request === null || (is_array($request) && count($request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request when calling warehouseStockMovement'
            );
        }


        $resourcePath = '/api/Warehouse/StockMovement';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $action,
            'Action', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation warehouseUpdateWarehouseTransfer
     *
     * Update WarehouseTransfer Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer warehouse_transfer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseUpdateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function warehouseUpdateWarehouseTransfer($api_key, $id, $warehouse_transfer, string $contentType = self::contentTypes['warehouseUpdateWarehouseTransfer'][0])
    {
        list($response) = $this->warehouseUpdateWarehouseTransferWithHttpInfo($api_key, $id, $warehouse_transfer, $contentType);
        return $response;
    }

    /**
     * Operation warehouseUpdateWarehouseTransferWithHttpInfo
     *
     * Update WarehouseTransfer Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseUpdateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function warehouseUpdateWarehouseTransferWithHttpInfo($api_key, $id, $warehouse_transfer, string $contentType = self::contentTypes['warehouseUpdateWarehouseTransfer'][0])
    {
        $request = $this->warehouseUpdateWarehouseTransferRequest($api_key, $id, $warehouse_transfer, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation warehouseUpdateWarehouseTransferAsync
     *
     * Update WarehouseTransfer Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseUpdateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseUpdateWarehouseTransferAsync($api_key, $id, $warehouse_transfer, string $contentType = self::contentTypes['warehouseUpdateWarehouseTransfer'][0])
    {
        return $this->warehouseUpdateWarehouseTransferAsyncWithHttpInfo($api_key, $id, $warehouse_transfer, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation warehouseUpdateWarehouseTransferAsyncWithHttpInfo
     *
     * Update WarehouseTransfer Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseUpdateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function warehouseUpdateWarehouseTransferAsyncWithHttpInfo($api_key, $id, $warehouse_transfer, string $contentType = self::contentTypes['warehouseUpdateWarehouseTransfer'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->warehouseUpdateWarehouseTransferRequest($api_key, $id, $warehouse_transfer, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'warehouseUpdateWarehouseTransfer'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the WarehouseTransfer (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer $warehouse_transfer (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['warehouseUpdateWarehouseTransfer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function warehouseUpdateWarehouseTransferRequest($api_key, $id, $warehouse_transfer, string $contentType = self::contentTypes['warehouseUpdateWarehouseTransfer'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling warehouseUpdateWarehouseTransfer'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling warehouseUpdateWarehouseTransfer'
            );
        }

        // verify the required parameter 'warehouse_transfer' is set
        if ($warehouse_transfer === null || (is_array($warehouse_transfer) && count($warehouse_transfer) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_transfer when calling warehouseUpdateWarehouseTransfer'
            );
        }


        $resourcePath = '/api/WarehouseTransfer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($warehouse_transfer)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($warehouse_transfer));
            } else {
                $httpBody = $warehouse_transfer;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
