<?php
/**
 * ReturnApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * ReturnApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReturnApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'returnAddReturnItem' => [
            'application/json',
            'text/json',
        ],
        'returnAllocateItemLocation' => [
            'application/json',
        ],
        'returnConfirmReturn' => [
            'application/json',
        ],
        'returnCreateReturn' => [
            'application/json',
        ],
        'returnGetReturn' => [
            'application/json',
        ],
        'returnGetReturnItems' => [
            'application/json',
        ],
        'returnGetReturnReasons' => [
            'application/json',
        ],
        'returnGetReturnsOnDate' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation returnAddReturnItem
     *
     * @param  string $api_key api_key (required)
     * @param  int $id id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI $item item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAddReturnItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function returnAddReturnItem($api_key, $id, $item, string $contentType = self::contentTypes['returnAddReturnItem'][0])
    {
        list($response) = $this->returnAddReturnItemWithHttpInfo($api_key, $id, $item, $contentType);
        return $response;
    }

    /**
     * Operation returnAddReturnItemWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI $item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAddReturnItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function returnAddReturnItemWithHttpInfo($api_key, $id, $item, string $contentType = self::contentTypes['returnAddReturnItem'][0])
    {
        $request = $this->returnAddReturnItemRequest($api_key, $id, $item, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnAddReturnItemAsync
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI $item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAddReturnItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnAddReturnItemAsync($api_key, $id, $item, string $contentType = self::contentTypes['returnAddReturnItem'][0])
    {
        return $this->returnAddReturnItemAsyncWithHttpInfo($api_key, $id, $item, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnAddReturnItemAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI $item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAddReturnItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnAddReturnItemAsyncWithHttpInfo($api_key, $id, $item, string $contentType = self::contentTypes['returnAddReturnItem'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->returnAddReturnItemRequest($api_key, $id, $item, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnAddReturnItem'
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI $item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAddReturnItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnAddReturnItemRequest($api_key, $id, $item, string $contentType = self::contentTypes['returnAddReturnItem'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnAddReturnItem'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling returnAddReturnItem'
            );
        }

        // verify the required parameter 'item' is set
        if ($item === null || (is_array($item) && count($item) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item when calling returnAddReturnItem'
            );
        }


        $resourcePath = '/api/Return/{id}/AddItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item));
            } else {
                $httpBody = $item;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnAllocateItemLocation
     *
     * @param  string $api_key api_key (required)
     * @param  int $id id (required)
     * @param  int $returnitem_id returnitem_id (required)
     * @param  int $quantity quantity (required)
     * @param  int $location_id location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAllocateItemLocation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function returnAllocateItemLocation($api_key, $id, $returnitem_id, $quantity, $location_id, string $contentType = self::contentTypes['returnAllocateItemLocation'][0])
    {
        list($response) = $this->returnAllocateItemLocationWithHttpInfo($api_key, $id, $returnitem_id, $quantity, $location_id, $contentType);
        return $response;
    }

    /**
     * Operation returnAllocateItemLocationWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  int $returnitem_id (required)
     * @param  int $quantity (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAllocateItemLocation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function returnAllocateItemLocationWithHttpInfo($api_key, $id, $returnitem_id, $quantity, $location_id, string $contentType = self::contentTypes['returnAllocateItemLocation'][0])
    {
        $request = $this->returnAllocateItemLocationRequest($api_key, $id, $returnitem_id, $quantity, $location_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnAllocateItemLocationAsync
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  int $returnitem_id (required)
     * @param  int $quantity (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAllocateItemLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnAllocateItemLocationAsync($api_key, $id, $returnitem_id, $quantity, $location_id, string $contentType = self::contentTypes['returnAllocateItemLocation'][0])
    {
        return $this->returnAllocateItemLocationAsyncWithHttpInfo($api_key, $id, $returnitem_id, $quantity, $location_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnAllocateItemLocationAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  int $returnitem_id (required)
     * @param  int $quantity (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAllocateItemLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnAllocateItemLocationAsyncWithHttpInfo($api_key, $id, $returnitem_id, $quantity, $location_id, string $contentType = self::contentTypes['returnAllocateItemLocation'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->returnAllocateItemLocationRequest($api_key, $id, $returnitem_id, $quantity, $location_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnAllocateItemLocation'
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  int $returnitem_id (required)
     * @param  int $quantity (required)
     * @param  int $location_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnAllocateItemLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnAllocateItemLocationRequest($api_key, $id, $returnitem_id, $quantity, $location_id, string $contentType = self::contentTypes['returnAllocateItemLocation'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnAllocateItemLocation'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling returnAllocateItemLocation'
            );
        }

        // verify the required parameter 'returnitem_id' is set
        if ($returnitem_id === null || (is_array($returnitem_id) && count($returnitem_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returnitem_id when calling returnAllocateItemLocation'
            );
        }

        // verify the required parameter 'quantity' is set
        if ($quantity === null || (is_array($quantity) && count($quantity) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quantity when calling returnAllocateItemLocation'
            );
        }

        // verify the required parameter 'location_id' is set
        if ($location_id === null || (is_array($location_id) && count($location_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $location_id when calling returnAllocateItemLocation'
            );
        }


        $resourcePath = '/api/Return/{id}/AllocateItemLocation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $returnitem_id,
            'ReturnitemId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $quantity,
            'Quantity', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnConfirmReturn
     *
     * @param  string $api_key api_key (required)
     * @param  int $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnConfirmReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function returnConfirmReturn($api_key, $id, string $contentType = self::contentTypes['returnConfirmReturn'][0])
    {
        list($response) = $this->returnConfirmReturnWithHttpInfo($api_key, $id, $contentType);
        return $response;
    }

    /**
     * Operation returnConfirmReturnWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnConfirmReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function returnConfirmReturnWithHttpInfo($api_key, $id, string $contentType = self::contentTypes['returnConfirmReturn'][0])
    {
        $request = $this->returnConfirmReturnRequest($api_key, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnConfirmReturnAsync
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnConfirmReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnConfirmReturnAsync($api_key, $id, string $contentType = self::contentTypes['returnConfirmReturn'][0])
    {
        return $this->returnConfirmReturnAsyncWithHttpInfo($api_key, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnConfirmReturnAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnConfirmReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnConfirmReturnAsyncWithHttpInfo($api_key, $id, string $contentType = self::contentTypes['returnConfirmReturn'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->returnConfirmReturnRequest($api_key, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnConfirmReturn'
     *
     * @param  string $api_key (required)
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnConfirmReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnConfirmReturnRequest($api_key, $id, string $contentType = self::contentTypes['returnConfirmReturn'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnConfirmReturn'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling returnConfirmReturn'
            );
        }


        $resourcePath = '/api/Return/{id}/Confirm';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnCreateReturn
     *
     * @param  string $api_key api_key (required)
     * @param  int $order_id order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnCreateReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function returnCreateReturn($api_key, $order_id, string $contentType = self::contentTypes['returnCreateReturn'][0])
    {
        list($response) = $this->returnCreateReturnWithHttpInfo($api_key, $order_id, $contentType);
        return $response;
    }

    /**
     * Operation returnCreateReturnWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnCreateReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function returnCreateReturnWithHttpInfo($api_key, $order_id, string $contentType = self::contentTypes['returnCreateReturn'][0])
    {
        $request = $this->returnCreateReturnRequest($api_key, $order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnCreateReturnAsync
     *
     * @param  string $api_key (required)
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnCreateReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnCreateReturnAsync($api_key, $order_id, string $contentType = self::contentTypes['returnCreateReturn'][0])
    {
        return $this->returnCreateReturnAsyncWithHttpInfo($api_key, $order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnCreateReturnAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnCreateReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnCreateReturnAsyncWithHttpInfo($api_key, $order_id, string $contentType = self::contentTypes['returnCreateReturn'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->returnCreateReturnRequest($api_key, $order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnCreateReturn'
     *
     * @param  string $api_key (required)
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnCreateReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnCreateReturnRequest($api_key, $order_id, string $contentType = self::contentTypes['returnCreateReturn'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnCreateReturn'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling returnCreateReturn'
            );
        }


        $resourcePath = '/api/Return/CreateReturn/{OrderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OrderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnGetReturn
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesReturnsReturn
     */
    public function returnGetReturn($id, $api_key, string $contentType = self::contentTypes['returnGetReturn'][0])
    {
        list($response) = $this->returnGetReturnWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation returnGetReturnWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturn'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesReturnsReturn, HTTP status code, HTTP response headers (array of strings)
     */
    public function returnGetReturnWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['returnGetReturn'][0])
    {
        $request = $this->returnGetReturnRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturn',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesReturnsReturn',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturn',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnGetReturnAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnAsync($id, $api_key, string $contentType = self::contentTypes['returnGetReturn'][0])
    {
        return $this->returnGetReturnAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnGetReturnAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['returnGetReturn'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesReturnsReturn';
        $request = $this->returnGetReturnRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnGetReturn'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturn'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnGetReturnRequest($id, $api_key, string $contentType = self::contentTypes['returnGetReturn'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling returnGetReturn'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnGetReturn'
            );
        }


        $resourcePath = '/api/Return/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnGetReturnItems
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]
     */
    public function returnGetReturnItems($id, $api_key, string $contentType = self::contentTypes['returnGetReturnItems'][0])
    {
        list($response) = $this->returnGetReturnItemsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation returnGetReturnItemsWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function returnGetReturnItemsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['returnGetReturnItems'][0])
    {
        $request = $this->returnGetReturnItemsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnGetReturnItemsAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnItemsAsync($id, $api_key, string $contentType = self::contentTypes['returnGetReturnItems'][0])
    {
        return $this->returnGetReturnItemsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnGetReturnItemsAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnItemsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['returnGetReturnItems'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]';
        $request = $this->returnGetReturnItemsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnGetReturnItems'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnGetReturnItemsRequest($id, $api_key, string $contentType = self::contentTypes['returnGetReturnItems'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling returnGetReturnItems'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnGetReturnItems'
            );
        }


        $resourcePath = '/api/Return/{id}/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnGetReturnReasons
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnReasons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]
     */
    public function returnGetReturnReasons($api_key, string $contentType = self::contentTypes['returnGetReturnReasons'][0])
    {
        list($response) = $this->returnGetReturnReasonsWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation returnGetReturnReasonsWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnReasons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[], HTTP status code, HTTP response headers (array of strings)
     */
    public function returnGetReturnReasonsWithHttpInfo($api_key, string $contentType = self::contentTypes['returnGetReturnReasons'][0])
    {
        $request = $this->returnGetReturnReasonsRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnGetReturnReasonsAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnReasonsAsync($api_key, string $contentType = self::contentTypes['returnGetReturnReasons'][0])
    {
        return $this->returnGetReturnReasonsAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnGetReturnReasonsAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnReasonsAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['returnGetReturnReasons'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]';
        $request = $this->returnGetReturnReasonsRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnGetReturnReasons'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnReasons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnGetReturnReasonsRequest($api_key, string $contentType = self::contentTypes['returnGetReturnReasons'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnGetReturnReasons'
            );
        }


        $resourcePath = '/api/Return/Reasons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation returnGetReturnsOnDate
     *
     * @param  string $api_key api_key (required)
     * @param  \DateTime $date date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnsOnDate'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesReturnsReturn[]
     */
    public function returnGetReturnsOnDate($api_key, $date, string $contentType = self::contentTypes['returnGetReturnsOnDate'][0])
    {
        list($response) = $this->returnGetReturnsOnDateWithHttpInfo($api_key, $date, $contentType);
        return $response;
    }

    /**
     * Operation returnGetReturnsOnDateWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  \DateTime $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnsOnDate'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesReturnsReturn[], HTTP status code, HTTP response headers (array of strings)
     */
    public function returnGetReturnsOnDateWithHttpInfo($api_key, $date, string $contentType = self::contentTypes['returnGetReturnsOnDate'][0])
    {
        $request = $this->returnGetReturnsOnDateRequest($api_key, $date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturn[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesReturnsReturn[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesReturnsReturn[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation returnGetReturnsOnDateAsync
     *
     * @param  string $api_key (required)
     * @param  \DateTime $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnsOnDate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnsOnDateAsync($api_key, $date, string $contentType = self::contentTypes['returnGetReturnsOnDate'][0])
    {
        return $this->returnGetReturnsOnDateAsyncWithHttpInfo($api_key, $date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation returnGetReturnsOnDateAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  \DateTime $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnsOnDate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function returnGetReturnsOnDateAsyncWithHttpInfo($api_key, $date, string $contentType = self::contentTypes['returnGetReturnsOnDate'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesReturnsReturn[]';
        $request = $this->returnGetReturnsOnDateRequest($api_key, $date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'returnGetReturnsOnDate'
     *
     * @param  string $api_key (required)
     * @param  \DateTime $date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['returnGetReturnsOnDate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function returnGetReturnsOnDateRequest($api_key, $date, string $contentType = self::contentTypes['returnGetReturnsOnDate'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling returnGetReturnsOnDate'
            );
        }

        // verify the required parameter 'date' is set
        if ($date === null || (is_array($date) && count($date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $date when calling returnGetReturnsOnDate'
            );
        }


        $resourcePath = '/api/Return/SearchByDate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date,
            'Date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
