<?php
/**
 * ProductApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * ProductApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'productAddAddAlt' => [
            'application/json',
        ],
        'productBulkAddCartons' => [
            'application/json',
            'text/json',
        ],
        'productBulkOnHandStockUpdate' => [
            'application/json',
            'text/json',
        ],
        'productCreateBundle' => [
            'application/json',
            'text/json',
        ],
        'productCreateProduct' => [
            'application/json',
            'text/json',
        ],
        'productCreateSupplier' => [
            'application/json',
            'text/json',
        ],
        'productDeleteCarton' => [
            'application/json',
        ],
        'productGet' => [
            'application/json',
        ],
        'productGetAltCodes' => [
            'application/json',
        ],
        'productGetBundle' => [
            'application/json',
        ],
        'productGetCartons' => [
            'application/json',
        ],
        'productGetInventory' => [
            'application/json',
        ],
        'productGetInventoryPreOrderBreakdown' => [
            'application/json',
        ],
        'productGetInventoryPreOrderBreakdownAllWarehouses' => [
            'application/json',
        ],
        'productGetProductChanges' => [
            'application/json',
        ],
        'productGetStockFlow' => [
            'application/json',
        ],
        'productGetStockFlowFiltered' => [
            'application/json',
        ],
        'productGetStockLevels' => [
            'application/json',
        ],
        'productGetStockLevelsUpdatedSince' => [
            'application/json',
        ],
        'productListProducts' => [
            'application/json',
        ],
        'productListSuppliers' => [
            'application/json',
        ],
        'productLookupProductId' => [
            'application/json',
        ],
        'productSearchBarcode' => [
            'application/json',
        ],
        'productSearchProducts' => [
            'application/json',
        ],
        'productUpdateProduct' => [
            'application/json',
            'text/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation productAddAddAlt
     *
     * Add Alt Code
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku The Alternative SKU you want to add (required)
     * @param  string $connect_mapping_type The Type e.g. Amazon, Ebay, API etc (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productAddAddAlt'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productAddAddAlt($id, $api_key, $sku, $connect_mapping_type, string $contentType = self::contentTypes['productAddAddAlt'][0])
    {
        $this->productAddAddAltWithHttpInfo($id, $api_key, $sku, $connect_mapping_type, $contentType);
    }

    /**
     * Operation productAddAddAltWithHttpInfo
     *
     * Add Alt Code
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku The Alternative SKU you want to add (required)
     * @param  string $connect_mapping_type The Type e.g. Amazon, Ebay, API etc (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productAddAddAlt'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productAddAddAltWithHttpInfo($id, $api_key, $sku, $connect_mapping_type, string $contentType = self::contentTypes['productAddAddAlt'][0])
    {
        $request = $this->productAddAddAltRequest($id, $api_key, $sku, $connect_mapping_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productAddAddAltAsync
     *
     * Add Alt Code
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku The Alternative SKU you want to add (required)
     * @param  string $connect_mapping_type The Type e.g. Amazon, Ebay, API etc (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productAddAddAlt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productAddAddAltAsync($id, $api_key, $sku, $connect_mapping_type, string $contentType = self::contentTypes['productAddAddAlt'][0])
    {
        return $this->productAddAddAltAsyncWithHttpInfo($id, $api_key, $sku, $connect_mapping_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productAddAddAltAsyncWithHttpInfo
     *
     * Add Alt Code
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku The Alternative SKU you want to add (required)
     * @param  string $connect_mapping_type The Type e.g. Amazon, Ebay, API etc (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productAddAddAlt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productAddAddAltAsyncWithHttpInfo($id, $api_key, $sku, $connect_mapping_type, string $contentType = self::contentTypes['productAddAddAlt'][0])
    {
        $returnType = '';
        $request = $this->productAddAddAltRequest($id, $api_key, $sku, $connect_mapping_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productAddAddAlt'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku The Alternative SKU you want to add (required)
     * @param  string $connect_mapping_type The Type e.g. Amazon, Ebay, API etc (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productAddAddAlt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productAddAddAltRequest($id, $api_key, $sku, $connect_mapping_type, string $contentType = self::contentTypes['productAddAddAlt'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productAddAddAlt'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productAddAddAlt'
            );
        }

        // verify the required parameter 'sku' is set
        if ($sku === null || (is_array($sku) && count($sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sku when calling productAddAddAlt'
            );
        }

        // verify the required parameter 'connect_mapping_type' is set
        if ($connect_mapping_type === null || (is_array($connect_mapping_type) && count($connect_mapping_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $connect_mapping_type when calling productAddAddAlt'
            );
        }


        $resourcePath = '/api/Product/{id}/AltCodes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'SKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $connect_mapping_type,
            'ConnectMappingType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productBulkAddCartons
     *
     * Bulk Add Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductContainer[] $cartons cartons (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkAddCartons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productBulkAddCartons($id, $api_key, $cartons, string $contentType = self::contentTypes['productBulkAddCartons'][0])
    {
        $this->productBulkAddCartonsWithHttpInfo($id, $api_key, $cartons, $contentType);
    }

    /**
     * Operation productBulkAddCartonsWithHttpInfo
     *
     * Bulk Add Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductContainer[] $cartons (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkAddCartons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productBulkAddCartonsWithHttpInfo($id, $api_key, $cartons, string $contentType = self::contentTypes['productBulkAddCartons'][0])
    {
        $request = $this->productBulkAddCartonsRequest($id, $api_key, $cartons, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productBulkAddCartonsAsync
     *
     * Bulk Add Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductContainer[] $cartons (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkAddCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productBulkAddCartonsAsync($id, $api_key, $cartons, string $contentType = self::contentTypes['productBulkAddCartons'][0])
    {
        return $this->productBulkAddCartonsAsyncWithHttpInfo($id, $api_key, $cartons, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productBulkAddCartonsAsyncWithHttpInfo
     *
     * Bulk Add Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductContainer[] $cartons (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkAddCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productBulkAddCartonsAsyncWithHttpInfo($id, $api_key, $cartons, string $contentType = self::contentTypes['productBulkAddCartons'][0])
    {
        $returnType = '';
        $request = $this->productBulkAddCartonsRequest($id, $api_key, $cartons, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productBulkAddCartons'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductContainer[] $cartons (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkAddCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productBulkAddCartonsRequest($id, $api_key, $cartons, string $contentType = self::contentTypes['productBulkAddCartons'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productBulkAddCartons'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productBulkAddCartons'
            );
        }

        // verify the required parameter 'cartons' is set
        if ($cartons === null || (is_array($cartons) && count($cartons) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cartons when calling productBulkAddCartons'
            );
        }


        $resourcePath = '/api/Product/{id}/Cartons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($cartons)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($cartons));
            } else {
                $httpBody = $cartons;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productBulkOnHandStockUpdate
     *
     * Bulk On Hand Stock Update
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] $records Update Requests (required)
     * @param  int|null $client_id Client ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkOnHandStockUpdate'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]
     */
    public function productBulkOnHandStockUpdate($api_key, $records, $client_id = null, string $contentType = self::contentTypes['productBulkOnHandStockUpdate'][0])
    {
        list($response) = $this->productBulkOnHandStockUpdateWithHttpInfo($api_key, $records, $client_id, $contentType);
        return $response;
    }

    /**
     * Operation productBulkOnHandStockUpdateWithHttpInfo
     *
     * Bulk On Hand Stock Update
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] $records Update Requests (required)
     * @param  int|null $client_id Client ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkOnHandStockUpdate'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[], HTTP status code, HTTP response headers (array of strings)
     */
    public function productBulkOnHandStockUpdateWithHttpInfo($api_key, $records, $client_id = null, string $contentType = self::contentTypes['productBulkOnHandStockUpdate'][0])
    {
        $request = $this->productBulkOnHandStockUpdateRequest($api_key, $records, $client_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation productBulkOnHandStockUpdateAsync
     *
     * Bulk On Hand Stock Update
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] $records Update Requests (required)
     * @param  int|null $client_id Client ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkOnHandStockUpdate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productBulkOnHandStockUpdateAsync($api_key, $records, $client_id = null, string $contentType = self::contentTypes['productBulkOnHandStockUpdate'][0])
    {
        return $this->productBulkOnHandStockUpdateAsyncWithHttpInfo($api_key, $records, $client_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productBulkOnHandStockUpdateAsyncWithHttpInfo
     *
     * Bulk On Hand Stock Update
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] $records Update Requests (required)
     * @param  int|null $client_id Client ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkOnHandStockUpdate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productBulkOnHandStockUpdateAsyncWithHttpInfo($api_key, $records, $client_id = null, string $contentType = self::contentTypes['productBulkOnHandStockUpdate'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]';
        $request = $this->productBulkOnHandStockUpdateRequest($api_key, $records, $client_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productBulkOnHandStockUpdate'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] $records Update Requests (required)
     * @param  int|null $client_id Client ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productBulkOnHandStockUpdate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productBulkOnHandStockUpdateRequest($api_key, $records, $client_id = null, string $contentType = self::contentTypes['productBulkOnHandStockUpdate'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productBulkOnHandStockUpdate'
            );
        }

        // verify the required parameter 'records' is set
        if ($records === null || (is_array($records) && count($records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $records when calling productBulkOnHandStockUpdate'
            );
        }



        $resourcePath = '/api/Product/BulkOnHandStockUpdate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($records)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($records));
            } else {
                $httpBody = $records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productCreateBundle
     *
     * Create New Bundle
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBundle $bundle Bundle (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateBundle'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productCreateBundle($api_key, $bundle, string $contentType = self::contentTypes['productCreateBundle'][0])
    {
        $this->productCreateBundleWithHttpInfo($api_key, $bundle, $contentType);
    }

    /**
     * Operation productCreateBundleWithHttpInfo
     *
     * Create New Bundle
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBundle $bundle Bundle (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateBundle'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productCreateBundleWithHttpInfo($api_key, $bundle, string $contentType = self::contentTypes['productCreateBundle'][0])
    {
        $request = $this->productCreateBundleRequest($api_key, $bundle, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productCreateBundleAsync
     *
     * Create New Bundle
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBundle $bundle Bundle (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateBundleAsync($api_key, $bundle, string $contentType = self::contentTypes['productCreateBundle'][0])
    {
        return $this->productCreateBundleAsyncWithHttpInfo($api_key, $bundle, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productCreateBundleAsyncWithHttpInfo
     *
     * Create New Bundle
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBundle $bundle Bundle (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateBundleAsyncWithHttpInfo($api_key, $bundle, string $contentType = self::contentTypes['productCreateBundle'][0])
    {
        $returnType = '';
        $request = $this->productCreateBundleRequest($api_key, $bundle, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productCreateBundle'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPIBundle $bundle Bundle (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productCreateBundleRequest($api_key, $bundle, string $contentType = self::contentTypes['productCreateBundle'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productCreateBundle'
            );
        }

        // verify the required parameter 'bundle' is set
        if ($bundle === null || (is_array($bundle) && count($bundle) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bundle when calling productCreateBundle'
            );
        }


        $resourcePath = '/api/Product/Bundle';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($bundle)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($bundle));
            } else {
                $httpBody = $bundle;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productCreateProduct
     *
     * Create New Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateProduct'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productCreateProduct($api_key, $product, string $contentType = self::contentTypes['productCreateProduct'][0])
    {
        $this->productCreateProductWithHttpInfo($api_key, $product, $contentType);
    }

    /**
     * Operation productCreateProductWithHttpInfo
     *
     * Create New Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateProduct'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productCreateProductWithHttpInfo($api_key, $product, string $contentType = self::contentTypes['productCreateProduct'][0])
    {
        $request = $this->productCreateProductRequest($api_key, $product, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productCreateProductAsync
     *
     * Create New Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateProductAsync($api_key, $product, string $contentType = self::contentTypes['productCreateProduct'][0])
    {
        return $this->productCreateProductAsyncWithHttpInfo($api_key, $product, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productCreateProductAsyncWithHttpInfo
     *
     * Create New Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateProductAsyncWithHttpInfo($api_key, $product, string $contentType = self::contentTypes['productCreateProduct'][0])
    {
        $returnType = '';
        $request = $this->productCreateProductRequest($api_key, $product, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productCreateProduct'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productCreateProductRequest($api_key, $product, string $contentType = self::contentTypes['productCreateProduct'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productCreateProduct'
            );
        }

        // verify the required parameter 'product' is set
        if ($product === null || (is_array($product) && count($product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product when calling productCreateProduct'
            );
        }


        $resourcePath = '/api/Product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productCreateSupplier
     *
     * Create New Product Supplier
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductSupplier $product_supplier ProductSupplier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateSupplier'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function productCreateSupplier($api_key, $product_supplier, string $contentType = self::contentTypes['productCreateSupplier'][0])
    {
        list($response) = $this->productCreateSupplierWithHttpInfo($api_key, $product_supplier, $contentType);
        return $response;
    }

    /**
     * Operation productCreateSupplierWithHttpInfo
     *
     * Create New Product Supplier
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductSupplier $product_supplier ProductSupplier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateSupplier'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function productCreateSupplierWithHttpInfo($api_key, $product_supplier, string $contentType = self::contentTypes['productCreateSupplier'][0])
    {
        $request = $this->productCreateSupplierRequest($api_key, $product_supplier, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation productCreateSupplierAsync
     *
     * Create New Product Supplier
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductSupplier $product_supplier ProductSupplier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateSupplierAsync($api_key, $product_supplier, string $contentType = self::contentTypes['productCreateSupplier'][0])
    {
        return $this->productCreateSupplierAsyncWithHttpInfo($api_key, $product_supplier, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productCreateSupplierAsyncWithHttpInfo
     *
     * Create New Product Supplier
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductSupplier $product_supplier ProductSupplier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productCreateSupplierAsyncWithHttpInfo($api_key, $product_supplier, string $contentType = self::contentTypes['productCreateSupplier'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->productCreateSupplierRequest($api_key, $product_supplier, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productCreateSupplier'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProductSupplier $product_supplier ProductSupplier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productCreateSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productCreateSupplierRequest($api_key, $product_supplier, string $contentType = self::contentTypes['productCreateSupplier'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productCreateSupplier'
            );
        }

        // verify the required parameter 'product_supplier' is set
        if ($product_supplier === null || (is_array($product_supplier) && count($product_supplier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_supplier when calling productCreateSupplier'
            );
        }


        $resourcePath = '/api/Product/Suppliers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_supplier)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_supplier));
            } else {
                $httpBody = $product_supplier;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productDeleteCarton
     *
     * Delete Carton
     *
     * @param  int $id Product ID (required)
     * @param  int $carton_id ID of Carton to delete (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productDeleteCarton'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productDeleteCarton($id, $carton_id, $api_key, string $contentType = self::contentTypes['productDeleteCarton'][0])
    {
        $this->productDeleteCartonWithHttpInfo($id, $carton_id, $api_key, $contentType);
    }

    /**
     * Operation productDeleteCartonWithHttpInfo
     *
     * Delete Carton
     *
     * @param  int $id Product ID (required)
     * @param  int $carton_id ID of Carton to delete (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productDeleteCarton'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productDeleteCartonWithHttpInfo($id, $carton_id, $api_key, string $contentType = self::contentTypes['productDeleteCarton'][0])
    {
        $request = $this->productDeleteCartonRequest($id, $carton_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productDeleteCartonAsync
     *
     * Delete Carton
     *
     * @param  int $id Product ID (required)
     * @param  int $carton_id ID of Carton to delete (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productDeleteCarton'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productDeleteCartonAsync($id, $carton_id, $api_key, string $contentType = self::contentTypes['productDeleteCarton'][0])
    {
        return $this->productDeleteCartonAsyncWithHttpInfo($id, $carton_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productDeleteCartonAsyncWithHttpInfo
     *
     * Delete Carton
     *
     * @param  int $id Product ID (required)
     * @param  int $carton_id ID of Carton to delete (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productDeleteCarton'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productDeleteCartonAsyncWithHttpInfo($id, $carton_id, $api_key, string $contentType = self::contentTypes['productDeleteCarton'][0])
    {
        $returnType = '';
        $request = $this->productDeleteCartonRequest($id, $carton_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productDeleteCarton'
     *
     * @param  int $id Product ID (required)
     * @param  int $carton_id ID of Carton to delete (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productDeleteCarton'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productDeleteCartonRequest($id, $carton_id, $api_key, string $contentType = self::contentTypes['productDeleteCarton'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productDeleteCarton'
            );
        }

        // verify the required parameter 'carton_id' is set
        if ($carton_id === null || (is_array($carton_id) && count($carton_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $carton_id when calling productDeleteCarton'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productDeleteCarton'
            );
        }


        $resourcePath = '/api/Product/{id}/Carton/{cartonId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($carton_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cartonId' . '}',
                ObjectSerializer::toPathValue($carton_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGet
     *
     * Get Product
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGet($id, $api_key, string $contentType = self::contentTypes['productGet'][0])
    {
        $this->productGetWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetWithHttpInfo
     *
     * Get Product
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGet'][0])
    {
        $request = $this->productGetRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetAsync
     *
     * Get Product
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetAsync($id, $api_key, string $contentType = self::contentTypes['productGet'][0])
    {
        return $this->productGetAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetAsyncWithHttpInfo
     *
     * Get Product
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGet'][0])
    {
        $returnType = '';
        $request = $this->productGetRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGet'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetRequest($id, $api_key, string $contentType = self::contentTypes['productGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGet'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGet'
            );
        }


        $resourcePath = '/api/Product/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetAltCodes
     *
     * Get Alt Codes
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetAltCodes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetAltCodes($id, $api_key, string $contentType = self::contentTypes['productGetAltCodes'][0])
    {
        $this->productGetAltCodesWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetAltCodesWithHttpInfo
     *
     * Get Alt Codes
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetAltCodes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetAltCodesWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetAltCodes'][0])
    {
        $request = $this->productGetAltCodesRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetAltCodesAsync
     *
     * Get Alt Codes
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetAltCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetAltCodesAsync($id, $api_key, string $contentType = self::contentTypes['productGetAltCodes'][0])
    {
        return $this->productGetAltCodesAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetAltCodesAsyncWithHttpInfo
     *
     * Get Alt Codes
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetAltCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetAltCodesAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetAltCodes'][0])
    {
        $returnType = '';
        $request = $this->productGetAltCodesRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetAltCodes'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetAltCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetAltCodesRequest($id, $api_key, string $contentType = self::contentTypes['productGetAltCodes'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetAltCodes'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetAltCodes'
            );
        }


        $resourcePath = '/api/Product/{id}/AltCodes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetBundle
     *
     * Get Bundle
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetBundle'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetBundle($id, $api_key, string $contentType = self::contentTypes['productGetBundle'][0])
    {
        $this->productGetBundleWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetBundleWithHttpInfo
     *
     * Get Bundle
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetBundle'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetBundleWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetBundle'][0])
    {
        $request = $this->productGetBundleRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetBundleAsync
     *
     * Get Bundle
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetBundleAsync($id, $api_key, string $contentType = self::contentTypes['productGetBundle'][0])
    {
        return $this->productGetBundleAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetBundleAsyncWithHttpInfo
     *
     * Get Bundle
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetBundleAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetBundle'][0])
    {
        $returnType = '';
        $request = $this->productGetBundleRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetBundle'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetBundle'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetBundleRequest($id, $api_key, string $contentType = self::contentTypes['productGetBundle'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetBundle'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetBundle'
            );
        }


        $resourcePath = '/api/Product/{id}/Bundle';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetCartons
     *
     * Get Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetCartons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetCartons($id, $api_key, string $contentType = self::contentTypes['productGetCartons'][0])
    {
        $this->productGetCartonsWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetCartonsWithHttpInfo
     *
     * Get Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetCartons'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetCartonsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetCartons'][0])
    {
        $request = $this->productGetCartonsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetCartonsAsync
     *
     * Get Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetCartonsAsync($id, $api_key, string $contentType = self::contentTypes['productGetCartons'][0])
    {
        return $this->productGetCartonsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetCartonsAsyncWithHttpInfo
     *
     * Get Cartons
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetCartonsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetCartons'][0])
    {
        $returnType = '';
        $request = $this->productGetCartonsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetCartons'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetCartons'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetCartonsRequest($id, $api_key, string $contentType = self::contentTypes['productGetCartons'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetCartons'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetCartons'
            );
        }


        $resourcePath = '/api/Product/{id}/Cartons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetInventory
     *
     * Get Inventory Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventory'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetInventory($id, $api_key, string $contentType = self::contentTypes['productGetInventory'][0])
    {
        $this->productGetInventoryWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetInventoryWithHttpInfo
     *
     * Get Inventory Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventory'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetInventoryWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetInventory'][0])
    {
        $request = $this->productGetInventoryRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetInventoryAsync
     *
     * Get Inventory Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryAsync($id, $api_key, string $contentType = self::contentTypes['productGetInventory'][0])
    {
        return $this->productGetInventoryAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetInventoryAsyncWithHttpInfo
     *
     * Get Inventory Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetInventory'][0])
    {
        $returnType = '';
        $request = $this->productGetInventoryRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetInventory'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetInventoryRequest($id, $api_key, string $contentType = self::contentTypes['productGetInventory'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetInventory'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetInventory'
            );
        }


        $resourcePath = '/api/Product/{id}/Inventory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetInventoryPreOrderBreakdown
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId
     *
     * @param  int $id Product ID (required)
     * @param  int $warehouse_id WarehouseId ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdown'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetInventoryPreOrderBreakdown($id, $warehouse_id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdown'][0])
    {
        $this->productGetInventoryPreOrderBreakdownWithHttpInfo($id, $warehouse_id, $api_key, $contentType);
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownWithHttpInfo
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId
     *
     * @param  int $id Product ID (required)
     * @param  int $warehouse_id WarehouseId ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdown'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetInventoryPreOrderBreakdownWithHttpInfo($id, $warehouse_id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdown'][0])
    {
        $request = $this->productGetInventoryPreOrderBreakdownRequest($id, $warehouse_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAsync
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId
     *
     * @param  int $id Product ID (required)
     * @param  int $warehouse_id WarehouseId ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdown'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryPreOrderBreakdownAsync($id, $warehouse_id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdown'][0])
    {
        return $this->productGetInventoryPreOrderBreakdownAsyncWithHttpInfo($id, $warehouse_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAsyncWithHttpInfo
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId
     *
     * @param  int $id Product ID (required)
     * @param  int $warehouse_id WarehouseId ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdown'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryPreOrderBreakdownAsyncWithHttpInfo($id, $warehouse_id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdown'][0])
    {
        $returnType = '';
        $request = $this->productGetInventoryPreOrderBreakdownRequest($id, $warehouse_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetInventoryPreOrderBreakdown'
     *
     * @param  int $id Product ID (required)
     * @param  int $warehouse_id WarehouseId ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdown'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetInventoryPreOrderBreakdownRequest($id, $warehouse_id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdown'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetInventoryPreOrderBreakdown'
            );
        }

        // verify the required parameter 'warehouse_id' is set
        if ($warehouse_id === null || (is_array($warehouse_id) && count($warehouse_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_id when calling productGetInventoryPreOrderBreakdown'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetInventoryPreOrderBreakdown'
            );
        }


        $resourcePath = '/api/Product/{id}/Inventory/PreOrderBreakdown';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_id,
            'WarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAllWarehouses
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetInventoryPreOrderBreakdownAllWarehouses($id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'][0])
    {
        $this->productGetInventoryPreOrderBreakdownAllWarehousesWithHttpInfo($id, $api_key, $contentType);
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAllWarehousesWithHttpInfo
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetInventoryPreOrderBreakdownAllWarehousesWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'][0])
    {
        $request = $this->productGetInventoryPreOrderBreakdownAllWarehousesRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAllWarehousesAsync
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryPreOrderBreakdownAllWarehousesAsync($id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'][0])
    {
        return $this->productGetInventoryPreOrderBreakdownAllWarehousesAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetInventoryPreOrderBreakdownAllWarehousesAsyncWithHttpInfo
     *
     * Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetInventoryPreOrderBreakdownAllWarehousesAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'][0])
    {
        $returnType = '';
        $request = $this->productGetInventoryPreOrderBreakdownAllWarehousesRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetInventoryPreOrderBreakdownAllWarehouses'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetInventoryPreOrderBreakdownAllWarehousesRequest($id, $api_key, string $contentType = self::contentTypes['productGetInventoryPreOrderBreakdownAllWarehouses'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetInventoryPreOrderBreakdownAllWarehouses'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetInventoryPreOrderBreakdownAllWarehouses'
            );
        }


        $resourcePath = '/api/Product/{id}/Inventory/PreOrderBreakdown/All';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetProductChanges
     *
     * Products Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetProductChanges'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetProductChanges($api_key, $from_date, string $contentType = self::contentTypes['productGetProductChanges'][0])
    {
        $this->productGetProductChangesWithHttpInfo($api_key, $from_date, $contentType);
    }

    /**
     * Operation productGetProductChangesWithHttpInfo
     *
     * Products Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetProductChanges'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetProductChangesWithHttpInfo($api_key, $from_date, string $contentType = self::contentTypes['productGetProductChanges'][0])
    {
        $request = $this->productGetProductChangesRequest($api_key, $from_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetProductChangesAsync
     *
     * Products Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetProductChanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetProductChangesAsync($api_key, $from_date, string $contentType = self::contentTypes['productGetProductChanges'][0])
    {
        return $this->productGetProductChangesAsyncWithHttpInfo($api_key, $from_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetProductChangesAsyncWithHttpInfo
     *
     * Products Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetProductChanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetProductChangesAsyncWithHttpInfo($api_key, $from_date, string $contentType = self::contentTypes['productGetProductChanges'][0])
    {
        $returnType = '';
        $request = $this->productGetProductChangesRequest($api_key, $from_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetProductChanges'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetProductChanges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetProductChangesRequest($api_key, $from_date, string $contentType = self::contentTypes['productGetProductChanges'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetProductChanges'
            );
        }

        // verify the required parameter 'from_date' is set
        if ($from_date === null || (is_array($from_date) && count($from_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_date when calling productGetProductChanges'
            );
        }


        $resourcePath = '/api/Product/UpdatedSince';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'FromDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetStockFlow
     *
     * Get Stock Flow Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlow'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetStockFlow($id, $api_key, $from_date, $to_date, string $contentType = self::contentTypes['productGetStockFlow'][0])
    {
        $this->productGetStockFlowWithHttpInfo($id, $api_key, $from_date, $to_date, $contentType);
    }

    /**
     * Operation productGetStockFlowWithHttpInfo
     *
     * Get Stock Flow Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlow'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetStockFlowWithHttpInfo($id, $api_key, $from_date, $to_date, string $contentType = self::contentTypes['productGetStockFlow'][0])
    {
        $request = $this->productGetStockFlowRequest($id, $api_key, $from_date, $to_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetStockFlowAsync
     *
     * Get Stock Flow Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockFlowAsync($id, $api_key, $from_date, $to_date, string $contentType = self::contentTypes['productGetStockFlow'][0])
    {
        return $this->productGetStockFlowAsyncWithHttpInfo($id, $api_key, $from_date, $to_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetStockFlowAsyncWithHttpInfo
     *
     * Get Stock Flow Records
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockFlowAsyncWithHttpInfo($id, $api_key, $from_date, $to_date, string $contentType = self::contentTypes['productGetStockFlow'][0])
    {
        $returnType = '';
        $request = $this->productGetStockFlowRequest($id, $api_key, $from_date, $to_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetStockFlow'
     *
     * @param  int $id Product ID (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetStockFlowRequest($id, $api_key, $from_date, $to_date, string $contentType = self::contentTypes['productGetStockFlow'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetStockFlow'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetStockFlow'
            );
        }

        // verify the required parameter 'from_date' is set
        if ($from_date === null || (is_array($from_date) && count($from_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_date when calling productGetStockFlow'
            );
        }

        // verify the required parameter 'to_date' is set
        if ($to_date === null || (is_array($to_date) && count($to_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_date when calling productGetStockFlow'
            );
        }


        $resourcePath = '/api/Product/{id}/StockFlow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'FromDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'ToDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetStockFlowFiltered
     *
     * Get Stock Flow Records - Filtered
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  int $id Product ID - Can be 0 if Supplying SKU (required)
     * @param  string|null $sku sku (optional)
     * @param  int|null $warehouse_id WarehouseId e.g. 3 (optional)
     * @param  string|null $types Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT (optional)
     * @param  bool|null $include_orders Include Flows that relate to Orders (optional)
     * @param  bool|null $include_returns Include Flows that relate to Returns (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlowFiltered'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetStockFlowFiltered($api_key, $from_date, $to_date, $id, $sku = null, $warehouse_id = null, $types = null, $include_orders = null, $include_returns = null, string $contentType = self::contentTypes['productGetStockFlowFiltered'][0])
    {
        $this->productGetStockFlowFilteredWithHttpInfo($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns, $contentType);
    }

    /**
     * Operation productGetStockFlowFilteredWithHttpInfo
     *
     * Get Stock Flow Records - Filtered
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  int $id Product ID - Can be 0 if Supplying SKU (required)
     * @param  string|null $sku (optional)
     * @param  int|null $warehouse_id WarehouseId e.g. 3 (optional)
     * @param  string|null $types Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT (optional)
     * @param  bool|null $include_orders Include Flows that relate to Orders (optional)
     * @param  bool|null $include_returns Include Flows that relate to Returns (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlowFiltered'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetStockFlowFilteredWithHttpInfo($api_key, $from_date, $to_date, $id, $sku = null, $warehouse_id = null, $types = null, $include_orders = null, $include_returns = null, string $contentType = self::contentTypes['productGetStockFlowFiltered'][0])
    {
        $request = $this->productGetStockFlowFilteredRequest($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetStockFlowFilteredAsync
     *
     * Get Stock Flow Records - Filtered
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  int $id Product ID - Can be 0 if Supplying SKU (required)
     * @param  string|null $sku (optional)
     * @param  int|null $warehouse_id WarehouseId e.g. 3 (optional)
     * @param  string|null $types Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT (optional)
     * @param  bool|null $include_orders Include Flows that relate to Orders (optional)
     * @param  bool|null $include_returns Include Flows that relate to Returns (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlowFiltered'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockFlowFilteredAsync($api_key, $from_date, $to_date, $id, $sku = null, $warehouse_id = null, $types = null, $include_orders = null, $include_returns = null, string $contentType = self::contentTypes['productGetStockFlowFiltered'][0])
    {
        return $this->productGetStockFlowFilteredAsyncWithHttpInfo($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetStockFlowFilteredAsyncWithHttpInfo
     *
     * Get Stock Flow Records - Filtered
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  int $id Product ID - Can be 0 if Supplying SKU (required)
     * @param  string|null $sku (optional)
     * @param  int|null $warehouse_id WarehouseId e.g. 3 (optional)
     * @param  string|null $types Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT (optional)
     * @param  bool|null $include_orders Include Flows that relate to Orders (optional)
     * @param  bool|null $include_returns Include Flows that relate to Returns (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlowFiltered'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockFlowFilteredAsyncWithHttpInfo($api_key, $from_date, $to_date, $id, $sku = null, $warehouse_id = null, $types = null, $include_orders = null, $include_returns = null, string $contentType = self::contentTypes['productGetStockFlowFiltered'][0])
    {
        $returnType = '';
        $request = $this->productGetStockFlowFilteredRequest($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetStockFlowFiltered'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date From Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  \DateTime $to_date To Date e.g. 2011-10-05T22:26:12-04:00 (required)
     * @param  int $id Product ID - Can be 0 if Supplying SKU (required)
     * @param  string|null $sku (optional)
     * @param  int|null $warehouse_id WarehouseId e.g. 3 (optional)
     * @param  string|null $types Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT (optional)
     * @param  bool|null $include_orders Include Flows that relate to Orders (optional)
     * @param  bool|null $include_returns Include Flows that relate to Returns (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockFlowFiltered'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetStockFlowFilteredRequest($api_key, $from_date, $to_date, $id, $sku = null, $warehouse_id = null, $types = null, $include_orders = null, $include_returns = null, string $contentType = self::contentTypes['productGetStockFlowFiltered'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetStockFlowFiltered'
            );
        }

        // verify the required parameter 'from_date' is set
        if ($from_date === null || (is_array($from_date) && count($from_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_date when calling productGetStockFlowFiltered'
            );
        }

        // verify the required parameter 'to_date' is set
        if ($to_date === null || (is_array($to_date) && count($to_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_date when calling productGetStockFlowFiltered'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling productGetStockFlowFiltered'
            );
        }







        $resourcePath = '/api/Product/{id}/StockFlow/Filtered';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'FromDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'ToDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'SKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_id,
            'WarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $types,
            'Types', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_orders,
            'IncludeOrders', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_returns,
            'IncludeReturns', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetStockLevels
     *
     * Get Stock Levels
     *
     * @param  int $warehouse_id WarehouseId that you want to get stock levels for e.g. 3 (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $breakdown Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc (optional)
     * @param  int|null $product_id product_id (optional)
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetStockLevels($warehouse_id, $api_key, $breakdown = null, $product_id = null, $sku = null, string $contentType = self::contentTypes['productGetStockLevels'][0])
    {
        $this->productGetStockLevelsWithHttpInfo($warehouse_id, $api_key, $breakdown, $product_id, $sku, $contentType);
    }

    /**
     * Operation productGetStockLevelsWithHttpInfo
     *
     * Get Stock Levels
     *
     * @param  int $warehouse_id WarehouseId that you want to get stock levels for e.g. 3 (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $breakdown Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc (optional)
     * @param  int|null $product_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetStockLevelsWithHttpInfo($warehouse_id, $api_key, $breakdown = null, $product_id = null, $sku = null, string $contentType = self::contentTypes['productGetStockLevels'][0])
    {
        $request = $this->productGetStockLevelsRequest($warehouse_id, $api_key, $breakdown, $product_id, $sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetStockLevelsAsync
     *
     * Get Stock Levels
     *
     * @param  int $warehouse_id WarehouseId that you want to get stock levels for e.g. 3 (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $breakdown Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc (optional)
     * @param  int|null $product_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockLevelsAsync($warehouse_id, $api_key, $breakdown = null, $product_id = null, $sku = null, string $contentType = self::contentTypes['productGetStockLevels'][0])
    {
        return $this->productGetStockLevelsAsyncWithHttpInfo($warehouse_id, $api_key, $breakdown, $product_id, $sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetStockLevelsAsyncWithHttpInfo
     *
     * Get Stock Levels
     *
     * @param  int $warehouse_id WarehouseId that you want to get stock levels for e.g. 3 (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $breakdown Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc (optional)
     * @param  int|null $product_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockLevelsAsyncWithHttpInfo($warehouse_id, $api_key, $breakdown = null, $product_id = null, $sku = null, string $contentType = self::contentTypes['productGetStockLevels'][0])
    {
        $returnType = '';
        $request = $this->productGetStockLevelsRequest($warehouse_id, $api_key, $breakdown, $product_id, $sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetStockLevels'
     *
     * @param  int $warehouse_id WarehouseId that you want to get stock levels for e.g. 3 (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $breakdown Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc (optional)
     * @param  int|null $product_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetStockLevelsRequest($warehouse_id, $api_key, $breakdown = null, $product_id = null, $sku = null, string $contentType = self::contentTypes['productGetStockLevels'][0])
    {

        // verify the required parameter 'warehouse_id' is set
        if ($warehouse_id === null || (is_array($warehouse_id) && count($warehouse_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $warehouse_id when calling productGetStockLevels'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetStockLevels'
            );
        }





        $resourcePath = '/api/Product/StockLevels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_id,
            'WarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $breakdown,
            'Breakdown', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $product_id,
            'ProductId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'SKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productGetStockLevelsUpdatedSince
     *
     * Products StockLevels Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevelsUpdatedSince'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productGetStockLevelsUpdatedSince($api_key, $from_date, string $contentType = self::contentTypes['productGetStockLevelsUpdatedSince'][0])
    {
        $this->productGetStockLevelsUpdatedSinceWithHttpInfo($api_key, $from_date, $contentType);
    }

    /**
     * Operation productGetStockLevelsUpdatedSinceWithHttpInfo
     *
     * Products StockLevels Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevelsUpdatedSince'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productGetStockLevelsUpdatedSinceWithHttpInfo($api_key, $from_date, string $contentType = self::contentTypes['productGetStockLevelsUpdatedSince'][0])
    {
        $request = $this->productGetStockLevelsUpdatedSinceRequest($api_key, $from_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productGetStockLevelsUpdatedSinceAsync
     *
     * Products StockLevels Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevelsUpdatedSince'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockLevelsUpdatedSinceAsync($api_key, $from_date, string $contentType = self::contentTypes['productGetStockLevelsUpdatedSince'][0])
    {
        return $this->productGetStockLevelsUpdatedSinceAsyncWithHttpInfo($api_key, $from_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productGetStockLevelsUpdatedSinceAsyncWithHttpInfo
     *
     * Products StockLevels Updated Since
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevelsUpdatedSince'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productGetStockLevelsUpdatedSinceAsyncWithHttpInfo($api_key, $from_date, string $contentType = self::contentTypes['productGetStockLevelsUpdatedSince'][0])
    {
        $returnType = '';
        $request = $this->productGetStockLevelsUpdatedSinceRequest($api_key, $from_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productGetStockLevelsUpdatedSince'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \DateTime $from_date The Date (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productGetStockLevelsUpdatedSince'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productGetStockLevelsUpdatedSinceRequest($api_key, $from_date, string $contentType = self::contentTypes['productGetStockLevelsUpdatedSince'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productGetStockLevelsUpdatedSince'
            );
        }

        // verify the required parameter 'from_date' is set
        if ($from_date === null || (is_array($from_date) && count($from_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_date when calling productGetStockLevelsUpdatedSince'
            );
        }


        $resourcePath = '/api/Product/StockLevels/UpdatedSince';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'FromDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productListProducts
     *
     * List Products
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  \DateTime|null $since_last_updated Products that have been updated Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListProducts'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockProduct[]
     */
    public function productListProducts($api_key, $page_no = null, $limit = null, $client_id = null, $since_last_updated = null, string $contentType = self::contentTypes['productListProducts'][0])
    {
        list($response) = $this->productListProductsWithHttpInfo($api_key, $page_no, $limit, $client_id, $since_last_updated, $contentType);
        return $response;
    }

    /**
     * Operation productListProductsWithHttpInfo
     *
     * List Products
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  \DateTime|null $since_last_updated Products that have been updated Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListProducts'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockProduct[], HTTP status code, HTTP response headers (array of strings)
     */
    public function productListProductsWithHttpInfo($api_key, $page_no = null, $limit = null, $client_id = null, $since_last_updated = null, string $contentType = self::contentTypes['productListProducts'][0])
    {
        $request = $this->productListProductsRequest($api_key, $page_no, $limit, $client_id, $since_last_updated, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockProduct[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockProduct[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockProduct[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation productListProductsAsync
     *
     * List Products
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  \DateTime|null $since_last_updated Products that have been updated Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productListProductsAsync($api_key, $page_no = null, $limit = null, $client_id = null, $since_last_updated = null, string $contentType = self::contentTypes['productListProducts'][0])
    {
        return $this->productListProductsAsyncWithHttpInfo($api_key, $page_no, $limit, $client_id, $since_last_updated, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productListProductsAsyncWithHttpInfo
     *
     * List Products
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  \DateTime|null $since_last_updated Products that have been updated Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productListProductsAsyncWithHttpInfo($api_key, $page_no = null, $limit = null, $client_id = null, $since_last_updated = null, string $contentType = self::contentTypes['productListProducts'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockProduct[]';
        $request = $this->productListProductsRequest($api_key, $page_no, $limit, $client_id, $since_last_updated, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productListProducts'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  \DateTime|null $since_last_updated Products that have been updated Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productListProductsRequest($api_key, $page_no = null, $limit = null, $client_id = null, $since_last_updated = null, string $contentType = self::contentTypes['productListProducts'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productListProducts'
            );
        }






        $resourcePath = '/api/Product/List';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_last_updated,
            'SinceLastUpdated', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productListSuppliers
     *
     * List Product Suppliers
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListSuppliers'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]
     */
    public function productListSuppliers($api_key, $client_id = null, $page_no = null, $limit = null, string $contentType = self::contentTypes['productListSuppliers'][0])
    {
        list($response) = $this->productListSuppliersWithHttpInfo($api_key, $client_id, $page_no, $limit, $contentType);
        return $response;
    }

    /**
     * Operation productListSuppliersWithHttpInfo
     *
     * List Product Suppliers
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListSuppliers'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockProductSupplier[], HTTP status code, HTTP response headers (array of strings)
     */
    public function productListSuppliersWithHttpInfo($api_key, $client_id = null, $page_no = null, $limit = null, string $contentType = self::contentTypes['productListSuppliers'][0])
    {
        $request = $this->productListSuppliersRequest($api_key, $client_id, $page_no, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation productListSuppliersAsync
     *
     * List Product Suppliers
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productListSuppliersAsync($api_key, $client_id = null, $page_no = null, $limit = null, string $contentType = self::contentTypes['productListSuppliers'][0])
    {
        return $this->productListSuppliersAsyncWithHttpInfo($api_key, $client_id, $page_no, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productListSuppliersAsyncWithHttpInfo
     *
     * List Product Suppliers
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productListSuppliersAsyncWithHttpInfo($api_key, $client_id = null, $page_no = null, $limit = null, string $contentType = self::contentTypes['productListSuppliers'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]';
        $request = $this->productListSuppliersRequest($api_key, $client_id, $page_no, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productListSuppliers'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $client_id Filter by Client Id - Admin User Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 100 - Max 100 (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productListSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productListSuppliersRequest($api_key, $client_id = null, $page_no = null, $limit = null, string $contentType = self::contentTypes['productListSuppliers'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productListSuppliers'
            );
        }





        $resourcePath = '/api/Product/Suppliers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productLookupProductId
     *
     * Lookup Product Id
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku SKU to search (required)
     * @param  string|null $connect_mapping_type Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc (optional)
     * @param  int|null $client_id Default 0 - Only needs to be supplied by Admin Users (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productLookupProductId'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productLookupProductId($api_key, $sku, $connect_mapping_type = null, $client_id = null, string $contentType = self::contentTypes['productLookupProductId'][0])
    {
        $this->productLookupProductIdWithHttpInfo($api_key, $sku, $connect_mapping_type, $client_id, $contentType);
    }

    /**
     * Operation productLookupProductIdWithHttpInfo
     *
     * Lookup Product Id
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku SKU to search (required)
     * @param  string|null $connect_mapping_type Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc (optional)
     * @param  int|null $client_id Default 0 - Only needs to be supplied by Admin Users (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productLookupProductId'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productLookupProductIdWithHttpInfo($api_key, $sku, $connect_mapping_type = null, $client_id = null, string $contentType = self::contentTypes['productLookupProductId'][0])
    {
        $request = $this->productLookupProductIdRequest($api_key, $sku, $connect_mapping_type, $client_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productLookupProductIdAsync
     *
     * Lookup Product Id
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku SKU to search (required)
     * @param  string|null $connect_mapping_type Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc (optional)
     * @param  int|null $client_id Default 0 - Only needs to be supplied by Admin Users (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productLookupProductId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productLookupProductIdAsync($api_key, $sku, $connect_mapping_type = null, $client_id = null, string $contentType = self::contentTypes['productLookupProductId'][0])
    {
        return $this->productLookupProductIdAsyncWithHttpInfo($api_key, $sku, $connect_mapping_type, $client_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productLookupProductIdAsyncWithHttpInfo
     *
     * Lookup Product Id
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku SKU to search (required)
     * @param  string|null $connect_mapping_type Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc (optional)
     * @param  int|null $client_id Default 0 - Only needs to be supplied by Admin Users (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productLookupProductId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productLookupProductIdAsyncWithHttpInfo($api_key, $sku, $connect_mapping_type = null, $client_id = null, string $contentType = self::contentTypes['productLookupProductId'][0])
    {
        $returnType = '';
        $request = $this->productLookupProductIdRequest($api_key, $sku, $connect_mapping_type, $client_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productLookupProductId'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $sku SKU to search (required)
     * @param  string|null $connect_mapping_type Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc (optional)
     * @param  int|null $client_id Default 0 - Only needs to be supplied by Admin Users (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productLookupProductId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productLookupProductIdRequest($api_key, $sku, $connect_mapping_type = null, $client_id = null, string $contentType = self::contentTypes['productLookupProductId'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productLookupProductId'
            );
        }

        // verify the required parameter 'sku' is set
        if ($sku === null || (is_array($sku) && count($sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sku when calling productLookupProductId'
            );
        }




        $resourcePath = '/api/Product/LookupProductId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'SKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $connect_mapping_type,
            'ConnectMappingType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productSearchBarcode
     *
     * Search Product Barcode
     *
     * @param  string $barcode Product Barcode can be SKU, EAN, UPC based (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchBarcode'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productSearchBarcode($barcode, $api_key, string $contentType = self::contentTypes['productSearchBarcode'][0])
    {
        $this->productSearchBarcodeWithHttpInfo($barcode, $api_key, $contentType);
    }

    /**
     * Operation productSearchBarcodeWithHttpInfo
     *
     * Search Product Barcode
     *
     * @param  string $barcode Product Barcode can be SKU, EAN, UPC based (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchBarcode'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productSearchBarcodeWithHttpInfo($barcode, $api_key, string $contentType = self::contentTypes['productSearchBarcode'][0])
    {
        $request = $this->productSearchBarcodeRequest($barcode, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productSearchBarcodeAsync
     *
     * Search Product Barcode
     *
     * @param  string $barcode Product Barcode can be SKU, EAN, UPC based (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productSearchBarcodeAsync($barcode, $api_key, string $contentType = self::contentTypes['productSearchBarcode'][0])
    {
        return $this->productSearchBarcodeAsyncWithHttpInfo($barcode, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productSearchBarcodeAsyncWithHttpInfo
     *
     * Search Product Barcode
     *
     * @param  string $barcode Product Barcode can be SKU, EAN, UPC based (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productSearchBarcodeAsyncWithHttpInfo($barcode, $api_key, string $contentType = self::contentTypes['productSearchBarcode'][0])
    {
        $returnType = '';
        $request = $this->productSearchBarcodeRequest($barcode, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productSearchBarcode'
     *
     * @param  string $barcode Product Barcode can be SKU, EAN, UPC based (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchBarcode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productSearchBarcodeRequest($barcode, $api_key, string $contentType = self::contentTypes['productSearchBarcode'][0])
    {

        // verify the required parameter 'barcode' is set
        if ($barcode === null || (is_array($barcode) && count($barcode) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $barcode when calling productSearchBarcode'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productSearchBarcode'
            );
        }


        $resourcePath = '/api/Product/SearchBarcode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $barcode,
            'Barcode', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productSearchProducts
     *
     * Product Search by SKU/Name
     *
     * @param  string $search Text to Search (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $include_bundles Include Bundles in the search (optional)
     * @param  bool|null $include_discontinued Include products that have been discontinued in the search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchProducts'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productSearchProducts($search, $api_key, $include_bundles = null, $include_discontinued = null, string $contentType = self::contentTypes['productSearchProducts'][0])
    {
        $this->productSearchProductsWithHttpInfo($search, $api_key, $include_bundles, $include_discontinued, $contentType);
    }

    /**
     * Operation productSearchProductsWithHttpInfo
     *
     * Product Search by SKU/Name
     *
     * @param  string $search Text to Search (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $include_bundles Include Bundles in the search (optional)
     * @param  bool|null $include_discontinued Include products that have been discontinued in the search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchProducts'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productSearchProductsWithHttpInfo($search, $api_key, $include_bundles = null, $include_discontinued = null, string $contentType = self::contentTypes['productSearchProducts'][0])
    {
        $request = $this->productSearchProductsRequest($search, $api_key, $include_bundles, $include_discontinued, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productSearchProductsAsync
     *
     * Product Search by SKU/Name
     *
     * @param  string $search Text to Search (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $include_bundles Include Bundles in the search (optional)
     * @param  bool|null $include_discontinued Include products that have been discontinued in the search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productSearchProductsAsync($search, $api_key, $include_bundles = null, $include_discontinued = null, string $contentType = self::contentTypes['productSearchProducts'][0])
    {
        return $this->productSearchProductsAsyncWithHttpInfo($search, $api_key, $include_bundles, $include_discontinued, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productSearchProductsAsyncWithHttpInfo
     *
     * Product Search by SKU/Name
     *
     * @param  string $search Text to Search (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $include_bundles Include Bundles in the search (optional)
     * @param  bool|null $include_discontinued Include products that have been discontinued in the search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productSearchProductsAsyncWithHttpInfo($search, $api_key, $include_bundles = null, $include_discontinued = null, string $contentType = self::contentTypes['productSearchProducts'][0])
    {
        $returnType = '';
        $request = $this->productSearchProductsRequest($search, $api_key, $include_bundles, $include_discontinued, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productSearchProducts'
     *
     * @param  string $search Text to Search (required)
     * @param  string $api_key API Auth Key (required)
     * @param  bool|null $include_bundles Include Bundles in the search (optional)
     * @param  bool|null $include_discontinued Include products that have been discontinued in the search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productSearchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productSearchProductsRequest($search, $api_key, $include_bundles = null, $include_discontinued = null, string $contentType = self::contentTypes['productSearchProducts'][0])
    {

        // verify the required parameter 'search' is set
        if ($search === null || (is_array($search) && count($search) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $search when calling productSearchProducts'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productSearchProducts'
            );
        }




        $resourcePath = '/api/Product/Search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'Search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_bundles,
            'IncludeBundles', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_discontinued,
            'IncludeDiscontinued', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation productUpdateProduct
     *
     * Update Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productUpdateProduct'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function productUpdateProduct($api_key, $product, string $contentType = self::contentTypes['productUpdateProduct'][0])
    {
        $this->productUpdateProductWithHttpInfo($api_key, $product, $contentType);
    }

    /**
     * Operation productUpdateProductWithHttpInfo
     *
     * Update Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productUpdateProduct'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function productUpdateProductWithHttpInfo($api_key, $product, string $contentType = self::contentTypes['productUpdateProduct'][0])
    {
        $request = $this->productUpdateProductRequest($api_key, $product, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation productUpdateProductAsync
     *
     * Update Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productUpdateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productUpdateProductAsync($api_key, $product, string $contentType = self::contentTypes['productUpdateProduct'][0])
    {
        return $this->productUpdateProductAsyncWithHttpInfo($api_key, $product, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation productUpdateProductAsyncWithHttpInfo
     *
     * Update Product
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productUpdateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function productUpdateProductAsyncWithHttpInfo($api_key, $product, string $contentType = self::contentTypes['productUpdateProduct'][0])
    {
        $returnType = '';
        $request = $this->productUpdateProductRequest($api_key, $product, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'productUpdateProduct'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockProduct $product Product (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['productUpdateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function productUpdateProductRequest($api_key, $product, string $contentType = self::contentTypes['productUpdateProduct'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling productUpdateProduct'
            );
        }

        // verify the required parameter 'product' is set
        if ($product === null || (is_array($product) && count($product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product when calling productUpdateProduct'
            );
        }


        $resourcePath = '/api/Product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product));
            } else {
                $httpBody = $product;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
