<?php
/**
 * OrderApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * OrderApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'orderAddOrderComment' => [
            'application/json',
            'text/json',
        ],
        'orderAddOrderItem' => [
            'application/json',
            'text/json',
        ],
        'orderAddOrderTag' => [
            'application/json',
        ],
        'orderAllocations' => [
            'application/json',
        ],
        'orderBarcodeVerifiedOrderItems' => [
            'application/json',
        ],
        'orderBillingAddress' => [
            'application/json',
        ],
        'orderCancelOrder' => [
            'application/json',
        ],
        'orderCancelShipment' => [
            'application/json',
        ],
        'orderComments' => [
            'application/json',
        ],
        'orderCreateOrder' => [
            'application/json',
            'text/json',
        ],
        'orderCreateShipment' => [
            'application/json',
        ],
        'orderDeleteOrderItem' => [
            'application/json',
        ],
        'orderDeleteOrderShipment' => [
            'application/json',
        ],
        'orderDeleteOrderTag' => [
            'application/json',
        ],
        'orderDespatchNote' => [
            'application/json',
        ],
        'orderDocuments' => [
            'application/json',
        ],
        'orderGet' => [
            'application/json',
        ],
        'orderGetChannels' => [
            'application/json',
        ],
        'orderGetConnectAction' => [
            'application/json',
        ],
        'orderGetDocument' => [
            'application/json',
        ],
        'orderGetDocumentData' => [
            'application/json',
        ],
        'orderGetOrderDocumentPaperSizes' => [
            'application/json',
        ],
        'orderGetOrderDocumentTypes' => [
            'application/json',
        ],
        'orderGetOrderShipment' => [
            'application/json',
        ],
        'orderGetOrderShipmentTrackingEventsStatuses' => [
            'application/json',
        ],
        'orderGetOrderStatuses' => [
            'application/json',
        ],
        'orderItems' => [
            'application/json',
        ],
        'orderListOrders' => [
            'application/json',
        ],
        'orderListTrackingEvents' => [
            'application/json',
        ],
        'orderMarkAwaitingConfirmation' => [
            'application/json',
        ],
        'orderMarkAwaitingPayment' => [
            'application/json',
        ],
        'orderMarkConfirmed' => [
            'application/json',
        ],
        'orderMarkDespatched' => [
            'application/json',
        ],
        'orderMarkDocumentAsPrinted' => [
            'application/json',
        ],
        'orderMarkFraudRisk' => [
            'application/json',
        ],
        'orderMarkFraudRiskAccepted' => [
            'application/json',
        ],
        'orderMarkPackAndHold' => [
            'application/json',
        ],
        'orderMarkPaymentReceived' => [
            'application/json',
        ],
        'orderMarkPrinted' => [
            'application/json',
        ],
        'orderMarkReleasePackAndHold' => [
            'application/json',
        ],
        'orderOrderSplit' => [
            'application/json',
        ],
        'orderQueries' => [
            'application/json',
        ],
        'orderQueryComments' => [
            'application/json',
        ],
        'orderSearchOrder' => [
            'application/json',
        ],
        'orderSplitOrderItems' => [
            'application/json',
            'text/json',
        ],
        'orderUpdateNumberOfParcels' => [
            'application/json',
        ],
        'orderUpdateOrder' => [
            'application/json',
            'text/json',
        ],
        'orderUpdateOrderItem' => [
            'application/json',
            'text/json',
        ],
        'orderUploadConnectAction' => [
            'application/json',
            'text/json',
        ],
        'orderUploadOrderDocument' => [
            'application/json',
            'text/json',
        ],
        'orderUploadOrderShipment' => [
            'application/json',
            'text/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation orderAddOrderComment
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment $comment comment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderComment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderAddOrderComment($id, $api_key, $comment, string $contentType = self::contentTypes['orderAddOrderComment'][0])
    {
        list($response) = $this->orderAddOrderCommentWithHttpInfo($id, $api_key, $comment, $contentType);
        return $response;
    }

    /**
     * Operation orderAddOrderCommentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment $comment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderComment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderAddOrderCommentWithHttpInfo($id, $api_key, $comment, string $contentType = self::contentTypes['orderAddOrderComment'][0])
    {
        $request = $this->orderAddOrderCommentRequest($id, $api_key, $comment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderAddOrderCommentAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment $comment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderCommentAsync($id, $api_key, $comment, string $contentType = self::contentTypes['orderAddOrderComment'][0])
    {
        return $this->orderAddOrderCommentAsyncWithHttpInfo($id, $api_key, $comment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderAddOrderCommentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment $comment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderCommentAsyncWithHttpInfo($id, $api_key, $comment, string $contentType = self::contentTypes['orderAddOrderComment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderAddOrderCommentRequest($id, $api_key, $comment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderAddOrderComment'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment $comment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderAddOrderCommentRequest($id, $api_key, $comment, string $contentType = self::contentTypes['orderAddOrderComment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderAddOrderComment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderAddOrderComment'
            );
        }

        // verify the required parameter 'comment' is set
        if ($comment === null || (is_array($comment) && count($comment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $comment when calling orderAddOrderComment'
            );
        }


        $resourcePath = '/api/Order/{id}/Comments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($comment)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($comment));
            } else {
                $httpBody = $comment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderAddOrderItem
     *
     * Add new item to the existing order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderAddOrderItem($id, $api_key, $order_item, string $contentType = self::contentTypes['orderAddOrderItem'][0])
    {
        list($response) = $this->orderAddOrderItemWithHttpInfo($id, $api_key, $order_item, $contentType);
        return $response;
    }

    /**
     * Operation orderAddOrderItemWithHttpInfo
     *
     * Add new item to the existing order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderAddOrderItemWithHttpInfo($id, $api_key, $order_item, string $contentType = self::contentTypes['orderAddOrderItem'][0])
    {
        $request = $this->orderAddOrderItemRequest($id, $api_key, $order_item, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderAddOrderItemAsync
     *
     * Add new item to the existing order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderItemAsync($id, $api_key, $order_item, string $contentType = self::contentTypes['orderAddOrderItem'][0])
    {
        return $this->orderAddOrderItemAsyncWithHttpInfo($id, $api_key, $order_item, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderAddOrderItemAsyncWithHttpInfo
     *
     * Add new item to the existing order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderItemAsyncWithHttpInfo($id, $api_key, $order_item, string $contentType = self::contentTypes['orderAddOrderItem'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderAddOrderItemRequest($id, $api_key, $order_item, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderAddOrderItem'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderAddOrderItemRequest($id, $api_key, $order_item, string $contentType = self::contentTypes['orderAddOrderItem'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderAddOrderItem'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderAddOrderItem'
            );
        }

        // verify the required parameter 'order_item' is set
        if ($order_item === null || (is_array($order_item) && count($order_item) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_item when calling orderAddOrderItem'
            );
        }


        $resourcePath = '/api/Order/{id}/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_item)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_item));
            } else {
                $httpBody = $order_item;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderAddOrderTag
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $tag tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderTag'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderAddOrderTag($id, $api_key, $tag, string $contentType = self::contentTypes['orderAddOrderTag'][0])
    {
        list($response) = $this->orderAddOrderTagWithHttpInfo($id, $api_key, $tag, $contentType);
        return $response;
    }

    /**
     * Operation orderAddOrderTagWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderTag'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderAddOrderTagWithHttpInfo($id, $api_key, $tag, string $contentType = self::contentTypes['orderAddOrderTag'][0])
    {
        $request = $this->orderAddOrderTagRequest($id, $api_key, $tag, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderAddOrderTagAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderTagAsync($id, $api_key, $tag, string $contentType = self::contentTypes['orderAddOrderTag'][0])
    {
        return $this->orderAddOrderTagAsyncWithHttpInfo($id, $api_key, $tag, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderAddOrderTagAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAddOrderTagAsyncWithHttpInfo($id, $api_key, $tag, string $contentType = self::contentTypes['orderAddOrderTag'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderAddOrderTagRequest($id, $api_key, $tag, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderAddOrderTag'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAddOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderAddOrderTagRequest($id, $api_key, $tag, string $contentType = self::contentTypes['orderAddOrderTag'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderAddOrderTag'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderAddOrderTag'
            );
        }

        // verify the required parameter 'tag' is set
        if ($tag === null || (is_array($tag) && count($tag) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag when calling orderAddOrderTag'
            );
        }


        $resourcePath = '/api/Order/{id}/Tag';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tag,
            'Tag', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderAllocations
     *
     * Order Allocations
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAllocations'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]
     */
    public function orderAllocations($id, $api_key, string $contentType = self::contentTypes['orderAllocations'][0])
    {
        list($response) = $this->orderAllocationsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderAllocationsWithHttpInfo
     *
     * Order Allocations
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAllocations'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderAllocationsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderAllocations'][0])
    {
        $request = $this->orderAllocationsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderAllocationsAsync
     *
     * Order Allocations
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAllocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAllocationsAsync($id, $api_key, string $contentType = self::contentTypes['orderAllocations'][0])
    {
        return $this->orderAllocationsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderAllocationsAsyncWithHttpInfo
     *
     * Order Allocations
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAllocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderAllocationsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderAllocations'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]';
        $request = $this->orderAllocationsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderAllocations'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderAllocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderAllocationsRequest($id, $api_key, string $contentType = self::contentTypes['orderAllocations'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderAllocations'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderAllocations'
            );
        }


        $resourcePath = '/api/Order/{id}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderBarcodeVerifiedOrderItems
     *
     * Order Barcode Verifications
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBarcodeVerifiedOrderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]
     */
    public function orderBarcodeVerifiedOrderItems($id, $api_key, string $contentType = self::contentTypes['orderBarcodeVerifiedOrderItems'][0])
    {
        list($response) = $this->orderBarcodeVerifiedOrderItemsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderBarcodeVerifiedOrderItemsWithHttpInfo
     *
     * Order Barcode Verifications
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBarcodeVerifiedOrderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderBarcodeVerifiedOrderItemsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderBarcodeVerifiedOrderItems'][0])
    {
        $request = $this->orderBarcodeVerifiedOrderItemsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderBarcodeVerifiedOrderItemsAsync
     *
     * Order Barcode Verifications
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBarcodeVerifiedOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderBarcodeVerifiedOrderItemsAsync($id, $api_key, string $contentType = self::contentTypes['orderBarcodeVerifiedOrderItems'][0])
    {
        return $this->orderBarcodeVerifiedOrderItemsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderBarcodeVerifiedOrderItemsAsyncWithHttpInfo
     *
     * Order Barcode Verifications
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBarcodeVerifiedOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderBarcodeVerifiedOrderItemsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderBarcodeVerifiedOrderItems'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]';
        $request = $this->orderBarcodeVerifiedOrderItemsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderBarcodeVerifiedOrderItems'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBarcodeVerifiedOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderBarcodeVerifiedOrderItemsRequest($id, $api_key, string $contentType = self::contentTypes['orderBarcodeVerifiedOrderItems'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderBarcodeVerifiedOrderItems'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderBarcodeVerifiedOrderItems'
            );
        }


        $resourcePath = '/api/Order/{id}/BarcodeVerifiedOrderItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderBillingAddress
     *
     * Get Billing Address for Order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBillingAddress'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersAddress
     */
    public function orderBillingAddress($id, $api_key, string $contentType = self::contentTypes['orderBillingAddress'][0])
    {
        list($response) = $this->orderBillingAddressWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderBillingAddressWithHttpInfo
     *
     * Get Billing Address for Order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBillingAddress'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderBillingAddressWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderBillingAddress'][0])
    {
        $request = $this->orderBillingAddressRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersAddress',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderBillingAddressAsync
     *
     * Get Billing Address for Order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBillingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderBillingAddressAsync($id, $api_key, string $contentType = self::contentTypes['orderBillingAddress'][0])
    {
        return $this->orderBillingAddressAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderBillingAddressAsyncWithHttpInfo
     *
     * Get Billing Address for Order
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBillingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderBillingAddressAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderBillingAddress'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersAddress';
        $request = $this->orderBillingAddressRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderBillingAddress'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderBillingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderBillingAddressRequest($id, $api_key, string $contentType = self::contentTypes['orderBillingAddress'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderBillingAddress'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderBillingAddress'
            );
        }


        $resourcePath = '/api/Order/{id}/BillingAddress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCancelOrder
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderCancelOrder($id, $api_key, string $contentType = self::contentTypes['orderCancelOrder'][0])
    {
        list($response) = $this->orderCancelOrderWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderCancelOrderWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCancelOrderWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderCancelOrder'][0])
    {
        $request = $this->orderCancelOrderRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCancelOrderAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCancelOrderAsync($id, $api_key, string $contentType = self::contentTypes['orderCancelOrder'][0])
    {
        return $this->orderCancelOrderAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCancelOrderAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCancelOrderAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderCancelOrder'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderCancelOrderRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCancelOrder'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCancelOrderRequest($id, $api_key, string $contentType = self::contentTypes['orderCancelOrder'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderCancelOrder'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderCancelOrder'
            );
        }


        $resourcePath = '/api/Order/{id}/Cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCancelShipment
     *
     * Cancel Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderCancelShipment($id, $api_key, string $contentType = self::contentTypes['orderCancelShipment'][0])
    {
        list($response) = $this->orderCancelShipmentWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderCancelShipmentWithHttpInfo
     *
     * Cancel Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCancelShipmentWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderCancelShipment'][0])
    {
        $request = $this->orderCancelShipmentRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCancelShipmentAsync
     *
     * Cancel Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCancelShipmentAsync($id, $api_key, string $contentType = self::contentTypes['orderCancelShipment'][0])
    {
        return $this->orderCancelShipmentAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCancelShipmentAsyncWithHttpInfo
     *
     * Cancel Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCancelShipmentAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderCancelShipment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderCancelShipmentRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCancelShipment'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCancelShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCancelShipmentRequest($id, $api_key, string $contentType = self::contentTypes['orderCancelShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderCancelShipment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderCancelShipment'
            );
        }


        $resourcePath = '/api/Order/{id}/Shipments/CancelShipment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderComments
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderComments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]
     */
    public function orderComments($id, $api_key, string $contentType = self::contentTypes['orderComments'][0])
    {
        list($response) = $this->orderCommentsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderCommentsWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderComments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCommentsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderComments'][0])
    {
        $request = $this->orderCommentsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCommentsAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCommentsAsync($id, $api_key, string $contentType = self::contentTypes['orderComments'][0])
    {
        return $this->orderCommentsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCommentsAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCommentsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderComments'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]';
        $request = $this->orderCommentsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderComments'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCommentsRequest($id, $api_key, string $contentType = self::contentTypes['orderComments'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderComments'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderComments'
            );
        }


        $resourcePath = '/api/Order/{id}/Comments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCreateOrder
     *
     * Create a New Order
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems $order order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]
     */
    public function orderCreateOrder($api_key, $order, string $contentType = self::contentTypes['orderCreateOrder'][0])
    {
        list($response) = $this->orderCreateOrderWithHttpInfo($api_key, $order, $contentType);
        return $response;
    }

    /**
     * Operation orderCreateOrderWithHttpInfo
     *
     * Create a New Order
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCreateOrderWithHttpInfo($api_key, $order, string $contentType = self::contentTypes['orderCreateOrder'][0])
    {
        $request = $this->orderCreateOrderRequest($api_key, $order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCreateOrderAsync
     *
     * Create a New Order
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCreateOrderAsync($api_key, $order, string $contentType = self::contentTypes['orderCreateOrder'][0])
    {
        return $this->orderCreateOrderAsyncWithHttpInfo($api_key, $order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCreateOrderAsyncWithHttpInfo
     *
     * Create a New Order
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCreateOrderAsyncWithHttpInfo($api_key, $order, string $contentType = self::contentTypes['orderCreateOrder'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]';
        $request = $this->orderCreateOrderRequest($api_key, $order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCreateOrder'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCreateOrderRequest($api_key, $order, string $contentType = self::contentTypes['orderCreateOrder'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderCreateOrder'
            );
        }

        // verify the required parameter 'order' is set
        if ($order === null || (is_array($order) && count($order) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order when calling orderCreateOrder'
            );
        }


        $resourcePath = '/api/Order';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order));
            } else {
                $httpBody = $order;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderCreateShipment
     *
     * Create Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $courier_service_id Optional - CourierServiceId if you want to update CourierService before creating a shipment (optional)
     * @param  int|null $number_of_parcels Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesShippingShipmentResult
     */
    public function orderCreateShipment($id, $api_key, $courier_service_id = null, $number_of_parcels = null, string $contentType = self::contentTypes['orderCreateShipment'][0])
    {
        list($response) = $this->orderCreateShipmentWithHttpInfo($id, $api_key, $courier_service_id, $number_of_parcels, $contentType);
        return $response;
    }

    /**
     * Operation orderCreateShipmentWithHttpInfo
     *
     * Create Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $courier_service_id Optional - CourierServiceId if you want to update CourierService before creating a shipment (optional)
     * @param  int|null $number_of_parcels Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesShippingShipmentResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderCreateShipmentWithHttpInfo($id, $api_key, $courier_service_id = null, $number_of_parcels = null, string $contentType = self::contentTypes['orderCreateShipment'][0])
    {
        $request = $this->orderCreateShipmentRequest($id, $api_key, $courier_service_id, $number_of_parcels, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesShippingShipmentResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesShippingShipmentResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesShippingShipmentResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderCreateShipmentAsync
     *
     * Create Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $courier_service_id Optional - CourierServiceId if you want to update CourierService before creating a shipment (optional)
     * @param  int|null $number_of_parcels Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCreateShipmentAsync($id, $api_key, $courier_service_id = null, $number_of_parcels = null, string $contentType = self::contentTypes['orderCreateShipment'][0])
    {
        return $this->orderCreateShipmentAsyncWithHttpInfo($id, $api_key, $courier_service_id, $number_of_parcels, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderCreateShipmentAsyncWithHttpInfo
     *
     * Create Shipment - using Courier API Connection
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $courier_service_id Optional - CourierServiceId if you want to update CourierService before creating a shipment (optional)
     * @param  int|null $number_of_parcels Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderCreateShipmentAsyncWithHttpInfo($id, $api_key, $courier_service_id = null, $number_of_parcels = null, string $contentType = self::contentTypes['orderCreateShipment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesShippingShipmentResult';
        $request = $this->orderCreateShipmentRequest($id, $api_key, $courier_service_id, $number_of_parcels, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderCreateShipment'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $courier_service_id Optional - CourierServiceId if you want to update CourierService before creating a shipment (optional)
     * @param  int|null $number_of_parcels Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderCreateShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderCreateShipmentRequest($id, $api_key, $courier_service_id = null, $number_of_parcels = null, string $contentType = self::contentTypes['orderCreateShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderCreateShipment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderCreateShipment'
            );
        }




        $resourcePath = '/api/Order/{id}/Shipments/CreateShipment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $courier_service_id,
            'CourierServiceId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $number_of_parcels,
            'NumberOfParcels', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderDeleteOrderItem
     *
     * Delete Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderDeleteOrderItem($id, $item_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderItem'][0])
    {
        list($response) = $this->orderDeleteOrderItemWithHttpInfo($id, $item_id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderDeleteOrderItemWithHttpInfo
     *
     * Delete Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderDeleteOrderItemWithHttpInfo($id, $item_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderItem'][0])
    {
        $request = $this->orderDeleteOrderItemRequest($id, $item_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderDeleteOrderItemAsync
     *
     * Delete Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderItemAsync($id, $item_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderItem'][0])
    {
        return $this->orderDeleteOrderItemAsyncWithHttpInfo($id, $item_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderDeleteOrderItemAsyncWithHttpInfo
     *
     * Delete Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderItemAsyncWithHttpInfo($id, $item_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderItem'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderDeleteOrderItemRequest($id, $item_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderDeleteOrderItem'
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderDeleteOrderItemRequest($id, $item_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderItem'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderDeleteOrderItem'
            );
        }

        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling orderDeleteOrderItem'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderDeleteOrderItem'
            );
        }


        $resourcePath = '/api/Order/{id}/Items/{ItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemId' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderDeleteOrderShipment
     *
     * @param  int $id id (required)
     * @param  int $order_shipment_id order_shipment_id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderDeleteOrderShipment($id, $order_shipment_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderShipment'][0])
    {
        list($response) = $this->orderDeleteOrderShipmentWithHttpInfo($id, $order_shipment_id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderDeleteOrderShipmentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $order_shipment_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderDeleteOrderShipmentWithHttpInfo($id, $order_shipment_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderShipment'][0])
    {
        $request = $this->orderDeleteOrderShipmentRequest($id, $order_shipment_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderDeleteOrderShipmentAsync
     *
     * @param  int $id (required)
     * @param  int $order_shipment_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderShipmentAsync($id, $order_shipment_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderShipment'][0])
    {
        return $this->orderDeleteOrderShipmentAsyncWithHttpInfo($id, $order_shipment_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderDeleteOrderShipmentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $order_shipment_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderShipmentAsyncWithHttpInfo($id, $order_shipment_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderShipment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderDeleteOrderShipmentRequest($id, $order_shipment_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderDeleteOrderShipment'
     *
     * @param  int $id (required)
     * @param  int $order_shipment_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderDeleteOrderShipmentRequest($id, $order_shipment_id, $api_key, string $contentType = self::contentTypes['orderDeleteOrderShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderDeleteOrderShipment'
            );
        }

        // verify the required parameter 'order_shipment_id' is set
        if ($order_shipment_id === null || (is_array($order_shipment_id) && count($order_shipment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_shipment_id when calling orderDeleteOrderShipment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderDeleteOrderShipment'
            );
        }


        $resourcePath = '/api/Order/{id}/Shipments/{OrderShipmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($order_shipment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OrderShipmentId' . '}',
                ObjectSerializer::toPathValue($order_shipment_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderDeleteOrderTag
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $tag tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderTag'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderDeleteOrderTag($id, $api_key, $tag, string $contentType = self::contentTypes['orderDeleteOrderTag'][0])
    {
        list($response) = $this->orderDeleteOrderTagWithHttpInfo($id, $api_key, $tag, $contentType);
        return $response;
    }

    /**
     * Operation orderDeleteOrderTagWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderTag'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderDeleteOrderTagWithHttpInfo($id, $api_key, $tag, string $contentType = self::contentTypes['orderDeleteOrderTag'][0])
    {
        $request = $this->orderDeleteOrderTagRequest($id, $api_key, $tag, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderDeleteOrderTagAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderTagAsync($id, $api_key, $tag, string $contentType = self::contentTypes['orderDeleteOrderTag'][0])
    {
        return $this->orderDeleteOrderTagAsyncWithHttpInfo($id, $api_key, $tag, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderDeleteOrderTagAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDeleteOrderTagAsyncWithHttpInfo($id, $api_key, $tag, string $contentType = self::contentTypes['orderDeleteOrderTag'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderDeleteOrderTagRequest($id, $api_key, $tag, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderDeleteOrderTag'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $tag (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDeleteOrderTag'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderDeleteOrderTagRequest($id, $api_key, $tag, string $contentType = self::contentTypes['orderDeleteOrderTag'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderDeleteOrderTag'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderDeleteOrderTag'
            );
        }

        // verify the required parameter 'tag' is set
        if ($tag === null || (is_array($tag) && count($tag) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag when calling orderDeleteOrderTag'
            );
        }


        $resourcePath = '/api/Order/{id}/Tag';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tag,
            'Tag', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderDespatchNote
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDespatchNote'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function orderDespatchNote($id, $api_key, string $contentType = self::contentTypes['orderDespatchNote'][0])
    {
        list($response) = $this->orderDespatchNoteWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderDespatchNoteWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDespatchNote'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderDespatchNoteWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderDespatchNote'][0])
    {
        $request = $this->orderDespatchNoteRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderDespatchNoteAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDespatchNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDespatchNoteAsync($id, $api_key, string $contentType = self::contentTypes['orderDespatchNote'][0])
    {
        return $this->orderDespatchNoteAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderDespatchNoteAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDespatchNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDespatchNoteAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderDespatchNote'][0])
    {
        $returnType = 'string';
        $request = $this->orderDespatchNoteRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderDespatchNote'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDespatchNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderDespatchNoteRequest($id, $api_key, string $contentType = self::contentTypes['orderDespatchNote'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderDespatchNote'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderDespatchNote'
            );
        }


        $resourcePath = '/api/Order/{id}/DespatchNote';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderDocuments
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDocuments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]
     */
    public function orderDocuments($id, $api_key, string $contentType = self::contentTypes['orderDocuments'][0])
    {
        list($response) = $this->orderDocumentsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderDocumentsWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDocuments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderDocumentsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderDocuments'][0])
    {
        $request = $this->orderDocumentsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderDocumentsAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDocumentsAsync($id, $api_key, string $contentType = self::contentTypes['orderDocuments'][0])
    {
        return $this->orderDocumentsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderDocumentsAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderDocumentsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderDocuments'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]';
        $request = $this->orderDocumentsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderDocuments'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderDocumentsRequest($id, $api_key, string $contentType = self::contentTypes['orderDocuments'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderDocuments'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderDocuments'
            );
        }


        $resourcePath = '/api/Order/{id}/Documents';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGet
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrder
     */
    public function orderGet($id, $api_key, string $contentType = self::contentTypes['orderGet'][0])
    {
        list($response) = $this->orderGetWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGet'][0])
    {
        $request = $this->orderGetRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetAsync($id, $api_key, string $contentType = self::contentTypes['orderGet'][0])
    {
        return $this->orderGetAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGet'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrder';
        $request = $this->orderGetRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGet'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetRequest($id, $api_key, string $contentType = self::contentTypes['orderGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderGet'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGet'
            );
        }


        $resourcePath = '/api/Order/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetChannels
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetChannels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesChannelsChannel[]
     */
    public function orderGetChannels($api_key, string $contentType = self::contentTypes['orderGetChannels'][0])
    {
        list($response) = $this->orderGetChannelsWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetChannelsWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetChannels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesChannelsChannel[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetChannelsWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetChannels'][0])
    {
        $request = $this->orderGetChannelsRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesChannelsChannel[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesChannelsChannel[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesChannelsChannel[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetChannelsAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetChannelsAsync($api_key, string $contentType = self::contentTypes['orderGetChannels'][0])
    {
        return $this->orderGetChannelsAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetChannelsAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetChannelsAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetChannels'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesChannelsChannel[]';
        $request = $this->orderGetChannelsRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetChannels'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetChannelsRequest($api_key, string $contentType = self::contentTypes['orderGetChannels'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetChannels'
            );
        }


        $resourcePath = '/api/Order/Channels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetConnectAction
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]
     */
    public function orderGetConnectAction($id, $api_key, string $contentType = self::contentTypes['orderGetConnectAction'][0])
    {
        list($response) = $this->orderGetConnectActionWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetConnectActionWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetConnectActionWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGetConnectAction'][0])
    {
        $request = $this->orderGetConnectActionRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetConnectActionAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetConnectActionAsync($id, $api_key, string $contentType = self::contentTypes['orderGetConnectAction'][0])
    {
        return $this->orderGetConnectActionAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetConnectActionAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetConnectActionAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGetConnectAction'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]';
        $request = $this->orderGetConnectActionRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetConnectAction'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetConnectActionRequest($id, $api_key, string $contentType = self::contentTypes['orderGetConnectAction'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderGetConnectAction'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetConnectAction'
            );
        }


        $resourcePath = '/api/Order/{id}/ConnectActions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetDocument
     *
     * @param  int $id id (required)
     * @param  int $document_id document_id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocument'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument
     */
    public function orderGetDocument($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocument'][0])
    {
        list($response) = $this->orderGetDocumentWithHttpInfo($id, $document_id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetDocumentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocument'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetDocumentWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocument'][0])
    {
        $request = $this->orderGetDocumentRequest($id, $document_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetDocumentAsync
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetDocumentAsync($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocument'][0])
    {
        return $this->orderGetDocumentAsyncWithHttpInfo($id, $document_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetDocumentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetDocumentAsyncWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocument'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument';
        $request = $this->orderGetDocumentRequest($id, $document_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetDocument'
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetDocumentRequest($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocument'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderGetDocument'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling orderGetDocument'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetDocument'
            );
        }


        $resourcePath = '/api/Order/{id}/Documents/{DocumentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'DocumentId' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetDocumentData
     *
     * @param  int $id id (required)
     * @param  int $document_id document_id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocumentData'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function orderGetDocumentData($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocumentData'][0])
    {
        list($response) = $this->orderGetDocumentDataWithHttpInfo($id, $document_id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetDocumentDataWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocumentData'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetDocumentDataWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocumentData'][0])
    {
        $request = $this->orderGetDocumentDataRequest($id, $document_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetDocumentDataAsync
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocumentData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetDocumentDataAsync($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocumentData'][0])
    {
        return $this->orderGetDocumentDataAsyncWithHttpInfo($id, $document_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetDocumentDataAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocumentData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetDocumentDataAsyncWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocumentData'][0])
    {
        $returnType = 'string';
        $request = $this->orderGetDocumentDataRequest($id, $document_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetDocumentData'
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetDocumentData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetDocumentDataRequest($id, $document_id, $api_key, string $contentType = self::contentTypes['orderGetDocumentData'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderGetDocumentData'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling orderGetDocumentData'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetDocumentData'
            );
        }


        $resourcePath = '/api/Order/{id}/Documents/{DocumentId}/Data';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'DocumentId' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetOrderDocumentPaperSizes
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentPaperSizes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
     */
    public function orderGetOrderDocumentPaperSizes($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentPaperSizes'][0])
    {
        list($response) = $this->orderGetOrderDocumentPaperSizesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetOrderDocumentPaperSizesWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentPaperSizes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetOrderDocumentPaperSizesWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentPaperSizes'][0])
    {
        $request = $this->orderGetOrderDocumentPaperSizesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetOrderDocumentPaperSizesAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentPaperSizes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderDocumentPaperSizesAsync($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentPaperSizes'][0])
    {
        return $this->orderGetOrderDocumentPaperSizesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetOrderDocumentPaperSizesAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentPaperSizes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderDocumentPaperSizesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentPaperSizes'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]';
        $request = $this->orderGetOrderDocumentPaperSizesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetOrderDocumentPaperSizes'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentPaperSizes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetOrderDocumentPaperSizesRequest($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentPaperSizes'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetOrderDocumentPaperSizes'
            );
        }


        $resourcePath = '/api/Order/Documents/PaperSizes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetOrderDocumentTypes
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]
     */
    public function orderGetOrderDocumentTypes($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentTypes'][0])
    {
        list($response) = $this->orderGetOrderDocumentTypesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetOrderDocumentTypesWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetOrderDocumentTypesWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentTypes'][0])
    {
        $request = $this->orderGetOrderDocumentTypesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetOrderDocumentTypesAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderDocumentTypesAsync($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentTypes'][0])
    {
        return $this->orderGetOrderDocumentTypesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetOrderDocumentTypesAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderDocumentTypesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentTypes'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]';
        $request = $this->orderGetOrderDocumentTypesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetOrderDocumentTypes'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderDocumentTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetOrderDocumentTypesRequest($api_key, string $contentType = self::contentTypes['orderGetOrderDocumentTypes'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetOrderDocumentTypes'
            );
        }


        $resourcePath = '/api/Order/Documents/DocumentTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetOrderShipment
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]
     */
    public function orderGetOrderShipment($id, $api_key, string $contentType = self::contentTypes['orderGetOrderShipment'][0])
    {
        list($response) = $this->orderGetOrderShipmentWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetOrderShipmentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetOrderShipmentWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGetOrderShipment'][0])
    {
        $request = $this->orderGetOrderShipmentRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetOrderShipmentAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderShipmentAsync($id, $api_key, string $contentType = self::contentTypes['orderGetOrderShipment'][0])
    {
        return $this->orderGetOrderShipmentAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetOrderShipmentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderShipmentAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderGetOrderShipment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]';
        $request = $this->orderGetOrderShipmentRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetOrderShipment'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetOrderShipmentRequest($id, $api_key, string $contentType = self::contentTypes['orderGetOrderShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderGetOrderShipment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetOrderShipment'
            );
        }


        $resourcePath = '/api/Order/{id}/Shipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetOrderShipmentTrackingEventsStatuses
     *
     * Tracking Event - Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
     */
    public function orderGetOrderShipmentTrackingEventsStatuses($api_key, string $contentType = self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'][0])
    {
        list($response) = $this->orderGetOrderShipmentTrackingEventsStatusesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetOrderShipmentTrackingEventsStatusesWithHttpInfo
     *
     * Tracking Event - Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetOrderShipmentTrackingEventsStatusesWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'][0])
    {
        $request = $this->orderGetOrderShipmentTrackingEventsStatusesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetOrderShipmentTrackingEventsStatusesAsync
     *
     * Tracking Event - Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderShipmentTrackingEventsStatusesAsync($api_key, string $contentType = self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'][0])
    {
        return $this->orderGetOrderShipmentTrackingEventsStatusesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetOrderShipmentTrackingEventsStatusesAsyncWithHttpInfo
     *
     * Tracking Event - Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderShipmentTrackingEventsStatusesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]';
        $request = $this->orderGetOrderShipmentTrackingEventsStatusesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetOrderShipmentTrackingEventsStatuses'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetOrderShipmentTrackingEventsStatusesRequest($api_key, string $contentType = self::contentTypes['orderGetOrderShipmentTrackingEventsStatuses'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetOrderShipmentTrackingEventsStatuses'
            );
        }


        $resourcePath = '/api/Order/Shipments/TrackingEvents/Statuses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderGetOrderStatuses
     *
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]
     */
    public function orderGetOrderStatuses($api_key, string $contentType = self::contentTypes['orderGetOrderStatuses'][0])
    {
        list($response) = $this->orderGetOrderStatusesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderGetOrderStatusesWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderGetOrderStatusesWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderStatuses'][0])
    {
        $request = $this->orderGetOrderStatusesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderGetOrderStatusesAsync
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderStatusesAsync($api_key, string $contentType = self::contentTypes['orderGetOrderStatuses'][0])
    {
        return $this->orderGetOrderStatusesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderGetOrderStatusesAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderGetOrderStatusesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['orderGetOrderStatuses'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]';
        $request = $this->orderGetOrderStatusesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderGetOrderStatuses'
     *
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderGetOrderStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderGetOrderStatusesRequest($api_key, string $contentType = self::contentTypes['orderGetOrderStatuses'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderGetOrderStatuses'
            );
        }


        $resourcePath = '/api/Order/Statuses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderItems
     *
     * Get Order Items
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]
     */
    public function orderItems($id, $api_key, string $contentType = self::contentTypes['orderItems'][0])
    {
        list($response) = $this->orderItemsWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderItemsWithHttpInfo
     *
     * Get Order Items
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderItemsWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderItems'][0])
    {
        $request = $this->orderItemsRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderItemsAsync
     *
     * Get Order Items
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderItemsAsync($id, $api_key, string $contentType = self::contentTypes['orderItems'][0])
    {
        return $this->orderItemsAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderItemsAsyncWithHttpInfo
     *
     * Get Order Items
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderItemsAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderItems'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]';
        $request = $this->orderItemsRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderItems'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderItemsRequest($id, $api_key, string $contentType = self::contentTypes['orderItems'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderItems'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderItems'
            );
        }


        $resourcePath = '/api/Order/{id}/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderListOrders
     *
     * @param  string $api_key api_key (required)
     * @param  int|null $order_status_id order_status_id (optional)
     * @param  int|null $client_id client_id (optional)
     * @param  int|null $channel_id channel_id (optional)
     * @param  int|null $courier_service_id courier_service_id (optional)
     * @param  int|null $warehouse_id warehouse_id (optional)
     * @param  int|null $page_no page_no (optional)
     * @param  int|null $limit limit (optional)
     * @param  \DateTime|null $since_date since_date (optional)
     * @param  \DateTime|null $since_last_updated since_last_updated (optional)
     * @param  \DateTime|null $since_despatch_date since_despatch_date (optional)
     * @param  string|null $exclude_tags exclude_tags (optional)
     * @param  string|null $include_tags include_tags (optional)
     * @param  bool|null $include_order_items include_order_items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListOrders'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrder[]
     */
    public function orderListOrders($api_key, $order_status_id = null, $client_id = null, $channel_id = null, $courier_service_id = null, $warehouse_id = null, $page_no = null, $limit = null, $since_date = null, $since_last_updated = null, $since_despatch_date = null, $exclude_tags = null, $include_tags = null, $include_order_items = null, string $contentType = self::contentTypes['orderListOrders'][0])
    {
        list($response) = $this->orderListOrdersWithHttpInfo($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items, $contentType);
        return $response;
    }

    /**
     * Operation orderListOrdersWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int|null $order_status_id (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $channel_id (optional)
     * @param  int|null $courier_service_id (optional)
     * @param  int|null $warehouse_id (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  \DateTime|null $since_date (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  \DateTime|null $since_despatch_date (optional)
     * @param  string|null $exclude_tags (optional)
     * @param  string|null $include_tags (optional)
     * @param  bool|null $include_order_items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListOrders'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderListOrdersWithHttpInfo($api_key, $order_status_id = null, $client_id = null, $channel_id = null, $courier_service_id = null, $warehouse_id = null, $page_no = null, $limit = null, $since_date = null, $since_last_updated = null, $since_despatch_date = null, $exclude_tags = null, $include_tags = null, $include_order_items = null, string $contentType = self::contentTypes['orderListOrders'][0])
    {
        $request = $this->orderListOrdersRequest($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderListOrdersAsync
     *
     * @param  string $api_key (required)
     * @param  int|null $order_status_id (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $channel_id (optional)
     * @param  int|null $courier_service_id (optional)
     * @param  int|null $warehouse_id (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  \DateTime|null $since_date (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  \DateTime|null $since_despatch_date (optional)
     * @param  string|null $exclude_tags (optional)
     * @param  string|null $include_tags (optional)
     * @param  bool|null $include_order_items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderListOrdersAsync($api_key, $order_status_id = null, $client_id = null, $channel_id = null, $courier_service_id = null, $warehouse_id = null, $page_no = null, $limit = null, $since_date = null, $since_last_updated = null, $since_despatch_date = null, $exclude_tags = null, $include_tags = null, $include_order_items = null, string $contentType = self::contentTypes['orderListOrders'][0])
    {
        return $this->orderListOrdersAsyncWithHttpInfo($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderListOrdersAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  int|null $order_status_id (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $channel_id (optional)
     * @param  int|null $courier_service_id (optional)
     * @param  int|null $warehouse_id (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  \DateTime|null $since_date (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  \DateTime|null $since_despatch_date (optional)
     * @param  string|null $exclude_tags (optional)
     * @param  string|null $include_tags (optional)
     * @param  bool|null $include_order_items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderListOrdersAsyncWithHttpInfo($api_key, $order_status_id = null, $client_id = null, $channel_id = null, $courier_service_id = null, $warehouse_id = null, $page_no = null, $limit = null, $since_date = null, $since_last_updated = null, $since_despatch_date = null, $exclude_tags = null, $include_tags = null, $include_order_items = null, string $contentType = self::contentTypes['orderListOrders'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]';
        $request = $this->orderListOrdersRequest($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderListOrders'
     *
     * @param  string $api_key (required)
     * @param  int|null $order_status_id (optional)
     * @param  int|null $client_id (optional)
     * @param  int|null $channel_id (optional)
     * @param  int|null $courier_service_id (optional)
     * @param  int|null $warehouse_id (optional)
     * @param  int|null $page_no (optional)
     * @param  int|null $limit (optional)
     * @param  \DateTime|null $since_date (optional)
     * @param  \DateTime|null $since_last_updated (optional)
     * @param  \DateTime|null $since_despatch_date (optional)
     * @param  string|null $exclude_tags (optional)
     * @param  string|null $include_tags (optional)
     * @param  bool|null $include_order_items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderListOrdersRequest($api_key, $order_status_id = null, $client_id = null, $channel_id = null, $courier_service_id = null, $warehouse_id = null, $page_no = null, $limit = null, $since_date = null, $since_last_updated = null, $since_despatch_date = null, $exclude_tags = null, $include_tags = null, $include_order_items = null, string $contentType = self::contentTypes['orderListOrders'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderListOrders'
            );
        }















        $resourcePath = '/api/Order/List';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status_id,
            'OrderStatusId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $channel_id,
            'ChannelId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $courier_service_id,
            'CourierServiceId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_id,
            'WarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_date,
            'SinceDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_last_updated,
            'SinceLastUpdated', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_despatch_date,
            'SinceDespatchDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_tags,
            'ExcludeTags', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_tags,
            'IncludeTags', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_order_items,
            'IncludeOrderItems', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderListTrackingEvents
     *
     * Shipment Tracking Events - List
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 500 - Max 500 (optional)
     * @param  int|null $tracking_status_id Filter by TrackingStatusId (optional)
     * @param  \DateTime|null $since_last_updated Tracking Events that have happened Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListTrackingEvents'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]
     */
    public function orderListTrackingEvents($api_key, $page_no = null, $limit = null, $tracking_status_id = null, $since_last_updated = null, string $contentType = self::contentTypes['orderListTrackingEvents'][0])
    {
        list($response) = $this->orderListTrackingEventsWithHttpInfo($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated, $contentType);
        return $response;
    }

    /**
     * Operation orderListTrackingEventsWithHttpInfo
     *
     * Shipment Tracking Events - List
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 500 - Max 500 (optional)
     * @param  int|null $tracking_status_id Filter by TrackingStatusId (optional)
     * @param  \DateTime|null $since_last_updated Tracking Events that have happened Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListTrackingEvents'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderListTrackingEventsWithHttpInfo($api_key, $page_no = null, $limit = null, $tracking_status_id = null, $since_last_updated = null, string $contentType = self::contentTypes['orderListTrackingEvents'][0])
    {
        $request = $this->orderListTrackingEventsRequest($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderListTrackingEventsAsync
     *
     * Shipment Tracking Events - List
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 500 - Max 500 (optional)
     * @param  int|null $tracking_status_id Filter by TrackingStatusId (optional)
     * @param  \DateTime|null $since_last_updated Tracking Events that have happened Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListTrackingEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderListTrackingEventsAsync($api_key, $page_no = null, $limit = null, $tracking_status_id = null, $since_last_updated = null, string $contentType = self::contentTypes['orderListTrackingEvents'][0])
    {
        return $this->orderListTrackingEventsAsyncWithHttpInfo($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderListTrackingEventsAsyncWithHttpInfo
     *
     * Shipment Tracking Events - List
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 500 - Max 500 (optional)
     * @param  int|null $tracking_status_id Filter by TrackingStatusId (optional)
     * @param  \DateTime|null $since_last_updated Tracking Events that have happened Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListTrackingEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderListTrackingEventsAsyncWithHttpInfo($api_key, $page_no = null, $limit = null, $tracking_status_id = null, $since_last_updated = null, string $contentType = self::contentTypes['orderListTrackingEvents'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]';
        $request = $this->orderListTrackingEventsRequest($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderListTrackingEvents'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Results to Return - Default 500 - Max 500 (optional)
     * @param  int|null $tracking_status_id Filter by TrackingStatusId (optional)
     * @param  \DateTime|null $since_last_updated Tracking Events that have happened Since Supplied Time (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderListTrackingEvents'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderListTrackingEventsRequest($api_key, $page_no = null, $limit = null, $tracking_status_id = null, $since_last_updated = null, string $contentType = self::contentTypes['orderListTrackingEvents'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderListTrackingEvents'
            );
        }






        $resourcePath = '/api/Order/Shipments/TrackingEvents/List';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tracking_status_id,
            'TrackingStatusId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_last_updated,
            'SinceLastUpdated', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkAwaitingConfirmation
     *
     * MarkAwaitingConfirmation
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingConfirmation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkAwaitingConfirmation($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingConfirmation'][0])
    {
        list($response) = $this->orderMarkAwaitingConfirmationWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkAwaitingConfirmationWithHttpInfo
     *
     * MarkAwaitingConfirmation
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingConfirmation'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkAwaitingConfirmationWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingConfirmation'][0])
    {
        $request = $this->orderMarkAwaitingConfirmationRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkAwaitingConfirmationAsync
     *
     * MarkAwaitingConfirmation
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingConfirmation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkAwaitingConfirmationAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingConfirmation'][0])
    {
        return $this->orderMarkAwaitingConfirmationAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkAwaitingConfirmationAsyncWithHttpInfo
     *
     * MarkAwaitingConfirmation
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingConfirmation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkAwaitingConfirmationAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingConfirmation'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkAwaitingConfirmationRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkAwaitingConfirmation'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingConfirmation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkAwaitingConfirmationRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingConfirmation'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkAwaitingConfirmation'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkAwaitingConfirmation'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkAwaitingConfirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkAwaitingPayment
     *
     * MarkAwaitingPayment
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingPayment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkAwaitingPayment($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingPayment'][0])
    {
        list($response) = $this->orderMarkAwaitingPaymentWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkAwaitingPaymentWithHttpInfo
     *
     * MarkAwaitingPayment
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingPayment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkAwaitingPaymentWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingPayment'][0])
    {
        $request = $this->orderMarkAwaitingPaymentRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkAwaitingPaymentAsync
     *
     * MarkAwaitingPayment
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingPayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkAwaitingPaymentAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingPayment'][0])
    {
        return $this->orderMarkAwaitingPaymentAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkAwaitingPaymentAsyncWithHttpInfo
     *
     * MarkAwaitingPayment
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingPayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkAwaitingPaymentAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingPayment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkAwaitingPaymentRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkAwaitingPayment'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkAwaitingPayment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkAwaitingPaymentRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkAwaitingPayment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkAwaitingPayment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkAwaitingPayment'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkAwaitingPayment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkConfirmed
     *
     * MarkConfirmed
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkConfirmed'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkConfirmed($id, $api_key, string $contentType = self::contentTypes['orderMarkConfirmed'][0])
    {
        list($response) = $this->orderMarkConfirmedWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkConfirmedWithHttpInfo
     *
     * MarkConfirmed
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkConfirmed'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkConfirmedWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkConfirmed'][0])
    {
        $request = $this->orderMarkConfirmedRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkConfirmedAsync
     *
     * MarkConfirmed
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkConfirmed'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkConfirmedAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkConfirmed'][0])
    {
        return $this->orderMarkConfirmedAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkConfirmedAsyncWithHttpInfo
     *
     * MarkConfirmed
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkConfirmed'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkConfirmedAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkConfirmed'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkConfirmedRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkConfirmed'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkConfirmed'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkConfirmedRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkConfirmed'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkConfirmed'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkConfirmed'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkConfirmed';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkDespatched
     *
     * MarkDespatched
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $tracking_number TrackingNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDespatched'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkDespatched($id, $api_key, $tracking_number = null, string $contentType = self::contentTypes['orderMarkDespatched'][0])
    {
        list($response) = $this->orderMarkDespatchedWithHttpInfo($id, $api_key, $tracking_number, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkDespatchedWithHttpInfo
     *
     * MarkDespatched
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $tracking_number TrackingNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDespatched'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkDespatchedWithHttpInfo($id, $api_key, $tracking_number = null, string $contentType = self::contentTypes['orderMarkDespatched'][0])
    {
        $request = $this->orderMarkDespatchedRequest($id, $api_key, $tracking_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkDespatchedAsync
     *
     * MarkDespatched
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $tracking_number TrackingNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDespatched'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkDespatchedAsync($id, $api_key, $tracking_number = null, string $contentType = self::contentTypes['orderMarkDespatched'][0])
    {
        return $this->orderMarkDespatchedAsyncWithHttpInfo($id, $api_key, $tracking_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkDespatchedAsyncWithHttpInfo
     *
     * MarkDespatched
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $tracking_number TrackingNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDespatched'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkDespatchedAsyncWithHttpInfo($id, $api_key, $tracking_number = null, string $contentType = self::contentTypes['orderMarkDespatched'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkDespatchedRequest($id, $api_key, $tracking_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkDespatched'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $tracking_number TrackingNumber (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDespatched'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkDespatchedRequest($id, $api_key, $tracking_number = null, string $contentType = self::contentTypes['orderMarkDespatched'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkDespatched'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkDespatched'
            );
        }



        $resourcePath = '/api/Order/{id}/MarkDespatched';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tracking_number,
            'TrackingNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkDocumentAsPrinted
     *
     * @param  int $id id (required)
     * @param  int $document_id document_id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDocumentAsPrinted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function orderMarkDocumentAsPrinted($id, $document_id, $api_key, string $contentType = self::contentTypes['orderMarkDocumentAsPrinted'][0])
    {
        $this->orderMarkDocumentAsPrintedWithHttpInfo($id, $document_id, $api_key, $contentType);
    }

    /**
     * Operation orderMarkDocumentAsPrintedWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDocumentAsPrinted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkDocumentAsPrintedWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderMarkDocumentAsPrinted'][0])
    {
        $request = $this->orderMarkDocumentAsPrintedRequest($id, $document_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkDocumentAsPrintedAsync
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDocumentAsPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkDocumentAsPrintedAsync($id, $document_id, $api_key, string $contentType = self::contentTypes['orderMarkDocumentAsPrinted'][0])
    {
        return $this->orderMarkDocumentAsPrintedAsyncWithHttpInfo($id, $document_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkDocumentAsPrintedAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDocumentAsPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkDocumentAsPrintedAsyncWithHttpInfo($id, $document_id, $api_key, string $contentType = self::contentTypes['orderMarkDocumentAsPrinted'][0])
    {
        $returnType = '';
        $request = $this->orderMarkDocumentAsPrintedRequest($id, $document_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkDocumentAsPrinted'
     *
     * @param  int $id (required)
     * @param  int $document_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkDocumentAsPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkDocumentAsPrintedRequest($id, $document_id, $api_key, string $contentType = self::contentTypes['orderMarkDocumentAsPrinted'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkDocumentAsPrinted'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling orderMarkDocumentAsPrinted'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkDocumentAsPrinted'
            );
        }


        $resourcePath = '/api/Order/{id}/Documents/{DocumentId}/MarkPrinted';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'DocumentId' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkFraudRisk
     *
     * Marks Fraud Risk
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRisk'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkFraudRisk($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRisk'][0])
    {
        list($response) = $this->orderMarkFraudRiskWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkFraudRiskWithHttpInfo
     *
     * Marks Fraud Risk
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRisk'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkFraudRiskWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRisk'][0])
    {
        $request = $this->orderMarkFraudRiskRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkFraudRiskAsync
     *
     * Marks Fraud Risk
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRisk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkFraudRiskAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRisk'][0])
    {
        return $this->orderMarkFraudRiskAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkFraudRiskAsyncWithHttpInfo
     *
     * Marks Fraud Risk
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRisk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkFraudRiskAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRisk'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkFraudRiskRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkFraudRisk'
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRisk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkFraudRiskRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRisk'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkFraudRisk'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkFraudRisk'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkFraudRisk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkFraudRiskAccepted
     *
     * Marks Fraud Risk Accepted
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRiskAccepted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkFraudRiskAccepted($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRiskAccepted'][0])
    {
        list($response) = $this->orderMarkFraudRiskAcceptedWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkFraudRiskAcceptedWithHttpInfo
     *
     * Marks Fraud Risk Accepted
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRiskAccepted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkFraudRiskAcceptedWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRiskAccepted'][0])
    {
        $request = $this->orderMarkFraudRiskAcceptedRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkFraudRiskAcceptedAsync
     *
     * Marks Fraud Risk Accepted
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRiskAccepted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkFraudRiskAcceptedAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRiskAccepted'][0])
    {
        return $this->orderMarkFraudRiskAcceptedAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkFraudRiskAcceptedAsyncWithHttpInfo
     *
     * Marks Fraud Risk Accepted
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRiskAccepted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkFraudRiskAcceptedAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRiskAccepted'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkFraudRiskAcceptedRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkFraudRiskAccepted'
     *
     * @param  int $id Order Id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkFraudRiskAccepted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkFraudRiskAcceptedRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkFraudRiskAccepted'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkFraudRiskAccepted'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkFraudRiskAccepted'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkFraudRiskAccepted';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkPackAndHold
     *
     * MarkPackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  \DateTime $release_date Date you want the order released (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPackAndHold'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkPackAndHold($id, $release_date, $api_key, string $contentType = self::contentTypes['orderMarkPackAndHold'][0])
    {
        list($response) = $this->orderMarkPackAndHoldWithHttpInfo($id, $release_date, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkPackAndHoldWithHttpInfo
     *
     * MarkPackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  \DateTime $release_date Date you want the order released (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPackAndHold'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkPackAndHoldWithHttpInfo($id, $release_date, $api_key, string $contentType = self::contentTypes['orderMarkPackAndHold'][0])
    {
        $request = $this->orderMarkPackAndHoldRequest($id, $release_date, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkPackAndHoldAsync
     *
     * MarkPackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  \DateTime $release_date Date you want the order released (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPackAndHoldAsync($id, $release_date, $api_key, string $contentType = self::contentTypes['orderMarkPackAndHold'][0])
    {
        return $this->orderMarkPackAndHoldAsyncWithHttpInfo($id, $release_date, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkPackAndHoldAsyncWithHttpInfo
     *
     * MarkPackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  \DateTime $release_date Date you want the order released (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPackAndHoldAsyncWithHttpInfo($id, $release_date, $api_key, string $contentType = self::contentTypes['orderMarkPackAndHold'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkPackAndHoldRequest($id, $release_date, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkPackAndHold'
     *
     * @param  int $id OrderId (required)
     * @param  \DateTime $release_date Date you want the order released (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkPackAndHoldRequest($id, $release_date, $api_key, string $contentType = self::contentTypes['orderMarkPackAndHold'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkPackAndHold'
            );
        }

        // verify the required parameter 'release_date' is set
        if ($release_date === null || (is_array($release_date) && count($release_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $release_date when calling orderMarkPackAndHold'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkPackAndHold'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkPackAndHold';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $release_date,
            'ReleaseDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkPaymentReceived
     *
     * MarkPaymentReceived
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPaymentReceived'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkPaymentReceived($id, $api_key, string $contentType = self::contentTypes['orderMarkPaymentReceived'][0])
    {
        list($response) = $this->orderMarkPaymentReceivedWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkPaymentReceivedWithHttpInfo
     *
     * MarkPaymentReceived
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPaymentReceived'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkPaymentReceivedWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkPaymentReceived'][0])
    {
        $request = $this->orderMarkPaymentReceivedRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkPaymentReceivedAsync
     *
     * MarkPaymentReceived
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPaymentReceived'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPaymentReceivedAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkPaymentReceived'][0])
    {
        return $this->orderMarkPaymentReceivedAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkPaymentReceivedAsyncWithHttpInfo
     *
     * MarkPaymentReceived
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPaymentReceived'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPaymentReceivedAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkPaymentReceived'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkPaymentReceivedRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkPaymentReceived'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPaymentReceived'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkPaymentReceivedRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkPaymentReceived'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkPaymentReceived'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkPaymentReceived'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkPaymentReceived';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkPrinted
     *
     * MarkPrinted
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $comment Comment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPrinted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkPrinted($id, $api_key, $comment = null, string $contentType = self::contentTypes['orderMarkPrinted'][0])
    {
        list($response) = $this->orderMarkPrintedWithHttpInfo($id, $api_key, $comment, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkPrintedWithHttpInfo
     *
     * MarkPrinted
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $comment Comment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPrinted'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkPrintedWithHttpInfo($id, $api_key, $comment = null, string $contentType = self::contentTypes['orderMarkPrinted'][0])
    {
        $request = $this->orderMarkPrintedRequest($id, $api_key, $comment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkPrintedAsync
     *
     * MarkPrinted
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $comment Comment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPrintedAsync($id, $api_key, $comment = null, string $contentType = self::contentTypes['orderMarkPrinted'][0])
    {
        return $this->orderMarkPrintedAsyncWithHttpInfo($id, $api_key, $comment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkPrintedAsyncWithHttpInfo
     *
     * MarkPrinted
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $comment Comment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkPrintedAsyncWithHttpInfo($id, $api_key, $comment = null, string $contentType = self::contentTypes['orderMarkPrinted'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkPrintedRequest($id, $api_key, $comment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkPrinted'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $comment Comment (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkPrinted'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkPrintedRequest($id, $api_key, $comment = null, string $contentType = self::contentTypes['orderMarkPrinted'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkPrinted'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkPrinted'
            );
        }



        $resourcePath = '/api/Order/{id}/MarkPrinted';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $comment,
            'Comment', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderMarkReleasePackAndHold
     *
     * MarkReleasePackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkReleasePackAndHold'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderMarkReleasePackAndHold($id, $api_key, string $contentType = self::contentTypes['orderMarkReleasePackAndHold'][0])
    {
        list($response) = $this->orderMarkReleasePackAndHoldWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderMarkReleasePackAndHoldWithHttpInfo
     *
     * MarkReleasePackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkReleasePackAndHold'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderMarkReleasePackAndHoldWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkReleasePackAndHold'][0])
    {
        $request = $this->orderMarkReleasePackAndHoldRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderMarkReleasePackAndHoldAsync
     *
     * MarkReleasePackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkReleasePackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkReleasePackAndHoldAsync($id, $api_key, string $contentType = self::contentTypes['orderMarkReleasePackAndHold'][0])
    {
        return $this->orderMarkReleasePackAndHoldAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderMarkReleasePackAndHoldAsyncWithHttpInfo
     *
     * MarkReleasePackAndHold
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkReleasePackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderMarkReleasePackAndHoldAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderMarkReleasePackAndHold'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderMarkReleasePackAndHoldRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderMarkReleasePackAndHold'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderMarkReleasePackAndHold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderMarkReleasePackAndHoldRequest($id, $api_key, string $contentType = self::contentTypes['orderMarkReleasePackAndHold'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderMarkReleasePackAndHold'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderMarkReleasePackAndHold'
            );
        }


        $resourcePath = '/api/Order/{id}/MarkReleasePackAndHold';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderOrderSplit
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderOrderSplit'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]
     */
    public function orderOrderSplit($id, $api_key, string $contentType = self::contentTypes['orderOrderSplit'][0])
    {
        list($response) = $this->orderOrderSplitWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderOrderSplitWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderOrderSplit'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderOrderSplitWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderOrderSplit'][0])
    {
        $request = $this->orderOrderSplitRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderOrderSplitAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderOrderSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderOrderSplitAsync($id, $api_key, string $contentType = self::contentTypes['orderOrderSplit'][0])
    {
        return $this->orderOrderSplitAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderOrderSplitAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderOrderSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderOrderSplitAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderOrderSplit'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]';
        $request = $this->orderOrderSplitRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderOrderSplit'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderOrderSplit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderOrderSplitRequest($id, $api_key, string $contentType = self::contentTypes['orderOrderSplit'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderOrderSplit'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderOrderSplit'
            );
        }


        $resourcePath = '/api/Order/{id}/Splits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderQueries
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueries'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]
     */
    public function orderQueries($id, $api_key, string $contentType = self::contentTypes['orderQueries'][0])
    {
        list($response) = $this->orderQueriesWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderQueriesWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueries'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderQueriesWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderQueries'][0])
    {
        $request = $this->orderQueriesRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderQueriesAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderQueriesAsync($id, $api_key, string $contentType = self::contentTypes['orderQueries'][0])
    {
        return $this->orderQueriesAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderQueriesAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderQueriesAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['orderQueries'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]';
        $request = $this->orderQueriesRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderQueries'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderQueriesRequest($id, $api_key, string $contentType = self::contentTypes['orderQueries'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderQueries'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderQueries'
            );
        }


        $resourcePath = '/api/Order/{id}/Queries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderQueryComments
     *
     * @param  int $id id (required)
     * @param  int $query_id query_id (required)
     * @param  string $api_key api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueryComments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]
     */
    public function orderQueryComments($id, $query_id, $api_key, string $contentType = self::contentTypes['orderQueryComments'][0])
    {
        list($response) = $this->orderQueryCommentsWithHttpInfo($id, $query_id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation orderQueryCommentsWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $query_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueryComments'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderQueryCommentsWithHttpInfo($id, $query_id, $api_key, string $contentType = self::contentTypes['orderQueryComments'][0])
    {
        $request = $this->orderQueryCommentsRequest($id, $query_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderQueryCommentsAsync
     *
     * @param  int $id (required)
     * @param  int $query_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueryComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderQueryCommentsAsync($id, $query_id, $api_key, string $contentType = self::contentTypes['orderQueryComments'][0])
    {
        return $this->orderQueryCommentsAsyncWithHttpInfo($id, $query_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderQueryCommentsAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  int $query_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueryComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderQueryCommentsAsyncWithHttpInfo($id, $query_id, $api_key, string $contentType = self::contentTypes['orderQueryComments'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]';
        $request = $this->orderQueryCommentsRequest($id, $query_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderQueryComments'
     *
     * @param  int $id (required)
     * @param  int $query_id (required)
     * @param  string $api_key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderQueryComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderQueryCommentsRequest($id, $query_id, $api_key, string $contentType = self::contentTypes['orderQueryComments'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderQueryComments'
            );
        }

        // verify the required parameter 'query_id' is set
        if ($query_id === null || (is_array($query_id) && count($query_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $query_id when calling orderQueryComments'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderQueryComments'
            );
        }


        $resourcePath = '/api/Order/{id}/Queries/{QueryId}/Comments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($query_id !== null) {
            $resourcePath = str_replace(
                '{' . 'QueryId' . '}',
                ObjectSerializer::toPathValue($query_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderSearchOrder
     *
     * @param  string $api_key api_key (required)
     * @param  string $order_number order_number (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSearchOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesOrdersOrder[]
     */
    public function orderSearchOrder($api_key, $order_number, string $contentType = self::contentTypes['orderSearchOrder'][0])
    {
        list($response) = $this->orderSearchOrderWithHttpInfo($api_key, $order_number, $contentType);
        return $response;
    }

    /**
     * Operation orderSearchOrderWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $order_number (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSearchOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesOrdersOrder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function orderSearchOrderWithHttpInfo($api_key, $order_number, string $contentType = self::contentTypes['orderSearchOrder'][0])
    {
        $request = $this->orderSearchOrderRequest($api_key, $order_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderSearchOrderAsync
     *
     * @param  string $api_key (required)
     * @param  string $order_number (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSearchOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderSearchOrderAsync($api_key, $order_number, string $contentType = self::contentTypes['orderSearchOrder'][0])
    {
        return $this->orderSearchOrderAsyncWithHttpInfo($api_key, $order_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderSearchOrderAsyncWithHttpInfo
     *
     * @param  string $api_key (required)
     * @param  string $order_number (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSearchOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderSearchOrderAsyncWithHttpInfo($api_key, $order_number, string $contentType = self::contentTypes['orderSearchOrder'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]';
        $request = $this->orderSearchOrderRequest($api_key, $order_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderSearchOrder'
     *
     * @param  string $api_key (required)
     * @param  string $order_number (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSearchOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderSearchOrderRequest($api_key, $order_number, string $contentType = self::contentTypes['orderSearchOrder'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderSearchOrder'
            );
        }

        // verify the required parameter 'order_number' is set
        if ($order_number === null || (is_array($order_number) && count($order_number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_number when calling orderSearchOrder'
            );
        }


        $resourcePath = '/api/Order/Search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'OrderNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderSplitOrderItems
     *
     * SplitOrderItems
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] $order_items_to_split Order Items to Split onto new order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSplitOrderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderSplitOrderItems($id, $api_key, $order_items_to_split, string $contentType = self::contentTypes['orderSplitOrderItems'][0])
    {
        list($response) = $this->orderSplitOrderItemsWithHttpInfo($id, $api_key, $order_items_to_split, $contentType);
        return $response;
    }

    /**
     * Operation orderSplitOrderItemsWithHttpInfo
     *
     * SplitOrderItems
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] $order_items_to_split Order Items to Split onto new order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSplitOrderItems'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderSplitOrderItemsWithHttpInfo($id, $api_key, $order_items_to_split, string $contentType = self::contentTypes['orderSplitOrderItems'][0])
    {
        $request = $this->orderSplitOrderItemsRequest($id, $api_key, $order_items_to_split, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderSplitOrderItemsAsync
     *
     * SplitOrderItems
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] $order_items_to_split Order Items to Split onto new order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSplitOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderSplitOrderItemsAsync($id, $api_key, $order_items_to_split, string $contentType = self::contentTypes['orderSplitOrderItems'][0])
    {
        return $this->orderSplitOrderItemsAsyncWithHttpInfo($id, $api_key, $order_items_to_split, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderSplitOrderItemsAsyncWithHttpInfo
     *
     * SplitOrderItems
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] $order_items_to_split Order Items to Split onto new order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSplitOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderSplitOrderItemsAsyncWithHttpInfo($id, $api_key, $order_items_to_split, string $contentType = self::contentTypes['orderSplitOrderItems'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderSplitOrderItemsRequest($id, $api_key, $order_items_to_split, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderSplitOrderItems'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] $order_items_to_split Order Items to Split onto new order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderSplitOrderItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderSplitOrderItemsRequest($id, $api_key, $order_items_to_split, string $contentType = self::contentTypes['orderSplitOrderItems'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderSplitOrderItems'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderSplitOrderItems'
            );
        }

        // verify the required parameter 'order_items_to_split' is set
        if ($order_items_to_split === null || (is_array($order_items_to_split) && count($order_items_to_split) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_items_to_split when calling orderSplitOrderItems'
            );
        }


        $resourcePath = '/api/Order/{id}/SplitOrderItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_items_to_split)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_items_to_split));
            } else {
                $httpBody = $order_items_to_split;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUpdateNumberOfParcels
     *
     * Update Number Of Parcels
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int $number_of_parcels NumberOfParcels (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateNumberOfParcels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUpdateNumberOfParcels($id, $api_key, $number_of_parcels, string $contentType = self::contentTypes['orderUpdateNumberOfParcels'][0])
    {
        list($response) = $this->orderUpdateNumberOfParcelsWithHttpInfo($id, $api_key, $number_of_parcels, $contentType);
        return $response;
    }

    /**
     * Operation orderUpdateNumberOfParcelsWithHttpInfo
     *
     * Update Number Of Parcels
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int $number_of_parcels NumberOfParcels (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateNumberOfParcels'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUpdateNumberOfParcelsWithHttpInfo($id, $api_key, $number_of_parcels, string $contentType = self::contentTypes['orderUpdateNumberOfParcels'][0])
    {
        $request = $this->orderUpdateNumberOfParcelsRequest($id, $api_key, $number_of_parcels, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUpdateNumberOfParcelsAsync
     *
     * Update Number Of Parcels
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int $number_of_parcels NumberOfParcels (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateNumberOfParcels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateNumberOfParcelsAsync($id, $api_key, $number_of_parcels, string $contentType = self::contentTypes['orderUpdateNumberOfParcels'][0])
    {
        return $this->orderUpdateNumberOfParcelsAsyncWithHttpInfo($id, $api_key, $number_of_parcels, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUpdateNumberOfParcelsAsyncWithHttpInfo
     *
     * Update Number Of Parcels
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int $number_of_parcels NumberOfParcels (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateNumberOfParcels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateNumberOfParcelsAsyncWithHttpInfo($id, $api_key, $number_of_parcels, string $contentType = self::contentTypes['orderUpdateNumberOfParcels'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUpdateNumberOfParcelsRequest($id, $api_key, $number_of_parcels, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUpdateNumberOfParcels'
     *
     * @param  int $id OrderId (required)
     * @param  string $api_key API Auth Key (required)
     * @param  int $number_of_parcels NumberOfParcels (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateNumberOfParcels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUpdateNumberOfParcelsRequest($id, $api_key, $number_of_parcels, string $contentType = self::contentTypes['orderUpdateNumberOfParcels'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUpdateNumberOfParcels'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUpdateNumberOfParcels'
            );
        }

        // verify the required parameter 'number_of_parcels' is set
        if ($number_of_parcels === null || (is_array($number_of_parcels) && count($number_of_parcels) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $number_of_parcels when calling orderUpdateNumberOfParcels'
            );
        }


        $resourcePath = '/api/Order/{id}/UpdateNumberOfParcels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $number_of_parcels,
            'NumberOfParcels', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUpdateOrder
     *
     * Update Order Details
     *
     * @param  int $id id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder $order order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUpdateOrder($id, $api_key, $order, string $contentType = self::contentTypes['orderUpdateOrder'][0])
    {
        list($response) = $this->orderUpdateOrderWithHttpInfo($id, $api_key, $order, $contentType);
        return $response;
    }

    /**
     * Operation orderUpdateOrderWithHttpInfo
     *
     * Update Order Details
     *
     * @param  int $id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrder'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUpdateOrderWithHttpInfo($id, $api_key, $order, string $contentType = self::contentTypes['orderUpdateOrder'][0])
    {
        $request = $this->orderUpdateOrderRequest($id, $api_key, $order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUpdateOrderAsync
     *
     * Update Order Details
     *
     * @param  int $id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateOrderAsync($id, $api_key, $order, string $contentType = self::contentTypes['orderUpdateOrder'][0])
    {
        return $this->orderUpdateOrderAsyncWithHttpInfo($id, $api_key, $order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUpdateOrderAsyncWithHttpInfo
     *
     * Update Order Details
     *
     * @param  int $id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateOrderAsyncWithHttpInfo($id, $api_key, $order, string $contentType = self::contentTypes['orderUpdateOrder'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUpdateOrderRequest($id, $api_key, $order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUpdateOrder'
     *
     * @param  int $id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder $order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUpdateOrderRequest($id, $api_key, $order, string $contentType = self::contentTypes['orderUpdateOrder'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUpdateOrder'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUpdateOrder'
            );
        }

        // verify the required parameter 'order' is set
        if ($order === null || (is_array($order) && count($order) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order when calling orderUpdateOrder'
            );
        }


        $resourcePath = '/api/Order/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order));
            } else {
                $httpBody = $order;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUpdateOrderItem
     *
     * Update Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUpdateOrderItem($id, $item_id, $api_key, $order_item, string $contentType = self::contentTypes['orderUpdateOrderItem'][0])
    {
        list($response) = $this->orderUpdateOrderItemWithHttpInfo($id, $item_id, $api_key, $order_item, $contentType);
        return $response;
    }

    /**
     * Operation orderUpdateOrderItemWithHttpInfo
     *
     * Update Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrderItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUpdateOrderItemWithHttpInfo($id, $item_id, $api_key, $order_item, string $contentType = self::contentTypes['orderUpdateOrderItem'][0])
    {
        $request = $this->orderUpdateOrderItemRequest($id, $item_id, $api_key, $order_item, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUpdateOrderItemAsync
     *
     * Update Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateOrderItemAsync($id, $item_id, $api_key, $order_item, string $contentType = self::contentTypes['orderUpdateOrderItem'][0])
    {
        return $this->orderUpdateOrderItemAsyncWithHttpInfo($id, $item_id, $api_key, $order_item, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUpdateOrderItemAsyncWithHttpInfo
     *
     * Update Order Item
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUpdateOrderItemAsyncWithHttpInfo($id, $item_id, $api_key, $order_item, string $contentType = self::contentTypes['orderUpdateOrderItem'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUpdateOrderItemRequest($id, $item_id, $api_key, $order_item, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUpdateOrderItem'
     *
     * @param  int $id OrderId (required)
     * @param  int $item_id (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem $order_item (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUpdateOrderItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUpdateOrderItemRequest($id, $item_id, $api_key, $order_item, string $contentType = self::contentTypes['orderUpdateOrderItem'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUpdateOrderItem'
            );
        }

        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling orderUpdateOrderItem'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUpdateOrderItem'
            );
        }

        // verify the required parameter 'order_item' is set
        if ($order_item === null || (is_array($order_item) && count($order_item) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_item when calling orderUpdateOrderItem'
            );
        }


        $resourcePath = '/api/Order/{id}/Items/{ItemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemId' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_item)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_item));
            } else {
                $httpBody = $order_item;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUploadConnectAction
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction $order_shipment order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUploadConnectAction($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadConnectAction'][0])
    {
        list($response) = $this->orderUploadConnectActionWithHttpInfo($id, $api_key, $order_shipment, $contentType);
        return $response;
    }

    /**
     * Operation orderUploadConnectActionWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUploadConnectActionWithHttpInfo($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadConnectAction'][0])
    {
        $request = $this->orderUploadConnectActionRequest($id, $api_key, $order_shipment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUploadConnectActionAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadConnectActionAsync($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadConnectAction'][0])
    {
        return $this->orderUploadConnectActionAsyncWithHttpInfo($id, $api_key, $order_shipment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUploadConnectActionAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadConnectActionAsyncWithHttpInfo($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadConnectAction'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUploadConnectActionRequest($id, $api_key, $order_shipment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUploadConnectAction'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUploadConnectActionRequest($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadConnectAction'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUploadConnectAction'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUploadConnectAction'
            );
        }

        // verify the required parameter 'order_shipment' is set
        if ($order_shipment === null || (is_array($order_shipment) && count($order_shipment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_shipment when calling orderUploadConnectAction'
            );
        }


        $resourcePath = '/api/Order/{id}/ConnectActions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_shipment)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_shipment));
            } else {
                $httpBody = $order_shipment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUploadOrderDocument
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  bool $print_with_order print_with_order (required)
     * @param  int $document_type_id document_type_id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument $order_document order_document (required)
     * @param  int|null $paper_size paper_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderDocument'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUploadOrderDocument($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size = null, string $contentType = self::contentTypes['orderUploadOrderDocument'][0])
    {
        list($response) = $this->orderUploadOrderDocumentWithHttpInfo($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size, $contentType);
        return $response;
    }

    /**
     * Operation orderUploadOrderDocumentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  bool $print_with_order (required)
     * @param  int $document_type_id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument $order_document (required)
     * @param  int|null $paper_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderDocument'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUploadOrderDocumentWithHttpInfo($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size = null, string $contentType = self::contentTypes['orderUploadOrderDocument'][0])
    {
        $request = $this->orderUploadOrderDocumentRequest($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUploadOrderDocumentAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  bool $print_with_order (required)
     * @param  int $document_type_id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument $order_document (required)
     * @param  int|null $paper_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadOrderDocumentAsync($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size = null, string $contentType = self::contentTypes['orderUploadOrderDocument'][0])
    {
        return $this->orderUploadOrderDocumentAsyncWithHttpInfo($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUploadOrderDocumentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  bool $print_with_order (required)
     * @param  int $document_type_id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument $order_document (required)
     * @param  int|null $paper_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadOrderDocumentAsyncWithHttpInfo($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size = null, string $contentType = self::contentTypes['orderUploadOrderDocument'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUploadOrderDocumentRequest($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUploadOrderDocument'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  bool $print_with_order (required)
     * @param  int $document_type_id (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument $order_document (required)
     * @param  int|null $paper_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUploadOrderDocumentRequest($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size = null, string $contentType = self::contentTypes['orderUploadOrderDocument'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUploadOrderDocument'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUploadOrderDocument'
            );
        }

        // verify the required parameter 'print_with_order' is set
        if ($print_with_order === null || (is_array($print_with_order) && count($print_with_order) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $print_with_order when calling orderUploadOrderDocument'
            );
        }

        // verify the required parameter 'document_type_id' is set
        if ($document_type_id === null || (is_array($document_type_id) && count($document_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_type_id when calling orderUploadOrderDocument'
            );
        }

        // verify the required parameter 'order_document' is set
        if ($order_document === null || (is_array($order_document) && count($order_document) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_document when calling orderUploadOrderDocument'
            );
        }



        $resourcePath = '/api/Order/{id}/Documents';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $print_with_order,
            'PrintWithOrder', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $document_type_id,
            'DocumentTypeId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $paper_size,
            'PaperSize', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_document)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_document));
            } else {
                $httpBody = $order_document;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation orderUploadOrderShipment
     *
     * @param  int $id id (required)
     * @param  string $api_key api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment $order_shipment order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function orderUploadOrderShipment($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadOrderShipment'][0])
    {
        list($response) = $this->orderUploadOrderShipmentWithHttpInfo($id, $api_key, $order_shipment, $contentType);
        return $response;
    }

    /**
     * Operation orderUploadOrderShipmentWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderShipment'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function orderUploadOrderShipmentWithHttpInfo($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadOrderShipment'][0])
    {
        $request = $this->orderUploadOrderShipmentRequest($id, $api_key, $order_shipment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation orderUploadOrderShipmentAsync
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadOrderShipmentAsync($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadOrderShipment'][0])
    {
        return $this->orderUploadOrderShipmentAsyncWithHttpInfo($id, $api_key, $order_shipment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation orderUploadOrderShipmentAsyncWithHttpInfo
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function orderUploadOrderShipmentAsyncWithHttpInfo($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadOrderShipment'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->orderUploadOrderShipmentRequest($id, $api_key, $order_shipment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'orderUploadOrderShipment'
     *
     * @param  int $id (required)
     * @param  string $api_key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment $order_shipment (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['orderUploadOrderShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function orderUploadOrderShipmentRequest($id, $api_key, $order_shipment, string $contentType = self::contentTypes['orderUploadOrderShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling orderUploadOrderShipment'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling orderUploadOrderShipment'
            );
        }

        // verify the required parameter 'order_shipment' is set
        if ($order_shipment === null || (is_array($order_shipment) && count($order_shipment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_shipment when calling orderUploadOrderShipment'
            );
        }


        $resourcePath = '/api/Order/{id}/Shipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_shipment)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_shipment));
            } else {
                $httpBody = $order_shipment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
