<?php
/**
 * ClientApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * ClientApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ClientApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'clientAddSubClient' => [
            'application/json',
            'text/json',
        ],
        'clientGet' => [
            'application/json',
        ],
        'clientSubClients' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation clientAddSubClient
     *
     * Add SubClient
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient $client client (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientAddSubClient'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function clientAddSubClient($api_key, $client, string $contentType = self::contentTypes['clientAddSubClient'][0])
    {
        list($response) = $this->clientAddSubClientWithHttpInfo($api_key, $client, $contentType);
        return $response;
    }

    /**
     * Operation clientAddSubClientWithHttpInfo
     *
     * Add SubClient
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient $client (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientAddSubClient'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientAddSubClientWithHttpInfo($api_key, $client, string $contentType = self::contentTypes['clientAddSubClient'][0])
    {
        $request = $this->clientAddSubClientRequest($api_key, $client, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation clientAddSubClientAsync
     *
     * Add SubClient
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient $client (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientAddSubClient'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientAddSubClientAsync($api_key, $client, string $contentType = self::contentTypes['clientAddSubClient'][0])
    {
        return $this->clientAddSubClientAsyncWithHttpInfo($api_key, $client, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientAddSubClientAsyncWithHttpInfo
     *
     * Add SubClient
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient $client (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientAddSubClient'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientAddSubClientAsyncWithHttpInfo($api_key, $client, string $contentType = self::contentTypes['clientAddSubClient'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->clientAddSubClientRequest($api_key, $client, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientAddSubClient'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient $client (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientAddSubClient'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clientAddSubClientRequest($api_key, $client, string $contentType = self::contentTypes['clientAddSubClient'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling clientAddSubClient'
            );
        }

        // verify the required parameter 'client' is set
        if ($client === null || (is_array($client) && count($client) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $client when calling clientAddSubClient'
            );
        }


        $resourcePath = '/api/Client/SubClients';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($client)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($client));
            } else {
                $httpBody = $client;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation clientGet
     *
     * Get Clients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function clientGet($api_key, string $contentType = self::contentTypes['clientGet'][0])
    {
        $this->clientGetWithHttpInfo($api_key, $contentType);
    }

    /**
     * Operation clientGetWithHttpInfo
     *
     * Get Clients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientGet'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientGetWithHttpInfo($api_key, string $contentType = self::contentTypes['clientGet'][0])
    {
        $request = $this->clientGetRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation clientGetAsync
     *
     * Get Clients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientGetAsync($api_key, string $contentType = self::contentTypes['clientGet'][0])
    {
        return $this->clientGetAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientGetAsyncWithHttpInfo
     *
     * Get Clients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientGetAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['clientGet'][0])
    {
        $returnType = '';
        $request = $this->clientGetRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientGet'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clientGetRequest($api_key, string $contentType = self::contentTypes['clientGet'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling clientGet'
            );
        }


        $resourcePath = '/api/Client';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation clientSubClients
     *
     * Get a list of SubClients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientSubClients'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]
     */
    public function clientSubClients($api_key, string $contentType = self::contentTypes['clientSubClients'][0])
    {
        list($response) = $this->clientSubClientsWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation clientSubClientsWithHttpInfo
     *
     * Get a list of SubClients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientSubClients'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[], HTTP status code, HTTP response headers (array of strings)
     */
    public function clientSubClientsWithHttpInfo($api_key, string $contentType = self::contentTypes['clientSubClients'][0])
    {
        $request = $this->clientSubClientsRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation clientSubClientsAsync
     *
     * Get a list of SubClients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientSubClients'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientSubClientsAsync($api_key, string $contentType = self::contentTypes['clientSubClients'][0])
    {
        return $this->clientSubClientsAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientSubClientsAsyncWithHttpInfo
     *
     * Get a list of SubClients
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientSubClients'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function clientSubClientsAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['clientSubClients'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]';
        $request = $this->clientSubClientsRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientSubClients'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['clientSubClients'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function clientSubClientsRequest($api_key, string $contentType = self::contentTypes['clientSubClients'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling clientSubClients'
            );
        }


        $resourcePath = '/api/Client/SubClients';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
