<?php
/**
 * ASNApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Mintsoft\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Mintsoft\ApiException;
use Mintsoft\Configuration;
use Mintsoft\FormDataProcessor;
use Mintsoft\HeaderSelector;
use Mintsoft\ObjectSerializer;

/**
 * ASNApi Class Doc Comment
 *
 * @category Class
 * @package  Mintsoft
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ASNApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'aSNBookInASN' => [
            'application/json',
        ],
        'aSNBookInASNPartial' => [
            'application/json',
        ],
        'aSNConfirmASN' => [
            'application/json',
        ],
        'aSNCreateASN' => [
            'application/json',
            'text/json',
        ],
        'aSNDeleteASN' => [
            'application/json',
        ],
        'aSNGetASN' => [
            'application/json',
        ],
        'aSNGetGoodsInTypes' => [
            'application/json',
        ],
        'aSNGetPaperwork' => [
            'application/json',
        ],
        'aSNGetStatuses' => [
            'application/json',
        ],
        'aSNListASNs' => [
            'application/json',
        ],
        'aSNPartBook' => [
            'application/json',
        ],
        'aSNReceiveItem' => [
            'application/json',
            'text/json',
        ],
        'aSNUpdateASN' => [
            'application/json',
            'text/json',
        ],
        'aSNUploadConnectAction' => [
            'application/json',
            'text/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation aSNBookInASN
     *
     * Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNBookInASN($id, $api_key, string $contentType = self::contentTypes['aSNBookInASN'][0])
    {
        list($response) = $this->aSNBookInASNWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNBookInASNWithHttpInfo
     *
     * Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNBookInASNWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNBookInASN'][0])
    {
        $request = $this->aSNBookInASNRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNBookInASNAsync
     *
     * Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNBookInASNAsync($id, $api_key, string $contentType = self::contentTypes['aSNBookInASN'][0])
    {
        return $this->aSNBookInASNAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNBookInASNAsyncWithHttpInfo
     *
     * Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNBookInASNAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNBookInASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNBookInASNRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNBookInASN'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNBookInASNRequest($id, $api_key, string $contentType = self::contentTypes['aSNBookInASN'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNBookInASN'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNBookInASN'
            );
        }


        $resourcePath = '/api/ASN/{id}/BookIn';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNBookInASNPartial
     *
     * Book In  Partial ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASNPartial'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNBookInASNPartial($id, $api_key, string $contentType = self::contentTypes['aSNBookInASNPartial'][0])
    {
        list($response) = $this->aSNBookInASNPartialWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNBookInASNPartialWithHttpInfo
     *
     * Book In  Partial ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASNPartial'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNBookInASNPartialWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNBookInASNPartial'][0])
    {
        $request = $this->aSNBookInASNPartialRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNBookInASNPartialAsync
     *
     * Book In  Partial ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASNPartial'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNBookInASNPartialAsync($id, $api_key, string $contentType = self::contentTypes['aSNBookInASNPartial'][0])
    {
        return $this->aSNBookInASNPartialAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNBookInASNPartialAsyncWithHttpInfo
     *
     * Book In  Partial ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASNPartial'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNBookInASNPartialAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNBookInASNPartial'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNBookInASNPartialRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNBookInASNPartial'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNBookInASNPartial'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNBookInASNPartialRequest($id, $api_key, string $contentType = self::contentTypes['aSNBookInASNPartial'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNBookInASNPartial'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNBookInASNPartial'
            );
        }


        $resourcePath = '/api/ASN/{id}/BookInPartial';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNConfirmASN
     *
     * Confirm ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNConfirmASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNConfirmASN($id, $api_key, string $contentType = self::contentTypes['aSNConfirmASN'][0])
    {
        list($response) = $this->aSNConfirmASNWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNConfirmASNWithHttpInfo
     *
     * Confirm ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNConfirmASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNConfirmASNWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNConfirmASN'][0])
    {
        $request = $this->aSNConfirmASNRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNConfirmASNAsync
     *
     * Confirm ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNConfirmASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNConfirmASNAsync($id, $api_key, string $contentType = self::contentTypes['aSNConfirmASN'][0])
    {
        return $this->aSNConfirmASNAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNConfirmASNAsyncWithHttpInfo
     *
     * Confirm ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNConfirmASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNConfirmASNAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNConfirmASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNConfirmASNRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNConfirmASN'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNConfirmASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNConfirmASNRequest($id, $api_key, string $contentType = self::contentTypes['aSNConfirmASN'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNConfirmASN'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNConfirmASN'
            );
        }


        $resourcePath = '/api/ASN/{id}/Confirm';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNCreateASN
     *
     * Create new ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn ASN Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNCreateASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNCreateASN($api_key, $asn, string $contentType = self::contentTypes['aSNCreateASN'][0])
    {
        list($response) = $this->aSNCreateASNWithHttpInfo($api_key, $asn, $contentType);
        return $response;
    }

    /**
     * Operation aSNCreateASNWithHttpInfo
     *
     * Create new ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn ASN Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNCreateASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNCreateASNWithHttpInfo($api_key, $asn, string $contentType = self::contentTypes['aSNCreateASN'][0])
    {
        $request = $this->aSNCreateASNRequest($api_key, $asn, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNCreateASNAsync
     *
     * Create new ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn ASN Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNCreateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNCreateASNAsync($api_key, $asn, string $contentType = self::contentTypes['aSNCreateASN'][0])
    {
        return $this->aSNCreateASNAsyncWithHttpInfo($api_key, $asn, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNCreateASNAsyncWithHttpInfo
     *
     * Create new ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn ASN Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNCreateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNCreateASNAsyncWithHttpInfo($api_key, $asn, string $contentType = self::contentTypes['aSNCreateASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNCreateASNRequest($api_key, $asn, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNCreateASN'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn ASN Json in the Body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNCreateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNCreateASNRequest($api_key, $asn, string $contentType = self::contentTypes['aSNCreateASN'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNCreateASN'
            );
        }

        // verify the required parameter 'asn' is set
        if ($asn === null || (is_array($asn) && count($asn) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $asn when calling aSNCreateASN'
            );
        }


        $resourcePath = '/api/ASN';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($asn)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($asn));
            } else {
                $httpBody = $asn;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNDeleteASN
     *
     * Delete ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNDeleteASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNDeleteASN($id, $api_key, string $contentType = self::contentTypes['aSNDeleteASN'][0])
    {
        list($response) = $this->aSNDeleteASNWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNDeleteASNWithHttpInfo
     *
     * Delete ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNDeleteASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNDeleteASNWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNDeleteASN'][0])
    {
        $request = $this->aSNDeleteASNRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNDeleteASNAsync
     *
     * Delete ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNDeleteASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNDeleteASNAsync($id, $api_key, string $contentType = self::contentTypes['aSNDeleteASN'][0])
    {
        return $this->aSNDeleteASNAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNDeleteASNAsyncWithHttpInfo
     *
     * Delete ASN
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNDeleteASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNDeleteASNAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNDeleteASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNDeleteASNRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNDeleteASN'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNDeleteASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNDeleteASNRequest($id, $api_key, string $contentType = self::contentTypes['aSNDeleteASN'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNDeleteASN'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNDeleteASN'
            );
        }


        $resourcePath = '/api/ASN/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNGetASN
     *
     * Get ASN(Advanced Shipping Notice)
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockASN
     */
    public function aSNGetASN($id, $api_key, string $contentType = self::contentTypes['aSNGetASN'][0])
    {
        list($response) = $this->aSNGetASNWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNGetASNWithHttpInfo
     *
     * Get ASN(Advanced Shipping Notice)
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockASN, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNGetASNWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNGetASN'][0])
    {
        $request = $this->aSNGetASNRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockASN',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockASN',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockASN',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNGetASNAsync
     *
     * Get ASN(Advanced Shipping Notice)
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetASNAsync($id, $api_key, string $contentType = self::contentTypes['aSNGetASN'][0])
    {
        return $this->aSNGetASNAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNGetASNAsyncWithHttpInfo
     *
     * Get ASN(Advanced Shipping Notice)
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetASNAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNGetASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockASN';
        $request = $this->aSNGetASNRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNGetASN'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNGetASNRequest($id, $api_key, string $contentType = self::contentTypes['aSNGetASN'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNGetASN'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNGetASN'
            );
        }


        $resourcePath = '/api/ASN/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNGetGoodsInTypes
     *
     * Get Goods In Types
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetGoodsInTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
     */
    public function aSNGetGoodsInTypes($api_key, string $contentType = self::contentTypes['aSNGetGoodsInTypes'][0])
    {
        list($response) = $this->aSNGetGoodsInTypesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNGetGoodsInTypesWithHttpInfo
     *
     * Get Goods In Types
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetGoodsInTypes'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[], HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNGetGoodsInTypesWithHttpInfo($api_key, string $contentType = self::contentTypes['aSNGetGoodsInTypes'][0])
    {
        $request = $this->aSNGetGoodsInTypesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNGetGoodsInTypesAsync
     *
     * Get Goods In Types
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetGoodsInTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetGoodsInTypesAsync($api_key, string $contentType = self::contentTypes['aSNGetGoodsInTypes'][0])
    {
        return $this->aSNGetGoodsInTypesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNGetGoodsInTypesAsyncWithHttpInfo
     *
     * Get Goods In Types
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetGoodsInTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetGoodsInTypesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['aSNGetGoodsInTypes'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]';
        $request = $this->aSNGetGoodsInTypesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNGetGoodsInTypes'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetGoodsInTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNGetGoodsInTypesRequest($api_key, string $contentType = self::contentTypes['aSNGetGoodsInTypes'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNGetGoodsInTypes'
            );
        }


        $resourcePath = '/api/ASN/GoodsInTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNGetPaperwork
     *
     * Get ASN Paperwork
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetPaperwork'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function aSNGetPaperwork($id, $api_key, string $contentType = self::contentTypes['aSNGetPaperwork'][0])
    {
        list($response) = $this->aSNGetPaperworkWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNGetPaperworkWithHttpInfo
     *
     * Get ASN Paperwork
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetPaperwork'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNGetPaperworkWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNGetPaperwork'][0])
    {
        $request = $this->aSNGetPaperworkRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNGetPaperworkAsync
     *
     * Get ASN Paperwork
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetPaperwork'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetPaperworkAsync($id, $api_key, string $contentType = self::contentTypes['aSNGetPaperwork'][0])
    {
        return $this->aSNGetPaperworkAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNGetPaperworkAsyncWithHttpInfo
     *
     * Get ASN Paperwork
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetPaperwork'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetPaperworkAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNGetPaperwork'][0])
    {
        $returnType = 'string';
        $request = $this->aSNGetPaperworkRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNGetPaperwork'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetPaperwork'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNGetPaperworkRequest($id, $api_key, string $contentType = self::contentTypes['aSNGetPaperwork'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNGetPaperwork'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNGetPaperwork'
            );
        }


        $resourcePath = '/api/ASN/{id}/Paperwork';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNGetStatuses
     *
     * Get ASN Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockASNStatus[]
     */
    public function aSNGetStatuses($api_key, string $contentType = self::contentTypes['aSNGetStatuses'][0])
    {
        list($response) = $this->aSNGetStatusesWithHttpInfo($api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNGetStatusesWithHttpInfo
     *
     * Get ASN Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetStatuses'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockASNStatus[], HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNGetStatusesWithHttpInfo($api_key, string $contentType = self::contentTypes['aSNGetStatuses'][0])
    {
        $request = $this->aSNGetStatusesRequest($api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockASNStatus[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockASNStatus[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockASNStatus[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNGetStatusesAsync
     *
     * Get ASN Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetStatusesAsync($api_key, string $contentType = self::contentTypes['aSNGetStatuses'][0])
    {
        return $this->aSNGetStatusesAsyncWithHttpInfo($api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNGetStatusesAsyncWithHttpInfo
     *
     * Get ASN Statuses
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNGetStatusesAsyncWithHttpInfo($api_key, string $contentType = self::contentTypes['aSNGetStatuses'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockASNStatus[]';
        $request = $this->aSNGetStatusesRequest($api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNGetStatuses'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNGetStatuses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNGetStatusesRequest($api_key, string $contentType = self::contentTypes['aSNGetStatuses'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNGetStatuses'
            );
        }


        $resourcePath = '/api/ASN/Statuses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNListASNs
     *
     * List Of ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $asn_status_id ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses (optional)
     * @param  int|null $client_id ClientId - Filter by ClientId - 3PL Admin Users Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Result to be returned - Default 100 - Max 100 (optional)
     * @param  int|null $warehouse_id Filter by WarehouseId (optional)
     * @param  \DateTime|null $since_last_updated Filter by any ASNs that have been Updated Since supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_start_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_end_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  bool|null $include_asn_items Request the ASN items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNListASNs'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesStockASN[]
     */
    public function aSNListASNs($api_key, $asn_status_id = null, $client_id = null, $page_no = null, $limit = null, $warehouse_id = null, $since_last_updated = null, $booked_in_start_interval = null, $booked_in_end_interval = null, $include_asn_items = null, string $contentType = self::contentTypes['aSNListASNs'][0])
    {
        list($response) = $this->aSNListASNsWithHttpInfo($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items, $contentType);
        return $response;
    }

    /**
     * Operation aSNListASNsWithHttpInfo
     *
     * List Of ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $asn_status_id ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses (optional)
     * @param  int|null $client_id ClientId - Filter by ClientId - 3PL Admin Users Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Result to be returned - Default 100 - Max 100 (optional)
     * @param  int|null $warehouse_id Filter by WarehouseId (optional)
     * @param  \DateTime|null $since_last_updated Filter by any ASNs that have been Updated Since supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_start_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_end_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  bool|null $include_asn_items Request the ASN items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNListASNs'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesStockASN[], HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNListASNsWithHttpInfo($api_key, $asn_status_id = null, $client_id = null, $page_no = null, $limit = null, $warehouse_id = null, $since_last_updated = null, $booked_in_start_interval = null, $booked_in_end_interval = null, $include_asn_items = null, string $contentType = self::contentTypes['aSNListASNs'][0])
    {
        $request = $this->aSNListASNsRequest($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesStockASN[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesStockASN[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesStockASN[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNListASNsAsync
     *
     * List Of ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $asn_status_id ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses (optional)
     * @param  int|null $client_id ClientId - Filter by ClientId - 3PL Admin Users Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Result to be returned - Default 100 - Max 100 (optional)
     * @param  int|null $warehouse_id Filter by WarehouseId (optional)
     * @param  \DateTime|null $since_last_updated Filter by any ASNs that have been Updated Since supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_start_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_end_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  bool|null $include_asn_items Request the ASN items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNListASNs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNListASNsAsync($api_key, $asn_status_id = null, $client_id = null, $page_no = null, $limit = null, $warehouse_id = null, $since_last_updated = null, $booked_in_start_interval = null, $booked_in_end_interval = null, $include_asn_items = null, string $contentType = self::contentTypes['aSNListASNs'][0])
    {
        return $this->aSNListASNsAsyncWithHttpInfo($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNListASNsAsyncWithHttpInfo
     *
     * List Of ASN(Advanced Shipping Notice)
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $asn_status_id ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses (optional)
     * @param  int|null $client_id ClientId - Filter by ClientId - 3PL Admin Users Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Result to be returned - Default 100 - Max 100 (optional)
     * @param  int|null $warehouse_id Filter by WarehouseId (optional)
     * @param  \DateTime|null $since_last_updated Filter by any ASNs that have been Updated Since supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_start_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_end_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  bool|null $include_asn_items Request the ASN items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNListASNs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNListASNsAsyncWithHttpInfo($api_key, $asn_status_id = null, $client_id = null, $page_no = null, $limit = null, $warehouse_id = null, $since_last_updated = null, $booked_in_start_interval = null, $booked_in_end_interval = null, $include_asn_items = null, string $contentType = self::contentTypes['aSNListASNs'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesStockASN[]';
        $request = $this->aSNListASNsRequest($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNListASNs'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  string|null $asn_status_id ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses (optional)
     * @param  int|null $client_id ClientId - Filter by ClientId - 3PL Admin Users Only (optional)
     * @param  int|null $page_no Page No - Default 1 (optional)
     * @param  int|null $limit Number of Result to be returned - Default 100 - Max 100 (optional)
     * @param  int|null $warehouse_id Filter by WarehouseId (optional)
     * @param  \DateTime|null $since_last_updated Filter by any ASNs that have been Updated Since supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_start_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  \DateTime|null $booked_in_end_interval Filter by any ASNs that have been booked supplied Timestamp (optional)
     * @param  bool|null $include_asn_items Request the ASN items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNListASNs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNListASNsRequest($api_key, $asn_status_id = null, $client_id = null, $page_no = null, $limit = null, $warehouse_id = null, $since_last_updated = null, $booked_in_start_interval = null, $booked_in_end_interval = null, $include_asn_items = null, string $contentType = self::contentTypes['aSNListASNs'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNListASNs'
            );
        }











        $resourcePath = '/api/ASN/List';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $asn_status_id,
            'ASNStatusId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $client_id,
            'ClientId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_no,
            'PageNo', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'Limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_id,
            'WarehouseId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since_last_updated,
            'SinceLastUpdated', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $booked_in_start_interval,
            'BookedInStartInterval', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $booked_in_end_interval,
            'BookedInEndInterval', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_asn_items,
            'IncludeASNItems', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNPartBook
     *
     * Part Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNPartBook'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNPartBook($id, $api_key, string $contentType = self::contentTypes['aSNPartBook'][0])
    {
        list($response) = $this->aSNPartBookWithHttpInfo($id, $api_key, $contentType);
        return $response;
    }

    /**
     * Operation aSNPartBookWithHttpInfo
     *
     * Part Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNPartBook'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNPartBookWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNPartBook'][0])
    {
        $request = $this->aSNPartBookRequest($id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNPartBookAsync
     *
     * Part Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNPartBook'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNPartBookAsync($id, $api_key, string $contentType = self::contentTypes['aSNPartBook'][0])
    {
        return $this->aSNPartBookAsyncWithHttpInfo($id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNPartBookAsyncWithHttpInfo
     *
     * Part Book In ASN - Admin Only
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNPartBook'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNPartBookAsyncWithHttpInfo($id, $api_key, string $contentType = self::contentTypes['aSNPartBook'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNPartBookRequest($id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNPartBook'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNPartBook'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNPartBookRequest($id, $api_key, string $contentType = self::contentTypes['aSNPartBook'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNPartBook'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNPartBook'
            );
        }


        $resourcePath = '/api/ASN/{id}/PartBook';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNReceiveItem
     *
     * ASN - Receive Items
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] $items Json list of the Items being receieved in the body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNReceiveItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNReceiveItem($api_key, $id, $items, string $contentType = self::contentTypes['aSNReceiveItem'][0])
    {
        list($response) = $this->aSNReceiveItemWithHttpInfo($api_key, $id, $items, $contentType);
        return $response;
    }

    /**
     * Operation aSNReceiveItemWithHttpInfo
     *
     * ASN - Receive Items
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] $items Json list of the Items being receieved in the body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNReceiveItem'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNReceiveItemWithHttpInfo($api_key, $id, $items, string $contentType = self::contentTypes['aSNReceiveItem'][0])
    {
        $request = $this->aSNReceiveItemRequest($api_key, $id, $items, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNReceiveItemAsync
     *
     * ASN - Receive Items
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] $items Json list of the Items being receieved in the body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNReceiveItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNReceiveItemAsync($api_key, $id, $items, string $contentType = self::contentTypes['aSNReceiveItem'][0])
    {
        return $this->aSNReceiveItemAsyncWithHttpInfo($api_key, $id, $items, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNReceiveItemAsyncWithHttpInfo
     *
     * ASN - Receive Items
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] $items Json list of the Items being receieved in the body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNReceiveItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNReceiveItemAsyncWithHttpInfo($api_key, $id, $items, string $contentType = self::contentTypes['aSNReceiveItem'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNReceiveItemRequest($api_key, $id, $items, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNReceiveItem'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] $items Json list of the Items being receieved in the body of the request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNReceiveItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNReceiveItemRequest($api_key, $id, $items, string $contentType = self::contentTypes['aSNReceiveItem'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNReceiveItem'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNReceiveItem'
            );
        }

        // verify the required parameter 'items' is set
        if ($items === null || (is_array($items) && count($items) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $items when calling aSNReceiveItem'
            );
        }


        $resourcePath = '/api/ASN/{id}/Items/Receive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($items)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($items));
            } else {
                $httpBody = $items;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNUpdateASN
     *
     * Update ASN Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn asn (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUpdateASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNUpdateASN($api_key, $id, $asn, string $contentType = self::contentTypes['aSNUpdateASN'][0])
    {
        list($response) = $this->aSNUpdateASNWithHttpInfo($api_key, $id, $asn, $contentType);
        return $response;
    }

    /**
     * Operation aSNUpdateASNWithHttpInfo
     *
     * Update ASN Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUpdateASN'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNUpdateASNWithHttpInfo($api_key, $id, $asn, string $contentType = self::contentTypes['aSNUpdateASN'][0])
    {
        $request = $this->aSNUpdateASNRequest($api_key, $id, $asn, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNUpdateASNAsync
     *
     * Update ASN Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUpdateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNUpdateASNAsync($api_key, $id, $asn, string $contentType = self::contentTypes['aSNUpdateASN'][0])
    {
        return $this->aSNUpdateASNAsyncWithHttpInfo($api_key, $id, $asn, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNUpdateASNAsyncWithHttpInfo
     *
     * Update ASN Details
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUpdateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNUpdateASNAsyncWithHttpInfo($api_key, $id, $asn, string $contentType = self::contentTypes['aSNUpdateASN'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNUpdateASNRequest($api_key, $id, $asn, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNUpdateASN'
     *
     * @param  string $api_key API Auth Key (required)
     * @param  int $id ID of the ASN (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASN $asn (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUpdateASN'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNUpdateASNRequest($api_key, $id, $asn, string $contentType = self::contentTypes['aSNUpdateASN'][0])
    {

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNUpdateASN'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNUpdateASN'
            );
        }

        // verify the required parameter 'asn' is set
        if ($asn === null || (is_array($asn) && count($asn) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $asn when calling aSNUpdateASN'
            );
        }


        $resourcePath = '/api/ASN/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($asn)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($asn));
            } else {
                $httpBody = $asn;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation aSNUploadConnectAction
     *
     * Register ASN Webhook / ASNConnect Action
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction $connect_action Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
     */
    public function aSNUploadConnectAction($id, $api_key, $connect_action, string $contentType = self::contentTypes['aSNUploadConnectAction'][0])
    {
        list($response) = $this->aSNUploadConnectActionWithHttpInfo($id, $api_key, $connect_action, $contentType);
        return $response;
    }

    /**
     * Operation aSNUploadConnectActionWithHttpInfo
     *
     * Register ASN Webhook / ASNConnect Action
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction $connect_action Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \Mintsoft\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function aSNUploadConnectActionWithHttpInfo($id, $api_key, $connect_action, string $contentType = self::contentTypes['aSNUploadConnectAction'][0])
    {
        $request = $this->aSNUploadConnectActionRequest($id, $api_key, $connect_action, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation aSNUploadConnectActionAsync
     *
     * Register ASN Webhook / ASNConnect Action
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction $connect_action Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNUploadConnectActionAsync($id, $api_key, $connect_action, string $contentType = self::contentTypes['aSNUploadConnectAction'][0])
    {
        return $this->aSNUploadConnectActionAsyncWithHttpInfo($id, $api_key, $connect_action, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation aSNUploadConnectActionAsyncWithHttpInfo
     *
     * Register ASN Webhook / ASNConnect Action
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction $connect_action Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function aSNUploadConnectActionAsyncWithHttpInfo($id, $api_key, $connect_action, string $contentType = self::contentTypes['aSNUploadConnectAction'][0])
    {
        $returnType = '\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult';
        $request = $this->aSNUploadConnectActionRequest($id, $api_key, $connect_action, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'aSNUploadConnectAction'
     *
     * @param  int $id ID of the ASN (required)
     * @param  string $api_key API Auth Key (required)
     * @param  \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction $connect_action Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['aSNUploadConnectAction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function aSNUploadConnectActionRequest($id, $api_key, $connect_action, string $contentType = self::contentTypes['aSNUploadConnectAction'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling aSNUploadConnectAction'
            );
        }

        // verify the required parameter 'api_key' is set
        if ($api_key === null || (is_array($api_key) && count($api_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $api_key when calling aSNUploadConnectAction'
            );
        }

        // verify the required parameter 'connect_action' is set
        if ($connect_action === null || (is_array($connect_action) && count($connect_action) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $connect_action when calling aSNUploadConnectAction'
            );
        }


        $resourcePath = '/api/ASN/{id}/ConnectActions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $api_key,
            'APIKey', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($connect_action)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($connect_action));
            } else {
                $httpBody = $connect_action;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
