# Mintsoft\WarehouseApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**warehouseBulkStockMovement()**](WarehouseApi.md#warehouseBulkStockMovement) | **POST** /api/Warehouse/BulkStockMovement |  |
| [**warehouseCancelWarehouseTransfer()**](WarehouseApi.md#warehouseCancelWarehouseTransfer) | **GET** /api/WarehouseTransfer/{id}/Cancel | Cancel WarehouseTransfer |
| [**warehouseConfirmWarehouseTransfer()**](WarehouseApi.md#warehouseConfirmWarehouseTransfer) | **GET** /api/WarehouseTransfer/{id}/Confirm | Confirm WarehouseTransfer |
| [**warehouseCreateWarehouseTransfer()**](WarehouseApi.md#warehouseCreateWarehouseTransfer) | **PUT** /api/WarehouseTransfer | Create new WarehouseTransfer |
| [**warehouseDeleteWarehouseTransfer()**](WarehouseApi.md#warehouseDeleteWarehouseTransfer) | **DELETE** /api/WarehouseTransfer/{id} | Delete WarehouseTransfer |
| [**warehouseGetLocation()**](WarehouseApi.md#warehouseGetLocation) | **GET** /api/Warehouse/{WarehouseId}/Location/{LocationId} |  |
| [**warehouseGetLocationTypes()**](WarehouseApi.md#warehouseGetLocationTypes) | **GET** /api/Warehouse/LocationTypes |  |
| [**warehouseGetLocations()**](WarehouseApi.md#warehouseGetLocations) | **GET** /api/Warehouse/{WarehouseId}/Location/All |  |
| [**warehouseGetStatuses()**](WarehouseApi.md#warehouseGetStatuses) | **GET** /api/WarehouseTransfer/Statuses | Get WarehouseTransfer Statuses |
| [**warehouseGetWarehouseTransfer()**](WarehouseApi.md#warehouseGetWarehouseTransfer) | **GET** /api/WarehouseTransfer/{id} | Get WarehouseTransfer |
| [**warehouseGetWarehouses()**](WarehouseApi.md#warehouseGetWarehouses) | **GET** /api/Warehouse |  |
| [**warehouseListWarehouseTransfers()**](WarehouseApi.md#warehouseListWarehouseTransfers) | **GET** /api/WarehouseTransfer/List |  |
| [**warehouseLookupLocationId()**](WarehouseApi.md#warehouseLookupLocationId) | **GET** /api/Warehouse/{WarehouseId}/Location/LookupLocationId |  |
| [**warehouseStockMovement()**](WarehouseApi.md#warehouseStockMovement) | **POST** /api/Warehouse/StockMovement |  |
| [**warehouseUpdateWarehouseTransfer()**](WarehouseApi.md#warehouseUpdateWarehouseTransfer) | **POST** /api/WarehouseTransfer/{id} | Update WarehouseTransfer Details |


## `warehouseBulkStockMovement()`

```php
warehouseBulkStockMovement($api_key, $action, $requests): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$action = 56; // int
$requests = array(new \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest()); // \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[]

try {
    $result = $apiInstance->warehouseBulkStockMovement($api_key, $action, $requests);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseBulkStockMovement: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **action** | **int**|  | |
| **requests** | [**\Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest[]**](../Model/ToolkitDataClassesWarehouseBookStockRequest.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseCancelWarehouseTransfer()`

```php
warehouseCancelWarehouseTransfer($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Cancel WarehouseTransfer

Cancel WarehouseTransfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the WarehouseTransfer
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->warehouseCancelWarehouseTransfer($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseCancelWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the WarehouseTransfer | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseConfirmWarehouseTransfer()`

```php
warehouseConfirmWarehouseTransfer($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Confirm WarehouseTransfer

Confirm WarehouseTransfer is now ready to be expected in the warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the WarehouseTransfer
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->warehouseConfirmWarehouseTransfer($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseConfirmWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the WarehouseTransfer | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseCreateWarehouseTransfer()`

```php
warehouseCreateWarehouseTransfer($api_key, $warehouse_transfer): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Create new WarehouseTransfer

Used to Creating a new WarehouseTransfer i.e. Advising of a Delivery into the Warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$warehouse_transfer = new \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer(); // \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer | WarehouseTransfer Json in the Body of the request

try {
    $result = $apiInstance->warehouseCreateWarehouseTransfer($api_key, $warehouse_transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseCreateWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **warehouse_transfer** | [**\Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer**](../Model/ToolkitDataClassesWarehouseAPIWarehouseTransfer.md)| WarehouseTransfer Json in the Body of the request | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseDeleteWarehouseTransfer()`

```php
warehouseDeleteWarehouseTransfer($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Delete WarehouseTransfer

Delete WarehouseTransfer - Cannot be undone

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the WarehouseTransfer
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->warehouseDeleteWarehouseTransfer($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseDeleteWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the WarehouseTransfer | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetLocation()`

```php
warehouseGetLocation($api_key, $warehouse_id, $location_id): \Mintsoft\Model\ToolkitDataClassesWarehouseLocation
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$warehouse_id = 56; // int
$location_id = 56; // int

try {
    $result = $apiInstance->warehouseGetLocation($api_key, $warehouse_id, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **warehouse_id** | **int**|  | |
| **location_id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseLocation**](../Model/ToolkitDataClassesWarehouseLocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetLocationTypes()`

```php
warehouseGetLocationTypes($api_key): \Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->warehouseGetLocationTypes($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetLocationTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseLocationType[]**](../Model/ToolkitDataClassesWarehouseLocationType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetLocations()`

```php
warehouseGetLocations($api_key, $warehouse_id): \Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$warehouse_id = 56; // int

try {
    $result = $apiInstance->warehouseGetLocations($api_key, $warehouse_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **warehouse_id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseLocation[]**](../Model/ToolkitDataClassesWarehouseLocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetStatuses()`

```php
warehouseGetStatuses($api_key): string[]
```

Get WarehouseTransfer Statuses

Get a list of Possible WarehouseTransferStatuses within the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->warehouseGetStatuses($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetStatuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

**string[]**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetWarehouseTransfer()`

```php
warehouseGetWarehouseTransfer($id, $api_key): \Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer
```

Get WarehouseTransfer

Get back latest details about an Existing WarehouseTransfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the WarehouseTransfer
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->warehouseGetWarehouseTransfer($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the WarehouseTransfer | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseWarehouseTransfer**](../Model/ToolkitDataClassesWarehouseWarehouseTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseGetWarehouses()`

```php
warehouseGetWarehouses($api_key): \Mintsoft\Model\ToolkitDataClassesStockWarehouse[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->warehouseGetWarehouses($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseGetWarehouses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockWarehouse[]**](../Model/ToolkitDataClassesStockWarehouse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseListWarehouseTransfers()`

```php
warehouseListWarehouseTransfers($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated): \Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$include_warehouse_transfer_items = True; // bool
$warehouse_transfer_statuses = 'warehouse_transfer_statuses_example'; // string
$page_no = 56; // int
$limit = 56; // int
$client_id = 56; // int
$source_warehouse_id = 56; // int
$destination_warehouse_id = 56; // int
$since_last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->warehouseListWarehouseTransfers($api_key, $include_warehouse_transfer_items, $warehouse_transfer_statuses, $page_no, $limit, $client_id, $source_warehouse_id, $destination_warehouse_id, $since_last_updated);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseListWarehouseTransfers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **include_warehouse_transfer_items** | **bool**|  | [optional] |
| **warehouse_transfer_statuses** | **string**|  | [optional] |
| **page_no** | **int**|  | [optional] |
| **limit** | **int**|  | [optional] |
| **client_id** | **int**|  | [optional] |
| **source_warehouse_id** | **int**|  | [optional] |
| **destination_warehouse_id** | **int**|  | [optional] |
| **since_last_updated** | **\DateTime**|  | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseToReturnWarehouseTransfer[]**](../Model/ToolkitDataClassesWarehouseToReturnWarehouseTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseLookupLocationId()`

```php
warehouseLookupLocationId($api_key, $warehouse_id, $location): \Mintsoft\Model\ToolkitDataClassesWarehouseLocation
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$warehouse_id = 56; // int
$location = 'location_example'; // string

try {
    $result = $apiInstance->warehouseLookupLocationId($api_key, $warehouse_id, $location);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseLookupLocationId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **warehouse_id** | **int**|  | |
| **location** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseLocation**](../Model/ToolkitDataClassesWarehouseLocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseStockMovement()`

```php
warehouseStockMovement($api_key, $action, $request): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$action = 56; // int
$request = new \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest(); // \Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest

try {
    $result = $apiInstance->warehouseStockMovement($api_key, $action, $request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseStockMovement: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **action** | **int**|  | |
| **request** | [**\Mintsoft\Model\ToolkitDataClassesWarehouseBookStockRequest**](../Model/ToolkitDataClassesWarehouseBookStockRequest.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `warehouseUpdateWarehouseTransfer()`

```php
warehouseUpdateWarehouseTransfer($api_key, $id, $warehouse_transfer): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Update WarehouseTransfer Details

Update WarehouseTransfer Details for an Existing WarehouseTransfer (Excluding Items)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\WarehouseApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$id = 56; // int | ID of the WarehouseTransfer
$warehouse_transfer = new \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer(); // \Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer

try {
    $result = $apiInstance->warehouseUpdateWarehouseTransfer($api_key, $id, $warehouse_transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseApi->warehouseUpdateWarehouseTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **id** | **int**| ID of the WarehouseTransfer | |
| **warehouse_transfer** | [**\Mintsoft\Model\ToolkitDataClassesWarehouseAPIWarehouseTransfer**](../Model/ToolkitDataClassesWarehouseAPIWarehouseTransfer.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
