# Mintsoft\ReturnApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**returnAddReturnItem()**](ReturnApi.md#returnAddReturnItem) | **POST** /api/Return/{id}/AddItem |  |
| [**returnAllocateItemLocation()**](ReturnApi.md#returnAllocateItemLocation) | **POST** /api/Return/{id}/AllocateItemLocation |  |
| [**returnConfirmReturn()**](ReturnApi.md#returnConfirmReturn) | **POST** /api/Return/{id}/Confirm |  |
| [**returnCreateReturn()**](ReturnApi.md#returnCreateReturn) | **POST** /api/Return/CreateReturn/{OrderId} |  |
| [**returnGetReturn()**](ReturnApi.md#returnGetReturn) | **GET** /api/Return/{id} |  |
| [**returnGetReturnItems()**](ReturnApi.md#returnGetReturnItems) | **GET** /api/Return/{id}/Items |  |
| [**returnGetReturnReasons()**](ReturnApi.md#returnGetReturnReasons) | **GET** /api/Return/Reasons |  |
| [**returnGetReturnsOnDate()**](ReturnApi.md#returnGetReturnsOnDate) | **GET** /api/Return/SearchByDate |  |


## `returnAddReturnItem()`

```php
returnAddReturnItem($api_key, $id, $item): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int
$item = new \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI(); // \Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI

try {
    $result = $apiInstance->returnAddReturnItem($api_key, $id, $item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnAddReturnItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |
| **item** | [**\Mintsoft\Model\ToolkitDataClassesReturnsAPIReturnItemAPI**](../Model/ToolkitDataClassesReturnsAPIReturnItemAPI.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnAllocateItemLocation()`

```php
returnAllocateItemLocation($api_key, $id, $returnitem_id, $quantity, $location_id): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int
$returnitem_id = 56; // int
$quantity = 56; // int
$location_id = 56; // int

try {
    $result = $apiInstance->returnAllocateItemLocation($api_key, $id, $returnitem_id, $quantity, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnAllocateItemLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |
| **returnitem_id** | **int**|  | |
| **quantity** | **int**|  | |
| **location_id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnConfirmReturn()`

```php
returnConfirmReturn($api_key, $id): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->returnConfirmReturn($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnConfirmReturn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnCreateReturn()`

```php
returnCreateReturn($api_key, $order_id): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$order_id = 56; // int

try {
    $result = $apiInstance->returnCreateReturn($api_key, $order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnCreateReturn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **order_id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnGetReturn()`

```php
returnGetReturn($id, $api_key): \Mintsoft\Model\ToolkitDataClassesReturnsReturn
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->returnGetReturn($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnGetReturn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesReturnsReturn**](../Model/ToolkitDataClassesReturnsReturn.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnGetReturnItems()`

```php
returnGetReturnItems($id, $api_key): \Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->returnGetReturnItems($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnGetReturnItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesReturnsReturnItem[]**](../Model/ToolkitDataClassesReturnsReturnItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnGetReturnReasons()`

```php
returnGetReturnReasons($api_key): \Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->returnGetReturnReasons($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnGetReturnReasons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesReturnsReturnReason[]**](../Model/ToolkitDataClassesReturnsReturnReason.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `returnGetReturnsOnDate()`

```php
returnGetReturnsOnDate($api_key, $date): \Mintsoft\Model\ToolkitDataClassesReturnsReturn[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ReturnApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->returnGetReturnsOnDate($api_key, $date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnApi->returnGetReturnsOnDate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **date** | **\DateTime**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesReturnsReturn[]**](../Model/ToolkitDataClassesReturnsReturn.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
