# Mintsoft\RefDataApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**refDataCountries()**](RefDataApi.md#refDataCountries) | **GET** /api/RefData/Countries | Get Countries |
| [**refDataCurrencies()**](RefDataApi.md#refDataCurrencies) | **GET** /api/RefData/Currencies |  |


## `refDataCountries()`

```php
refDataCountries($api_key): \Mintsoft\Model\ToolkitDataClassesCommonCountry[]
```

Get Countries

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\RefDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->refDataCountries($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefDataApi->refDataCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonCountry[]**](../Model/ToolkitDataClassesCommonCountry.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refDataCurrencies()`

```php
refDataCurrencies($api_key): \Mintsoft\Model\ToolkitDataClassesCurrenciesCurrency[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\RefDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->refDataCurrencies($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefDataApi->refDataCurrencies: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCurrenciesCurrency[]**](../Model/ToolkitDataClassesCurrenciesCurrency.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
