# Mintsoft\ProductApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**productAddAddAlt()**](ProductApi.md#productAddAddAlt) | **POST** /api/Product/{id}/AltCodes | Add Alt Code |
| [**productBulkAddCartons()**](ProductApi.md#productBulkAddCartons) | **POST** /api/Product/{id}/Cartons | Bulk Add Cartons |
| [**productBulkOnHandStockUpdate()**](ProductApi.md#productBulkOnHandStockUpdate) | **POST** /api/Product/BulkOnHandStockUpdate | Bulk On Hand Stock Update |
| [**productCreateBundle()**](ProductApi.md#productCreateBundle) | **PUT** /api/Product/Bundle | Create New Bundle |
| [**productCreateProduct()**](ProductApi.md#productCreateProduct) | **PUT** /api/Product | Create New Product |
| [**productCreateSupplier()**](ProductApi.md#productCreateSupplier) | **PUT** /api/Product/Suppliers | Create New Product Supplier |
| [**productDeleteCarton()**](ProductApi.md#productDeleteCarton) | **DELETE** /api/Product/{id}/Carton/{cartonId} | Delete Carton |
| [**productGet()**](ProductApi.md#productGet) | **GET** /api/Product/{id} | Get Product |
| [**productGetAltCodes()**](ProductApi.md#productGetAltCodes) | **GET** /api/Product/{id}/AltCodes | Get Alt Codes |
| [**productGetBundle()**](ProductApi.md#productGetBundle) | **GET** /api/Product/{id}/Bundle | Get Bundle |
| [**productGetCartons()**](ProductApi.md#productGetCartons) | **GET** /api/Product/{id}/Cartons | Get Cartons |
| [**productGetInventory()**](ProductApi.md#productGetInventory) | **GET** /api/Product/{id}/Inventory | Get Inventory Records |
| [**productGetInventoryPreOrderBreakdown()**](ProductApi.md#productGetInventoryPreOrderBreakdown) | **GET** /api/Product/{id}/Inventory/PreOrderBreakdown | Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId |
| [**productGetInventoryPreOrderBreakdownAllWarehouses()**](ProductApi.md#productGetInventoryPreOrderBreakdownAllWarehouses) | **GET** /api/Product/{id}/Inventory/PreOrderBreakdown/All | Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses |
| [**productGetProductChanges()**](ProductApi.md#productGetProductChanges) | **GET** /api/Product/UpdatedSince | Products Updated Since |
| [**productGetStockFlow()**](ProductApi.md#productGetStockFlow) | **GET** /api/Product/{id}/StockFlow | Get Stock Flow Records |
| [**productGetStockFlowFiltered()**](ProductApi.md#productGetStockFlowFiltered) | **GET** /api/Product/{id}/StockFlow/Filtered | Get Stock Flow Records - Filtered |
| [**productGetStockLevels()**](ProductApi.md#productGetStockLevels) | **GET** /api/Product/StockLevels | Get Stock Levels |
| [**productGetStockLevelsUpdatedSince()**](ProductApi.md#productGetStockLevelsUpdatedSince) | **GET** /api/Product/StockLevels/UpdatedSince | Products StockLevels Updated Since |
| [**productListProducts()**](ProductApi.md#productListProducts) | **GET** /api/Product/List | List Products |
| [**productListSuppliers()**](ProductApi.md#productListSuppliers) | **GET** /api/Product/Suppliers | List Product Suppliers |
| [**productLookupProductId()**](ProductApi.md#productLookupProductId) | **GET** /api/Product/LookupProductId | Lookup Product Id |
| [**productSearchBarcode()**](ProductApi.md#productSearchBarcode) | **GET** /api/Product/SearchBarcode | Search Product Barcode |
| [**productSearchProducts()**](ProductApi.md#productSearchProducts) | **GET** /api/Product/Search | Product Search by SKU/Name |
| [**productUpdateProduct()**](ProductApi.md#productUpdateProduct) | **POST** /api/Product | Update Product |


## `productAddAddAlt()`

```php
productAddAddAlt($id, $api_key, $sku, $connect_mapping_type)
```

Add Alt Code

Add an AltCode against a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key
$sku = 'sku_example'; // string | The Alternative SKU you want to add
$connect_mapping_type = 'connect_mapping_type_example'; // string | The Type e.g. Amazon, Ebay, API etc

try {
    $apiInstance->productAddAddAlt($id, $api_key, $sku, $connect_mapping_type);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productAddAddAlt: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |
| **sku** | **string**| The Alternative SKU you want to add | |
| **connect_mapping_type** | **string**| The Type e.g. Amazon, Ebay, API etc | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productBulkAddCartons()`

```php
productBulkAddCartons($id, $api_key, $cartons)
```

Bulk Add Cartons

Add Cartons against a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key
$cartons = array(new \Mintsoft\Model\ToolkitDataClassesStockProductContainer()); // \Mintsoft\Model\ToolkitDataClassesStockProductContainer[]

try {
    $apiInstance->productBulkAddCartons($id, $api_key, $cartons);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productBulkAddCartons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |
| **cartons** | [**\Mintsoft\Model\ToolkitDataClassesStockProductContainer[]**](../Model/ToolkitDataClassesStockProductContainer.md)|  | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productBulkOnHandStockUpdate()`

```php
productBulkOnHandStockUpdate($api_key, $records, $client_id): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]
```

Bulk On Hand Stock Update

Update OnHand Stock Level to Provided Level and return results.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$records = array(new \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate()); // \Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[] | Update Requests
$client_id = 56; // int | Client ID

try {
    $result = $apiInstance->productBulkOnHandStockUpdate($api_key, $records, $client_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productBulkOnHandStockUpdate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **records** | [**\Mintsoft\Model\ToolkitDataClassesStockAPIBulkOnHandStockUpdate[]**](../Model/ToolkitDataClassesStockAPIBulkOnHandStockUpdate.md)| Update Requests | |
| **client_id** | **int**| Client ID | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult[]**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productCreateBundle()`

```php
productCreateBundle($api_key, $bundle)
```

Create New Bundle

Create a new Bundle

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$bundle = new \Mintsoft\Model\ToolkitDataClassesStockAPIBundle(); // \Mintsoft\Model\ToolkitDataClassesStockAPIBundle | Bundle

try {
    $apiInstance->productCreateBundle($api_key, $bundle);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productCreateBundle: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **bundle** | [**\Mintsoft\Model\ToolkitDataClassesStockAPIBundle**](../Model/ToolkitDataClassesStockAPIBundle.md)| Bundle | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productCreateProduct()`

```php
productCreateProduct($api_key, $product)
```

Create New Product

Create a new Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$product = new \Mintsoft\Model\ToolkitDataClassesStockProduct(); // \Mintsoft\Model\ToolkitDataClassesStockProduct | Product ID

try {
    $apiInstance->productCreateProduct($api_key, $product);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productCreateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **product** | [**\Mintsoft\Model\ToolkitDataClassesStockProduct**](../Model/ToolkitDataClassesStockProduct.md)| Product ID | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productCreateSupplier()`

```php
productCreateSupplier($api_key, $product_supplier): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Create New Product Supplier

Create a New Product Supplier

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$product_supplier = new \Mintsoft\Model\ToolkitDataClassesStockProductSupplier(); // \Mintsoft\Model\ToolkitDataClassesStockProductSupplier | ProductSupplier

try {
    $result = $apiInstance->productCreateSupplier($api_key, $product_supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productCreateSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **product_supplier** | [**\Mintsoft\Model\ToolkitDataClassesStockProductSupplier**](../Model/ToolkitDataClassesStockProductSupplier.md)| ProductSupplier | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productDeleteCarton()`

```php
productDeleteCarton($id, $carton_id, $api_key)
```

Delete Carton

Delete Carton against a Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$carton_id = 56; // int | ID of Carton to delete
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productDeleteCarton($id, $carton_id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productDeleteCarton: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **carton_id** | **int**| ID of Carton to delete | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGet()`

```php
productGet($id, $api_key)
```

Get Product

Get Details about Bundle and Items in the Bundle

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGet($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetAltCodes()`

```php
productGetAltCodes($id, $api_key)
```

Get Alt Codes

Get Alternative Codes for a ProductID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetAltCodes($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetAltCodes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetBundle()`

```php
productGetBundle($id, $api_key)
```

Get Bundle

Get Details about Bundle and Items in the Bundle

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetBundle($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetBundle: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetCartons()`

```php
productGetCartons($id, $api_key)
```

Get Cartons

Get Cartons for a ProductID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetCartons($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetCartons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetInventory()`

```php
productGetInventory($id, $api_key)
```

Get Inventory Records

Get Inventory Records relating to a ProductId

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetInventory($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetInventory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetInventoryPreOrderBreakdown()`

```php
productGetInventoryPreOrderBreakdown($id, $warehouse_id, $api_key)
```

Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId

Gets InventoryPreOrderBreakdown

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$warehouse_id = 56; // int | WarehouseId ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetInventoryPreOrderBreakdown($id, $warehouse_id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetInventoryPreOrderBreakdown: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **warehouse_id** | **int**| WarehouseId ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetInventoryPreOrderBreakdownAllWarehouses()`

```php
productGetInventoryPreOrderBreakdownAllWarehouses($id, $api_key)
```

Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses

Gets InventoryPreOrderBreakdown

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productGetInventoryPreOrderBreakdownAllWarehouses($id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetInventoryPreOrderBreakdownAllWarehouses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetProductChanges()`

```php
productGetProductChanges($api_key, $from_date)
```

Products Updated Since

Gets a List of ProductsIds that have been updated since the FromDate supplied

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The Date

try {
    $apiInstance->productGetProductChanges($api_key, $from_date);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetProductChanges: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **from_date** | **\DateTime**| The Date | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetStockFlow()`

```php
productGetStockFlow($id, $api_key, $from_date, $to_date)
```

Get Stock Flow Records

Get StockFlow Items by SKU, and Date

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Product ID
$api_key = 'api_key_example'; // string | API Auth Key
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | From Date e.g. 2011-10-05T22:26:12-04:00
$to_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | To Date e.g. 2011-10-05T22:26:12-04:00

try {
    $apiInstance->productGetStockFlow($id, $api_key, $from_date, $to_date);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetStockFlow: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Product ID | |
| **api_key** | **string**| API Auth Key | |
| **from_date** | **\DateTime**| From Date e.g. 2011-10-05T22:26:12-04:00 | |
| **to_date** | **\DateTime**| To Date e.g. 2011-10-05T22:26:12-04:00 | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetStockFlowFiltered()`

```php
productGetStockFlowFiltered($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns)
```

Get Stock Flow Records - Filtered

Get StockFlow Items by SKU, and Date, WarehouseId, Types etc

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | From Date e.g. 2011-10-05T22:26:12-04:00
$to_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | To Date e.g. 2011-10-05T22:26:12-04:00
$id = 56; // int | Product ID - Can be 0 if Supplying SKU
$sku = 'sku_example'; // string
$warehouse_id = 56; // int | WarehouseId e.g. 3
$types = 'types_example'; // string | Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT
$include_orders = True; // bool | Include Flows that relate to Orders
$include_returns = True; // bool | Include Flows that relate to Returns

try {
    $apiInstance->productGetStockFlowFiltered($api_key, $from_date, $to_date, $id, $sku, $warehouse_id, $types, $include_orders, $include_returns);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetStockFlowFiltered: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **from_date** | **\DateTime**| From Date e.g. 2011-10-05T22:26:12-04:00 | |
| **to_date** | **\DateTime**| To Date e.g. 2011-10-05T22:26:12-04:00 | |
| **id** | **int**| Product ID - Can be 0 if Supplying SKU | |
| **sku** | **string**|  | [optional] |
| **warehouse_id** | **int**| WarehouseId e.g. 3 | [optional] |
| **types** | **string**| Types of Flows to show e.g. ALL,IN, OUT, ALLOCATE, UNALLOCATE,TRANSFER, SCRAP - Multiple can be ; list e.g. IN;OUT | [optional] |
| **include_orders** | **bool**| Include Flows that relate to Orders | [optional] |
| **include_returns** | **bool**| Include Flows that relate to Returns | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetStockLevels()`

```php
productGetStockLevels($warehouse_id, $api_key, $breakdown, $product_id, $sku)
```

Get Stock Levels

Get Stock Levels of Products in Warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$warehouse_id = 56; // int | WarehouseId that you want to get stock levels for e.g. 3
$api_key = 'api_key_example'; // string | API Auth Key
$breakdown = True; // bool | Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc
$product_id = 56; // int
$sku = 'sku_example'; // string

try {
    $apiInstance->productGetStockLevels($warehouse_id, $api_key, $breakdown, $product_id, $sku);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetStockLevels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **warehouse_id** | **int**| WarehouseId that you want to get stock levels for e.g. 3 | |
| **api_key** | **string**| API Auth Key | |
| **breakdown** | **bool**| Include a Breakdown of that StockHolding by Batch, Serial, BestBefore etc | [optional] |
| **product_id** | **int**|  | [optional] |
| **sku** | **string**|  | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productGetStockLevelsUpdatedSince()`

```php
productGetStockLevelsUpdatedSince($api_key, $from_date)
```

Products StockLevels Updated Since

Gets a List of ProductsIds that whos StockLevels have changed since the FromDate supplied

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$from_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The Date

try {
    $apiInstance->productGetStockLevelsUpdatedSince($api_key, $from_date);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productGetStockLevelsUpdatedSince: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **from_date** | **\DateTime**| The Date | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productListProducts()`

```php
productListProducts($api_key, $page_no, $limit, $client_id, $since_last_updated): \Mintsoft\Model\ToolkitDataClassesStockProduct[]
```

List Products

Get a List Of Products Back

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$page_no = 56; // int | Page No - Default 1
$limit = 56; // int | Number of Results to Return - Default 100 - Max 100
$client_id = 56; // int | Filter by Client Id - Admin User Only
$since_last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Products that have been updated Since Supplied Time

try {
    $result = $apiInstance->productListProducts($api_key, $page_no, $limit, $client_id, $since_last_updated);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productListProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **page_no** | **int**| Page No - Default 1 | [optional] |
| **limit** | **int**| Number of Results to Return - Default 100 - Max 100 | [optional] |
| **client_id** | **int**| Filter by Client Id - Admin User Only | [optional] |
| **since_last_updated** | **\DateTime**| Products that have been updated Since Supplied Time | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockProduct[]**](../Model/ToolkitDataClassesStockProduct.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productListSuppliers()`

```php
productListSuppliers($api_key, $client_id, $page_no, $limit): \Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]
```

List Product Suppliers

Get paged list of Product Suppliers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$client_id = 56; // int | Filter by Client Id - Admin User Only
$page_no = 56; // int | Page No - Default 1
$limit = 56; // int | Number of Results to Return - Default 100 - Max 100

try {
    $result = $apiInstance->productListSuppliers($api_key, $client_id, $page_no, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productListSuppliers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **client_id** | **int**| Filter by Client Id - Admin User Only | [optional] |
| **page_no** | **int**| Page No - Default 1 | [optional] |
| **limit** | **int**| Number of Results to Return - Default 100 - Max 100 | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockProductSupplier[]**](../Model/ToolkitDataClassesStockProductSupplier.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productLookupProductId()`

```php
productLookupProductId($api_key, $sku, $connect_mapping_type, $client_id)
```

Lookup Product Id

Lookup ProductId using SKU or Alt Code SKU

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$sku = 'sku_example'; // string | SKU to search
$connect_mapping_type = 'connect_mapping_type_example'; // string | Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc
$client_id = 56; // int | Default 0 - Only needs to be supplied by Admin Users

try {
    $apiInstance->productLookupProductId($api_key, $sku, $connect_mapping_type, $client_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productLookupProductId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **sku** | **string**| SKU to search | |
| **connect_mapping_type** | **string**| Can be left blank if not searching Alt SKUs. e.g. Amazon, Ebay etc | [optional] |
| **client_id** | **int**| Default 0 - Only needs to be supplied by Admin Users | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productSearchBarcode()`

```php
productSearchBarcode($barcode, $api_key)
```

Search Product Barcode

Attempts to find a Product based on the barcode

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$barcode = 'barcode_example'; // string | Product Barcode can be SKU, EAN, UPC based
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->productSearchBarcode($barcode, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productSearchBarcode: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **barcode** | **string**| Product Barcode can be SKU, EAN, UPC based | |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productSearchProducts()`

```php
productSearchProducts($search, $api_key, $include_bundles, $include_discontinued)
```

Product Search by SKU/Name

Returns a list of products by seaching on SKU and Name

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = 'search_example'; // string | Text to Search
$api_key = 'api_key_example'; // string | API Auth Key
$include_bundles = True; // bool | Include Bundles in the search
$include_discontinued = True; // bool | Include products that have been discontinued in the search

try {
    $apiInstance->productSearchProducts($search, $api_key, $include_bundles, $include_discontinued);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productSearchProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **search** | **string**| Text to Search | |
| **api_key** | **string**| API Auth Key | |
| **include_bundles** | **bool**| Include Bundles in the search | [optional] |
| **include_discontinued** | **bool**| Include products that have been discontinued in the search | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `productUpdateProduct()`

```php
productUpdateProduct($api_key, $product)
```

Update Product

Updates an Existing Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$product = new \Mintsoft\Model\ToolkitDataClassesStockProduct(); // \Mintsoft\Model\ToolkitDataClassesStockProduct | Product

try {
    $apiInstance->productUpdateProduct($api_key, $product);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->productUpdateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **product** | [**\Mintsoft\Model\ToolkitDataClassesStockProduct**](../Model/ToolkitDataClassesStockProduct.md)| Product | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
