# Mintsoft\OrderApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**orderAddOrderComment()**](OrderApi.md#orderAddOrderComment) | **POST** /api/Order/{id}/Comments |  |
| [**orderAddOrderItem()**](OrderApi.md#orderAddOrderItem) | **PUT** /api/Order/{id}/Items | Add new item to the existing order |
| [**orderAddOrderTag()**](OrderApi.md#orderAddOrderTag) | **PUT** /api/Order/{id}/Tag |  |
| [**orderAllocations()**](OrderApi.md#orderAllocations) | **GET** /api/Order/{id}/Allocations | Order Allocations |
| [**orderBarcodeVerifiedOrderItems()**](OrderApi.md#orderBarcodeVerifiedOrderItems) | **GET** /api/Order/{id}/BarcodeVerifiedOrderItems | Order Barcode Verifications |
| [**orderBillingAddress()**](OrderApi.md#orderBillingAddress) | **GET** /api/Order/{id}/BillingAddress | Get Billing Address for Order |
| [**orderCancelOrder()**](OrderApi.md#orderCancelOrder) | **GET** /api/Order/{id}/Cancel |  |
| [**orderCancelShipment()**](OrderApi.md#orderCancelShipment) | **DELETE** /api/Order/{id}/Shipments/CancelShipment | Cancel Shipment - using Courier API Connection |
| [**orderComments()**](OrderApi.md#orderComments) | **GET** /api/Order/{id}/Comments |  |
| [**orderCreateOrder()**](OrderApi.md#orderCreateOrder) | **PUT** /api/Order | Create a New Order |
| [**orderCreateShipment()**](OrderApi.md#orderCreateShipment) | **POST** /api/Order/{id}/Shipments/CreateShipment | Create Shipment - using Courier API Connection |
| [**orderDeleteOrderItem()**](OrderApi.md#orderDeleteOrderItem) | **DELETE** /api/Order/{id}/Items/{ItemId} | Delete Order Item |
| [**orderDeleteOrderShipment()**](OrderApi.md#orderDeleteOrderShipment) | **DELETE** /api/Order/{id}/Shipments/{OrderShipmentId} |  |
| [**orderDeleteOrderTag()**](OrderApi.md#orderDeleteOrderTag) | **DELETE** /api/Order/{id}/Tag |  |
| [**orderDespatchNote()**](OrderApi.md#orderDespatchNote) | **GET** /api/Order/{id}/DespatchNote |  |
| [**orderDocuments()**](OrderApi.md#orderDocuments) | **GET** /api/Order/{id}/Documents |  |
| [**orderGet()**](OrderApi.md#orderGet) | **GET** /api/Order/{id} |  |
| [**orderGetChannels()**](OrderApi.md#orderGetChannels) | **GET** /api/Order/Channels |  |
| [**orderGetConnectAction()**](OrderApi.md#orderGetConnectAction) | **GET** /api/Order/{id}/ConnectActions |  |
| [**orderGetDocument()**](OrderApi.md#orderGetDocument) | **GET** /api/Order/{id}/Documents/{DocumentId} |  |
| [**orderGetDocumentData()**](OrderApi.md#orderGetDocumentData) | **GET** /api/Order/{id}/Documents/{DocumentId}/Data |  |
| [**orderGetOrderDocumentPaperSizes()**](OrderApi.md#orderGetOrderDocumentPaperSizes) | **GET** /api/Order/Documents/PaperSizes |  |
| [**orderGetOrderDocumentTypes()**](OrderApi.md#orderGetOrderDocumentTypes) | **GET** /api/Order/Documents/DocumentTypes |  |
| [**orderGetOrderShipment()**](OrderApi.md#orderGetOrderShipment) | **GET** /api/Order/{id}/Shipments |  |
| [**orderGetOrderShipmentTrackingEventsStatuses()**](OrderApi.md#orderGetOrderShipmentTrackingEventsStatuses) | **GET** /api/Order/Shipments/TrackingEvents/Statuses | Tracking Event - Statuses |
| [**orderGetOrderStatuses()**](OrderApi.md#orderGetOrderStatuses) | **GET** /api/Order/Statuses |  |
| [**orderItems()**](OrderApi.md#orderItems) | **GET** /api/Order/{id}/Items | Get Order Items |
| [**orderListOrders()**](OrderApi.md#orderListOrders) | **GET** /api/Order/List |  |
| [**orderListTrackingEvents()**](OrderApi.md#orderListTrackingEvents) | **GET** /api/Order/Shipments/TrackingEvents/List | Shipment Tracking Events - List |
| [**orderMarkAwaitingConfirmation()**](OrderApi.md#orderMarkAwaitingConfirmation) | **GET** /api/Order/{id}/MarkAwaitingConfirmation | MarkAwaitingConfirmation |
| [**orderMarkAwaitingPayment()**](OrderApi.md#orderMarkAwaitingPayment) | **GET** /api/Order/{id}/MarkAwaitingPayment | MarkAwaitingPayment |
| [**orderMarkConfirmed()**](OrderApi.md#orderMarkConfirmed) | **GET** /api/Order/{id}/MarkConfirmed | MarkConfirmed |
| [**orderMarkDespatched()**](OrderApi.md#orderMarkDespatched) | **GET** /api/Order/{id}/MarkDespatched | MarkDespatched |
| [**orderMarkDocumentAsPrinted()**](OrderApi.md#orderMarkDocumentAsPrinted) | **GET** /api/Order/{id}/Documents/{DocumentId}/MarkPrinted |  |
| [**orderMarkFraudRisk()**](OrderApi.md#orderMarkFraudRisk) | **POST** /api/Order/{id}/MarkFraudRisk | Marks Fraud Risk |
| [**orderMarkFraudRiskAccepted()**](OrderApi.md#orderMarkFraudRiskAccepted) | **POST** /api/Order/{id}/MarkFraudRiskAccepted | Marks Fraud Risk Accepted |
| [**orderMarkPackAndHold()**](OrderApi.md#orderMarkPackAndHold) | **GET** /api/Order/{id}/MarkPackAndHold | MarkPackAndHold |
| [**orderMarkPaymentReceived()**](OrderApi.md#orderMarkPaymentReceived) | **GET** /api/Order/{id}/MarkPaymentReceived | MarkPaymentReceived |
| [**orderMarkPrinted()**](OrderApi.md#orderMarkPrinted) | **GET** /api/Order/{id}/MarkPrinted | MarkPrinted |
| [**orderMarkReleasePackAndHold()**](OrderApi.md#orderMarkReleasePackAndHold) | **GET** /api/Order/{id}/MarkReleasePackAndHold | MarkReleasePackAndHold |
| [**orderOrderSplit()**](OrderApi.md#orderOrderSplit) | **GET** /api/Order/{id}/Splits |  |
| [**orderQueries()**](OrderApi.md#orderQueries) | **GET** /api/Order/{id}/Queries |  |
| [**orderQueryComments()**](OrderApi.md#orderQueryComments) | **GET** /api/Order/{id}/Queries/{QueryId}/Comments |  |
| [**orderSearchOrder()**](OrderApi.md#orderSearchOrder) | **GET** /api/Order/Search |  |
| [**orderSplitOrderItems()**](OrderApi.md#orderSplitOrderItems) | **POST** /api/Order/{id}/SplitOrderItems | SplitOrderItems |
| [**orderUpdateNumberOfParcels()**](OrderApi.md#orderUpdateNumberOfParcels) | **GET** /api/Order/{id}/UpdateNumberOfParcels | Update Number Of Parcels |
| [**orderUpdateOrder()**](OrderApi.md#orderUpdateOrder) | **POST** /api/Order/{id} | Update Order Details |
| [**orderUpdateOrderItem()**](OrderApi.md#orderUpdateOrderItem) | **POST** /api/Order/{id}/Items/{ItemId} | Update Order Item |
| [**orderUploadConnectAction()**](OrderApi.md#orderUploadConnectAction) | **PUT** /api/Order/{id}/ConnectActions |  |
| [**orderUploadOrderDocument()**](OrderApi.md#orderUploadOrderDocument) | **PUT** /api/Order/{id}/Documents |  |
| [**orderUploadOrderShipment()**](OrderApi.md#orderUploadOrderShipment) | **PUT** /api/Order/{id}/Shipments |  |


## `orderAddOrderComment()`

```php
orderAddOrderComment($id, $api_key, $comment): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$comment = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment

try {
    $result = $apiInstance->orderAddOrderComment($id, $api_key, $comment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderAddOrderComment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **comment** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderComment**](../Model/ToolkitDataClassesOrdersAPINewOrderComment.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderAddOrderItem()`

```php
orderAddOrderItem($id, $api_key, $order_item): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Add new item to the existing order

Add new Order Item - Can be used for adding an new Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$order_item = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem

try {
    $result = $apiInstance->orderAddOrderItem($id, $api_key, $order_item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderAddOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **order_item** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem**](../Model/ToolkitDataClassesOrdersAPINewOrderItem.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderAddOrderTag()`

```php
orderAddOrderTag($id, $api_key, $tag): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$tag = 'tag_example'; // string

try {
    $result = $apiInstance->orderAddOrderTag($id, $api_key, $tag);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderAddOrderTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **tag** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderAllocations()`

```php
orderAllocations($id, $api_key): \Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]
```

Order Allocations

Get a list of the Stock Allocated to an Order including Batch and BB Details

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderAllocations($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderAllocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesWarehouseProductInLocation[]**](../Model/ToolkitDataClassesWarehouseProductInLocation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderBarcodeVerifiedOrderItems()`

```php
orderBarcodeVerifiedOrderItems($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]
```

Order Barcode Verifications

Get a list of Barcode Scanning including Batch and Serial Details

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderBarcodeVerifiedOrderItems($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderBarcodeVerifiedOrderItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersBarcodeVerifiedOrderItem[]**](../Model/ToolkitDataClassesOrdersBarcodeVerifiedOrderItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderBillingAddress()`

```php
orderBillingAddress($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersAddress
```

Get Billing Address for Order

Returns the Billing Address for an OrderID if one is present.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderBillingAddress($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderBillingAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersAddress**](../Model/ToolkitDataClassesOrdersAddress.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCancelOrder()`

```php
orderCancelOrder($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderCancelOrder($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderCancelOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCancelShipment()`

```php
orderCancelShipment($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Cancel Shipment - using Courier API Connection

Cancel a Courier Shipment using the Courier API Connection. Where supported.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderCancelShipment($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderCancelShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderComments()`

```php
orderComments($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderComments($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderComments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderComment[]**](../Model/ToolkitDataClassesOrdersOrderComment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCreateOrder()`

```php
orderCreateOrder($api_key, $order): \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]
```

Create a New Order

Creates a new order in the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$order = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems

try {
    $result = $apiInstance->orderCreateOrder($api_key, $order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderCreateOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **order** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderWithItems**](../Model/ToolkitDataClassesOrdersAPINewOrderWithItems.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderResult[]**](../Model/ToolkitDataClassesOrdersAPINewOrderResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderCreateShipment()`

```php
orderCreateShipment($id, $api_key, $courier_service_id, $number_of_parcels): \Mintsoft\Model\ToolkitDataClassesShippingShipmentResult
```

Create Shipment - using Courier API Connection

Create a Courier Shipment using the Courier API Connection. Will make an API request to the assigned courier relating to the order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$courier_service_id = 56; // int | Optional - CourierServiceId if you want to update CourierService before creating a shipment
$number_of_parcels = 56; // int | Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment

try {
    $result = $apiInstance->orderCreateShipment($id, $api_key, $courier_service_id, $number_of_parcels);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderCreateShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **courier_service_id** | **int**| Optional - CourierServiceId if you want to update CourierService before creating a shipment | [optional] |
| **number_of_parcels** | **int**| Optional - NumberOfParcels if you want to update NumberOfParcels field before creating a shipment | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesShippingShipmentResult**](../Model/ToolkitDataClassesShippingShipmentResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderDeleteOrderItem()`

```php
orderDeleteOrderItem($id, $item_id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Delete Order Item

Delete Order Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$item_id = 56; // int
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderDeleteOrderItem($id, $item_id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderDeleteOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **item_id** | **int**|  | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderDeleteOrderShipment()`

```php
orderDeleteOrderShipment($id, $order_shipment_id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$order_shipment_id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderDeleteOrderShipment($id, $order_shipment_id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderDeleteOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **order_shipment_id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderDeleteOrderTag()`

```php
orderDeleteOrderTag($id, $api_key, $tag): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$tag = 'tag_example'; // string

try {
    $result = $apiInstance->orderDeleteOrderTag($id, $api_key, $tag);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderDeleteOrderTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **tag** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderDespatchNote()`

```php
orderDespatchNote($id, $api_key): string
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderDespatchNote($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderDespatchNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderDocuments()`

```php
orderDocuments($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderDocuments($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderDocuments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument[]**](../Model/ToolkitDataClassesOrdersOrderDocument.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGet()`

```php
orderGet($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrder
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGet($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrder**](../Model/ToolkitDataClassesOrdersOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetChannels()`

```php
orderGetChannels($api_key): \Mintsoft\Model\ToolkitDataClassesChannelsChannel[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetChannels($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetChannels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesChannelsChannel[]**](../Model/ToolkitDataClassesChannelsChannel.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetConnectAction()`

```php
orderGetConnectAction($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetConnectAction($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetConnectAction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderAwaitingAction[]**](../Model/ToolkitDataClassesOrdersOrderAwaitingAction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetDocument()`

```php
orderGetDocument($id, $document_id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$document_id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetDocument($id, $document_id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetDocument: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **document_id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocument**](../Model/ToolkitDataClassesOrdersOrderDocument.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetDocumentData()`

```php
orderGetDocumentData($id, $document_id, $api_key): string
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$document_id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetDocumentData($id, $document_id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetDocumentData: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **document_id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetOrderDocumentPaperSizes()`

```php
orderGetOrderDocumentPaperSizes($api_key): \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetOrderDocumentPaperSizes($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetOrderDocumentPaperSizes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]**](../Model/ToolkitDataClassesCommonEnumPair.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetOrderDocumentTypes()`

```php
orderGetOrderDocumentTypes($api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetOrderDocumentTypes($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetOrderDocumentTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderDocumentType[]**](../Model/ToolkitDataClassesOrdersOrderDocumentType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetOrderShipment()`

```php
orderGetOrderShipment($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetOrderShipment($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipment[]**](../Model/ToolkitDataClassesOrdersOrderShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetOrderShipmentTrackingEventsStatuses()`

```php
orderGetOrderShipmentTrackingEventsStatuses($api_key): \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
```

Tracking Event - Statuses

A List of all the possible Tracking Event Statuses

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderGetOrderShipmentTrackingEventsStatuses($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetOrderShipmentTrackingEventsStatuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]**](../Model/ToolkitDataClassesCommonEnumPair.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderGetOrderStatuses()`

```php
orderGetOrderStatuses($api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderGetOrderStatuses($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderGetOrderStatuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderStatus[]**](../Model/ToolkitDataClassesOrdersOrderStatus.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderItems()`

```php
orderItems($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]
```

Get Order Items

Get All of the Items for an Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderItems($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderItem[]**](../Model/ToolkitDataClassesOrdersOrderItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderListOrders()`

```php
orderListOrders($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items): \Mintsoft\Model\ToolkitDataClassesOrdersOrder[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$order_status_id = 56; // int
$client_id = 56; // int
$channel_id = 56; // int
$courier_service_id = 56; // int
$warehouse_id = 56; // int
$page_no = 56; // int
$limit = 56; // int
$since_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$since_last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$since_despatch_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$exclude_tags = 'exclude_tags_example'; // string
$include_tags = 'include_tags_example'; // string
$include_order_items = True; // bool

try {
    $result = $apiInstance->orderListOrders($api_key, $order_status_id, $client_id, $channel_id, $courier_service_id, $warehouse_id, $page_no, $limit, $since_date, $since_last_updated, $since_despatch_date, $exclude_tags, $include_tags, $include_order_items);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderListOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **order_status_id** | **int**|  | [optional] |
| **client_id** | **int**|  | [optional] |
| **channel_id** | **int**|  | [optional] |
| **courier_service_id** | **int**|  | [optional] |
| **warehouse_id** | **int**|  | [optional] |
| **page_no** | **int**|  | [optional] |
| **limit** | **int**|  | [optional] |
| **since_date** | **\DateTime**|  | [optional] |
| **since_last_updated** | **\DateTime**|  | [optional] |
| **since_despatch_date** | **\DateTime**|  | [optional] |
| **exclude_tags** | **string**|  | [optional] |
| **include_tags** | **string**|  | [optional] |
| **include_order_items** | **bool**|  | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]**](../Model/ToolkitDataClassesOrdersOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderListTrackingEvents()`

```php
orderListTrackingEvents($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated): \Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]
```

Shipment Tracking Events - List

List Shipment Tracking Events

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$page_no = 56; // int | Page No - Default 1
$limit = 56; // int | Number of Results to Return - Default 500 - Max 500
$tracking_status_id = 56; // int | Filter by TrackingStatusId
$since_last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Tracking Events that have happened Since Supplied Time

try {
    $result = $apiInstance->orderListTrackingEvents($api_key, $page_no, $limit, $tracking_status_id, $since_last_updated);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderListTrackingEvents: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **page_no** | **int**| Page No - Default 1 | [optional] |
| **limit** | **int**| Number of Results to Return - Default 500 - Max 500 | [optional] |
| **tracking_status_id** | **int**| Filter by TrackingStatusId | [optional] |
| **since_last_updated** | **\DateTime**| Tracking Events that have happened Since Supplied Time | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderShipmentTrackingEvent[]**](../Model/ToolkitDataClassesOrdersOrderShipmentTrackingEvent.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkAwaitingConfirmation()`

```php
orderMarkAwaitingConfirmation($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkAwaitingConfirmation

Mark an Order as Awaiting Confirmation - Moves it to a AwaitingConfirmation Status

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkAwaitingConfirmation($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkAwaitingConfirmation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkAwaitingPayment()`

```php
orderMarkAwaitingPayment($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkAwaitingPayment

Mark an Order as Awaiting Payment - Moves it to a AwaitingPayment Status

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkAwaitingPayment($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkAwaitingPayment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkConfirmed()`

```php
orderMarkConfirmed($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkConfirmed

Mark an Order as Confirmed - Moves it to an Order from AwaitingConfirmation Status so it can be processed

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkConfirmed($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkConfirmed: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkDespatched()`

```php
orderMarkDespatched($id, $api_key, $tracking_number): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkDespatched

Marks an Order as Despatched

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$tracking_number = 'tracking_number_example'; // string | TrackingNumber

try {
    $result = $apiInstance->orderMarkDespatched($id, $api_key, $tracking_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkDespatched: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **tracking_number** | **string**| TrackingNumber | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkDocumentAsPrinted()`

```php
orderMarkDocumentAsPrinted($id, $document_id, $api_key)
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$document_id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $apiInstance->orderMarkDocumentAsPrinted($id, $document_id, $api_key);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkDocumentAsPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **document_id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkFraudRisk()`

```php
orderMarkFraudRisk($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Marks Fraud Risk

Marks an order as Fraud

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Order Id
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkFraudRisk($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkFraudRisk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Order Id | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkFraudRiskAccepted()`

```php
orderMarkFraudRiskAccepted($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Marks Fraud Risk Accepted

Marks an order as Fraud Accepted

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | Order Id
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkFraudRiskAccepted($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkFraudRiskAccepted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Order Id | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkPackAndHold()`

```php
orderMarkPackAndHold($id, $release_date, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkPackAndHold

Mark an Order as Pack And Hold- Moves it to an Order To PackAndHold Status to be released for despatch at a future date

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$release_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Date you want the order released
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkPackAndHold($id, $release_date, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkPackAndHold: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **release_date** | **\DateTime**| Date you want the order released | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkPaymentReceived()`

```php
orderMarkPaymentReceived($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkPaymentReceived

Mark an Order as Payment Received Payment - Moves it to an Order from AwaitingPayment Status so it can be processed

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkPaymentReceived($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkPaymentReceived: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkPrinted()`

```php
orderMarkPrinted($id, $api_key, $comment): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkPrinted

Marks an Order as Printed

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$comment = 'comment_example'; // string | Comment

try {
    $result = $apiInstance->orderMarkPrinted($id, $api_key, $comment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkPrinted: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **comment** | **string**| Comment | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderMarkReleasePackAndHold()`

```php
orderMarkReleasePackAndHold($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

MarkReleasePackAndHold

Release an Order as Pack And Hold - Moves it to an Order to it's orginal status

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->orderMarkReleasePackAndHold($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderMarkReleasePackAndHold: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderOrderSplit()`

```php
orderOrderSplit($id, $api_key): \Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderOrderSplit($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderOrderSplit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrderSplit[]**](../Model/ToolkitDataClassesOrdersOrderSplit.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderQueries()`

```php
orderQueries($id, $api_key): \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderQueries($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderQueries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQuery[]**](../Model/ToolkitDataClassesHelpOrderQueriesOrderQuery.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderQueryComments()`

```php
orderQueryComments($id, $query_id, $api_key): \Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$query_id = 56; // int
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->orderQueryComments($id, $query_id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderQueryComments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **query_id** | **int**|  | |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesHelpOrderQueriesOrderQueryComment[]**](../Model/ToolkitDataClassesHelpOrderQueriesOrderQueryComment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderSearchOrder()`

```php
orderSearchOrder($api_key, $order_number): \Mintsoft\Model\ToolkitDataClassesOrdersOrder[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$order_number = 'order_number_example'; // string

try {
    $result = $apiInstance->orderSearchOrder($api_key, $order_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderSearchOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **order_number** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesOrdersOrder[]**](../Model/ToolkitDataClassesOrdersOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderSplitOrderItems()`

```php
orderSplitOrderItems($id, $api_key, $order_items_to_split): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

SplitOrderItems

Split given OrderItems from existing order onto a new Order that could be despatched seperately.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$order_items_to_split = array(new \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems()); // \Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[] | Order Items to Split onto new order

try {
    $result = $apiInstance->orderSplitOrderItems($id, $api_key, $order_items_to_split);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderSplitOrderItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **order_items_to_split** | [**\Mintsoft\Model\ToolkitDataClassesOrdersSplitOrderOnOrderItems[]**](../Model/ToolkitDataClassesOrdersSplitOrderOnOrderItems.md)| Order Items to Split onto new order | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUpdateNumberOfParcels()`

```php
orderUpdateNumberOfParcels($id, $api_key, $number_of_parcels): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Update Number Of Parcels

Updates Number Of Parcels on an Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$api_key = 'api_key_example'; // string | API Auth Key
$number_of_parcels = 56; // int | NumberOfParcels

try {
    $result = $apiInstance->orderUpdateNumberOfParcels($id, $api_key, $number_of_parcels);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUpdateNumberOfParcels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **api_key** | **string**| API Auth Key | |
| **number_of_parcels** | **int**| NumberOfParcels | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUpdateOrder()`

```php
orderUpdateOrder($id, $api_key, $order): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Update Order Details

Update Order Details for an Existing Order - Note Will not Update Order Items use speicified methods for them

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string | API Auth Key
$order = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder

try {
    $result = $apiInstance->orderUpdateOrder($id, $api_key, $order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUpdateOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**| API Auth Key | |
| **order** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrder**](../Model/ToolkitDataClassesOrdersAPINewOrder.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUpdateOrderItem()`

```php
orderUpdateOrderItem($id, $item_id, $api_key, $order_item): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Update Order Item

Update Order Item - Can be used for editing the quantity of an Item

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | OrderId
$item_id = 56; // int
$api_key = 'api_key_example'; // string | API Auth Key
$order_item = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem

try {
    $result = $apiInstance->orderUpdateOrderItem($id, $item_id, $api_key, $order_item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUpdateOrderItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| OrderId | |
| **item_id** | **int**|  | |
| **api_key** | **string**| API Auth Key | |
| **order_item** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderItem**](../Model/ToolkitDataClassesOrdersAPINewOrderItem.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUploadConnectAction()`

```php
orderUploadConnectAction($id, $api_key, $order_shipment): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$order_shipment = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction

try {
    $result = $apiInstance->orderUploadConnectAction($id, $api_key, $order_shipment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUploadConnectAction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **order_shipment** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderConnectAction**](../Model/ToolkitDataClassesOrdersAPINewOrderConnectAction.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUploadOrderDocument()`

```php
orderUploadOrderDocument($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$print_with_order = True; // bool
$document_type_id = 56; // int
$order_document = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument
$paper_size = 56; // int

try {
    $result = $apiInstance->orderUploadOrderDocument($id, $api_key, $print_with_order, $document_type_id, $order_document, $paper_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUploadOrderDocument: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **print_with_order** | **bool**|  | |
| **document_type_id** | **int**|  | |
| **order_document** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderDocument**](../Model/ToolkitDataClassesOrdersAPINewOrderDocument.md)|  | |
| **paper_size** | **int**|  | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `orderUploadOrderShipment()`

```php
orderUploadOrderShipment($id, $api_key, $order_shipment): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$api_key = 'api_key_example'; // string
$order_shipment = new \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment(); // \Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment

try {
    $result = $apiInstance->orderUploadOrderShipment($id, $api_key, $order_shipment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderUploadOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **api_key** | **string**|  | |
| **order_shipment** | [**\Mintsoft\Model\ToolkitDataClassesOrdersAPINewOrderShipment**](../Model/ToolkitDataClassesOrdersAPINewOrderShipment.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
