# Mintsoft\ClientApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**clientAddSubClient()**](ClientApi.md#clientAddSubClient) | **POST** /api/Client/SubClients | Add SubClient |
| [**clientGet()**](ClientApi.md#clientGet) | **GET** /api/Client | Get Clients |
| [**clientSubClients()**](ClientApi.md#clientSubClients) | **GET** /api/Client/SubClients | Get a list of SubClients |


## `clientAddSubClient()`

```php
clientAddSubClient($api_key, $client): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Add SubClient

Adds a New SubClient - Available to MasterClient users only

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ClientApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$client = new \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient(); // \Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient

try {
    $result = $apiInstance->clientAddSubClient($api_key, $client);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ClientApi->clientAddSubClient: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **client** | [**\Mintsoft\Model\ToolkitDataClassesClientsAPIAddSubClient**](../Model/ToolkitDataClassesClientsAPIAddSubClient.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `clientGet()`

```php
clientGet($api_key)
```

Get Clients

Get list of Clients - Available to Admin users only

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ClientApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $apiInstance->clientGet($api_key);
} catch (Exception $e) {
    echo 'Exception when calling ClientApi->clientGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `clientSubClients()`

```php
clientSubClients($api_key): \Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]
```

Get a list of SubClients

Get list of SubClients - Available to MasterClient users only

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ClientApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->clientSubClients($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ClientApi->clientSubClients: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesClientsAPISubClient[]**](../Model/ToolkitDataClassesClientsAPISubClient.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
