# Mintsoft\AuthApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**authGet()**](AuthApi.md#authGet) | **GET** /api/Auth | Get API Key |


## `authGet()`

```php
authGet($user_name, $password): string
```

Get API Key

The API key is used for authentication of all other API calls. API keys last 24 hours. After that point you'll start receiving 401 unauthorized responses and will need to  renew the API key.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AuthApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_name = 'user_name_example'; // string | OMS User Name
$password = 'password_example'; // string | OMS Password

try {
    $result = $apiInstance->authGet($user_name, $password);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthApi->authGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **user_name** | **string**| OMS User Name | |
| **password** | **string**| OMS Password | |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
