# Mintsoft\AccountingApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**accountingGetInvoiceCollections()**](AccountingApi.md#accountingGetInvoiceCollections) | **GET** /api/Accounting/Invoice/{id}/Collections |  |
| [**accountingGetInvoiceGenerics()**](AccountingApi.md#accountingGetInvoiceGenerics) | **GET** /api/Accounting/Invoice/{id}/Other |  |
| [**accountingGetInvoiceGoodsIn()**](AccountingApi.md#accountingGetInvoiceGoodsIn) | **GET** /api/Accounting/Invoice/{id}/GoodsIn |  |
| [**accountingGetInvoiceItemForOrder()**](AccountingApi.md#accountingGetInvoiceItemForOrder) | **GET** /api/Accounting/Invoice/Orders/{OrderId} |  |
| [**accountingGetInvoiceOrders()**](AccountingApi.md#accountingGetInvoiceOrders) | **GET** /api/Accounting/Invoice/{id}/Orders |  |
| [**accountingGetInvoiceReturns()**](AccountingApi.md#accountingGetInvoiceReturns) | **GET** /api/Accounting/Invoice/{id}/Returns |  |
| [**accountingGetInvoices()**](AccountingApi.md#accountingGetInvoices) | **GET** /api/Accounting/Invoice/{id} |  |
| [**accountingGetInvoicesAll()**](AccountingApi.md#accountingGetInvoicesAll) | **GET** /api/Accounting/Invoice/All |  |
| [**accountingListInvoices()**](AccountingApi.md#accountingListInvoices) | **GET** /api/Accounting/Invoice/List |  |


## `accountingGetInvoiceCollections()`

```php
accountingGetInvoiceCollections($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountCollectionInvoiceItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceCollections($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceCollections: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountCollectionInvoiceItem[]**](../Model/ToolkitDataClassesAccountCollectionInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoiceGenerics()`

```php
accountingGetInvoiceGenerics($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountGenericInvoiceItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceGenerics($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceGenerics: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountGenericInvoiceItem[]**](../Model/ToolkitDataClassesAccountGenericInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoiceGoodsIn()`

```php
accountingGetInvoiceGoodsIn($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountGoodsInInvoiceItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceGoodsIn($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceGoodsIn: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountGoodsInInvoiceItem[]**](../Model/ToolkitDataClassesAccountGoodsInInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoiceItemForOrder()`

```php
accountingGetInvoiceItemForOrder($api_key, $order_id): \Mintsoft\Model\ToolkitDataClassesAccountInvoiceItem
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$order_id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceItemForOrder($api_key, $order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceItemForOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **order_id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountInvoiceItem**](../Model/ToolkitDataClassesAccountInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoiceOrders()`

```php
accountingGetInvoiceOrders($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountInvoiceItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceOrders($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountInvoiceItem[]**](../Model/ToolkitDataClassesAccountInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoiceReturns()`

```php
accountingGetInvoiceReturns($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountReturnInvoiceItem[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoiceReturns($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoiceReturns: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountReturnInvoiceItem[]**](../Model/ToolkitDataClassesAccountReturnInvoiceItem.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoices()`

```php
accountingGetInvoices($api_key, $id): \Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$id = 56; // int

try {
    $result = $apiInstance->accountingGetInvoices($api_key, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **id** | **int**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary**](../Model/ToolkitDataClassesAccountConfirmedInvoiceSummary.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingGetInvoicesAll()`

```php
accountingGetInvoicesAll($api_key): \Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string

try {
    $result = $apiInstance->accountingGetInvoicesAll($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingGetInvoicesAll: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary[]**](../Model/ToolkitDataClassesAccountConfirmedInvoiceSummary.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `accountingListInvoices()`

```php
accountingListInvoices($api_key, $client_id, $page_no, $limit, $since_date): \Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary[]
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string
$client_id = 56; // int
$page_no = 56; // int
$limit = 56; // int
$since_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->accountingListInvoices($api_key, $client_id, $page_no, $limit, $since_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->accountingListInvoices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**|  | |
| **client_id** | **int**|  | [optional] |
| **page_no** | **int**|  | [optional] |
| **limit** | **int**|  | [optional] |
| **since_date** | **\DateTime**|  | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesAccountConfirmedInvoiceSummary[]**](../Model/ToolkitDataClassesAccountConfirmedInvoiceSummary.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
