# Mintsoft\ASNApi

All URIs are relative to https://api.mintsoft.co.uk, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**aSNBookInASN()**](ASNApi.md#aSNBookInASN) | **GET** /api/ASN/{id}/BookIn | Book In ASN - Admin Only |
| [**aSNBookInASNPartial()**](ASNApi.md#aSNBookInASNPartial) | **GET** /api/ASN/{id}/BookInPartial | Book In  Partial ASN - Admin Only |
| [**aSNConfirmASN()**](ASNApi.md#aSNConfirmASN) | **GET** /api/ASN/{id}/Confirm | Confirm ASN |
| [**aSNCreateASN()**](ASNApi.md#aSNCreateASN) | **PUT** /api/ASN | Create new ASN(Advanced Shipping Notice) |
| [**aSNDeleteASN()**](ASNApi.md#aSNDeleteASN) | **DELETE** /api/ASN/{id} | Delete ASN |
| [**aSNGetASN()**](ASNApi.md#aSNGetASN) | **GET** /api/ASN/{id} | Get ASN(Advanced Shipping Notice) |
| [**aSNGetGoodsInTypes()**](ASNApi.md#aSNGetGoodsInTypes) | **GET** /api/ASN/GoodsInTypes | Get Goods In Types |
| [**aSNGetPaperwork()**](ASNApi.md#aSNGetPaperwork) | **GET** /api/ASN/{id}/Paperwork | Get ASN Paperwork |
| [**aSNGetStatuses()**](ASNApi.md#aSNGetStatuses) | **GET** /api/ASN/Statuses | Get ASN Statuses |
| [**aSNListASNs()**](ASNApi.md#aSNListASNs) | **GET** /api/ASN/List | List Of ASN(Advanced Shipping Notice) |
| [**aSNPartBook()**](ASNApi.md#aSNPartBook) | **GET** /api/ASN/{id}/PartBook | Part Book In ASN - Admin Only |
| [**aSNReceiveItem()**](ASNApi.md#aSNReceiveItem) | **POST** /api/ASN/{id}/Items/Receive | ASN - Receive Items |
| [**aSNUpdateASN()**](ASNApi.md#aSNUpdateASN) | **POST** /api/ASN/{id} | Update ASN Details |
| [**aSNUploadConnectAction()**](ASNApi.md#aSNUploadConnectAction) | **PUT** /api/ASN/{id}/ConnectActions | Register ASN Webhook / ASNConnect Action |


## `aSNBookInASN()`

```php
aSNBookInASN($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Book In ASN - Admin Only

Book in Items on ASN and mark as complete

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNBookInASN($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNBookInASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNBookInASNPartial()`

```php
aSNBookInASNPartial($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Book In  Partial ASN - Admin Only

Partially book in ASN  - Not all Items have arrived

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNBookInASNPartial($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNBookInASNPartial: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNConfirmASN()`

```php
aSNConfirmASN($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Confirm ASN

Confirm ASN is now ready to be expected in the warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNConfirmASN($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNConfirmASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNCreateASN()`

```php
aSNCreateASN($api_key, $asn): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Create new ASN(Advanced Shipping Notice)

Used to Creating a new ASN i.e. Advising of a Delivery into the Warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$asn = new \Mintsoft\Model\ToolkitDataClassesStockAPINewASN(); // \Mintsoft\Model\ToolkitDataClassesStockAPINewASN | ASN Json in the Body of the request

try {
    $result = $apiInstance->aSNCreateASN($api_key, $asn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNCreateASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **asn** | [**\Mintsoft\Model\ToolkitDataClassesStockAPINewASN**](../Model/ToolkitDataClassesStockAPINewASN.md)| ASN Json in the Body of the request | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNDeleteASN()`

```php
aSNDeleteASN($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Delete ASN

Delete ASN - Cannot be undone

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNDeleteASN($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNDeleteASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNGetASN()`

```php
aSNGetASN($id, $api_key): \Mintsoft\Model\ToolkitDataClassesStockASN
```

Get ASN(Advanced Shipping Notice)

Get back latest details about an Existing ASN

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNGetASN($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNGetASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockASN**](../Model/ToolkitDataClassesStockASN.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNGetGoodsInTypes()`

```php
aSNGetGoodsInTypes($api_key): \Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]
```

Get Goods In Types

Get a list of Possible GoodsInTypes within the system e.g. Pallet, Container

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNGetGoodsInTypes($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNGetGoodsInTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonEnumPair[]**](../Model/ToolkitDataClassesCommonEnumPair.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNGetPaperwork()`

```php
aSNGetPaperwork($id, $api_key): string
```

Get ASN Paperwork

Get Paperwork relating to ASN

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNGetPaperwork($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNGetPaperwork: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNGetStatuses()`

```php
aSNGetStatuses($api_key): \Mintsoft\Model\ToolkitDataClassesStockASNStatus[]
```

Get ASN Statuses

Get a list of Possible ASNStatusIds and Names within the system

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNGetStatuses($api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNGetStatuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockASNStatus[]**](../Model/ToolkitDataClassesStockASNStatus.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNListASNs()`

```php
aSNListASNs($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items): \Mintsoft\Model\ToolkitDataClassesStockASN[]
```

List Of ASN(Advanced Shipping Notice)

Get a List of ASNs within the system (ASN Items are excluded from this endpoint)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$asn_status_id = 'asn_status_id_example'; // string | ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses
$client_id = 56; // int | ClientId - Filter by ClientId - 3PL Admin Users Only
$page_no = 56; // int | Page No - Default 1
$limit = 56; // int | Number of Result to be returned - Default 100 - Max 100
$warehouse_id = 56; // int | Filter by WarehouseId
$since_last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter by any ASNs that have been Updated Since supplied Timestamp
$booked_in_start_interval = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter by any ASNs that have been booked supplied Timestamp
$booked_in_end_interval = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter by any ASNs that have been booked supplied Timestamp
$include_asn_items = True; // bool | Request the ASN items

try {
    $result = $apiInstance->aSNListASNs($api_key, $asn_status_id, $client_id, $page_no, $limit, $warehouse_id, $since_last_updated, $booked_in_start_interval, $booked_in_end_interval, $include_asn_items);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNListASNs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **asn_status_id** | **string**| ASNStatusId can be supplied as a list e.g. 1;2;4 if you want to filter multiple statuses | [optional] |
| **client_id** | **int**| ClientId - Filter by ClientId - 3PL Admin Users Only | [optional] |
| **page_no** | **int**| Page No - Default 1 | [optional] |
| **limit** | **int**| Number of Result to be returned - Default 100 - Max 100 | [optional] |
| **warehouse_id** | **int**| Filter by WarehouseId | [optional] |
| **since_last_updated** | **\DateTime**| Filter by any ASNs that have been Updated Since supplied Timestamp | [optional] |
| **booked_in_start_interval** | **\DateTime**| Filter by any ASNs that have been booked supplied Timestamp | [optional] |
| **booked_in_end_interval** | **\DateTime**| Filter by any ASNs that have been booked supplied Timestamp | [optional] |
| **include_asn_items** | **bool**| Request the ASN items | [optional] |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesStockASN[]**](../Model/ToolkitDataClassesStockASN.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNPartBook()`

```php
aSNPartBook($id, $api_key): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Part Book In ASN - Admin Only

Book in Items that have been received already

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNPartBook($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNPartBook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNReceiveItem()`

```php
aSNReceiveItem($api_key, $id, $items): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

ASN - Receive Items

Receive Items against a ASN

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$id = 56; // int | ID of the ASN
$items = array(new \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation()); // \Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[] | Json list of the Items being receieved in the body of the request

try {
    $result = $apiInstance->aSNReceiveItem($api_key, $id, $items);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNReceiveItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **id** | **int**| ID of the ASN | |
| **items** | [**\Mintsoft\Model\ToolkitDataClassesStockASNItemAllocation[]**](../Model/ToolkitDataClassesStockASNItemAllocation.md)| Json list of the Items being receieved in the body of the request | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNUpdateASN()`

```php
aSNUpdateASN($api_key, $id, $asn): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Update ASN Details

Update ASN Details for an Existing ASN

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$api_key = 'api_key_example'; // string | API Auth Key
$id = 56; // int | ID of the ASN
$asn = new \Mintsoft\Model\ToolkitDataClassesStockAPINewASN(); // \Mintsoft\Model\ToolkitDataClassesStockAPINewASN

try {
    $result = $apiInstance->aSNUpdateASN($api_key, $id, $asn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNUpdateASN: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **api_key** | **string**| API Auth Key | |
| **id** | **int**| ID of the ASN | |
| **asn** | [**\Mintsoft\Model\ToolkitDataClassesStockAPINewASN**](../Model/ToolkitDataClassesStockAPINewASN.md)|  | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `aSNUploadConnectAction()`

```php
aSNUploadConnectAction($id, $api_key, $connect_action): \Mintsoft\Model\ToolkitDataClassesCommonToolkitResult
```

Register ASN Webhook / ASNConnect Action

Can be used to register a Webhook event so that when ASN is booked in a specified URL can be called with details of the book in

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key
$connect_action = new \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction(); // \Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction | Connect Action in Body of Result as Json - Type = API, ExtraCode1 = Callback Url,ExtraCode4 = Auth Header Values Complete = false

try {
    $result = $apiInstance->aSNUploadConnectAction($id, $api_key, $connect_action);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNUploadConnectAction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| ID of the ASN | |
| **api_key** | **string**| API Auth Key | |
| **connect_action** | [**\Mintsoft\Model\ToolkitDataClassesStockAPINewASNConnectAction**](../Model/ToolkitDataClassesStockAPINewASNConnectAction.md)| Connect Action in Body of Result as Json - Type &#x3D; API, ExtraCode1 &#x3D; Callback Url,ExtraCode4 &#x3D; Auth Header Values Complete &#x3D; false | |

### Return type

[**\Mintsoft\Model\ToolkitDataClassesCommonToolkitResult**](../Model/ToolkitDataClassesCommonToolkitResult.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`
- **Accept**: `application/json`, `text/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
