# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/mintsoft.git"
    }
  ],
  "require": {
    "talisman/mintsoft": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Mintsoft\Api\ASNApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | ID of the ASN
$api_key = 'api_key_example'; // string | API Auth Key

try {
    $result = $apiInstance->aSNBookInASN($id, $api_key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ASNApi->aSNBookInASN: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.mintsoft.co.uk*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ASNApi* | [**aSNBookInASN**](docs/Api/ASNApi.md#asnbookinasn) | **GET** /api/ASN/{id}/BookIn | Book In ASN - Admin Only
*ASNApi* | [**aSNBookInASNPartial**](docs/Api/ASNApi.md#asnbookinasnpartial) | **GET** /api/ASN/{id}/BookInPartial | Book In  Partial ASN - Admin Only
*ASNApi* | [**aSNConfirmASN**](docs/Api/ASNApi.md#asnconfirmasn) | **GET** /api/ASN/{id}/Confirm | Confirm ASN
*ASNApi* | [**aSNCreateASN**](docs/Api/ASNApi.md#asncreateasn) | **PUT** /api/ASN | Create new ASN(Advanced Shipping Notice)
*ASNApi* | [**aSNDeleteASN**](docs/Api/ASNApi.md#asndeleteasn) | **DELETE** /api/ASN/{id} | Delete ASN
*ASNApi* | [**aSNGetASN**](docs/Api/ASNApi.md#asngetasn) | **GET** /api/ASN/{id} | Get ASN(Advanced Shipping Notice)
*ASNApi* | [**aSNGetGoodsInTypes**](docs/Api/ASNApi.md#asngetgoodsintypes) | **GET** /api/ASN/GoodsInTypes | Get Goods In Types
*ASNApi* | [**aSNGetPaperwork**](docs/Api/ASNApi.md#asngetpaperwork) | **GET** /api/ASN/{id}/Paperwork | Get ASN Paperwork
*ASNApi* | [**aSNGetStatuses**](docs/Api/ASNApi.md#asngetstatuses) | **GET** /api/ASN/Statuses | Get ASN Statuses
*ASNApi* | [**aSNListASNs**](docs/Api/ASNApi.md#asnlistasns) | **GET** /api/ASN/List | List Of ASN(Advanced Shipping Notice)
*ASNApi* | [**aSNPartBook**](docs/Api/ASNApi.md#asnpartbook) | **GET** /api/ASN/{id}/PartBook | Part Book In ASN - Admin Only
*ASNApi* | [**aSNReceiveItem**](docs/Api/ASNApi.md#asnreceiveitem) | **POST** /api/ASN/{id}/Items/Receive | ASN - Receive Items
*ASNApi* | [**aSNUpdateASN**](docs/Api/ASNApi.md#asnupdateasn) | **POST** /api/ASN/{id} | Update ASN Details
*ASNApi* | [**aSNUploadConnectAction**](docs/Api/ASNApi.md#asnuploadconnectaction) | **PUT** /api/ASN/{id}/ConnectActions | Register ASN Webhook / ASNConnect Action
*AccountingApi* | [**accountingGetInvoiceCollections**](docs/Api/AccountingApi.md#accountinggetinvoicecollections) | **GET** /api/Accounting/Invoice/{id}/Collections | 
*AccountingApi* | [**accountingGetInvoiceGenerics**](docs/Api/AccountingApi.md#accountinggetinvoicegenerics) | **GET** /api/Accounting/Invoice/{id}/Other | 
*AccountingApi* | [**accountingGetInvoiceGoodsIn**](docs/Api/AccountingApi.md#accountinggetinvoicegoodsin) | **GET** /api/Accounting/Invoice/{id}/GoodsIn | 
*AccountingApi* | [**accountingGetInvoiceItemForOrder**](docs/Api/AccountingApi.md#accountinggetinvoiceitemfororder) | **GET** /api/Accounting/Invoice/Orders/{OrderId} | 
*AccountingApi* | [**accountingGetInvoiceOrders**](docs/Api/AccountingApi.md#accountinggetinvoiceorders) | **GET** /api/Accounting/Invoice/{id}/Orders | 
*AccountingApi* | [**accountingGetInvoiceReturns**](docs/Api/AccountingApi.md#accountinggetinvoicereturns) | **GET** /api/Accounting/Invoice/{id}/Returns | 
*AccountingApi* | [**accountingGetInvoices**](docs/Api/AccountingApi.md#accountinggetinvoices) | **GET** /api/Accounting/Invoice/{id} | 
*AccountingApi* | [**accountingGetInvoicesAll**](docs/Api/AccountingApi.md#accountinggetinvoicesall) | **GET** /api/Accounting/Invoice/All | 
*AccountingApi* | [**accountingListInvoices**](docs/Api/AccountingApi.md#accountinglistinvoices) | **GET** /api/Accounting/Invoice/List | 
*AuthApi* | [**authGet**](docs/Api/AuthApi.md#authget) | **GET** /api/Auth | Get API Key
*ClientApi* | [**clientAddSubClient**](docs/Api/ClientApi.md#clientaddsubclient) | **POST** /api/Client/SubClients | Add SubClient
*ClientApi* | [**clientGet**](docs/Api/ClientApi.md#clientget) | **GET** /api/Client | Get Clients
*ClientApi* | [**clientSubClients**](docs/Api/ClientApi.md#clientsubclients) | **GET** /api/Client/SubClients | Get a list of SubClients
*CourierApi* | [**courierGetCourierService**](docs/Api/CourierApi.md#couriergetcourierservice) | **GET** /api/Courier/Services/{id} | 
*CourierApi* | [**courierGetCourierServiceTypes**](docs/Api/CourierApi.md#couriergetcourierservicetypes) | **GET** /api/Courier/ServiceTypes | 
*CourierApi* | [**courierGetCourierServices**](docs/Api/CourierApi.md#couriergetcourierservices) | **GET** /api/Courier/Services | 
*CourierApi* | [**courierGetExternalCourierServiceNames**](docs/Api/CourierApi.md#couriergetexternalcourierservicenames) | **GET** /api/Courier/Services/{id}/ExternalNames | 
*OrderApi* | [**orderAddOrderComment**](docs/Api/OrderApi.md#orderaddordercomment) | **POST** /api/Order/{id}/Comments | 
*OrderApi* | [**orderAddOrderItem**](docs/Api/OrderApi.md#orderaddorderitem) | **PUT** /api/Order/{id}/Items | Add new item to the existing order
*OrderApi* | [**orderAddOrderTag**](docs/Api/OrderApi.md#orderaddordertag) | **PUT** /api/Order/{id}/Tag | 
*OrderApi* | [**orderAllocations**](docs/Api/OrderApi.md#orderallocations) | **GET** /api/Order/{id}/Allocations | Order Allocations
*OrderApi* | [**orderBarcodeVerifiedOrderItems**](docs/Api/OrderApi.md#orderbarcodeverifiedorderitems) | **GET** /api/Order/{id}/BarcodeVerifiedOrderItems | Order Barcode Verifications
*OrderApi* | [**orderBillingAddress**](docs/Api/OrderApi.md#orderbillingaddress) | **GET** /api/Order/{id}/BillingAddress | Get Billing Address for Order
*OrderApi* | [**orderCancelOrder**](docs/Api/OrderApi.md#ordercancelorder) | **GET** /api/Order/{id}/Cancel | 
*OrderApi* | [**orderCancelShipment**](docs/Api/OrderApi.md#ordercancelshipment) | **DELETE** /api/Order/{id}/Shipments/CancelShipment | Cancel Shipment - using Courier API Connection
*OrderApi* | [**orderComments**](docs/Api/OrderApi.md#ordercomments) | **GET** /api/Order/{id}/Comments | 
*OrderApi* | [**orderCreateOrder**](docs/Api/OrderApi.md#ordercreateorder) | **PUT** /api/Order | Create a New Order
*OrderApi* | [**orderCreateShipment**](docs/Api/OrderApi.md#ordercreateshipment) | **POST** /api/Order/{id}/Shipments/CreateShipment | Create Shipment - using Courier API Connection
*OrderApi* | [**orderDeleteOrderItem**](docs/Api/OrderApi.md#orderdeleteorderitem) | **DELETE** /api/Order/{id}/Items/{ItemId} | Delete Order Item
*OrderApi* | [**orderDeleteOrderShipment**](docs/Api/OrderApi.md#orderdeleteordershipment) | **DELETE** /api/Order/{id}/Shipments/{OrderShipmentId} | 
*OrderApi* | [**orderDeleteOrderTag**](docs/Api/OrderApi.md#orderdeleteordertag) | **DELETE** /api/Order/{id}/Tag | 
*OrderApi* | [**orderDespatchNote**](docs/Api/OrderApi.md#orderdespatchnote) | **GET** /api/Order/{id}/DespatchNote | 
*OrderApi* | [**orderDocuments**](docs/Api/OrderApi.md#orderdocuments) | **GET** /api/Order/{id}/Documents | 
*OrderApi* | [**orderGet**](docs/Api/OrderApi.md#orderget) | **GET** /api/Order/{id} | 
*OrderApi* | [**orderGetChannels**](docs/Api/OrderApi.md#ordergetchannels) | **GET** /api/Order/Channels | 
*OrderApi* | [**orderGetConnectAction**](docs/Api/OrderApi.md#ordergetconnectaction) | **GET** /api/Order/{id}/ConnectActions | 
*OrderApi* | [**orderGetDocument**](docs/Api/OrderApi.md#ordergetdocument) | **GET** /api/Order/{id}/Documents/{DocumentId} | 
*OrderApi* | [**orderGetDocumentData**](docs/Api/OrderApi.md#ordergetdocumentdata) | **GET** /api/Order/{id}/Documents/{DocumentId}/Data | 
*OrderApi* | [**orderGetOrderDocumentPaperSizes**](docs/Api/OrderApi.md#ordergetorderdocumentpapersizes) | **GET** /api/Order/Documents/PaperSizes | 
*OrderApi* | [**orderGetOrderDocumentTypes**](docs/Api/OrderApi.md#ordergetorderdocumenttypes) | **GET** /api/Order/Documents/DocumentTypes | 
*OrderApi* | [**orderGetOrderShipment**](docs/Api/OrderApi.md#ordergetordershipment) | **GET** /api/Order/{id}/Shipments | 
*OrderApi* | [**orderGetOrderShipmentTrackingEventsStatuses**](docs/Api/OrderApi.md#ordergetordershipmenttrackingeventsstatuses) | **GET** /api/Order/Shipments/TrackingEvents/Statuses | Tracking Event - Statuses
*OrderApi* | [**orderGetOrderStatuses**](docs/Api/OrderApi.md#ordergetorderstatuses) | **GET** /api/Order/Statuses | 
*OrderApi* | [**orderItems**](docs/Api/OrderApi.md#orderitems) | **GET** /api/Order/{id}/Items | Get Order Items
*OrderApi* | [**orderListOrders**](docs/Api/OrderApi.md#orderlistorders) | **GET** /api/Order/List | 
*OrderApi* | [**orderListTrackingEvents**](docs/Api/OrderApi.md#orderlisttrackingevents) | **GET** /api/Order/Shipments/TrackingEvents/List | Shipment Tracking Events - List
*OrderApi* | [**orderMarkAwaitingConfirmation**](docs/Api/OrderApi.md#ordermarkawaitingconfirmation) | **GET** /api/Order/{id}/MarkAwaitingConfirmation | MarkAwaitingConfirmation
*OrderApi* | [**orderMarkAwaitingPayment**](docs/Api/OrderApi.md#ordermarkawaitingpayment) | **GET** /api/Order/{id}/MarkAwaitingPayment | MarkAwaitingPayment
*OrderApi* | [**orderMarkConfirmed**](docs/Api/OrderApi.md#ordermarkconfirmed) | **GET** /api/Order/{id}/MarkConfirmed | MarkConfirmed
*OrderApi* | [**orderMarkDespatched**](docs/Api/OrderApi.md#ordermarkdespatched) | **GET** /api/Order/{id}/MarkDespatched | MarkDespatched
*OrderApi* | [**orderMarkDocumentAsPrinted**](docs/Api/OrderApi.md#ordermarkdocumentasprinted) | **GET** /api/Order/{id}/Documents/{DocumentId}/MarkPrinted | 
*OrderApi* | [**orderMarkFraudRisk**](docs/Api/OrderApi.md#ordermarkfraudrisk) | **POST** /api/Order/{id}/MarkFraudRisk | Marks Fraud Risk
*OrderApi* | [**orderMarkFraudRiskAccepted**](docs/Api/OrderApi.md#ordermarkfraudriskaccepted) | **POST** /api/Order/{id}/MarkFraudRiskAccepted | Marks Fraud Risk Accepted
*OrderApi* | [**orderMarkPackAndHold**](docs/Api/OrderApi.md#ordermarkpackandhold) | **GET** /api/Order/{id}/MarkPackAndHold | MarkPackAndHold
*OrderApi* | [**orderMarkPaymentReceived**](docs/Api/OrderApi.md#ordermarkpaymentreceived) | **GET** /api/Order/{id}/MarkPaymentReceived | MarkPaymentReceived
*OrderApi* | [**orderMarkPrinted**](docs/Api/OrderApi.md#ordermarkprinted) | **GET** /api/Order/{id}/MarkPrinted | MarkPrinted
*OrderApi* | [**orderMarkReleasePackAndHold**](docs/Api/OrderApi.md#ordermarkreleasepackandhold) | **GET** /api/Order/{id}/MarkReleasePackAndHold | MarkReleasePackAndHold
*OrderApi* | [**orderOrderSplit**](docs/Api/OrderApi.md#orderordersplit) | **GET** /api/Order/{id}/Splits | 
*OrderApi* | [**orderQueries**](docs/Api/OrderApi.md#orderqueries) | **GET** /api/Order/{id}/Queries | 
*OrderApi* | [**orderQueryComments**](docs/Api/OrderApi.md#orderquerycomments) | **GET** /api/Order/{id}/Queries/{QueryId}/Comments | 
*OrderApi* | [**orderSearchOrder**](docs/Api/OrderApi.md#ordersearchorder) | **GET** /api/Order/Search | 
*OrderApi* | [**orderSplitOrderItems**](docs/Api/OrderApi.md#ordersplitorderitems) | **POST** /api/Order/{id}/SplitOrderItems | SplitOrderItems
*OrderApi* | [**orderUpdateNumberOfParcels**](docs/Api/OrderApi.md#orderupdatenumberofparcels) | **GET** /api/Order/{id}/UpdateNumberOfParcels | Update Number Of Parcels
*OrderApi* | [**orderUpdateOrder**](docs/Api/OrderApi.md#orderupdateorder) | **POST** /api/Order/{id} | Update Order Details
*OrderApi* | [**orderUpdateOrderItem**](docs/Api/OrderApi.md#orderupdateorderitem) | **POST** /api/Order/{id}/Items/{ItemId} | Update Order Item
*OrderApi* | [**orderUploadConnectAction**](docs/Api/OrderApi.md#orderuploadconnectaction) | **PUT** /api/Order/{id}/ConnectActions | 
*OrderApi* | [**orderUploadOrderDocument**](docs/Api/OrderApi.md#orderuploadorderdocument) | **PUT** /api/Order/{id}/Documents | 
*OrderApi* | [**orderUploadOrderShipment**](docs/Api/OrderApi.md#orderuploadordershipment) | **PUT** /api/Order/{id}/Shipments | 
*ProductApi* | [**productAddAddAlt**](docs/Api/ProductApi.md#productaddaddalt) | **POST** /api/Product/{id}/AltCodes | Add Alt Code
*ProductApi* | [**productBulkAddCartons**](docs/Api/ProductApi.md#productbulkaddcartons) | **POST** /api/Product/{id}/Cartons | Bulk Add Cartons
*ProductApi* | [**productBulkOnHandStockUpdate**](docs/Api/ProductApi.md#productbulkonhandstockupdate) | **POST** /api/Product/BulkOnHandStockUpdate | Bulk On Hand Stock Update
*ProductApi* | [**productCreateBundle**](docs/Api/ProductApi.md#productcreatebundle) | **PUT** /api/Product/Bundle | Create New Bundle
*ProductApi* | [**productCreateProduct**](docs/Api/ProductApi.md#productcreateproduct) | **PUT** /api/Product | Create New Product
*ProductApi* | [**productCreateSupplier**](docs/Api/ProductApi.md#productcreatesupplier) | **PUT** /api/Product/Suppliers | Create New Product Supplier
*ProductApi* | [**productDeleteCarton**](docs/Api/ProductApi.md#productdeletecarton) | **DELETE** /api/Product/{id}/Carton/{cartonId} | Delete Carton
*ProductApi* | [**productGet**](docs/Api/ProductApi.md#productget) | **GET** /api/Product/{id} | Get Product
*ProductApi* | [**productGetAltCodes**](docs/Api/ProductApi.md#productgetaltcodes) | **GET** /api/Product/{id}/AltCodes | Get Alt Codes
*ProductApi* | [**productGetBundle**](docs/Api/ProductApi.md#productgetbundle) | **GET** /api/Product/{id}/Bundle | Get Bundle
*ProductApi* | [**productGetCartons**](docs/Api/ProductApi.md#productgetcartons) | **GET** /api/Product/{id}/Cartons | Get Cartons
*ProductApi* | [**productGetInventory**](docs/Api/ProductApi.md#productgetinventory) | **GET** /api/Product/{id}/Inventory | Get Inventory Records
*ProductApi* | [**productGetInventoryPreOrderBreakdown**](docs/Api/ProductApi.md#productgetinventorypreorderbreakdown) | **GET** /api/Product/{id}/Inventory/PreOrderBreakdown | Get an Inventory Pre Order Breakdown for a specified Product and WarehouseId
*ProductApi* | [**productGetInventoryPreOrderBreakdownAllWarehouses**](docs/Api/ProductApi.md#productgetinventorypreorderbreakdownallwarehouses) | **GET** /api/Product/{id}/Inventory/PreOrderBreakdown/All | Get an Inventory Pre Order Breakdown for a specified Product and All Warehouses
*ProductApi* | [**productGetProductChanges**](docs/Api/ProductApi.md#productgetproductchanges) | **GET** /api/Product/UpdatedSince | Products Updated Since
*ProductApi* | [**productGetStockFlow**](docs/Api/ProductApi.md#productgetstockflow) | **GET** /api/Product/{id}/StockFlow | Get Stock Flow Records
*ProductApi* | [**productGetStockFlowFiltered**](docs/Api/ProductApi.md#productgetstockflowfiltered) | **GET** /api/Product/{id}/StockFlow/Filtered | Get Stock Flow Records - Filtered
*ProductApi* | [**productGetStockLevels**](docs/Api/ProductApi.md#productgetstocklevels) | **GET** /api/Product/StockLevels | Get Stock Levels
*ProductApi* | [**productGetStockLevelsUpdatedSince**](docs/Api/ProductApi.md#productgetstocklevelsupdatedsince) | **GET** /api/Product/StockLevels/UpdatedSince | Products StockLevels Updated Since
*ProductApi* | [**productListProducts**](docs/Api/ProductApi.md#productlistproducts) | **GET** /api/Product/List | List Products
*ProductApi* | [**productListSuppliers**](docs/Api/ProductApi.md#productlistsuppliers) | **GET** /api/Product/Suppliers | List Product Suppliers
*ProductApi* | [**productLookupProductId**](docs/Api/ProductApi.md#productlookupproductid) | **GET** /api/Product/LookupProductId | Lookup Product Id
*ProductApi* | [**productSearchBarcode**](docs/Api/ProductApi.md#productsearchbarcode) | **GET** /api/Product/SearchBarcode | Search Product Barcode
*ProductApi* | [**productSearchProducts**](docs/Api/ProductApi.md#productsearchproducts) | **GET** /api/Product/Search | Product Search by SKU/Name
*ProductApi* | [**productUpdateProduct**](docs/Api/ProductApi.md#productupdateproduct) | **POST** /api/Product | Update Product
*RefDataApi* | [**refDataCountries**](docs/Api/RefDataApi.md#refdatacountries) | **GET** /api/RefData/Countries | Get Countries
*RefDataApi* | [**refDataCurrencies**](docs/Api/RefDataApi.md#refdatacurrencies) | **GET** /api/RefData/Currencies | 
*ReportsApi* | [**reportsCourierDespatchReport**](docs/Api/ReportsApi.md#reportscourierdespatchreport) | **GET** /api/Reports/CourierDespatchReport | Courier Despatch Report
*ReturnApi* | [**returnAddReturnItem**](docs/Api/ReturnApi.md#returnaddreturnitem) | **POST** /api/Return/{id}/AddItem | 
*ReturnApi* | [**returnAllocateItemLocation**](docs/Api/ReturnApi.md#returnallocateitemlocation) | **POST** /api/Return/{id}/AllocateItemLocation | 
*ReturnApi* | [**returnConfirmReturn**](docs/Api/ReturnApi.md#returnconfirmreturn) | **POST** /api/Return/{id}/Confirm | 
*ReturnApi* | [**returnCreateReturn**](docs/Api/ReturnApi.md#returncreatereturn) | **POST** /api/Return/CreateReturn/{OrderId} | 
*ReturnApi* | [**returnGetReturn**](docs/Api/ReturnApi.md#returngetreturn) | **GET** /api/Return/{id} | 
*ReturnApi* | [**returnGetReturnItems**](docs/Api/ReturnApi.md#returngetreturnitems) | **GET** /api/Return/{id}/Items | 
*ReturnApi* | [**returnGetReturnReasons**](docs/Api/ReturnApi.md#returngetreturnreasons) | **GET** /api/Return/Reasons | 
*ReturnApi* | [**returnGetReturnsOnDate**](docs/Api/ReturnApi.md#returngetreturnsondate) | **GET** /api/Return/SearchByDate | 
*WarehouseApi* | [**warehouseBulkStockMovement**](docs/Api/WarehouseApi.md#warehousebulkstockmovement) | **POST** /api/Warehouse/BulkStockMovement | 
*WarehouseApi* | [**warehouseCancelWarehouseTransfer**](docs/Api/WarehouseApi.md#warehousecancelwarehousetransfer) | **GET** /api/WarehouseTransfer/{id}/Cancel | Cancel WarehouseTransfer
*WarehouseApi* | [**warehouseConfirmWarehouseTransfer**](docs/Api/WarehouseApi.md#warehouseconfirmwarehousetransfer) | **GET** /api/WarehouseTransfer/{id}/Confirm | Confirm WarehouseTransfer
*WarehouseApi* | [**warehouseCreateWarehouseTransfer**](docs/Api/WarehouseApi.md#warehousecreatewarehousetransfer) | **PUT** /api/WarehouseTransfer | Create new WarehouseTransfer
*WarehouseApi* | [**warehouseDeleteWarehouseTransfer**](docs/Api/WarehouseApi.md#warehousedeletewarehousetransfer) | **DELETE** /api/WarehouseTransfer/{id} | Delete WarehouseTransfer
*WarehouseApi* | [**warehouseGetLocation**](docs/Api/WarehouseApi.md#warehousegetlocation) | **GET** /api/Warehouse/{WarehouseId}/Location/{LocationId} | 
*WarehouseApi* | [**warehouseGetLocationTypes**](docs/Api/WarehouseApi.md#warehousegetlocationtypes) | **GET** /api/Warehouse/LocationTypes | 
*WarehouseApi* | [**warehouseGetLocations**](docs/Api/WarehouseApi.md#warehousegetlocations) | **GET** /api/Warehouse/{WarehouseId}/Location/All | 
*WarehouseApi* | [**warehouseGetStatuses**](docs/Api/WarehouseApi.md#warehousegetstatuses) | **GET** /api/WarehouseTransfer/Statuses | Get WarehouseTransfer Statuses
*WarehouseApi* | [**warehouseGetWarehouseTransfer**](docs/Api/WarehouseApi.md#warehousegetwarehousetransfer) | **GET** /api/WarehouseTransfer/{id} | Get WarehouseTransfer
*WarehouseApi* | [**warehouseGetWarehouses**](docs/Api/WarehouseApi.md#warehousegetwarehouses) | **GET** /api/Warehouse | 
*WarehouseApi* | [**warehouseListWarehouseTransfers**](docs/Api/WarehouseApi.md#warehouselistwarehousetransfers) | **GET** /api/WarehouseTransfer/List | 
*WarehouseApi* | [**warehouseLookupLocationId**](docs/Api/WarehouseApi.md#warehouselookuplocationid) | **GET** /api/Warehouse/{WarehouseId}/Location/LookupLocationId | 
*WarehouseApi* | [**warehouseStockMovement**](docs/Api/WarehouseApi.md#warehousestockmovement) | **POST** /api/Warehouse/StockMovement | 
*WarehouseApi* | [**warehouseUpdateWarehouseTransfer**](docs/Api/WarehouseApi.md#warehouseupdatewarehousetransfer) | **POST** /api/WarehouseTransfer/{id} | Update WarehouseTransfer Details

## Models

- [ToolkitDataClassesAccountCollectionInvoiceItem](docs/Model/ToolkitDataClassesAccountCollectionInvoiceItem.md)
- [ToolkitDataClassesAccountConfirmedInvoiceSummary](docs/Model/ToolkitDataClassesAccountConfirmedInvoiceSummary.md)
- [ToolkitDataClassesAccountGenericInvoiceItem](docs/Model/ToolkitDataClassesAccountGenericInvoiceItem.md)
- [ToolkitDataClassesAccountGoodsInInvoiceItem](docs/Model/ToolkitDataClassesAccountGoodsInInvoiceItem.md)
- [ToolkitDataClassesAccountInvoiceItem](docs/Model/ToolkitDataClassesAccountInvoiceItem.md)
- [ToolkitDataClassesAccountInvoiceItemType](docs/Model/ToolkitDataClassesAccountInvoiceItemType.md)
- [ToolkitDataClassesAccountReturnInvoiceItem](docs/Model/ToolkitDataClassesAccountReturnInvoiceItem.md)
- [ToolkitDataClassesChannelsChannel](docs/Model/ToolkitDataClassesChannelsChannel.md)
- [ToolkitDataClassesClientsAPIAddSubClient](docs/Model/ToolkitDataClassesClientsAPIAddSubClient.md)
- [ToolkitDataClassesClientsAPISubClient](docs/Model/ToolkitDataClassesClientsAPISubClient.md)
- [ToolkitDataClassesClientsClient](docs/Model/ToolkitDataClassesClientsClient.md)
- [ToolkitDataClassesCommonCountry](docs/Model/ToolkitDataClassesCommonCountry.md)
- [ToolkitDataClassesCommonEnumPair](docs/Model/ToolkitDataClassesCommonEnumPair.md)
- [ToolkitDataClassesCommonToolkitResult](docs/Model/ToolkitDataClassesCommonToolkitResult.md)
- [ToolkitDataClassesCurrenciesCurrency](docs/Model/ToolkitDataClassesCurrenciesCurrency.md)
- [ToolkitDataClassesHelpOrderQueriesOrderQuery](docs/Model/ToolkitDataClassesHelpOrderQueriesOrderQuery.md)
- [ToolkitDataClassesHelpOrderQueriesOrderQueryComment](docs/Model/ToolkitDataClassesHelpOrderQueriesOrderQueryComment.md)
- [ToolkitDataClassesOrdersAPINewOrder](docs/Model/ToolkitDataClassesOrdersAPINewOrder.md)
- [ToolkitDataClassesOrdersAPINewOrderComment](docs/Model/ToolkitDataClassesOrdersAPINewOrderComment.md)
- [ToolkitDataClassesOrdersAPINewOrderConnectAction](docs/Model/ToolkitDataClassesOrdersAPINewOrderConnectAction.md)
- [ToolkitDataClassesOrdersAPINewOrderDocument](docs/Model/ToolkitDataClassesOrdersAPINewOrderDocument.md)
- [ToolkitDataClassesOrdersAPINewOrderItem](docs/Model/ToolkitDataClassesOrdersAPINewOrderItem.md)
- [ToolkitDataClassesOrdersAPINewOrderItemNameValue](docs/Model/ToolkitDataClassesOrdersAPINewOrderItemNameValue.md)
- [ToolkitDataClassesOrdersAPINewOrderNameValue](docs/Model/ToolkitDataClassesOrdersAPINewOrderNameValue.md)
- [ToolkitDataClassesOrdersAPINewOrderResult](docs/Model/ToolkitDataClassesOrdersAPINewOrderResult.md)
- [ToolkitDataClassesOrdersAPINewOrderShipment](docs/Model/ToolkitDataClassesOrdersAPINewOrderShipment.md)
- [ToolkitDataClassesOrdersAPINewOrderWithItems](docs/Model/ToolkitDataClassesOrdersAPINewOrderWithItems.md)
- [ToolkitDataClassesOrdersAddress](docs/Model/ToolkitDataClassesOrdersAddress.md)
- [ToolkitDataClassesOrdersBarcodeVerifiedOrderItem](docs/Model/ToolkitDataClassesOrdersBarcodeVerifiedOrderItem.md)
- [ToolkitDataClassesOrdersOrder](docs/Model/ToolkitDataClassesOrdersOrder.md)
- [ToolkitDataClassesOrdersOrderAwaitingAction](docs/Model/ToolkitDataClassesOrdersOrderAwaitingAction.md)
- [ToolkitDataClassesOrdersOrderComment](docs/Model/ToolkitDataClassesOrdersOrderComment.md)
- [ToolkitDataClassesOrdersOrderDocument](docs/Model/ToolkitDataClassesOrdersOrderDocument.md)
- [ToolkitDataClassesOrdersOrderDocumentType](docs/Model/ToolkitDataClassesOrdersOrderDocumentType.md)
- [ToolkitDataClassesOrdersOrderItem](docs/Model/ToolkitDataClassesOrdersOrderItem.md)
- [ToolkitDataClassesOrdersOrderItemNameValue](docs/Model/ToolkitDataClassesOrdersOrderItemNameValue.md)
- [ToolkitDataClassesOrdersOrderNameValue](docs/Model/ToolkitDataClassesOrdersOrderNameValue.md)
- [ToolkitDataClassesOrdersOrderShipment](docs/Model/ToolkitDataClassesOrdersOrderShipment.md)
- [ToolkitDataClassesOrdersOrderShipmentTrackingEvent](docs/Model/ToolkitDataClassesOrdersOrderShipmentTrackingEvent.md)
- [ToolkitDataClassesOrdersOrderSplit](docs/Model/ToolkitDataClassesOrdersOrderSplit.md)
- [ToolkitDataClassesOrdersOrderStatus](docs/Model/ToolkitDataClassesOrdersOrderStatus.md)
- [ToolkitDataClassesOrdersSplitOrderOnOrderItems](docs/Model/ToolkitDataClassesOrdersSplitOrderOnOrderItems.md)
- [ToolkitDataClassesReportsCourierDespatchReportLine](docs/Model/ToolkitDataClassesReportsCourierDespatchReportLine.md)
- [ToolkitDataClassesReturnsAPIReturnItemAPI](docs/Model/ToolkitDataClassesReturnsAPIReturnItemAPI.md)
- [ToolkitDataClassesReturnsReturn](docs/Model/ToolkitDataClassesReturnsReturn.md)
- [ToolkitDataClassesReturnsReturnItem](docs/Model/ToolkitDataClassesReturnsReturnItem.md)
- [ToolkitDataClassesReturnsReturnReason](docs/Model/ToolkitDataClassesReturnsReturnReason.md)
- [ToolkitDataClassesShippingCourierService](docs/Model/ToolkitDataClassesShippingCourierService.md)
- [ToolkitDataClassesShippingCourierServiceType](docs/Model/ToolkitDataClassesShippingCourierServiceType.md)
- [ToolkitDataClassesShippingExternalCourierServiceName](docs/Model/ToolkitDataClassesShippingExternalCourierServiceName.md)
- [ToolkitDataClassesShippingShipmentResult](docs/Model/ToolkitDataClassesShippingShipmentResult.md)
- [ToolkitDataClassesStockAPIASNBreakdown](docs/Model/ToolkitDataClassesStockAPIASNBreakdown.md)
- [ToolkitDataClassesStockAPIBulkOnHandStockUpdate](docs/Model/ToolkitDataClassesStockAPIBulkOnHandStockUpdate.md)
- [ToolkitDataClassesStockAPIBundle](docs/Model/ToolkitDataClassesStockAPIBundle.md)
- [ToolkitDataClassesStockAPIBundleItem](docs/Model/ToolkitDataClassesStockAPIBundleItem.md)
- [ToolkitDataClassesStockAPIInventoryPreOrderBreakdown](docs/Model/ToolkitDataClassesStockAPIInventoryPreOrderBreakdown.md)
- [ToolkitDataClassesStockAPINewASN](docs/Model/ToolkitDataClassesStockAPINewASN.md)
- [ToolkitDataClassesStockAPINewASNConnectAction](docs/Model/ToolkitDataClassesStockAPINewASNConnectAction.md)
- [ToolkitDataClassesStockAPINewASNItem](docs/Model/ToolkitDataClassesStockAPINewASNItem.md)
- [ToolkitDataClassesStockAPINewProductResult](docs/Model/ToolkitDataClassesStockAPINewProductResult.md)
- [ToolkitDataClassesStockAPIStockLevel](docs/Model/ToolkitDataClassesStockAPIStockLevel.md)
- [ToolkitDataClassesStockAPIStockLevelBreakdown](docs/Model/ToolkitDataClassesStockAPIStockLevelBreakdown.md)
- [ToolkitDataClassesStockASN](docs/Model/ToolkitDataClassesStockASN.md)
- [ToolkitDataClassesStockASNItem](docs/Model/ToolkitDataClassesStockASNItem.md)
- [ToolkitDataClassesStockASNItemAllocation](docs/Model/ToolkitDataClassesStockASNItemAllocation.md)
- [ToolkitDataClassesStockASNItemNameValue](docs/Model/ToolkitDataClassesStockASNItemNameValue.md)
- [ToolkitDataClassesStockASNStatus](docs/Model/ToolkitDataClassesStockASNStatus.md)
- [ToolkitDataClassesStockCommodityCode](docs/Model/ToolkitDataClassesStockCommodityCode.md)
- [ToolkitDataClassesStockInventoryItem](docs/Model/ToolkitDataClassesStockInventoryItem.md)
- [ToolkitDataClassesStockProduct](docs/Model/ToolkitDataClassesStockProduct.md)
- [ToolkitDataClassesStockProductAltCode](docs/Model/ToolkitDataClassesStockProductAltCode.md)
- [ToolkitDataClassesStockProductCategory](docs/Model/ToolkitDataClassesStockProductCategory.md)
- [ToolkitDataClassesStockProductContainer](docs/Model/ToolkitDataClassesStockProductContainer.md)
- [ToolkitDataClassesStockProductHazardousGoods](docs/Model/ToolkitDataClassesStockProductHazardousGoods.md)
- [ToolkitDataClassesStockProductInCategory](docs/Model/ToolkitDataClassesStockProductInCategory.md)
- [ToolkitDataClassesStockProductInSupplier](docs/Model/ToolkitDataClassesStockProductInSupplier.md)
- [ToolkitDataClassesStockProductPrice](docs/Model/ToolkitDataClassesStockProductPrice.md)
- [ToolkitDataClassesStockProductPriceType](docs/Model/ToolkitDataClassesStockProductPriceType.md)
- [ToolkitDataClassesStockProductSupplier](docs/Model/ToolkitDataClassesStockProductSupplier.md)
- [ToolkitDataClassesStockStockFlow](docs/Model/ToolkitDataClassesStockStockFlow.md)
- [ToolkitDataClassesStockWarehouse](docs/Model/ToolkitDataClassesStockWarehouse.md)
- [ToolkitDataClassesWarehouseAPIWarehouseTransfer](docs/Model/ToolkitDataClassesWarehouseAPIWarehouseTransfer.md)
- [ToolkitDataClassesWarehouseAPIWarehouseTransferItem](docs/Model/ToolkitDataClassesWarehouseAPIWarehouseTransferItem.md)
- [ToolkitDataClassesWarehouseBookStockRequest](docs/Model/ToolkitDataClassesWarehouseBookStockRequest.md)
- [ToolkitDataClassesWarehouseLocation](docs/Model/ToolkitDataClassesWarehouseLocation.md)
- [ToolkitDataClassesWarehouseLocationType](docs/Model/ToolkitDataClassesWarehouseLocationType.md)
- [ToolkitDataClassesWarehouseProductInLocation](docs/Model/ToolkitDataClassesWarehouseProductInLocation.md)
- [ToolkitDataClassesWarehouseToReturnWarehouseTransfer](docs/Model/ToolkitDataClassesWarehouseToReturnWarehouseTransfer.md)
- [ToolkitDataClassesWarehouseWarehouseTransfer](docs/Model/ToolkitDataClassesWarehouseWarehouseTransfer.md)
- [ToolkitDataClassesWarehouseWarehouseTransferItem](docs/Model/ToolkitDataClassesWarehouseWarehouseTransferItem.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v1`
    - Package version: `1.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
