<?php
/**
 * WeeeDataProductRenderWeeeAdjustmentAttributeInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * WeeeDataProductRenderWeeeAdjustmentAttributeInterface Class Doc Comment
 *
 * @category Class
 * @description List of all weee attributes, their amounts, etc.., that product has
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class WeeeDataProductRenderWeeeAdjustmentAttributeInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'weee-data-product-render-weee-adjustment-attribute-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amount' => 'string',
        'tax_amount' => 'string',
        'tax_amount_incl_tax' => 'string',
        'amount_excl_tax' => 'string',
        'attribute_code' => 'string',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amount' => null,
        'tax_amount' => null,
        'tax_amount_incl_tax' => null,
        'amount_excl_tax' => null,
        'attribute_code' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amount' => 'amount',
        'tax_amount' => 'tax_amount',
        'tax_amount_incl_tax' => 'tax_amount_incl_tax',
        'amount_excl_tax' => 'amount_excl_tax',
        'attribute_code' => 'attribute_code',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amount' => 'setAmount',
        'tax_amount' => 'setTaxAmount',
        'tax_amount_incl_tax' => 'setTaxAmountInclTax',
        'amount_excl_tax' => 'setAmountExclTax',
        'attribute_code' => 'setAttributeCode',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amount' => 'getAmount',
        'tax_amount' => 'getTaxAmount',
        'tax_amount_incl_tax' => 'getTaxAmountInclTax',
        'amount_excl_tax' => 'getAmountExclTax',
        'attribute_code' => 'getAttributeCode',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['amount'] = $data['amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['tax_amount_incl_tax'] = $data['tax_amount_incl_tax'] ?? null;
        $this->container['amount_excl_tax'] = $data['amount_excl_tax'] ?? null;
        $this->container['attribute_code'] = $data['attribute_code'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        if ($this->container['tax_amount'] === null) {
            $invalidProperties[] = "'tax_amount' can't be null";
        }
        if ($this->container['tax_amount_incl_tax'] === null) {
            $invalidProperties[] = "'tax_amount_incl_tax' can't be null";
        }
        if ($this->container['amount_excl_tax'] === null) {
            $invalidProperties[] = "'amount_excl_tax' can't be null";
        }
        if ($this->container['attribute_code'] === null) {
            $invalidProperties[] = "'attribute_code' can't be null";
        }
        if ($this->container['extension_attributes'] === null) {
            $invalidProperties[] = "'extension_attributes' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets amount
     *
     * @return string
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param string $amount Weee attribute amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return string
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param string $tax_amount Tax which is calculated to fixed product tax attribute
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_amount_incl_tax
     *
     * @return string
     */
    public function getTaxAmountInclTax()
    {
        return $this->container['tax_amount_incl_tax'];
    }

    /**
     * Sets tax_amount_incl_tax
     *
     * @param string $tax_amount_incl_tax Tax amount of weee attribute
     *
     * @return self
     */
    public function setTaxAmountInclTax($tax_amount_incl_tax)
    {
        $this->container['tax_amount_incl_tax'] = $tax_amount_incl_tax;

        return $this;
    }

    /**
     * Gets amount_excl_tax
     *
     * @return string
     */
    public function getAmountExclTax()
    {
        return $this->container['amount_excl_tax'];
    }

    /**
     * Sets amount_excl_tax
     *
     * @param string $amount_excl_tax Product amount exclude tax
     *
     * @return self
     */
    public function setAmountExclTax($amount_excl_tax)
    {
        $this->container['amount_excl_tax'] = $amount_excl_tax;

        return $this;
    }

    /**
     * Gets attribute_code
     *
     * @return string
     */
    public function getAttributeCode()
    {
        return $this->container['attribute_code'];
    }

    /**
     * Sets attribute_code
     *
     * @param string $attribute_code Weee attribute code
     *
     * @return self
     */
    public function setAttributeCode($attribute_code)
    {
        $this->container['attribute_code'] = $attribute_code;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object $extension_attributes ExtensionInterface class for @see \\Magento\\Weee\\Api\\Data\\ProductRender\\WeeeAdjustmentAttributeInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


