<?php
/**
 * VaultDataPaymentTokenInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * VaultDataPaymentTokenInterface Class Doc Comment
 *
 * @category Class
 * @description Gateway vault payment token interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class VaultDataPaymentTokenInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'vault-data-payment-token-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'entity_id' => 'int',
        'customer_id' => 'int',
        'public_hash' => 'string',
        'payment_method_code' => 'string',
        'type' => 'string',
        'created_at' => 'string',
        'expires_at' => 'string',
        'gateway_token' => 'string',
        'token_details' => 'string',
        'is_active' => 'bool',
        'is_visible' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'entity_id' => null,
        'customer_id' => null,
        'public_hash' => null,
        'payment_method_code' => null,
        'type' => null,
        'created_at' => null,
        'expires_at' => null,
        'gateway_token' => null,
        'token_details' => null,
        'is_active' => null,
        'is_visible' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entity_id' => 'entity_id',
        'customer_id' => 'customer_id',
        'public_hash' => 'public_hash',
        'payment_method_code' => 'payment_method_code',
        'type' => 'type',
        'created_at' => 'created_at',
        'expires_at' => 'expires_at',
        'gateway_token' => 'gateway_token',
        'token_details' => 'token_details',
        'is_active' => 'is_active',
        'is_visible' => 'is_visible'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'entity_id' => 'setEntityId',
        'customer_id' => 'setCustomerId',
        'public_hash' => 'setPublicHash',
        'payment_method_code' => 'setPaymentMethodCode',
        'type' => 'setType',
        'created_at' => 'setCreatedAt',
        'expires_at' => 'setExpiresAt',
        'gateway_token' => 'setGatewayToken',
        'token_details' => 'setTokenDetails',
        'is_active' => 'setIsActive',
        'is_visible' => 'setIsVisible'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'entity_id' => 'getEntityId',
        'customer_id' => 'getCustomerId',
        'public_hash' => 'getPublicHash',
        'payment_method_code' => 'getPaymentMethodCode',
        'type' => 'getType',
        'created_at' => 'getCreatedAt',
        'expires_at' => 'getExpiresAt',
        'gateway_token' => 'getGatewayToken',
        'token_details' => 'getTokenDetails',
        'is_active' => 'getIsActive',
        'is_visible' => 'getIsVisible'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['entity_id'] = $data['entity_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['public_hash'] = $data['public_hash'] ?? null;
        $this->container['payment_method_code'] = $data['payment_method_code'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['expires_at'] = $data['expires_at'] ?? null;
        $this->container['gateway_token'] = $data['gateway_token'] ?? null;
        $this->container['token_details'] = $data['token_details'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['is_visible'] = $data['is_visible'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['public_hash'] === null) {
            $invalidProperties[] = "'public_hash' can't be null";
        }
        if ($this->container['payment_method_code'] === null) {
            $invalidProperties[] = "'payment_method_code' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        if ($this->container['gateway_token'] === null) {
            $invalidProperties[] = "'gateway_token' can't be null";
        }
        if ($this->container['token_details'] === null) {
            $invalidProperties[] = "'token_details' can't be null";
        }
        if ($this->container['is_active'] === null) {
            $invalidProperties[] = "'is_active' can't be null";
        }
        if ($this->container['is_visible'] === null) {
            $invalidProperties[] = "'is_visible' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets entity_id
     *
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int|null $entity_id Entity ID.
     *
     * @return self
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Customer ID.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets public_hash
     *
     * @return string
     */
    public function getPublicHash()
    {
        return $this->container['public_hash'];
    }

    /**
     * Sets public_hash
     *
     * @param string $public_hash Public hash
     *
     * @return self
     */
    public function setPublicHash($public_hash)
    {
        $this->container['public_hash'] = $public_hash;

        return $this;
    }

    /**
     * Gets payment_method_code
     *
     * @return string
     */
    public function getPaymentMethodCode()
    {
        return $this->container['payment_method_code'];
    }

    /**
     * Sets payment_method_code
     *
     * @param string $payment_method_code Payment method code
     *
     * @return self
     */
    public function setPaymentMethodCode($payment_method_code)
    {
        $this->container['payment_method_code'] = $payment_method_code;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Type
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Token creation timestamp
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets expires_at
     *
     * @return string|null
     */
    public function getExpiresAt()
    {
        return $this->container['expires_at'];
    }

    /**
     * Sets expires_at
     *
     * @param string|null $expires_at Token expiration timestamp
     *
     * @return self
     */
    public function setExpiresAt($expires_at)
    {
        $this->container['expires_at'] = $expires_at;

        return $this;
    }

    /**
     * Gets gateway_token
     *
     * @return string
     */
    public function getGatewayToken()
    {
        return $this->container['gateway_token'];
    }

    /**
     * Sets gateway_token
     *
     * @param string $gateway_token Gateway token ID
     *
     * @return self
     */
    public function setGatewayToken($gateway_token)
    {
        $this->container['gateway_token'] = $gateway_token;

        return $this;
    }

    /**
     * Gets token_details
     *
     * @return string
     */
    public function getTokenDetails()
    {
        return $this->container['token_details'];
    }

    /**
     * Sets token_details
     *
     * @param string $token_details Token details
     *
     * @return self
     */
    public function setTokenDetails($token_details)
    {
        $this->container['token_details'] = $token_details;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool $is_active Is active.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets is_visible
     *
     * @return bool
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     *
     * @param bool $is_visible Is visible.
     *
     * @return self
     */
    public function setIsVisible($is_visible)
    {
        $this->container['is_visible'] = $is_visible;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


