<?php
/**
 * TaxDataTaxRuleInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * TaxDataTaxRuleInterface Class Doc Comment
 *
 * @category Class
 * @description Tax rule interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TaxDataTaxRuleInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'tax-data-tax-rule-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'code' => 'string',
        'priority' => 'int',
        'position' => 'int',
        'customer_tax_class_ids' => 'int[]',
        'product_tax_class_ids' => 'int[]',
        'tax_rate_ids' => 'int[]',
        'calculate_subtotal' => 'bool',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'code' => null,
        'priority' => null,
        'position' => null,
        'customer_tax_class_ids' => null,
        'product_tax_class_ids' => null,
        'tax_rate_ids' => null,
        'calculate_subtotal' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'code' => 'code',
        'priority' => 'priority',
        'position' => 'position',
        'customer_tax_class_ids' => 'customer_tax_class_ids',
        'product_tax_class_ids' => 'product_tax_class_ids',
        'tax_rate_ids' => 'tax_rate_ids',
        'calculate_subtotal' => 'calculate_subtotal',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'code' => 'setCode',
        'priority' => 'setPriority',
        'position' => 'setPosition',
        'customer_tax_class_ids' => 'setCustomerTaxClassIds',
        'product_tax_class_ids' => 'setProductTaxClassIds',
        'tax_rate_ids' => 'setTaxRateIds',
        'calculate_subtotal' => 'setCalculateSubtotal',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'code' => 'getCode',
        'priority' => 'getPriority',
        'position' => 'getPosition',
        'customer_tax_class_ids' => 'getCustomerTaxClassIds',
        'product_tax_class_ids' => 'getProductTaxClassIds',
        'tax_rate_ids' => 'getTaxRateIds',
        'calculate_subtotal' => 'getCalculateSubtotal',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['code'] = $data['code'] ?? null;
        $this->container['priority'] = $data['priority'] ?? null;
        $this->container['position'] = $data['position'] ?? null;
        $this->container['customer_tax_class_ids'] = $data['customer_tax_class_ids'] ?? null;
        $this->container['product_tax_class_ids'] = $data['product_tax_class_ids'] ?? null;
        $this->container['tax_rate_ids'] = $data['tax_rate_ids'] ?? null;
        $this->container['calculate_subtotal'] = $data['calculate_subtotal'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['code'] === null) {
            $invalidProperties[] = "'code' can't be null";
        }
        if ($this->container['priority'] === null) {
            $invalidProperties[] = "'priority' can't be null";
        }
        if ($this->container['position'] === null) {
            $invalidProperties[] = "'position' can't be null";
        }
        if ($this->container['customer_tax_class_ids'] === null) {
            $invalidProperties[] = "'customer_tax_class_ids' can't be null";
        }
        if ($this->container['product_tax_class_ids'] === null) {
            $invalidProperties[] = "'product_tax_class_ids' can't be null";
        }
        if ($this->container['tax_rate_ids'] === null) {
            $invalidProperties[] = "'tax_rate_ids' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string $code Tax rule code
     *
     * @return self
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets priority
     *
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     *
     * @param int $priority Priority
     *
     * @return self
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets position
     *
     * @return int
     */
    public function getPosition()
    {
        return $this->container['position'];
    }

    /**
     * Sets position
     *
     * @param int $position Sort order.
     *
     * @return self
     */
    public function setPosition($position)
    {
        $this->container['position'] = $position;

        return $this;
    }

    /**
     * Gets customer_tax_class_ids
     *
     * @return int[]
     */
    public function getCustomerTaxClassIds()
    {
        return $this->container['customer_tax_class_ids'];
    }

    /**
     * Sets customer_tax_class_ids
     *
     * @param int[] $customer_tax_class_ids Customer tax class id
     *
     * @return self
     */
    public function setCustomerTaxClassIds($customer_tax_class_ids)
    {
        $this->container['customer_tax_class_ids'] = $customer_tax_class_ids;

        return $this;
    }

    /**
     * Gets product_tax_class_ids
     *
     * @return int[]
     */
    public function getProductTaxClassIds()
    {
        return $this->container['product_tax_class_ids'];
    }

    /**
     * Sets product_tax_class_ids
     *
     * @param int[] $product_tax_class_ids Product tax class id
     *
     * @return self
     */
    public function setProductTaxClassIds($product_tax_class_ids)
    {
        $this->container['product_tax_class_ids'] = $product_tax_class_ids;

        return $this;
    }

    /**
     * Gets tax_rate_ids
     *
     * @return int[]
     */
    public function getTaxRateIds()
    {
        return $this->container['tax_rate_ids'];
    }

    /**
     * Sets tax_rate_ids
     *
     * @param int[] $tax_rate_ids Tax rate ids
     *
     * @return self
     */
    public function setTaxRateIds($tax_rate_ids)
    {
        $this->container['tax_rate_ids'] = $tax_rate_ids;

        return $this;
    }

    /**
     * Gets calculate_subtotal
     *
     * @return bool|null
     */
    public function getCalculateSubtotal()
    {
        return $this->container['calculate_subtotal'];
    }

    /**
     * Sets calculate_subtotal
     *
     * @param bool|null $calculate_subtotal Calculate subtotal.
     *
     * @return self
     */
    public function setCalculateSubtotal($calculate_subtotal)
    {
        $this->container['calculate_subtotal'] = $calculate_subtotal;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Tax\\Api\\Data\\TaxRuleInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


