<?php
/**
 * TaxDataTaxRateInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * TaxDataTaxRateInterface Class Doc Comment
 *
 * @category Class
 * @description Tax rate interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TaxDataTaxRateInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'tax-data-tax-rate-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'tax_country_id' => 'string',
        'tax_region_id' => 'int',
        'region_name' => 'string',
        'tax_postcode' => 'string',
        'zip_is_range' => 'int',
        'zip_from' => 'int',
        'zip_to' => 'int',
        'rate' => 'float',
        'code' => 'string',
        'titles' => '\Magento2\Model\TaxDataTaxRateTitleInterface[]',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'tax_country_id' => null,
        'tax_region_id' => null,
        'region_name' => null,
        'tax_postcode' => null,
        'zip_is_range' => null,
        'zip_from' => null,
        'zip_to' => null,
        'rate' => null,
        'code' => null,
        'titles' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'tax_country_id' => 'tax_country_id',
        'tax_region_id' => 'tax_region_id',
        'region_name' => 'region_name',
        'tax_postcode' => 'tax_postcode',
        'zip_is_range' => 'zip_is_range',
        'zip_from' => 'zip_from',
        'zip_to' => 'zip_to',
        'rate' => 'rate',
        'code' => 'code',
        'titles' => 'titles',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'tax_country_id' => 'setTaxCountryId',
        'tax_region_id' => 'setTaxRegionId',
        'region_name' => 'setRegionName',
        'tax_postcode' => 'setTaxPostcode',
        'zip_is_range' => 'setZipIsRange',
        'zip_from' => 'setZipFrom',
        'zip_to' => 'setZipTo',
        'rate' => 'setRate',
        'code' => 'setCode',
        'titles' => 'setTitles',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'tax_country_id' => 'getTaxCountryId',
        'tax_region_id' => 'getTaxRegionId',
        'region_name' => 'getRegionName',
        'tax_postcode' => 'getTaxPostcode',
        'zip_is_range' => 'getZipIsRange',
        'zip_from' => 'getZipFrom',
        'zip_to' => 'getZipTo',
        'rate' => 'getRate',
        'code' => 'getCode',
        'titles' => 'getTitles',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['tax_country_id'] = $data['tax_country_id'] ?? null;
        $this->container['tax_region_id'] = $data['tax_region_id'] ?? null;
        $this->container['region_name'] = $data['region_name'] ?? null;
        $this->container['tax_postcode'] = $data['tax_postcode'] ?? null;
        $this->container['zip_is_range'] = $data['zip_is_range'] ?? null;
        $this->container['zip_from'] = $data['zip_from'] ?? null;
        $this->container['zip_to'] = $data['zip_to'] ?? null;
        $this->container['rate'] = $data['rate'] ?? null;
        $this->container['code'] = $data['code'] ?? null;
        $this->container['titles'] = $data['titles'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['tax_country_id'] === null) {
            $invalidProperties[] = "'tax_country_id' can't be null";
        }
        if ($this->container['rate'] === null) {
            $invalidProperties[] = "'rate' can't be null";
        }
        if ($this->container['code'] === null) {
            $invalidProperties[] = "'code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Id
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets tax_country_id
     *
     * @return string
     */
    public function getTaxCountryId()
    {
        return $this->container['tax_country_id'];
    }

    /**
     * Sets tax_country_id
     *
     * @param string $tax_country_id Country id
     *
     * @return self
     */
    public function setTaxCountryId($tax_country_id)
    {
        $this->container['tax_country_id'] = $tax_country_id;

        return $this;
    }

    /**
     * Gets tax_region_id
     *
     * @return int|null
     */
    public function getTaxRegionId()
    {
        return $this->container['tax_region_id'];
    }

    /**
     * Sets tax_region_id
     *
     * @param int|null $tax_region_id Region id
     *
     * @return self
     */
    public function setTaxRegionId($tax_region_id)
    {
        $this->container['tax_region_id'] = $tax_region_id;

        return $this;
    }

    /**
     * Gets region_name
     *
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->container['region_name'];
    }

    /**
     * Sets region_name
     *
     * @param string|null $region_name Region name
     *
     * @return self
     */
    public function setRegionName($region_name)
    {
        $this->container['region_name'] = $region_name;

        return $this;
    }

    /**
     * Gets tax_postcode
     *
     * @return string|null
     */
    public function getTaxPostcode()
    {
        return $this->container['tax_postcode'];
    }

    /**
     * Sets tax_postcode
     *
     * @param string|null $tax_postcode Postcode
     *
     * @return self
     */
    public function setTaxPostcode($tax_postcode)
    {
        $this->container['tax_postcode'] = $tax_postcode;

        return $this;
    }

    /**
     * Gets zip_is_range
     *
     * @return int|null
     */
    public function getZipIsRange()
    {
        return $this->container['zip_is_range'];
    }

    /**
     * Sets zip_is_range
     *
     * @param int|null $zip_is_range Zip is range
     *
     * @return self
     */
    public function setZipIsRange($zip_is_range)
    {
        $this->container['zip_is_range'] = $zip_is_range;

        return $this;
    }

    /**
     * Gets zip_from
     *
     * @return int|null
     */
    public function getZipFrom()
    {
        return $this->container['zip_from'];
    }

    /**
     * Sets zip_from
     *
     * @param int|null $zip_from Zip range from
     *
     * @return self
     */
    public function setZipFrom($zip_from)
    {
        $this->container['zip_from'] = $zip_from;

        return $this;
    }

    /**
     * Gets zip_to
     *
     * @return int|null
     */
    public function getZipTo()
    {
        return $this->container['zip_to'];
    }

    /**
     * Sets zip_to
     *
     * @param int|null $zip_to Zip range to
     *
     * @return self
     */
    public function setZipTo($zip_to)
    {
        $this->container['zip_to'] = $zip_to;

        return $this;
    }

    /**
     * Gets rate
     *
     * @return float
     */
    public function getRate()
    {
        return $this->container['rate'];
    }

    /**
     * Sets rate
     *
     * @param float $rate Tax rate in percentage
     *
     * @return self
     */
    public function setRate($rate)
    {
        $this->container['rate'] = $rate;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string $code Tax rate code
     *
     * @return self
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets titles
     *
     * @return \Magento2\Model\TaxDataTaxRateTitleInterface[]|null
     */
    public function getTitles()
    {
        return $this->container['titles'];
    }

    /**
     * Sets titles
     *
     * @param \Magento2\Model\TaxDataTaxRateTitleInterface[]|null $titles Tax rate titles
     *
     * @return self
     */
    public function setTitles($titles)
    {
        $this->container['titles'] = $titles;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Tax\\Api\\Data\\TaxRateInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


